/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.data.vector;

import org.apache.flink.table.data.vector.ColumnVector;

public interface BytesColumnVector
extends ColumnVector {
    public Bytes getBytes(int var1);

    public static class Bytes {
        public final byte[] data;
        public final int offset;
        public final int len;

        public Bytes(byte[] data, int offset, int len) {
            this.data = data;
            this.offset = offset;
            this.len = len;
        }

        public byte[] getBytes() {
            if (this.offset == 0 && this.len == this.data.length) {
                return this.data;
            }
            byte[] res = new byte[this.len];
            System.arraycopy(this.data, this.offset, res, 0, this.len);
            return res;
        }
    }
}

