/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3native;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.s3native.FileMetadata;
import org.apache.hadoop.fs.s3native.NativeFileSystemStore;
import org.apache.hadoop.fs.s3native.PartialListing;
import org.apache.hadoop.util.Time;

class InMemoryNativeFileSystemStore
implements NativeFileSystemStore {
    private Configuration conf;
    private SortedMap<String, FileMetadata> metadataMap = new TreeMap<String, FileMetadata>();
    private SortedMap<String, byte[]> dataMap = new TreeMap<String, byte[]>();

    InMemoryNativeFileSystemStore() {
    }

    public void initialize(URI uri, Configuration conf) throws IOException {
        this.conf = conf;
    }

    public void storeEmptyFile(String key) throws IOException {
        this.metadataMap.put(key, new FileMetadata(key, 0L, Time.now()));
        this.dataMap.put(key, new byte[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeFile(String key, File file, byte[] md5Hash) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[8192];
        BufferedInputStream in = null;
        try {
            int numRead;
            in = new BufferedInputStream(new FileInputStream(file));
            while ((numRead = in.read(buf)) >= 0) {
                out.write(buf, 0, numRead);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        this.metadataMap.put(key, new FileMetadata(key, file.length(), Time.now()));
        this.dataMap.put(key, out.toByteArray());
    }

    public InputStream retrieve(String key) throws IOException {
        return this.retrieve(key, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream retrieve(String key, long byteRangeStart) throws IOException {
        byte[] data = (byte[])this.dataMap.get(key);
        File file = this.createTempFile();
        FilterOutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(file));
            ((BufferedOutputStream)out).write(data, (int)byteRangeStart, data.length - (int)byteRangeStart);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        return new FileInputStream(file);
    }

    private File createTempFile() throws IOException {
        File dir = new File(this.conf.get("fs.s3.buffer.dir"));
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("Cannot create S3 buffer directory: " + dir);
        }
        File result = File.createTempFile("test-", ".tmp", dir);
        result.deleteOnExit();
        return result;
    }

    public FileMetadata retrieveMetadata(String key) throws IOException {
        return (FileMetadata)this.metadataMap.get(key);
    }

    public PartialListing list(String prefix, int maxListingLength) throws IOException {
        return this.list(prefix, maxListingLength, null, false);
    }

    public PartialListing list(String prefix, int maxListingLength, String priorLastKey, boolean recursive) throws IOException {
        return this.list(prefix, recursive ? null : "/", maxListingLength, priorLastKey);
    }

    private PartialListing list(String prefix, String delimiter, int maxListingLength, String priorLastKey) throws IOException {
        if (prefix.length() > 0 && !prefix.endsWith("/")) {
            prefix = prefix + "/";
        }
        ArrayList<FileMetadata> metadata = new ArrayList<FileMetadata>();
        TreeSet<String> commonPrefixes = new TreeSet<String>();
        for (String key : this.dataMap.keySet()) {
            if (key.startsWith(prefix)) {
                if (delimiter == null) {
                    metadata.add(this.retrieveMetadata(key));
                } else {
                    int delimIndex = key.indexOf(delimiter, prefix.length());
                    if (delimIndex == -1) {
                        metadata.add(this.retrieveMetadata(key));
                    } else {
                        String commonPrefix = key.substring(0, delimIndex);
                        commonPrefixes.add(commonPrefix);
                    }
                }
            }
            if (metadata.size() + commonPrefixes.size() != maxListingLength) continue;
            new PartialListing(key, metadata.toArray(new FileMetadata[0]), commonPrefixes.toArray(new String[0]));
        }
        return new PartialListing(null, metadata.toArray(new FileMetadata[0]), commonPrefixes.toArray(new String[0]));
    }

    public void delete(String key) throws IOException {
        this.metadataMap.remove(key);
        this.dataMap.remove(key);
    }

    public void copy(String srcKey, String dstKey) throws IOException {
        this.metadataMap.put(dstKey, (FileMetadata)this.metadataMap.get(srcKey));
        this.dataMap.put(dstKey, (byte[])this.dataMap.get(srcKey));
    }

    public void purge(String prefix) throws IOException {
        Iterator<Map.Entry<String, FileMetadata>> i = this.metadataMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<String, FileMetadata> entry = i.next();
            if (!entry.getKey().startsWith(prefix)) continue;
            this.dataMap.remove(entry.getKey());
            i.remove();
        }
    }

    public void dump() throws IOException {
        System.out.println(this.metadataMap.values());
        System.out.println(this.dataMap.keySet());
    }
}

