/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3native;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.security.DigestInputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.s3native.Jets3tNativeFileSystemStore;
import org.apache.hadoop.fs.s3native.NativeFileSystemStore;
import org.apache.hadoop.fs.s3native.NativeS3FileSystem;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestJets3tNativeFileSystemStore {
    private Configuration conf;
    private Jets3tNativeFileSystemStore store;
    private NativeS3FileSystem fs;

    @Before
    public void setUp() throws Exception {
        this.conf = new Configuration();
        this.store = new Jets3tNativeFileSystemStore();
        this.fs = new NativeS3FileSystem((NativeFileSystemStore)this.store);
        this.conf.setBoolean("fs.s3n.multipart.uploads.enabled", true);
        this.conf.setLong("fs.s3n.multipart.uploads.block.size", 0x4000000L);
        this.fs.initialize(URI.create(this.conf.get("test.fs.s3n.name")), this.conf);
    }

    @After
    public void tearDown() throws Exception {
        try {
            this.store.purge("test");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @BeforeClass
    public static void checkSettings() throws Exception {
        Configuration conf = new Configuration();
        Assume.assumeNotNull((Object[])new Object[]{conf.get("fs.s3n.awsAccessKeyId")});
        Assume.assumeNotNull((Object[])new Object[]{conf.get("fs.s3n.awsSecretAccessKey")});
        Assume.assumeNotNull((Object[])new Object[]{conf.get("test.fs.s3n.name")});
    }

    protected void writeRenameReadCompare(Path path, long len) throws IOException, NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("MD5");
        BufferedOutputStream out = new BufferedOutputStream(new DigestOutputStream((OutputStream)this.fs.create(path, false), digest));
        for (long i = 0L; i < len; ++i) {
            ((OutputStream)out).write(81);
        }
        ((OutputStream)out).flush();
        ((OutputStream)out).close();
        Assert.assertTrue((String)"Exists", (boolean)this.fs.exists(path));
        Path copyPath = path.suffix(".copy");
        this.fs.rename(path, copyPath);
        Assert.assertTrue((String)"Copy exists", (boolean)this.fs.exists(copyPath));
        MessageDigest digest2 = MessageDigest.getInstance("MD5");
        BufferedInputStream in = new BufferedInputStream(new DigestInputStream((InputStream)this.fs.open(copyPath), digest2));
        long copyLen = 0L;
        while (((InputStream)in).read() != -1) {
            ++copyLen;
        }
        ((InputStream)in).close();
        Assert.assertEquals((String)"Copy length matches original", (long)len, (long)copyLen);
        Assert.assertArrayEquals((String)"Digests match", (byte[])digest.digest(), (byte[])digest2.digest());
    }

    @Test
    public void testSmallUpload() throws IOException, NoSuchAlgorithmException {
        this.writeRenameReadCompare(new Path("/test/small"), 16384L);
    }

    @Test
    public void testMediumUpload() throws IOException, NoSuchAlgorithmException {
        this.writeRenameReadCompare(new Path("/test/medium"), 0x2000000L);
    }

    @Test
    public void testExtraLargeUpload() throws IOException, NoSuchAlgorithmException {
        this.writeRenameReadCompare(new Path("/test/xlarge"), 0x140000001L);
    }
}

