/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.ClientBaseWithFixes;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.yarn.client.ProtocolHATestBase;
import org.apache.hadoop.yarn.client.TestRMFailover;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.AdminService;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public abstract class ProtocolHATestBase
extends ClientBaseWithFixes {
    protected static final HAServiceProtocol.StateChangeRequestInfo req = new HAServiceProtocol.StateChangeRequestInfo(HAServiceProtocol.RequestSource.REQUEST_BY_USER);
    protected static final String RM1_NODE_ID = "rm1";
    protected static final int RM1_PORT_BASE = 10000;
    protected static final String RM2_NODE_ID = "rm2";
    protected static final int RM2_PORT_BASE = 20000;
    protected Configuration conf;
    protected MiniYARNClusterForHATesting cluster;
    protected Thread failoverThread = null;
    private volatile boolean keepRunning;

    private void setConfForRM(String rmId, String prefix, String value) {
        this.conf.set(HAUtil.addSuffix((String)prefix, (String)rmId), value);
    }

    private void setRpcAddressForRM(String rmId, int base) {
        this.setConfForRM(rmId, "yarn.resourcemanager.address", "0.0.0.0:" + (base + 8032));
        this.setConfForRM(rmId, "yarn.resourcemanager.scheduler.address", "0.0.0.0:" + (base + 8030));
        this.setConfForRM(rmId, "yarn.resourcemanager.admin.address", "0.0.0.0:" + (base + 8033));
        this.setConfForRM(rmId, "yarn.resourcemanager.resource-tracker.address", "0.0.0.0:" + (base + 8031));
        this.setConfForRM(rmId, "yarn.resourcemanager.webapp.address", "0.0.0.0:" + (base + 8088));
        this.setConfForRM(rmId, "yarn.resourcemanager.webapp.https.address", "0.0.0.0:" + (base + 8090));
    }

    @Before
    public void setup() throws IOException {
        this.failoverThread = null;
        this.keepRunning = true;
        this.conf = new YarnConfiguration();
        this.conf.setBoolean("yarn.resourcemanager.ha.enabled", true);
        this.conf.setInt("yarn.client.failover-max-attempts", 5);
        this.conf.set("yarn.resourcemanager.ha.rm-ids", "rm1,rm2");
        this.setRpcAddressForRM(RM1_NODE_ID, 10000);
        this.setRpcAddressForRM(RM2_NODE_ID, 20000);
        this.conf.setLong("yarn.client.failover-sleep-base-ms", 100L);
        this.conf.setBoolean("yarn.minicluster.fixed.ports", true);
        this.conf.setBoolean("yarn.minicluster.use-rpc", true);
    }

    @After
    public void teardown() throws Exception {
        this.keepRunning = false;
        if (this.failoverThread != null) {
            this.failoverThread.interrupt();
            try {
                this.failoverThread.join();
            }
            catch (InterruptedException ex) {
                LOG.error("Error joining with failover thread", (Throwable)ex);
            }
        }
        this.cluster.stop();
    }

    protected AdminService getAdminService(int index) {
        return this.cluster.getResourceManager(index).getRMContext().getRMAdminService();
    }

    protected void explicitFailover() throws IOException {
        int activeRMIndex = this.cluster.getActiveRMIndex();
        int newActiveRMIndex = (activeRMIndex + 1) % 2;
        this.getAdminService(activeRMIndex).transitionToStandby(req);
        this.getAdminService(newActiveRMIndex).transitionToActive(req);
        Assert.assertEquals((String)"Failover failed", (long)newActiveRMIndex, (long)this.cluster.getActiveRMIndex());
    }

    protected YarnClient createAndStartYarnClient(Configuration conf) {
        YarnConfiguration configuration = new YarnConfiguration(conf);
        YarnClient client = YarnClient.createYarnClient();
        client.init((Configuration)configuration);
        client.start();
        return client;
    }

    protected void verifyConnections() throws InterruptedException, YarnException {
        Assert.assertTrue((String)"NMs failed to connect to the RM", (boolean)this.cluster.waitForNodeManagersToConnect(20000L));
        this.verifyClientConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void verifyClientConnection() {
        int numRetries = 3;
        while (numRetries-- > 0) {
            YarnConfiguration conf = new YarnConfiguration(this.conf);
            YarnClient client = this.createAndStartYarnClient((Configuration)conf);
            try {
                Thread.sleep(100L);
                client.getApplications();
                return;
            }
            catch (Exception e) {
                LOG.error(e.getMessage());
            }
            finally {
                client.stop();
            }
        }
        Assert.fail((String)"Client couldn't connect to the Active RM");
    }

    protected Thread createAndStartFailoverThread() {
        1 failoverThread = new /* Unavailable Anonymous Inner Class!! */;
        failoverThread.start();
        return failoverThread;
    }

    protected void startHACluster(int numOfNMs, boolean overrideClientRMService, boolean overrideRTS, boolean overrideApplicationMasterService) throws Exception {
        this.conf.setBoolean("yarn.resourcemanager.ha.automatic-failover.enabled", false);
        this.cluster = new MiniYARNClusterForHATesting(this, TestRMFailover.class.getName(), 2, numOfNMs, 1, 1, false, overrideClientRMService, overrideRTS, overrideApplicationMasterService);
        this.cluster.resetStartFailoverFlag(false);
        this.cluster.init(this.conf);
        this.cluster.start();
        this.getAdminService(0).transitionToActive(req);
        Assert.assertFalse((String)"RM never turned active", (-1 == this.cluster.getActiveRMIndex() ? 1 : 0) != 0);
        this.verifyConnections();
        this.explicitFailover();
        this.verifyConnections();
        this.failoverThread = this.createAndStartFailoverThread();
    }

    protected ResourceManager getActiveRM() {
        return this.cluster.getResourceManager(this.cluster.getActiveRMIndex());
    }

    static /* synthetic */ boolean access$002(ProtocolHATestBase x0, boolean x1) {
        x0.keepRunning = x1;
        return x0.keepRunning;
    }

    static /* synthetic */ boolean access$000(ProtocolHATestBase x0) {
        return x0.keepRunning;
    }
}

