/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.yarn.api.ApplicationMasterProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ResourceBlacklistRequest;
import org.apache.hadoop.yarn.client.ClientRMProxy;
import org.apache.hadoop.yarn.client.ProtocolHATestBase;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestApplicationMasterServiceOnHA
extends ProtocolHATestBase {
    private ApplicationMasterProtocol amClient;
    private ApplicationAttemptId attemptId;
    RMAppAttempt appAttempt;

    @Before
    public void initiate() throws Exception {
        this.startHACluster(0, false, false, true);
        this.attemptId = this.cluster.createFakeApplicationAttemptId();
        this.amClient = (ApplicationMasterProtocol)ClientRMProxy.createRMProxy((Configuration)this.conf, ApplicationMasterProtocol.class);
        AMRMTokenIdentifier id = new AMRMTokenIdentifier(this.attemptId);
        Token appToken = new Token((TokenIdentifier)id, (SecretManager)this.cluster.getResourceManager().getRMContext().getAMRMTokenSecretManager());
        appToken.setService(new Text("appToken service"));
        UserGroupInformation.setLoginUser((UserGroupInformation)UserGroupInformation.createRemoteUser((String)UserGroupInformation.getCurrentUser().getUserName()));
        UserGroupInformation.getCurrentUser().addToken(appToken);
        this.syncToken(appToken);
    }

    @After
    public void shutDown() {
        if (this.amClient != null) {
            RPC.stopProxy((Object)this.amClient);
        }
    }

    @Test(timeout=15000L)
    public void testAllocateOnHA() throws YarnException, IOException {
        AllocateRequest request = AllocateRequest.newInstance((int)0, (float)50.0f, new ArrayList(), new ArrayList(), (ResourceBlacklistRequest)ResourceBlacklistRequest.newInstance(new ArrayList(), new ArrayList()));
        AllocateResponse response = this.amClient.allocate(request);
        Assert.assertEquals((Object)response, (Object)this.cluster.createFakeAllocateResponse());
    }

    private void syncToken(Token<AMRMTokenIdentifier> token) throws IOException {
        for (int i = 0; i < this.cluster.getNumOfResourceManager(); ++i) {
            this.cluster.getResourceManager(i).getRMContext().getAMRMTokenSecretManager().addPersistedPassword(token);
        }
    }
}

