/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util.resource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class DominantResourceCalculator
extends ResourceCalculator {
    private static final Log LOG = LogFactory.getLog(DominantResourceCalculator.class);

    @Override
    public int compare(Resource clusterResource, Resource lhs, Resource rhs) {
        float r;
        float l;
        if (lhs.equals((Object)rhs)) {
            return 0;
        }
        if (this.isInvalidDivisor(clusterResource)) {
            if (lhs.getMemorySize() < rhs.getMemorySize() && lhs.getVirtualCores() > rhs.getVirtualCores() || lhs.getMemorySize() > rhs.getMemorySize() && lhs.getVirtualCores() < rhs.getVirtualCores()) {
                return 0;
            }
            if (lhs.getMemorySize() > rhs.getMemorySize() || lhs.getVirtualCores() > rhs.getVirtualCores()) {
                return 1;
            }
            if (lhs.getMemorySize() < rhs.getMemorySize() || lhs.getVirtualCores() < rhs.getVirtualCores()) {
                return -1;
            }
        }
        if ((l = this.getResourceAsValue(clusterResource, lhs, true)) < (r = this.getResourceAsValue(clusterResource, rhs, true))) {
            return -1;
        }
        if (l > r) {
            return 1;
        }
        l = this.getResourceAsValue(clusterResource, lhs, false);
        if (l < (r = this.getResourceAsValue(clusterResource, rhs, false))) {
            return -1;
        }
        if (l > r) {
            return 1;
        }
        return 0;
    }

    protected float getResourceAsValue(Resource clusterResource, Resource resource, boolean dominant) {
        return dominant ? Math.max((float)resource.getMemorySize() / (float)clusterResource.getMemorySize(), (float)resource.getVirtualCores() / (float)clusterResource.getVirtualCores()) : Math.min((float)resource.getMemorySize() / (float)clusterResource.getMemorySize(), (float)resource.getVirtualCores() / (float)clusterResource.getVirtualCores());
    }

    @Override
    public long computeAvailableContainers(Resource available, Resource required) {
        return Math.min(available.getMemorySize() / required.getMemorySize(), (long)(available.getVirtualCores() / required.getVirtualCores()));
    }

    @Override
    public float divide(Resource clusterResource, Resource numerator, Resource denominator) {
        return this.getResourceAsValue(clusterResource, numerator, true) / this.getResourceAsValue(clusterResource, denominator, true);
    }

    @Override
    public boolean isInvalidDivisor(Resource r) {
        return (float)r.getMemorySize() == 0.0f || (float)r.getVirtualCores() == 0.0f;
    }

    @Override
    public float ratio(Resource a, Resource b) {
        return Math.max((float)a.getMemorySize() / (float)b.getMemorySize(), (float)a.getVirtualCores() / (float)b.getVirtualCores());
    }

    @Override
    public Resource divideAndCeil(Resource numerator, int denominator) {
        return Resources.createResource(DominantResourceCalculator.divideAndCeil(numerator.getMemorySize(), (long)denominator), DominantResourceCalculator.divideAndCeil(numerator.getVirtualCores(), denominator));
    }

    @Override
    public Resource normalize(Resource r, Resource minimumResource, Resource maximumResource, Resource stepFactor) {
        if (stepFactor.getMemorySize() == 0L || stepFactor.getVirtualCores() == 0) {
            Resource step = Resources.clone(stepFactor);
            if (stepFactor.getMemorySize() == 0L) {
                LOG.error((Object)("Memory cannot be allocated in increments of zero. Assuming " + minimumResource.getMemorySize() + "MB increment size. Please ensure the scheduler configuration is correct."));
                step.setMemorySize(minimumResource.getMemorySize());
            }
            if (stepFactor.getVirtualCores() == 0) {
                LOG.error((Object)("VCore cannot be allocated in increments of zero. Assuming " + minimumResource.getVirtualCores() + "VCores increment size. Please ensure the scheduler configuration is correct."));
                step.setVirtualCores(minimumResource.getVirtualCores());
            }
            stepFactor = step;
        }
        long normalizedMemory = Math.min(DominantResourceCalculator.roundUp(Math.max(r.getMemorySize(), minimumResource.getMemorySize()), stepFactor.getMemorySize()), maximumResource.getMemorySize());
        int normalizedCores = Math.min(DominantResourceCalculator.roundUp(Math.max(r.getVirtualCores(), minimumResource.getVirtualCores()), stepFactor.getVirtualCores()), maximumResource.getVirtualCores());
        return Resources.createResource(normalizedMemory, normalizedCores);
    }

    @Override
    public Resource roundUp(Resource r, Resource stepFactor) {
        return Resources.createResource(DominantResourceCalculator.roundUp(r.getMemorySize(), stepFactor.getMemorySize()), DominantResourceCalculator.roundUp(r.getVirtualCores(), stepFactor.getVirtualCores()));
    }

    @Override
    public Resource roundDown(Resource r, Resource stepFactor) {
        return Resources.createResource(DominantResourceCalculator.roundDown(r.getMemorySize(), stepFactor.getMemorySize()), DominantResourceCalculator.roundDown(r.getVirtualCores(), stepFactor.getVirtualCores()));
    }

    @Override
    public Resource multiplyAndNormalizeUp(Resource r, double by, Resource stepFactor) {
        return Resources.createResource(DominantResourceCalculator.roundUp((long)((int)Math.ceil((double)r.getMemorySize() * by)), stepFactor.getMemorySize()), DominantResourceCalculator.roundUp((int)Math.ceil((double)r.getVirtualCores() * by), stepFactor.getVirtualCores()));
    }

    @Override
    public Resource multiplyAndNormalizeDown(Resource r, double by, Resource stepFactor) {
        return Resources.createResource(DominantResourceCalculator.roundDown((long)((int)((double)r.getMemorySize() * by)), stepFactor.getMemorySize()), DominantResourceCalculator.roundDown((int)((double)r.getVirtualCores() * by), stepFactor.getVirtualCores()));
    }

    @Override
    public boolean fitsIn(Resource cluster, Resource smaller, Resource bigger) {
        return smaller.getMemorySize() <= bigger.getMemorySize() && smaller.getVirtualCores() <= bigger.getVirtualCores();
    }
}

