/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.resolver;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.federation.resolver.SubClusterResolver;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;

public abstract class AbstractSubClusterResolver
implements SubClusterResolver {
    private Map<String, SubClusterId> nodeToSubCluster = new ConcurrentHashMap<String, SubClusterId>();
    private Map<String, Set<SubClusterId>> rackToSubClusters = new ConcurrentHashMap<String, Set<SubClusterId>>();

    @Override
    public SubClusterId getSubClusterForNode(String nodename) throws YarnException {
        SubClusterId subClusterId = this.nodeToSubCluster.get(nodename);
        if (subClusterId == null) {
            throw new YarnException("Cannot find subClusterId for node " + nodename);
        }
        return subClusterId;
    }

    @Override
    public Set<SubClusterId> getSubClustersForRack(String rackname) throws YarnException {
        if (!this.rackToSubClusters.containsKey(rackname)) {
            throw new YarnException("Cannot resolve rack " + rackname);
        }
        return this.rackToSubClusters.get(rackname);
    }

    public Map<String, SubClusterId> getNodeToSubCluster() {
        return this.nodeToSubCluster;
    }

    public Map<String, Set<SubClusterId>> getRackToSubClusters() {
        return this.rackToSubClusters;
    }
}

