/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperation;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.CGroupsHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.DiskResourceHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandlerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class CGroupsBlkioResourceHandlerImpl
implements DiskResourceHandler {
    static final Logger LOG = LoggerFactory.getLogger(CGroupsBlkioResourceHandlerImpl.class);
    private CGroupsHandler cGroupsHandler;
    @VisibleForTesting
    static final String DEFAULT_WEIGHT = "500";
    private static final String PARTITIONS_FILE = "/proc/partitions";

    CGroupsBlkioResourceHandlerImpl(CGroupsHandler cGroupsHandler) {
        this.cGroupsHandler = cGroupsHandler;
        if (Shell.LINUX) {
            this.checkDiskScheduler();
        }
    }

    private void checkDiskScheduler() {
        String data;
        try {
            byte[] contents = Files.readAllBytes(Paths.get(PARTITIONS_FILE, new String[0]));
            data = new String(contents, "UTF-8").trim();
        }
        catch (IOException e) {
            String msg = "Couldn't read /proc/partitions; can't determine disk scheduler type";
            LOG.warn(msg, (Throwable)e);
            return;
        }
        String[] lines = data.split(System.lineSeparator());
        if (lines.length > 0) {
            for (String line : lines) {
                String schedulerPath;
                File schedulerFile;
                String partition;
                String[] columns = line.split("\\s+");
                if (columns.length <= 4 || !(partition = columns[4]).startsWith("sd") && !partition.startsWith("hd") && !partition.startsWith("vd") && !partition.startsWith("xvd") || !(schedulerFile = new File(schedulerPath = "/sys/block/" + partition + "/queue/scheduler")).exists()) continue;
                try {
                    byte[] contents = Files.readAllBytes(Paths.get(schedulerPath, new String[0]));
                    String schedulerString = new String(contents, "UTF-8").trim();
                    if (schedulerString.contains("[cfq]")) continue;
                    LOG.warn("Device " + partition + " does not use the CFQ scheduler; disk isolation using CGroups will not work on this partition.");
                }
                catch (IOException ie) {
                    LOG.warn("Unable to determine disk scheduler type for partition " + partition, (Throwable)ie);
                }
            }
        }
    }

    @Override
    public List<PrivilegedOperation> bootstrap(Configuration configuration) throws ResourceHandlerException {
        this.cGroupsHandler.initializeCGroupController(CGroupsHandler.CGroupController.BLKIO);
        return null;
    }

    @Override
    public List<PrivilegedOperation> preStart(Container container) throws ResourceHandlerException {
        String cgroupId = container.getContainerId().toString();
        this.cGroupsHandler.createCGroup(CGroupsHandler.CGroupController.BLKIO, cgroupId);
        try {
            this.cGroupsHandler.updateCGroupParam(CGroupsHandler.CGroupController.BLKIO, cgroupId, "weight", DEFAULT_WEIGHT);
        }
        catch (ResourceHandlerException re) {
            this.cGroupsHandler.deleteCGroup(CGroupsHandler.CGroupController.BLKIO, cgroupId);
            LOG.warn("Could not update cgroup for container", (Throwable)((Object)re));
            throw re;
        }
        ArrayList<PrivilegedOperation> ret = new ArrayList<PrivilegedOperation>();
        ret.add(new PrivilegedOperation(PrivilegedOperation.OperationType.ADD_PID_TO_CGROUP, "cgroups=" + this.cGroupsHandler.getPathForCGroupTasks(CGroupsHandler.CGroupController.BLKIO, cgroupId)));
        return ret;
    }

    @Override
    public List<PrivilegedOperation> reacquireContainer(ContainerId containerId) throws ResourceHandlerException {
        return null;
    }

    @Override
    public List<PrivilegedOperation> postComplete(ContainerId containerId) throws ResourceHandlerException {
        this.cGroupsHandler.deleteCGroup(CGroupsHandler.CGroupController.BLKIO, containerId.toString());
        return null;
    }

    @Override
    public List<PrivilegedOperation> teardown() throws ResourceHandlerException {
        return null;
    }

    public String toString() {
        return CGroupsBlkioResourceHandlerImpl.class.getName();
    }
}

