/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.net.InetAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;

public class RMAuditLogger {
    private static final Log LOG = LogFactory.getLog(RMAuditLogger.class);

    static String createSuccessLog(String user, String operation, String target, ApplicationId appId, ApplicationAttemptId attemptId, ContainerId containerId) {
        StringBuilder b = new StringBuilder();
        RMAuditLogger.start(Keys.USER, user, b);
        RMAuditLogger.addRemoteIP(b);
        RMAuditLogger.add(Keys.OPERATION, operation, b);
        RMAuditLogger.add(Keys.TARGET, target, b);
        RMAuditLogger.add(Keys.RESULT, "SUCCESS", b);
        if (appId != null) {
            RMAuditLogger.add(Keys.APPID, appId.toString(), b);
        }
        if (attemptId != null) {
            RMAuditLogger.add(Keys.APPATTEMPTID, attemptId.toString(), b);
        }
        if (containerId != null) {
            RMAuditLogger.add(Keys.CONTAINERID, containerId.toString(), b);
        }
        return b.toString();
    }

    public static void logSuccess(String user, String operation, String target, ApplicationId appId, ContainerId containerId) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)RMAuditLogger.createSuccessLog(user, operation, target, appId, null, containerId));
        }
    }

    public static void logSuccess(String user, String operation, String target, ApplicationId appId, ApplicationAttemptId attemptId) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)RMAuditLogger.createSuccessLog(user, operation, target, appId, attemptId, null));
        }
    }

    public static void logSuccess(String user, String operation, String target, ApplicationId appId) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)RMAuditLogger.createSuccessLog(user, operation, target, appId, null, null));
        }
    }

    public static void logSuccess(String user, String operation, String target) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)RMAuditLogger.createSuccessLog(user, operation, target, null, null, null));
        }
    }

    static String createFailureLog(String user, String operation, String perm, String target, String description, ApplicationId appId, ApplicationAttemptId attemptId, ContainerId containerId) {
        StringBuilder b = new StringBuilder();
        RMAuditLogger.start(Keys.USER, user, b);
        RMAuditLogger.addRemoteIP(b);
        RMAuditLogger.add(Keys.OPERATION, operation, b);
        RMAuditLogger.add(Keys.TARGET, target, b);
        RMAuditLogger.add(Keys.RESULT, "FAILURE", b);
        RMAuditLogger.add(Keys.DESCRIPTION, description, b);
        RMAuditLogger.add(Keys.PERMISSIONS, perm, b);
        if (appId != null) {
            RMAuditLogger.add(Keys.APPID, appId.toString(), b);
        }
        if (attemptId != null) {
            RMAuditLogger.add(Keys.APPATTEMPTID, attemptId.toString(), b);
        }
        if (containerId != null) {
            RMAuditLogger.add(Keys.CONTAINERID, containerId.toString(), b);
        }
        return b.toString();
    }

    public static void logFailure(String user, String operation, String perm, String target, String description, ApplicationId appId, ContainerId containerId) {
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)RMAuditLogger.createFailureLog(user, operation, perm, target, description, appId, null, containerId));
        }
    }

    public static void logFailure(String user, String operation, String perm, String target, String description, ApplicationId appId, ApplicationAttemptId attemptId) {
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)RMAuditLogger.createFailureLog(user, operation, perm, target, description, appId, attemptId, null));
        }
    }

    public static void logFailure(String user, String operation, String perm, String target, String description, ApplicationId appId) {
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)RMAuditLogger.createFailureLog(user, operation, perm, target, description, appId, null, null));
        }
    }

    public static void logFailure(String user, String operation, String perm, String target, String description) {
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)RMAuditLogger.createFailureLog(user, operation, perm, target, description, null, null, null));
        }
    }

    static void addRemoteIP(StringBuilder b) {
        InetAddress ip = Server.getRemoteIp();
        if (ip != null) {
            RMAuditLogger.add(Keys.IP, ip.getHostAddress(), b);
        }
    }

    static void start(Keys key, String value, StringBuilder b) {
        b.append(key.name()).append("=").append(value);
    }

    static void add(Keys key, String value, StringBuilder b) {
        b.append('\t').append(key.name()).append("=").append(value);
    }

    public static class AuditConstants {
        static final String SUCCESS = "SUCCESS";
        static final String FAILURE = "FAILURE";
        static final String KEY_VAL_SEPARATOR = "=";
        static final char PAIR_SEPARATOR = '\t';
        public static final String KILL_APP_REQUEST = "Kill Application Request";
        public static final String SUBMIT_APP_REQUEST = "Submit Application Request";
        public static final String MOVE_APP_REQUEST = "Move Application Request";
        public static final String FINISH_SUCCESS_APP = "Application Finished - Succeeded";
        public static final String FINISH_FAILED_APP = "Application Finished - Failed";
        public static final String FINISH_KILLED_APP = "Application Finished - Killed";
        public static final String REGISTER_AM = "Register App Master";
        public static final String UNREGISTER_AM = "Unregister App Master";
        public static final String ALLOC_CONTAINER = "AM Allocated Container";
        public static final String RELEASE_CONTAINER = "AM Released Container";
        public static final String UNAUTHORIZED_USER = "Unauthorized user";
    }

    static enum Keys {
        USER,
        OPERATION,
        TARGET,
        RESULT,
        IP,
        PERMISSIONS,
        DESCRIPTION,
        APPID,
        APPATTEMPTID,
        CONTAINERID;

    }
}

