/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AppSchedulable;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;

public class MaxRunningAppsEnforcer {
    private static final Log LOG = LogFactory.getLog(FairScheduler.class);
    private final FairScheduler scheduler;
    private final Map<String, Integer> usersNumRunnableApps;
    @VisibleForTesting
    final ListMultimap<String, AppSchedulable> usersNonRunnableApps;

    public MaxRunningAppsEnforcer(FairScheduler scheduler) {
        this.scheduler = scheduler;
        this.usersNumRunnableApps = new HashMap<String, Integer>();
        this.usersNonRunnableApps = ArrayListMultimap.create();
    }

    public boolean canAppBeRunnable(FSQueue queue, String user) {
        AllocationConfiguration allocConf = this.scheduler.getAllocationConfiguration();
        Integer userNumRunnable = this.usersNumRunnableApps.get(user);
        if (userNumRunnable == null) {
            userNumRunnable = 0;
        }
        if (userNumRunnable >= allocConf.getUserMaxApps(user)) {
            return false;
        }
        while (queue != null) {
            int queueMaxApps = allocConf.getQueueMaxApps(queue.getName());
            if (queue.getNumRunnableApps() >= queueMaxApps) {
                return false;
            }
            queue = queue.getParent();
        }
        return true;
    }

    public void trackRunnableApp(FSSchedulerApp app) {
        String user = app.getUser();
        FSLeafQueue queue = app.getQueue();
        for (FSParentQueue parent = queue.getParent(); parent != null; parent = parent.getParent()) {
            parent.incrementRunnableApps();
        }
        Integer userNumRunnable = this.usersNumRunnableApps.get(user);
        this.usersNumRunnableApps.put(user, (userNumRunnable == null ? 0 : userNumRunnable) + 1);
    }

    public void trackNonRunnableApp(FSSchedulerApp app) {
        String user = app.getUser();
        this.usersNonRunnableApps.put((Object)user, (Object)app.getAppSchedulable());
    }

    public void updateRunnabilityOnAppRemoval(FSSchedulerApp app, FSLeafQueue queue) {
        List userWaitingApps;
        String user;
        Integer userNumRunning;
        AllocationConfiguration allocConf = this.scheduler.getAllocationConfiguration();
        FSQueue highestQueueWithAppsNowRunnable = queue.getNumRunnableApps() == allocConf.getQueueMaxApps(queue.getName()) - 1 ? queue : null;
        for (FSParentQueue parent = queue.getParent(); parent != null; parent = parent.getParent()) {
            if (parent.getNumRunnableApps() != allocConf.getQueueMaxApps(parent.getName()) - 1) continue;
            highestQueueWithAppsNowRunnable = parent;
        }
        ArrayList<List<AppSchedulable>> appsNowMaybeRunnable = new ArrayList<List<AppSchedulable>>();
        if (highestQueueWithAppsNowRunnable != null) {
            this.gatherPossiblyRunnableAppLists(highestQueueWithAppsNowRunnable, appsNowMaybeRunnable);
        }
        if ((userNumRunning = this.usersNumRunnableApps.get(user = app.getUser())) == null) {
            userNumRunning = 0;
        }
        if (userNumRunning == allocConf.getUserMaxApps(user) - 1 && (userWaitingApps = this.usersNonRunnableApps.get((Object)user)) != null) {
            appsNowMaybeRunnable.add(userWaitingApps);
        }
        MultiListStartTimeIterator iter = new MultiListStartTimeIterator(appsNowMaybeRunnable);
        FSSchedulerApp prev = null;
        ArrayList<AppSchedulable> noLongerPendingApps = new ArrayList<AppSchedulable>();
        while (iter.hasNext()) {
            FSSchedulerApp next = (FSSchedulerApp)iter.next();
            if (next == prev) continue;
            if (this.canAppBeRunnable(next.getQueue(), next.getUser())) {
                this.trackRunnableApp(next);
                AppSchedulable appSched = next.getAppSchedulable();
                next.getQueue().getRunnableAppSchedulables().add(appSched);
                noLongerPendingApps.add(appSched);
                if (noLongerPendingApps.size() >= appsNowMaybeRunnable.size()) break;
            }
            prev = next;
        }
        for (AppSchedulable appSched : noLongerPendingApps) {
            if (!appSched.getApp().getQueue().getNonRunnableAppSchedulables().remove(appSched)) {
                LOG.error((Object)("Can't make app runnable that does not already exist in queue as non-runnable: " + appSched + ". This should never happen."));
            }
            if (this.usersNonRunnableApps.remove((Object)appSched.getApp().getUser(), (Object)appSched)) continue;
            LOG.error((Object)("Waiting app " + appSched + " expected to be in " + "usersNonRunnableApps, but was not. This should never happen."));
        }
    }

    public void untrackRunnableApp(FSSchedulerApp app) {
        String user = app.getUser();
        int newUserNumRunning = this.usersNumRunnableApps.get(user) - 1;
        if (newUserNumRunning == 0) {
            this.usersNumRunnableApps.remove(user);
        } else {
            this.usersNumRunnableApps.put(user, newUserNumRunning);
        }
        FSLeafQueue queue = app.getQueue();
        for (FSParentQueue parent = queue.getParent(); parent != null; parent = parent.getParent()) {
            parent.decrementRunnableApps();
        }
    }

    public void untrackNonRunnableApp(FSSchedulerApp app) {
        this.usersNonRunnableApps.remove((Object)app.getUser(), (Object)app.getAppSchedulable());
    }

    private void gatherPossiblyRunnableAppLists(FSQueue queue, List<List<AppSchedulable>> appLists) {
        if (queue.getNumRunnableApps() < this.scheduler.getAllocationConfiguration().getQueueMaxApps(queue.getName())) {
            if (queue instanceof FSLeafQueue) {
                appLists.add(((FSLeafQueue)queue).getNonRunnableAppSchedulables());
            } else {
                for (FSQueue child : queue.getChildQueues()) {
                    this.gatherPossiblyRunnableAppLists(child, appLists);
                }
            }
        }
    }

    static class MultiListStartTimeIterator
    implements Iterator<FSSchedulerApp> {
        private List<AppSchedulable>[] appLists;
        private int[] curPositionsInAppLists;
        private PriorityQueue<IndexAndTime> appListsByCurStartTime;

        public MultiListStartTimeIterator(List<List<AppSchedulable>> appListList) {
            this.appLists = appListList.toArray(new List[appListList.size()]);
            this.curPositionsInAppLists = new int[this.appLists.length];
            this.appListsByCurStartTime = new PriorityQueue();
            for (int i = 0; i < this.appLists.length; ++i) {
                long time = this.appLists[i].isEmpty() ? Long.MAX_VALUE : this.appLists[i].get(0).getStartTime();
                this.appListsByCurStartTime.add(new IndexAndTime(i, time));
            }
        }

        @Override
        public boolean hasNext() {
            return !this.appListsByCurStartTime.isEmpty() && this.appListsByCurStartTime.peek().time != Long.MAX_VALUE;
        }

        @Override
        public FSSchedulerApp next() {
            IndexAndTime indexAndTime = (IndexAndTime)this.appListsByCurStartTime.remove();
            int nextListIndex = indexAndTime.index;
            AppSchedulable next = this.appLists[nextListIndex].get(this.curPositionsInAppLists[nextListIndex]);
            int n = nextListIndex;
            this.curPositionsInAppLists[n] = this.curPositionsInAppLists[n] + 1;
            indexAndTime.time = this.curPositionsInAppLists[nextListIndex] < this.appLists[nextListIndex].size() ? this.appLists[nextListIndex].get(this.curPositionsInAppLists[nextListIndex]).getStartTime() : Long.MAX_VALUE;
            this.appListsByCurStartTime.add(indexAndTime);
            return next.getApp();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove not supported");
        }

        private static class IndexAndTime
        implements Comparable<IndexAndTime> {
            public int index;
            public long time;

            public IndexAndTime(int index, long time) {
                this.index = index;
                this.time = time;
            }

            @Override
            public int compareTo(IndexAndTime o) {
                return this.time < o.time ? -1 : (this.time > o.time ? 1 : 0);
            }

            public boolean equals(Object o) {
                if (!(o instanceof IndexAndTime)) {
                    return false;
                }
                IndexAndTime other = (IndexAndTime)o;
                return other.time == this.time;
            }

            public int hashCode() {
                return (int)this.time;
            }
        }
    }
}

