/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.security;

import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.security.client.BaseClientToAMTokenSecretManager;

public class ClientToAMTokenSecretManagerInRM
extends BaseClientToAMTokenSecretManager {
    private Map<ApplicationAttemptId, SecretKey> masterKeys = new HashMap<ApplicationAttemptId, SecretKey>();

    public synchronized SecretKey createMasterKey(ApplicationAttemptId applicationAttemptID) {
        return this.generateSecret();
    }

    public synchronized void registerApplication(ApplicationAttemptId applicationAttemptID, SecretKey key) {
        this.masterKeys.put(applicationAttemptID, key);
    }

    public synchronized SecretKey registerMasterKey(ApplicationAttemptId applicationAttemptID, byte[] keyData) {
        SecretKey key = ClientToAMTokenSecretManagerInRM.createSecretKey((byte[])keyData);
        this.registerApplication(applicationAttemptID, key);
        return key;
    }

    public synchronized void unRegisterApplication(ApplicationAttemptId applicationAttemptID) {
        this.masterKeys.remove(applicationAttemptID);
    }

    public synchronized SecretKey getMasterKey(ApplicationAttemptId applicationAttemptID) {
        return this.masterKeys.get(applicationAttemptID);
    }

    @VisibleForTesting
    public synchronized boolean hasMasterKey(ApplicationAttemptId applicationAttemptID) {
        return this.masterKeys.containsKey(applicationAttemptID);
    }
}

