/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.CellScannable;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.MultiAction;
import org.apache.hadoop.hbase.client.MultiResponse;
import org.apache.hadoop.hbase.client.PayloadCarryingServerCallable;
import org.apache.hadoop.hbase.client.RetryingTimeTracker;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.RequestConverter;
import org.apache.hadoop.hbase.protobuf.ResponseConverter;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;

class MultiServerCallable<R>
extends PayloadCarryingServerCallable<MultiResponse> {
    private final MultiAction<R> multiAction;
    private final boolean cellBlock;
    private final RetryingTimeTracker tracker;
    private final int rpcTimeout;

    MultiServerCallable(ClusterConnection connection, TableName tableName, ServerName location, RpcControllerFactory rpcFactory, MultiAction<R> multi, int rpcTimeout, RetryingTimeTracker tracker) {
        super(connection, tableName, null, rpcFactory);
        this.multiAction = multi;
        this.location = new HRegionLocation(null, location);
        this.cellBlock = this.isCellBlock();
        this.tracker = tracker;
        this.rpcTimeout = rpcTimeout;
    }

    @Override
    protected HRegionLocation getLocation() {
        throw new RuntimeException("Cannot get region location for multi-region request");
    }

    @Override
    public HRegionInfo getHRegionInfo() {
        throw new RuntimeException("Cannot get region info for multi-region request");
    }

    MultiAction<R> getMulti() {
        return this.multiAction;
    }

    @Override
    public MultiResponse call(int operationTimeout) throws IOException {
        ClientProtos.MultiResponse responseProto;
        int remainingTime = this.tracker.getRemainingTime(operationTimeout);
        if (remainingTime <= 1) {
            throw new DoNotRetryIOException("Operation Timeout");
        }
        int callTimeout = Math.min(this.rpcTimeout, remainingTime);
        int countOfActions = this.multiAction.size();
        if (countOfActions <= 0) {
            throw new DoNotRetryIOException("No Actions");
        }
        ClientProtos.MultiRequest.Builder multiRequestBuilder = ClientProtos.MultiRequest.newBuilder();
        ClientProtos.RegionAction.Builder regionActionBuilder = ClientProtos.RegionAction.newBuilder();
        ClientProtos.Action.Builder actionBuilder = ClientProtos.Action.newBuilder();
        ClientProtos.MutationProto.Builder mutationBuilder = ClientProtos.MutationProto.newBuilder();
        ArrayList<CellScannable> cells = null;
        long nonceGroup = this.multiAction.getNonceGroup();
        if (nonceGroup != 0L) {
            multiRequestBuilder.setNonceGroup(nonceGroup);
        }
        for (Map.Entry e : this.multiAction.actions.entrySet()) {
            byte[] regionName = e.getKey();
            List actions = e.getValue();
            regionActionBuilder.clear();
            regionActionBuilder.setRegion(RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName));
            if (this.cellBlock) {
                if (cells == null) {
                    cells = new ArrayList<CellScannable>(countOfActions);
                }
                regionActionBuilder = RequestConverter.buildNoDataRegionAction(regionName, actions, cells, regionActionBuilder, actionBuilder, mutationBuilder);
            } else {
                regionActionBuilder = RequestConverter.buildRegionAction(regionName, actions, regionActionBuilder, actionBuilder, mutationBuilder);
            }
            multiRequestBuilder.addRegionAction(regionActionBuilder.build());
        }
        if (cells != null) {
            this.controller.setCellScanner(CellUtil.createCellScanner(cells));
        }
        this.controller.setPriority(this.getTableName());
        this.controller.setCallTimeout(callTimeout);
        ClientProtos.MultiRequest requestProto = multiRequestBuilder.build();
        try {
            responseProto = this.getStub().multi((RpcController)this.controller, requestProto);
        }
        catch (ServiceException e) {
            throw ProtobufUtil.getRemoteException(e);
        }
        if (responseProto == null) {
            return null;
        }
        return ResponseConverter.getResults(requestProto, responseProto, this.controller.cellScanner());
    }

    private boolean isCellBlock() {
        HConnection connection = this.getConnection();
        if (!(connection instanceof ClusterConnection)) {
            return true;
        }
        return ((ClusterConnection)connection).hasCellBlockSupport();
    }

    @Override
    public void prepare(boolean reload) throws IOException {
        this.setStub(this.getConnection().getClient(this.location.getServerName()));
    }

    @VisibleForTesting
    ServerName getServerName() {
        return this.location.getServerName();
    }
}

