/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.ArrayBackedTag;
import org.apache.hadoop.hbase.ByteBufferKeyOnlyKeyValue;
import org.apache.hadoop.hbase.ByteBufferKeyValue;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, SmallTests.class})
public class TestByteBufferKeyValue {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestByteBufferKeyValue.class);
    private static final String QUAL2 = "qual2";
    private static final String FAM2 = "fam2";
    private static final String QUAL1 = "qual1";
    private static final String FAM1 = "fam1";
    private static final String ROW1 = "row1";
    private static final byte[] row1 = Bytes.toBytes((String)"row1");
    private static final byte[] fam1 = Bytes.toBytes((String)"fam1");
    private static final byte[] fam2 = Bytes.toBytes((String)"fam2");
    private static final byte[] qual1 = Bytes.toBytes((String)"qual1");
    private static final byte[] qual2 = Bytes.toBytes((String)"qual2");
    private static final Tag t1 = new ArrayBackedTag(1, Bytes.toBytes((String)"TAG1"));
    private static final Tag t2 = new ArrayBackedTag(2, Bytes.toBytes((String)"TAG2"));
    private static final ArrayList<Tag> tags = new ArrayList();

    @Test
    public void testByteBufferBackedKeyValue() throws Exception {
        KeyValue kvCell = new KeyValue(row1, fam1, qual1, 0L, KeyValue.Type.Put, row1);
        ByteBuffer buf = ByteBuffer.allocateDirect(kvCell.getBuffer().length);
        ByteBufferUtils.copyFromArrayToBuffer((ByteBuffer)buf, (byte[])kvCell.getBuffer(), (int)0, (int)kvCell.getBuffer().length);
        ByteBufferKeyValue offheapKV = new ByteBufferKeyValue(buf, 0, buf.capacity(), 0L);
        Assert.assertEquals((Object)ROW1, (Object)ByteBufferUtils.toStringBinary((ByteBuffer)offheapKV.getRowByteBuffer(), (int)offheapKV.getRowPosition(), (int)offheapKV.getRowLength()));
        Assert.assertEquals((Object)FAM1, (Object)ByteBufferUtils.toStringBinary((ByteBuffer)offheapKV.getFamilyByteBuffer(), (int)offheapKV.getFamilyPosition(), (int)offheapKV.getFamilyLength()));
        Assert.assertEquals((Object)QUAL1, (Object)ByteBufferUtils.toStringBinary((ByteBuffer)offheapKV.getQualifierByteBuffer(), (int)offheapKV.getQualifierPosition(), (int)offheapKV.getQualifierLength()));
        Assert.assertEquals((Object)ROW1, (Object)ByteBufferUtils.toStringBinary((ByteBuffer)offheapKV.getValueByteBuffer(), (int)offheapKV.getValuePosition(), (int)offheapKV.getValueLength()));
        Assert.assertEquals((long)0L, (long)offheapKV.getTimestamp());
        Assert.assertEquals((long)KeyValue.Type.Put.getCode(), (long)offheapKV.getTypeByte());
        Assert.assertEquals((Object)ROW1, (Object)Bytes.toStringBinary((byte[])offheapKV.getRowArray(), (int)offheapKV.getRowOffset(), (int)offheapKV.getRowLength()));
        Assert.assertEquals((Object)FAM1, (Object)Bytes.toStringBinary((byte[])offheapKV.getFamilyArray(), (int)offheapKV.getFamilyOffset(), (int)offheapKV.getFamilyLength()));
        Assert.assertEquals((Object)QUAL1, (Object)Bytes.toStringBinary((byte[])offheapKV.getQualifierArray(), (int)offheapKV.getQualifierOffset(), (int)offheapKV.getQualifierLength()));
        Assert.assertEquals((Object)ROW1, (Object)Bytes.toStringBinary((byte[])offheapKV.getValueArray(), (int)offheapKV.getValueOffset(), (int)offheapKV.getValueLength()));
        Assert.assertEquals((long)0L, (long)offheapKV.getTimestamp());
        Assert.assertEquals((long)KeyValue.Type.Put.getCode(), (long)offheapKV.getTypeByte());
        kvCell = new KeyValue(row1, fam2, qual2, 0L, KeyValue.Type.Put, row1);
        buf = ByteBuffer.allocateDirect(kvCell.getBuffer().length);
        ByteBufferUtils.copyFromArrayToBuffer((ByteBuffer)buf, (byte[])kvCell.getBuffer(), (int)0, (int)kvCell.getBuffer().length);
        offheapKV = new ByteBufferKeyValue(buf, 0, buf.capacity(), 0L);
        Assert.assertEquals((Object)FAM2, (Object)ByteBufferUtils.toStringBinary((ByteBuffer)offheapKV.getFamilyByteBuffer(), (int)offheapKV.getFamilyPosition(), (int)offheapKV.getFamilyLength()));
        Assert.assertEquals((Object)QUAL2, (Object)ByteBufferUtils.toStringBinary((ByteBuffer)offheapKV.getQualifierByteBuffer(), (int)offheapKV.getQualifierPosition(), (int)offheapKV.getQualifierLength()));
        byte[] nullQualifier = new byte[]{};
        kvCell = new KeyValue(row1, fam1, nullQualifier, 0L, KeyValue.Type.Put, row1);
        buf = ByteBuffer.allocateDirect(kvCell.getBuffer().length);
        ByteBufferUtils.copyFromArrayToBuffer((ByteBuffer)buf, (byte[])kvCell.getBuffer(), (int)0, (int)kvCell.getBuffer().length);
        offheapKV = new ByteBufferKeyValue(buf, 0, buf.capacity(), 0L);
        Assert.assertEquals((Object)ROW1, (Object)ByteBufferUtils.toStringBinary((ByteBuffer)offheapKV.getRowByteBuffer(), (int)offheapKV.getRowPosition(), (int)offheapKV.getRowLength()));
        Assert.assertEquals((Object)FAM1, (Object)ByteBufferUtils.toStringBinary((ByteBuffer)offheapKV.getFamilyByteBuffer(), (int)offheapKV.getFamilyPosition(), (int)offheapKV.getFamilyLength()));
        Assert.assertEquals((Object)"", (Object)ByteBufferUtils.toStringBinary((ByteBuffer)offheapKV.getQualifierByteBuffer(), (int)offheapKV.getQualifierPosition(), (int)offheapKV.getQualifierLength()));
        Assert.assertEquals((Object)ROW1, (Object)ByteBufferUtils.toStringBinary((ByteBuffer)offheapKV.getValueByteBuffer(), (int)offheapKV.getValuePosition(), (int)offheapKV.getValueLength()));
        Assert.assertEquals((long)0L, (long)offheapKV.getTimestamp());
        Assert.assertEquals((long)KeyValue.Type.Put.getCode(), (long)offheapKV.getTypeByte());
    }

    @Test
    public void testByteBufferBackedKeyValueWithTags() throws Exception {
        KeyValue kvCell = new KeyValue(row1, fam1, qual1, 0L, KeyValue.Type.Put, row1, tags);
        ByteBuffer buf = ByteBuffer.allocateDirect(kvCell.getBuffer().length);
        ByteBufferUtils.copyFromArrayToBuffer((ByteBuffer)buf, (byte[])kvCell.getBuffer(), (int)0, (int)kvCell.getBuffer().length);
        ByteBufferKeyValue offheapKV = new ByteBufferKeyValue(buf, 0, buf.capacity(), 0L);
        Assert.assertEquals((Object)ROW1, (Object)ByteBufferUtils.toStringBinary((ByteBuffer)offheapKV.getRowByteBuffer(), (int)offheapKV.getRowPosition(), (int)offheapKV.getRowLength()));
        Assert.assertEquals((Object)FAM1, (Object)ByteBufferUtils.toStringBinary((ByteBuffer)offheapKV.getFamilyByteBuffer(), (int)offheapKV.getFamilyPosition(), (int)offheapKV.getFamilyLength()));
        Assert.assertEquals((Object)QUAL1, (Object)ByteBufferUtils.toStringBinary((ByteBuffer)offheapKV.getQualifierByteBuffer(), (int)offheapKV.getQualifierPosition(), (int)offheapKV.getQualifierLength()));
        Assert.assertEquals((Object)ROW1, (Object)ByteBufferUtils.toStringBinary((ByteBuffer)offheapKV.getValueByteBuffer(), (int)offheapKV.getValuePosition(), (int)offheapKV.getValueLength()));
        Assert.assertEquals((long)0L, (long)offheapKV.getTimestamp());
        Assert.assertEquals((long)KeyValue.Type.Put.getCode(), (long)offheapKV.getTypeByte());
        List resTags = PrivateCellUtil.getTags((Cell)offheapKV);
        Tag tag1 = (Tag)resTags.get(0);
        Assert.assertEquals((long)t1.getType(), (long)tag1.getType());
        Assert.assertEquals((Object)Tag.getValueAsString((Tag)t1), (Object)Tag.getValueAsString((Tag)tag1));
        Tag tag2 = (Tag)resTags.get(1);
        Assert.assertEquals((long)tag2.getType(), (long)tag2.getType());
        Assert.assertEquals((Object)Tag.getValueAsString((Tag)t2), (Object)Tag.getValueAsString((Tag)tag2));
        Tag res = (Tag)PrivateCellUtil.getTag((Cell)offheapKV, (byte)2).get();
        Assert.assertEquals((Object)Tag.getValueAsString((Tag)t2), (Object)Tag.getValueAsString((Tag)tag2));
        Assert.assertFalse((boolean)PrivateCellUtil.getTag((Cell)offheapKV, (byte)3).isPresent());
    }

    @Test
    public void testGetKeyMethods() throws Exception {
        KeyValue kvCell = new KeyValue(row1, fam1, qual1, 0L, KeyValue.Type.Put, row1, tags);
        ByteBuffer buf = ByteBuffer.allocateDirect(kvCell.getKeyLength());
        ByteBufferUtils.copyFromArrayToBuffer((ByteBuffer)buf, (byte[])kvCell.getBuffer(), (int)kvCell.getKeyOffset(), (int)kvCell.getKeyLength());
        ByteBufferKeyOnlyKeyValue offheapKeyOnlyKV = new ByteBufferKeyOnlyKeyValue(buf, 0, buf.capacity());
        Assert.assertEquals((Object)ROW1, (Object)ByteBufferUtils.toStringBinary((ByteBuffer)offheapKeyOnlyKV.getRowByteBuffer(), (int)offheapKeyOnlyKV.getRowPosition(), (int)offheapKeyOnlyKV.getRowLength()));
        Assert.assertEquals((Object)FAM1, (Object)ByteBufferUtils.toStringBinary((ByteBuffer)offheapKeyOnlyKV.getFamilyByteBuffer(), (int)offheapKeyOnlyKV.getFamilyPosition(), (int)offheapKeyOnlyKV.getFamilyLength()));
        Assert.assertEquals((Object)QUAL1, (Object)ByteBufferUtils.toStringBinary((ByteBuffer)offheapKeyOnlyKV.getQualifierByteBuffer(), (int)offheapKeyOnlyKV.getQualifierPosition(), (int)offheapKeyOnlyKV.getQualifierLength()));
        Assert.assertEquals((long)0L, (long)offheapKeyOnlyKV.getTimestamp());
        Assert.assertEquals((long)KeyValue.Type.Put.getCode(), (long)offheapKeyOnlyKV.getTypeByte());
    }

    static {
        tags.add(t1);
        tags.add(t2);
    }
}

