/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.types;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.types.DataType;
import org.apache.hadoop.hbase.types.RawInteger;
import org.apache.hadoop.hbase.types.RawStringTerminated;
import org.apache.hadoop.hbase.types.Union2;
import org.apache.hadoop.hbase.util.Order;
import org.apache.hadoop.hbase.util.PositionedByteRange;
import org.apache.hadoop.hbase.util.SimplePositionedMutableByteRange;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, SmallTests.class})
public class TestUnion2 {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestUnion2.class);

    @Test
    public void testEncodeDecode() {
        Integer intVal = 10;
        String strVal = "hello";
        SimplePositionedMutableByteRange buff = new SimplePositionedMutableByteRange(10);
        SampleUnion1 type = new SampleUnion1();
        type.encode((PositionedByteRange)buff, intVal);
        buff.setPosition(0);
        Assert.assertTrue((0 == intVal.compareTo((Integer)type.decodeA((PositionedByteRange)buff)) ? 1 : 0) != 0);
        buff.setPosition(0);
        type.encode((PositionedByteRange)buff, strVal);
        buff.setPosition(0);
        Assert.assertTrue((0 == strVal.compareTo((String)type.decodeB((PositionedByteRange)buff)) ? 1 : 0) != 0);
    }

    @Test
    public void testSkip() {
        Integer intVal = 10;
        String strVal = "hello";
        SimplePositionedMutableByteRange buff = new SimplePositionedMutableByteRange(10);
        SampleUnion1 type = new SampleUnion1();
        int len = type.encode((PositionedByteRange)buff, intVal);
        buff.setPosition(0);
        Assert.assertEquals((long)len, (long)type.skip((PositionedByteRange)buff));
        buff.setPosition(0);
        len = type.encode((PositionedByteRange)buff, strVal);
        buff.setPosition(0);
        Assert.assertEquals((long)len, (long)type.skip((PositionedByteRange)buff));
    }

    private static class SampleUnion1
    extends Union2<Integer, String> {
        private static final byte IS_INTEGER = 0;
        private static final byte IS_STRING = 1;

        public SampleUnion1() {
            super((DataType)new RawInteger(), (DataType)new RawStringTerminated(Order.DESCENDING, "."));
        }

        public int skip(PositionedByteRange src) {
            switch (src.get()) {
                case 0: {
                    return 1 + this.typeA.skip(src);
                }
                case 1: {
                    return 1 + this.typeB.skip(src);
                }
            }
            throw new IllegalArgumentException("Unrecognized encoding format.");
        }

        public Object decode(PositionedByteRange src) {
            switch (src.get()) {
                case 0: {
                    return this.typeA.decode(src);
                }
                case 1: {
                    return this.typeB.decode(src);
                }
            }
            throw new IllegalArgumentException("Unrecognized encoding format.");
        }

        public int encodedLength(Object val) {
            Integer i = null;
            String s = null;
            try {
                i = (Integer)val;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            try {
                s = (String)val;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            if (null != i) {
                return 1 + this.typeA.encodedLength((Object)i);
            }
            if (null != s) {
                return 1 + this.typeB.encodedLength((Object)s);
            }
            throw new IllegalArgumentException("val is not a valid member of this union.");
        }

        public int encode(PositionedByteRange dst, Object val) {
            Integer i = null;
            String s = null;
            try {
                i = (Integer)val;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            try {
                s = (String)val;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            if (null != i) {
                dst.put((byte)0);
                return 1 + this.typeA.encode(dst, (Object)i);
            }
            if (null != s) {
                dst.put((byte)1);
                return 1 + this.typeB.encode(dst, (Object)s);
            }
            throw new IllegalArgumentException("val is not of a supported type.");
        }
    }
}

