/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.Serializable;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.util.ClassSize;

@InterfaceAudience.Private
public class BlockCacheKey
implements HeapSize,
Serializable {
    private static final long serialVersionUID = -5199992013113130534L;
    private final String hfileName;
    private final long offset;
    public static final long FIXED_OVERHEAD = ClassSize.align((int)(ClassSize.OBJECT + ClassSize.REFERENCE + 8));

    public BlockCacheKey(String hfileName, long offset) {
        this.hfileName = hfileName;
        this.offset = offset;
    }

    public int hashCode() {
        return this.hfileName.hashCode() * 127 + (int)(this.offset ^ this.offset >>> 32);
    }

    public boolean equals(Object o) {
        if (o instanceof BlockCacheKey) {
            BlockCacheKey k = (BlockCacheKey)o;
            return this.offset == k.offset && (this.hfileName == null ? k.hfileName == null : this.hfileName.equals(k.hfileName));
        }
        return false;
    }

    public String toString() {
        return String.format("%s_%d", this.hfileName, this.offset);
    }

    public long heapSize() {
        return ClassSize.align((long)(FIXED_OVERHEAD + (long)ClassSize.STRING + (long)(2 * this.hfileName.length())));
    }

    public String getHfileName() {
        return this.hfileName;
    }

    public long getOffset() {
        return this.offset;
    }
}

