/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.ipc.MetricsHBaseServerSource;
import org.apache.hadoop.hbase.ipc.MetricsHBaseServerSourceFactory;
import org.apache.hadoop.hbase.ipc.MetricsHBaseServerWrapper;

@InterfaceAudience.Private
public class MetricsHBaseServer {
    private MetricsHBaseServerSource source;

    public MetricsHBaseServer(String serverName, MetricsHBaseServerWrapper wrapper) {
        this.source = ((MetricsHBaseServerSourceFactory)CompatibilitySingletonFactory.getInstance(MetricsHBaseServerSourceFactory.class)).create(serverName, wrapper);
    }

    void authorizationSuccess() {
        this.source.authorizationSuccess();
    }

    void authorizationFailure() {
        this.source.authorizationFailure();
    }

    void authenticationFailure() {
        this.source.authenticationFailure();
    }

    void authenticationSuccess() {
        this.source.authenticationSuccess();
    }

    void sentBytes(long count) {
        this.source.sentBytes(count);
    }

    void receivedBytes(int count) {
        this.source.receivedBytes(count);
    }

    void dequeuedCall(int qTime) {
        this.source.dequeuedCall(qTime);
    }

    void processedCall(int processingTime) {
        this.source.processedCall(processingTime);
    }

    public MetricsHBaseServerSource getMetricsSource() {
        return this.source;
    }
}

