/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.security.Key;
import java.security.KeyException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.CompoundConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.RemoteExceptionHandler;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.conf.ConfigurationManager;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.crypto.Cipher;
import org.apache.hadoop.hbase.io.crypto.Encryption;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.io.hfile.HFileDataBlockEncoder;
import org.apache.hadoop.hbase.io.hfile.HFileDataBlockEncoderImpl;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.io.hfile.InvalidHFileException;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.regionserver.ChangedReadersObserver;
import org.apache.hadoop.hbase.regionserver.DefaultMemStore;
import org.apache.hadoop.hbase.regionserver.GetClosestRowBeforeTracker;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.MemStore;
import org.apache.hadoop.hbase.regionserver.MemStoreSnapshot;
import org.apache.hadoop.hbase.regionserver.RegionCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.ReversedStoreScanner;
import org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hadoop.hbase.regionserver.ScanQueryMatcher;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreEngine;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.regionserver.StoreFileManager;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;
import org.apache.hadoop.hbase.regionserver.StoreFlushContext;
import org.apache.hadoop.hbase.regionserver.StoreFlusher;
import org.apache.hadoop.hbase.regionserver.StoreScanner;
import org.apache.hadoop.hbase.regionserver.StoreUtils;
import org.apache.hadoop.hbase.regionserver.WrongRegionException;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionContext;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionPolicy;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionProgress;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.regionserver.compactions.DefaultCompactor;
import org.apache.hadoop.hbase.regionserver.compactions.OffPeakHours;
import org.apache.hadoop.hbase.regionserver.wal.WALUtil;
import org.apache.hadoop.hbase.security.EncryptionUtil;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ChecksumType;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
public class HStore
implements Store {
    private static final String MEMSTORE_CLASS_NAME = "hbase.regionserver.memstore.class";
    public static final String COMPACTCHECKER_INTERVAL_MULTIPLIER_KEY = "hbase.server.compactchecker.interval.multiplier";
    public static final String BLOCKING_STOREFILES_KEY = "hbase.hstore.blockingStoreFiles";
    public static final int DEFAULT_COMPACTCHECKER_INTERVAL_MULTIPLIER = 1000;
    public static final int DEFAULT_BLOCKING_STOREFILE_COUNT = 7;
    static final Log LOG = LogFactory.getLog(HStore.class);
    protected final MemStore memstore;
    private final HRegion region;
    private final HColumnDescriptor family;
    private final HRegionFileSystem fs;
    private Configuration conf;
    private final CacheConfig cacheConf;
    private long lastCompactSize = 0L;
    volatile boolean forceMajor = false;
    static int closeCheckInterval = 0;
    private volatile long storeSize = 0L;
    private volatile long totalUncompressedBytes = 0L;
    final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final boolean verifyBulkLoads;
    private ScanInfo scanInfo;
    final List<StoreFile> filesCompacting = Lists.newArrayList();
    private final Set<ChangedReadersObserver> changedReaderObservers = Collections.newSetFromMap(new ConcurrentHashMap());
    private final int blocksize;
    private HFileDataBlockEncoder dataBlockEncoder;
    private ChecksumType checksumType;
    private int bytesPerChecksum;
    private final KeyValue.KVComparator comparator;
    final StoreEngine<?, ?, ?, ?> storeEngine;
    private static final AtomicBoolean offPeakCompactionTracker = new AtomicBoolean();
    private volatile OffPeakHours offPeakHours;
    private static final int DEFAULT_FLUSH_RETRIES_NUMBER = 10;
    private int flushRetriesNumber;
    private int pauseTime;
    private long blockingFileCount;
    private int compactionCheckMultiplier;
    private Encryption.Context cryptoContext = Encryption.Context.NONE;
    private volatile long flushedCellsCount = 0L;
    private volatile long compactedCellsCount = 0L;
    private volatile long majorCompactedCellsCount = 0L;
    private volatile long flushedCellsSize = 0L;
    private volatile long compactedCellsSize = 0L;
    private volatile long majorCompactedCellsSize = 0L;
    public static final long FIXED_OVERHEAD = ClassSize.align((int)(ClassSize.OBJECT + 16 * ClassSize.REFERENCE + 80 + 20 + 2));
    public static final long DEEP_OVERHEAD = ClassSize.align((long)(FIXED_OVERHEAD + (long)ClassSize.OBJECT + (long)ClassSize.REENTRANT_LOCK + (long)ClassSize.CONCURRENT_SKIPLISTMAP + (long)ClassSize.CONCURRENT_SKIPLISTMAP_ENTRY + (long)ClassSize.OBJECT + ScanInfo.FIXED_OVERHEAD));

    protected HStore(HRegion region, HColumnDescriptor family, Configuration confParam) throws IOException {
        HRegionInfo info = region.getRegionInfo();
        this.fs = region.getRegionFileSystem();
        this.fs.createStoreDir(family.getNameAsString());
        this.region = region;
        this.family = family;
        this.conf = new CompoundConfiguration().add(confParam).addStringMap(region.getTableDesc().getConfiguration()).addStringMap(family.getConfiguration()).addWritableMap(family.getValues());
        this.blocksize = family.getBlocksize();
        this.dataBlockEncoder = new HFileDataBlockEncoderImpl(family.getDataBlockEncoding());
        this.comparator = info.getComparator();
        long timeToPurgeDeletes = Math.max(this.conf.getLong("hbase.hstore.time.to.purge.deletes", 0L), 0L);
        LOG.trace((Object)("Time to purge deletes set to " + timeToPurgeDeletes + "ms in store " + this));
        long ttl = HStore.determineTTLFromFamily(family);
        this.scanInfo = new ScanInfo(family, ttl, timeToPurgeDeletes, this.comparator);
        String className = this.conf.get(MEMSTORE_CLASS_NAME, DefaultMemStore.class.getName());
        this.memstore = (MemStore)ReflectionUtils.instantiateWithCustomCtor((String)className, (Class[])new Class[]{Configuration.class, KeyValue.KVComparator.class}, (Object[])new Object[]{this.conf, this.comparator});
        this.offPeakHours = OffPeakHours.getInstance(this.conf);
        this.cacheConf = new CacheConfig(this.conf, family);
        this.verifyBulkLoads = this.conf.getBoolean("hbase.hstore.bulkload.verify", false);
        this.blockingFileCount = this.conf.getInt(BLOCKING_STOREFILES_KEY, 7);
        this.compactionCheckMultiplier = this.conf.getInt(COMPACTCHECKER_INTERVAL_MULTIPLIER_KEY, 1000);
        if (this.compactionCheckMultiplier <= 0) {
            LOG.error((Object)"Compaction check period multiplier must be positive, setting default: 1000");
            this.compactionCheckMultiplier = 1000;
        }
        if (closeCheckInterval == 0) {
            closeCheckInterval = this.conf.getInt("hbase.hstore.close.check.interval", 10000000);
        }
        this.storeEngine = StoreEngine.create(this, this.conf, this.comparator);
        this.storeEngine.getStoreFileManager().loadFiles(this.loadStoreFiles());
        this.checksumType = HStore.getChecksumType(this.conf);
        this.bytesPerChecksum = HStore.getBytesPerChecksum(this.conf);
        this.flushRetriesNumber = this.conf.getInt("hbase.hstore.flush.retries.number", 10);
        this.pauseTime = this.conf.getInt("hbase.server.pause", 1000);
        if (this.flushRetriesNumber <= 0) {
            throw new IllegalArgumentException("hbase.hstore.flush.retries.number must be > 0, not " + this.flushRetriesNumber);
        }
        String cipherName = family.getEncryptionType();
        if (cipherName != null) {
            Cipher cipher;
            Key key;
            byte[] keyBytes = family.getEncryptionKey();
            if (keyBytes != null) {
                String masterKeyName = this.conf.get("hbase.crypto.master.key.name", User.getCurrent().getShortName());
                try {
                    key = EncryptionUtil.unwrapKey((Configuration)this.conf, (String)masterKeyName, (byte[])keyBytes);
                }
                catch (KeyException e) {
                    String alternateKeyName;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Unable to unwrap key with current master key '" + masterKeyName + "'"));
                    }
                    if ((alternateKeyName = this.conf.get("hbase.crypto.master.alternate.key.name")) != null) {
                        try {
                            key = EncryptionUtil.unwrapKey((Configuration)this.conf, (String)alternateKeyName, (byte[])keyBytes);
                        }
                        catch (KeyException ex) {
                            throw new IOException(ex);
                        }
                    }
                    throw new IOException(e);
                }
                cipher = Encryption.getCipher((Configuration)this.conf, (String)key.getAlgorithm());
                if (cipher == null) {
                    throw new RuntimeException("Cipher '" + key.getAlgorithm() + "' is not available");
                }
                if (!cipher.getName().equalsIgnoreCase(cipherName)) {
                    throw new RuntimeException("Encryption for family '" + family.getNameAsString() + "' configured with type '" + cipherName + "' but key specifies algorithm '" + cipher.getName() + "'");
                }
            } else {
                cipher = Encryption.getCipher((Configuration)this.conf, (String)cipherName);
                if (cipher == null) {
                    throw new RuntimeException("Cipher '" + cipherName + "' is not available");
                }
                key = cipher.getRandomKey();
            }
            this.cryptoContext = Encryption.newContext((Configuration)this.conf);
            this.cryptoContext.setCipher(cipher);
            this.cryptoContext.setKey(key);
        }
    }

    private static long determineTTLFromFamily(HColumnDescriptor family) {
        long ttl = family.getTimeToLive();
        ttl = ttl == Integer.MAX_VALUE ? Long.MAX_VALUE : (ttl == -1L ? Long.MAX_VALUE : (ttl *= 1000L));
        return ttl;
    }

    @Override
    public String getColumnFamilyName() {
        return this.family.getNameAsString();
    }

    @Override
    public TableName getTableName() {
        return this.getRegionInfo().getTable();
    }

    @Override
    public FileSystem getFileSystem() {
        return this.fs.getFileSystem();
    }

    public HRegionFileSystem getRegionFileSystem() {
        return this.fs;
    }

    @Override
    public long getStoreFileTtl() {
        return this.scanInfo.getMinVersions() == 0 ? this.scanInfo.getTtl() : Long.MAX_VALUE;
    }

    @Override
    public long getMemstoreFlushSize() {
        return this.region.memstoreFlushSize;
    }

    @Override
    public long getFlushableSize() {
        return this.memstore.getFlushableSize();
    }

    @Override
    public long getCompactionCheckMultiplier() {
        return this.compactionCheckMultiplier;
    }

    @Override
    public long getBlockingFileCount() {
        return this.blockingFileCount;
    }

    public static int getBytesPerChecksum(Configuration conf) {
        return conf.getInt("hbase.hstore.bytes.per.checksum", 16384);
    }

    public static ChecksumType getChecksumType(Configuration conf) {
        String checksumName = conf.get("hbase.hstore.checksum.algorithm");
        if (checksumName == null) {
            return HFile.DEFAULT_CHECKSUM_TYPE;
        }
        return ChecksumType.nameToType((String)checksumName);
    }

    public static int getCloseCheckInterval() {
        return closeCheckInterval;
    }

    @Override
    public HColumnDescriptor getFamily() {
        return this.family;
    }

    long getMaxSequenceId() {
        return StoreFile.getMaxSequenceIdInList(this.getStorefiles());
    }

    @Override
    public long getMaxMemstoreTS() {
        return StoreFile.getMaxMemstoreTSInList(this.getStorefiles());
    }

    @Deprecated
    public static Path getStoreHomedir(Path tabledir, HRegionInfo hri, byte[] family) {
        return HStore.getStoreHomedir(tabledir, hri.getEncodedName(), family);
    }

    @Deprecated
    public static Path getStoreHomedir(Path tabledir, String encodedName, byte[] family) {
        return new Path(tabledir, new Path(encodedName, Bytes.toString((byte[])family)));
    }

    @Override
    public HFileDataBlockEncoder getDataBlockEncoder() {
        return this.dataBlockEncoder;
    }

    void setDataBlockEncoderInTest(HFileDataBlockEncoder blockEncoder) {
        this.dataBlockEncoder = blockEncoder;
    }

    private List<StoreFile> loadStoreFiles() throws IOException {
        Collection<StoreFileInfo> files = this.fs.getStoreFiles(this.getColumnFamilyName());
        return this.openStoreFiles(files);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<StoreFile> openStoreFiles(Collection<StoreFileInfo> files) throws IOException {
        if (files == null || files.size() == 0) {
            return new ArrayList<StoreFile>();
        }
        ThreadPoolExecutor storeFileOpenerThreadPool = this.region.getStoreFileOpenAndCloseThreadPool("StoreFileOpenerThread-" + this.getColumnFamilyName());
        ExecutorCompletionService<StoreFile> completionService = new ExecutorCompletionService<StoreFile>(storeFileOpenerThreadPool);
        int totalValidStoreFile = 0;
        for (final StoreFileInfo storeFileInfo : files) {
            completionService.submit(new Callable<StoreFile>(){

                @Override
                public StoreFile call() throws IOException {
                    StoreFile storeFile = HStore.this.createStoreFileAndReader(storeFileInfo);
                    return storeFile;
                }
            });
            ++totalValidStoreFile;
        }
        ArrayList<StoreFile> results = new ArrayList<StoreFile>(files.size());
        IOException ioe = null;
        try {
            for (int i = 0; i < totalValidStoreFile; ++i) {
                try {
                    Future future = completionService.take();
                    StoreFile storeFile = (StoreFile)future.get();
                    long length = storeFile.getReader().length();
                    this.storeSize += length;
                    this.totalUncompressedBytes += storeFile.getReader().getTotalUncompressedBytes();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("loaded " + storeFile.toStringDetailed()));
                    }
                    results.add(storeFile);
                    continue;
                }
                catch (InterruptedException e) {
                    if (ioe != null) continue;
                    ioe = new InterruptedIOException(e.getMessage());
                    continue;
                }
                catch (ExecutionException e) {
                    if (ioe != null) continue;
                    ioe = new IOException(e.getCause());
                }
            }
        }
        finally {
            storeFileOpenerThreadPool.shutdownNow();
        }
        if (ioe != null) {
            for (StoreFile file : results) {
                try {
                    if (file == null) continue;
                    file.closeReader(true);
                }
                catch (IOException e) {
                    LOG.warn((Object)e.getMessage());
                }
            }
            throw ioe;
        }
        return results;
    }

    @Override
    public void refreshStoreFiles() throws IOException {
        Collection<StoreFileInfo> newFiles;
        StoreFileManager sfm = this.storeEngine.getStoreFileManager();
        Collection<StoreFile> currentFiles = sfm.getStorefiles();
        if (currentFiles == null) {
            currentFiles = new ArrayList<StoreFile>(0);
        }
        if ((newFiles = this.fs.getStoreFiles(this.getColumnFamilyName())) == null) {
            newFiles = new ArrayList<StoreFileInfo>(0);
        }
        HashMap<StoreFileInfo, StoreFile> currentFilesSet = new HashMap<StoreFileInfo, StoreFile>(currentFiles.size());
        for (StoreFile sf : currentFiles) {
            currentFilesSet.put(sf.getFileInfo(), sf);
        }
        HashSet<StoreFileInfo> newFilesSet = new HashSet<StoreFileInfo>(newFiles);
        Sets.SetView toBeAddedFiles = Sets.difference(newFilesSet, currentFilesSet.keySet());
        Sets.SetView toBeRemovedFiles = Sets.difference(currentFilesSet.keySet(), newFilesSet);
        if (toBeAddedFiles.isEmpty() && toBeRemovedFiles.isEmpty()) {
            return;
        }
        LOG.info((Object)("Refreshing store files for region " + this.getRegionInfo().getRegionNameAsString() + " files to add: " + toBeAddedFiles + " files to remove: " + toBeRemovedFiles));
        HashSet<StoreFile> toBeRemovedStoreFiles = new HashSet<StoreFile>(toBeRemovedFiles.size());
        for (StoreFileInfo sfi : toBeRemovedFiles) {
            toBeRemovedStoreFiles.add((StoreFile)currentFilesSet.get(sfi));
        }
        List<StoreFile> openedFiles = this.openStoreFiles((Collection<StoreFileInfo>)toBeAddedFiles);
        this.replaceStoreFiles(toBeRemovedStoreFiles, openedFiles);
        if (!toBeAddedFiles.isEmpty()) {
            this.region.getMVCC().advanceMemstoreReadPointIfNeeded(this.getMaxSequenceId());
        }
        this.completeCompaction(toBeRemovedStoreFiles, false);
    }

    private StoreFile createStoreFileAndReader(Path p) throws IOException {
        StoreFileInfo info = new StoreFileInfo(this.conf, this.getFileSystem(), p);
        return this.createStoreFileAndReader(info);
    }

    private StoreFile createStoreFileAndReader(StoreFileInfo info) throws IOException {
        info.setRegionCoprocessorHost(this.region.getCoprocessorHost());
        StoreFile storeFile = new StoreFile(this.getFileSystem(), info, this.conf, this.cacheConf, this.family.getBloomFilterType());
        storeFile.createReader();
        return storeFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Pair<Long, Cell> add(Cell cell) {
        this.lock.readLock().lock();
        try {
            Pair<Long, Cell> pair = this.memstore.add(cell);
            return pair;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public long timeOfOldestEdit() {
        return this.memstore.timeOfOldestEdit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long delete(KeyValue kv) {
        this.lock.readLock().lock();
        try {
            long l = this.memstore.delete((Cell)kv);
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Cell cell) {
        this.lock.readLock().lock();
        try {
            this.memstore.rollback(cell);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Collection<StoreFile> getStorefiles() {
        return this.storeEngine.getStoreFileManager().getStorefiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void assertBulkLoadHFileOk(Path srcPath) throws IOException {
        try (Closeable reader = null;){
            LOG.info((Object)("Validating hfile at " + srcPath + " for inclusion in " + "store " + this + " region " + this.getRegionInfo().getRegionNameAsString()));
            reader = HFile.createReader(srcPath.getFileSystem(this.conf), srcPath, this.cacheConf, this.conf);
            reader.loadFileInfo();
            byte[] firstKey = reader.getFirstRowKey();
            Preconditions.checkState((firstKey != null ? 1 : 0) != 0, (Object)"First key can not be null");
            byte[] lk = reader.getLastKey();
            Preconditions.checkState((lk != null ? 1 : 0) != 0, (Object)"Last key can not be null");
            byte[] lastKey = KeyValue.createKeyValueFromKey((byte[])lk).getRow();
            LOG.debug((Object)("HFile bounds: first=" + Bytes.toStringBinary((byte[])firstKey) + " last=" + Bytes.toStringBinary((byte[])lastKey)));
            LOG.debug((Object)("Region bounds: first=" + Bytes.toStringBinary((byte[])this.getRegionInfo().getStartKey()) + " last=" + Bytes.toStringBinary((byte[])this.getRegionInfo().getEndKey())));
            if (!this.getRegionInfo().containsRange(firstKey, lastKey)) {
                throw new WrongRegionException("Bulk load file " + srcPath.toString() + " does not fit inside region " + this.getRegionInfo().getRegionNameAsString());
            }
            if (reader.length() > this.conf.getLong("hbase.hregion.max.filesize", 0x280000000L)) {
                LOG.warn((Object)("Trying to bulk load hfile " + srcPath.toString() + " with size: " + reader.length() + " bytes can be problematic as it may lead to oversplitting."));
            }
            if (this.verifyBulkLoads) {
                long verificationStartTime = EnvironmentEdgeManager.currentTime();
                LOG.info((Object)("Full verification started for bulk load hfile: " + srcPath.toString()));
                Cell prevCell = null;
                HFileScanner scanner = reader.getScanner(false, false, false);
                scanner.seekTo();
                do {
                    Cell cell = scanner.getKeyValue();
                    if (prevCell != null) {
                        if (CellComparator.compareRows((Cell)prevCell, (Cell)cell) > 0) {
                            throw new InvalidHFileException("Previous row is greater than current row: path=" + srcPath + " previous=" + CellUtil.getCellKeyAsString((Cell)prevCell) + " current=" + CellUtil.getCellKeyAsString((Cell)cell));
                        }
                        if (CellComparator.compareFamilies((Cell)prevCell, (Cell)cell) != 0) {
                            throw new InvalidHFileException("Previous key had different family compared to current key: path=" + srcPath + " previous=" + Bytes.toStringBinary((byte[])prevCell.getFamilyArray(), (int)prevCell.getFamilyOffset(), (int)prevCell.getFamilyLength()) + " current=" + Bytes.toStringBinary((byte[])cell.getFamilyArray(), (int)cell.getFamilyOffset(), (int)cell.getFamilyLength()));
                        }
                    }
                    prevCell = cell;
                } while (scanner.next());
                LOG.info((Object)("Full verification complete for bulk load hfile: " + srcPath.toString() + " took " + (EnvironmentEdgeManager.currentTime() - verificationStartTime) + " ms"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bulkLoadHFile(String srcPathStr, long seqNum) throws IOException {
        Path srcPath = new Path(srcPathStr);
        Path dstPath = this.fs.bulkLoadStoreFile(this.getColumnFamilyName(), srcPath, seqNum);
        StoreFile sf = this.createStoreFileAndReader(dstPath);
        StoreFile.Reader r = sf.getReader();
        this.storeSize += r.length();
        this.totalUncompressedBytes += r.getTotalUncompressedBytes();
        LOG.info((Object)("Loaded HFile " + srcPath + " into store '" + this.getColumnFamilyName() + "' as " + dstPath + " - updating store file list."));
        this.lock.writeLock().lock();
        try {
            this.storeEngine.getStoreFileManager().insertNewFiles(Lists.newArrayList((Object[])new StoreFile[]{sf}));
        }
        finally {
            this.lock.writeLock().unlock();
        }
        this.notifyChangedReadersObservers();
        LOG.info((Object)("Successfully loaded store file " + srcPath + " into store " + this + " (new location: " + dstPath + ")"));
        if (LOG.isTraceEnabled()) {
            String traceMessage = "BULK LOAD time,size,store size,store files [" + EnvironmentEdgeManager.currentTime() + "," + r.length() + "," + this.storeSize + "," + this.storeEngine.getStoreFileManager().getStorefileCount() + "]";
            LOG.trace((Object)traceMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableCollection<StoreFile> close() throws IOException {
        this.lock.writeLock().lock();
        try {
            ImmutableCollection<StoreFile> result = this.storeEngine.getStoreFileManager().clearFiles();
            if (!result.isEmpty()) {
                ThreadPoolExecutor storeFileCloserThreadPool = this.region.getStoreFileOpenAndCloseThreadPool("StoreFileCloserThread-" + this.getColumnFamilyName());
                ExecutorCompletionService<Void> completionService = new ExecutorCompletionService<Void>(storeFileCloserThreadPool);
                for (final StoreFile f : result) {
                    completionService.submit(new Callable<Void>(){

                        @Override
                        public Void call() throws IOException {
                            f.closeReader(true);
                            return null;
                        }
                    });
                }
                IOException ioe = null;
                try {
                    for (int i = 0; i < result.size(); ++i) {
                        try {
                            Future future = completionService.take();
                            future.get();
                            continue;
                        }
                        catch (InterruptedException e) {
                            if (ioe != null) continue;
                            ioe = new InterruptedIOException();
                            ioe.initCause(e);
                            continue;
                        }
                        catch (ExecutionException e) {
                            if (ioe != null) continue;
                            ioe = new IOException(e.getCause());
                        }
                    }
                }
                finally {
                    storeFileCloserThreadPool.shutdownNow();
                }
                if (ioe != null) {
                    throw ioe;
                }
            }
            LOG.info((Object)("Closed " + this));
            ImmutableCollection<StoreFile> immutableCollection = result;
            return immutableCollection;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void snapshot() {
        this.lock.writeLock().lock();
        try {
            this.memstore.snapshot();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    protected List<Path> flushCache(long logCacheFlushId, MemStoreSnapshot snapshot, MonitoredTask status) throws IOException {
        StoreFlusher flusher = this.storeEngine.getStoreFlusher();
        IOException lastException = null;
        for (int i = 0; i < this.flushRetriesNumber; ++i) {
            try {
                List<Path> pathNames = flusher.flushSnapshot(snapshot, logCacheFlushId, status);
                Path lastPathName = null;
                try {
                    Iterator<Path> i$ = pathNames.iterator();
                    while (i$.hasNext()) {
                        Path pathName;
                        lastPathName = pathName = i$.next();
                        this.validateStoreFile(pathName);
                    }
                    return pathNames;
                }
                catch (Exception e) {
                    LOG.warn((Object)("Failed validating store file " + lastPathName + ", retrying num=" + i), (Throwable)e);
                    lastException = e instanceof IOException ? (IOException)e : new IOException(e);
                }
            }
            catch (IOException e) {
                LOG.warn((Object)("Failed flushing store file, retrying num=" + i), (Throwable)e);
                lastException = e;
            }
            if (lastException == null || i >= this.flushRetriesNumber - 1) continue;
            try {
                Thread.sleep(this.pauseTime);
                continue;
            }
            catch (InterruptedException e) {
                InterruptedIOException iie = new InterruptedIOException();
                iie.initCause(e);
                throw iie;
            }
        }
        throw lastException;
    }

    private StoreFile commitFile(Path path, long logCacheFlushId, MonitoredTask status) throws IOException {
        Path dstPath = this.fs.commitStoreFile(this.getColumnFamilyName(), path);
        status.setStatus("Flushing " + this + ": reopening flushed file");
        StoreFile sf = this.createStoreFileAndReader(dstPath);
        StoreFile.Reader r = sf.getReader();
        this.storeSize += r.length();
        this.totalUncompressedBytes += r.getTotalUncompressedBytes();
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Added " + sf + ", entries=" + r.getEntries() + ", sequenceid=" + logCacheFlushId + ", filesize=" + StringUtils.humanReadableInt((long)r.length())));
        }
        return sf;
    }

    @Override
    public StoreFile.Writer createWriterInTmp(long maxKeyCount, Compression.Algorithm compression, boolean isCompaction, boolean includeMVCCReadpoint, boolean includesTag) throws IOException {
        CacheConfig writerCacheConf;
        if (isCompaction) {
            writerCacheConf = new CacheConfig(this.cacheConf);
            writerCacheConf.setCacheDataOnWrite(false);
        } else {
            writerCacheConf = this.cacheConf;
        }
        InetSocketAddress[] favoredNodes = null;
        if (this.region.getRegionServerServices() != null) {
            favoredNodes = this.region.getRegionServerServices().getFavoredNodesForRegion(this.region.getRegionInfo().getEncodedName());
        }
        HFileContext hFileContext = this.createFileContext(compression, includeMVCCReadpoint, includesTag, this.cryptoContext);
        StoreFile.Writer w = new StoreFile.WriterBuilder(this.conf, writerCacheConf, this.getFileSystem()).withFilePath(this.fs.createTempName()).withComparator(this.comparator).withBloomType(this.family.getBloomFilterType()).withMaxKeyCount(maxKeyCount).withFavoredNodes(favoredNodes).withFileContext(hFileContext).build();
        return w;
    }

    private HFileContext createFileContext(Compression.Algorithm compression, boolean includeMVCCReadpoint, boolean includesTag, Encryption.Context cryptoContext) {
        if (compression == null) {
            compression = HFile.DEFAULT_COMPRESSION_ALGORITHM;
        }
        HFileContext hFileContext = new HFileContextBuilder().withIncludesMvcc(includeMVCCReadpoint).withIncludesTags(includesTag).withCompression(compression).withCompressTags(this.family.isCompressTags()).withChecksumType(this.checksumType).withBytesPerCheckSum(this.bytesPerChecksum).withBlockSize(this.blocksize).withHBaseCheckSum(true).withDataBlockEncoding(this.family.getDataBlockEncoding()).withEncryptionContext(cryptoContext).build();
        return hFileContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateStorefiles(List<StoreFile> sfs, long snapshotId) throws IOException {
        this.lock.writeLock().lock();
        try {
            this.storeEngine.getStoreFileManager().insertNewFiles(sfs);
            this.memstore.clearSnapshot(snapshotId);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        this.notifyChangedReadersObservers();
        if (LOG.isTraceEnabled()) {
            long totalSize = 0L;
            for (StoreFile sf : sfs) {
                totalSize += sf.getReader().length();
            }
            String traceMessage = "FLUSH time,count,size,store size,store files [" + EnvironmentEdgeManager.currentTime() + "," + sfs.size() + "," + totalSize + "," + this.storeSize + "," + this.storeEngine.getStoreFileManager().getStorefileCount() + "]";
            LOG.trace((Object)traceMessage);
        }
        return this.needsCompaction();
    }

    private void notifyChangedReadersObservers() throws IOException {
        for (ChangedReadersObserver o : this.changedReaderObservers) {
            o.updateReaders();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<KeyValueScanner> getScanners(boolean cacheBlocks, boolean isGet, boolean usePread, boolean isCompaction, ScanQueryMatcher matcher, byte[] startRow, byte[] stopRow, long readPt) throws IOException {
        List<KeyValueScanner> memStoreScanners;
        Collection<StoreFile> storeFilesToScan;
        this.lock.readLock().lock();
        try {
            storeFilesToScan = this.storeEngine.getStoreFileManager().getFilesForScanOrGet(isGet, startRow, stopRow);
            memStoreScanners = this.memstore.getScanners(readPt);
        }
        finally {
            this.lock.readLock().unlock();
        }
        List<StoreFileScanner> sfScanners = StoreFileScanner.getScannersForStoreFiles(storeFilesToScan, cacheBlocks, usePread, isCompaction, matcher, readPt);
        ArrayList<KeyValueScanner> scanners = new ArrayList<KeyValueScanner>(sfScanners.size() + 1);
        scanners.addAll(sfScanners);
        scanners.addAll(memStoreScanners);
        return scanners;
    }

    @Override
    public void addChangedReaderObserver(ChangedReadersObserver o) {
        this.changedReaderObservers.add(o);
    }

    @Override
    public void deleteChangedReaderObserver(ChangedReadersObserver o) {
        this.changedReaderObservers.remove(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<StoreFile> compact(CompactionContext compaction) throws IOException {
        assert (compaction != null);
        List<StoreFile> sfs = null;
        CompactionRequest cr = compaction.getRequest();
        try {
            long compactionStartTime = EnvironmentEdgeManager.currentTime();
            assert (compaction.hasSelection());
            Collection<StoreFile> filesToCompact = cr.getFiles();
            assert (!filesToCompact.isEmpty());
            List<StoreFile> list = this.filesCompacting;
            synchronized (list) {
                Preconditions.checkArgument((boolean)this.filesCompacting.containsAll(filesToCompact));
            }
            LOG.info((Object)("Starting compaction of " + filesToCompact.size() + " file(s) in " + this + " of " + this.getRegionInfo().getRegionNameAsString() + " into tmpdir=" + this.fs.getTempDir() + ", totalSize=" + StringUtils.humanReadableInt((long)cr.getSize())));
            List<Path> newFiles = compaction.compact();
            if (!this.conf.getBoolean("hbase.hstore.compaction.complete", true)) {
                LOG.warn((Object)"hbase.hstore.compaction.complete is set to false");
                sfs = new ArrayList<StoreFile>(newFiles.size());
                for (Path newFile : newFiles) {
                    StoreFile sf = this.createStoreFileAndReader(newFile);
                    sf.closeReader(true);
                    sfs.add(sf);
                }
                List<StoreFile> list2 = sfs;
                return list2;
            }
            sfs = this.moveCompatedFilesIntoPlace(cr, newFiles);
            this.writeCompactionWalRecord(filesToCompact, sfs);
            this.replaceStoreFiles(filesToCompact, sfs);
            if (cr.isMajor()) {
                this.majorCompactedCellsCount += this.getCompactionProgress().totalCompactingKVs;
                this.majorCompactedCellsSize += this.getCompactionProgress().totalCompactedSize;
            } else {
                this.compactedCellsCount += this.getCompactionProgress().totalCompactingKVs;
                this.compactedCellsSize += this.getCompactionProgress().totalCompactedSize;
            }
            this.completeCompaction(filesToCompact, true);
            this.logCompactionEndMessage(cr, sfs, compactionStartTime);
            List<StoreFile> list3 = sfs;
            return list3;
        }
        finally {
            this.finishCompactionRequest(cr);
        }
    }

    private List<StoreFile> moveCompatedFilesIntoPlace(CompactionRequest cr, List<Path> newFiles) throws IOException {
        ArrayList<StoreFile> sfs = new ArrayList<StoreFile>(newFiles.size());
        for (Path newFile : newFiles) {
            assert (newFile != null);
            StoreFile sf = this.moveFileIntoPlace(newFile);
            if (this.getCoprocessorHost() != null) {
                this.getCoprocessorHost().postCompact(this, sf, cr);
            }
            assert (sf != null);
            sfs.add(sf);
        }
        return sfs;
    }

    StoreFile moveFileIntoPlace(Path newFile) throws IOException {
        this.validateStoreFile(newFile);
        Path destPath = this.fs.commitStoreFile(this.getColumnFamilyName(), newFile);
        return this.createStoreFileAndReader(destPath);
    }

    private void writeCompactionWalRecord(Collection<StoreFile> filesCompacted, Collection<StoreFile> newFiles) throws IOException {
        if (this.region.getWAL() == null) {
            return;
        }
        ArrayList<Path> inputPaths = new ArrayList<Path>(filesCompacted.size());
        for (StoreFile f : filesCompacted) {
            inputPaths.add(f.getPath());
        }
        ArrayList<Path> outputPaths = new ArrayList<Path>(newFiles.size());
        for (StoreFile f : newFiles) {
            outputPaths.add(f.getPath());
        }
        HRegionInfo info = this.region.getRegionInfo();
        WALProtos.CompactionDescriptor compactionDescriptor = ProtobufUtil.toCompactionDescriptor((HRegionInfo)info, (byte[])this.family.getName(), inputPaths, outputPaths, (Path)this.fs.getStoreDir(this.getFamily().getNameAsString()));
        WALUtil.writeCompactionMarker(this.region.getWAL(), this.region.getTableDesc(), this.region.getRegionInfo(), compactionDescriptor, this.region.getSequenceId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void replaceStoreFiles(Collection<StoreFile> compactedFiles, Collection<StoreFile> result) throws IOException {
        this.lock.writeLock().lock();
        try {
            this.storeEngine.getStoreFileManager().addCompactionResults(compactedFiles, result);
            this.filesCompacting.removeAll(compactedFiles);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void logCompactionEndMessage(CompactionRequest cr, List<StoreFile> sfs, long compactionStartTime) {
        long now = EnvironmentEdgeManager.currentTime();
        StringBuilder message = new StringBuilder("Completed" + (cr.isMajor() ? " major" : "") + " compaction of " + cr.getFiles().size() + (cr.isAllFiles() ? " (all)" : "") + " file(s) in " + this + " of " + this.getRegionInfo().getRegionNameAsString() + " into ");
        if (sfs.isEmpty()) {
            message.append("none, ");
        } else {
            for (StoreFile sf : sfs) {
                message.append(sf.getPath().getName());
                message.append("(size=");
                message.append(StringUtils.humanReadableInt((long)sf.getReader().length()));
                message.append("), ");
            }
        }
        message.append("total size for store is ").append(StringUtils.humanReadableInt((long)this.storeSize)).append(". This selection was in queue for ").append(StringUtils.formatTimeDiff((long)compactionStartTime, (long)cr.getSelectionTime())).append(", and took ").append(StringUtils.formatTimeDiff((long)now, (long)compactionStartTime)).append(" to execute.");
        LOG.info((Object)message.toString());
        if (LOG.isTraceEnabled()) {
            int fileCount = this.storeEngine.getStoreFileManager().getStorefileCount();
            long resultSize = 0L;
            for (StoreFile sf : sfs) {
                resultSize += sf.getReader().length();
            }
            String traceMessage = "COMPACTION start,end,size out,files in,files out,store size,store files [" + compactionStartTime + "," + now + "," + resultSize + "," + cr.getFiles().size() + "," + sfs.size() + "," + this.storeSize + "," + fileCount + "]";
            LOG.trace((Object)traceMessage);
        }
    }

    @Override
    public void completeCompactionMarker(WALProtos.CompactionDescriptor compaction) throws IOException {
        LOG.debug((Object)"Completing compaction from the WAL marker");
        List compactionInputs = compaction.getCompactionInputList();
        String familyName = this.getColumnFamilyName();
        ArrayList<Path> inputPaths = new ArrayList<Path>(compactionInputs.size());
        for (String compactionInput : compactionInputs) {
            Path inputPath = this.fs.getStoreFilePath(familyName, compactionInput);
            inputPaths.add(inputPath);
        }
        ArrayList<StoreFile> inputStoreFiles = new ArrayList<StoreFile>(compactionInputs.size());
        for (StoreFile sf : this.getStorefiles()) {
            if (!inputPaths.contains(sf.getQualifiedPath())) continue;
            inputStoreFiles.add(sf);
        }
        this.replaceStoreFiles(inputStoreFiles, Collections.EMPTY_LIST);
        this.completeCompaction(inputStoreFiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compactRecentForTestingAssumingDefaultPolicy(int N) throws IOException {
        boolean isMajor;
        List<StoreFile> filesToCompact;
        List<StoreFile> list;
        this.lock.readLock().lock();
        try {
            list = this.filesCompacting;
            synchronized (list) {
                int count;
                filesToCompact = Lists.newArrayList(this.storeEngine.getStoreFileManager().getStorefiles());
                if (!this.filesCompacting.isEmpty()) {
                    StoreFile last = this.filesCompacting.get(this.filesCompacting.size() - 1);
                    int idx = filesToCompact.indexOf(last);
                    Preconditions.checkArgument((idx != -1 ? 1 : 0) != 0);
                    filesToCompact.subList(0, idx + 1).clear();
                }
                if (N > (count = filesToCompact.size())) {
                    throw new RuntimeException("Not enough files");
                }
                isMajor = (filesToCompact = filesToCompact.subList(count - N, count)).size() == this.storeEngine.getStoreFileManager().getStorefileCount();
                this.filesCompacting.addAll(filesToCompact);
                Collections.sort(this.filesCompacting, StoreFile.Comparators.SEQ_ID);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        try {
            List<Path> newFiles = ((DefaultCompactor)this.storeEngine.getCompactor()).compactForTesting(filesToCompact, isMajor);
            for (Path newFile : newFiles) {
                StoreFile sf = this.moveFileIntoPlace(newFile);
                if (this.getCoprocessorHost() != null) {
                    this.getCoprocessorHost().postCompact(this, sf, null);
                }
                this.replaceStoreFiles(filesToCompact, Lists.newArrayList((Object[])new StoreFile[]{sf}));
                this.completeCompaction(filesToCompact, true);
            }
        }
        finally {
            list = this.filesCompacting;
            synchronized (list) {
                this.filesCompacting.removeAll(filesToCompact);
            }
        }
    }

    @Override
    public boolean hasReferences() {
        return StoreUtils.hasReferences(this.storeEngine.getStoreFileManager().getStorefiles());
    }

    @Override
    public CompactionProgress getCompactionProgress() {
        return this.storeEngine.getCompactor().getProgress();
    }

    @Override
    public boolean isMajorCompaction() throws IOException {
        for (StoreFile sf : this.storeEngine.getStoreFileManager().getStorefiles()) {
            if (sf.getReader() != null) continue;
            LOG.debug((Object)("StoreFile " + sf + " has null Reader"));
            return false;
        }
        return this.storeEngine.getCompactionPolicy().isMajorCompaction(this.storeEngine.getStoreFileManager().getStorefiles());
    }

    @Override
    public CompactionContext requestCompaction() throws IOException {
        return this.requestCompaction(Integer.MIN_VALUE, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompactionContext requestCompaction(int priority, CompactionRequest baseRequest) throws IOException {
        if (!this.areWritesEnabled()) {
            return null;
        }
        this.removeUnneededFiles();
        CompactionContext compaction = this.storeEngine.createCompaction();
        CompactionRequest request = null;
        this.lock.readLock().lock();
        try {
            List<StoreFile> list = this.filesCompacting;
            synchronized (list) {
                Collection<StoreFile> selectedFiles;
                block19: {
                    if (this.getCoprocessorHost() != null) {
                        List<StoreFile> candidatesForCoproc = compaction.preSelect(this.filesCompacting);
                        boolean override = this.getCoprocessorHost().preCompactSelection(this, candidatesForCoproc, baseRequest);
                        if (override) {
                            compaction.forceSelect(new CompactionRequest(candidatesForCoproc));
                        }
                    }
                    if (!compaction.hasSelection()) {
                        boolean isUserCompaction = priority == 1;
                        boolean mayUseOffPeak = this.offPeakHours.isOffPeakHour() && offPeakCompactionTracker.compareAndSet(false, true);
                        try {
                            compaction.select(this.filesCompacting, isUserCompaction, mayUseOffPeak, this.forceMajor && this.filesCompacting.isEmpty());
                        }
                        catch (IOException e) {
                            if (mayUseOffPeak) {
                                offPeakCompactionTracker.set(false);
                            }
                            throw e;
                        }
                        assert (compaction.hasSelection());
                        if (mayUseOffPeak && !compaction.getRequest().isOffPeak()) {
                            offPeakCompactionTracker.set(false);
                        }
                    }
                    if (this.getCoprocessorHost() != null) {
                        this.getCoprocessorHost().postCompactSelection(this, (ImmutableList<StoreFile>)ImmutableList.copyOf(compaction.getRequest().getFiles()), baseRequest);
                    }
                    if (baseRequest != null) {
                        compaction.forceSelect(baseRequest.combineWith(compaction.getRequest()));
                    }
                    if (!(selectedFiles = (request = compaction.getRequest()).getFiles()).isEmpty()) break block19;
                    CompactionContext compactionContext = null;
                    return compactionContext;
                }
                this.addToCompactingFiles(selectedFiles);
                this.forceMajor = this.forceMajor && !request.isMajor();
                request.setPriority(priority != Integer.MIN_VALUE ? priority : this.getCompactPriority());
                request.setDescription(this.getRegionInfo().getRegionNameAsString(), this.getColumnFamilyName());
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        LOG.debug((Object)(this.getRegionInfo().getEncodedName() + " - " + this.getColumnFamilyName() + ": Initiating " + (request.isMajor() ? "major" : "minor") + " compaction" + (request.isAllFiles() ? " (all files)" : "")));
        this.region.reportCompactionRequestStart(request.isMajor());
        return compaction;
    }

    private void addToCompactingFiles(Collection<StoreFile> filesToAdd) {
        if (filesToAdd == null) {
            return;
        }
        if (!Collections.disjoint(this.filesCompacting, filesToAdd)) {
            Preconditions.checkArgument((boolean)false, (String)"%s overlaps with %s", (Object[])new Object[]{filesToAdd, this.filesCompacting});
        }
        this.filesCompacting.addAll(filesToAdd);
        Collections.sort(this.filesCompacting, StoreFile.Comparators.SEQ_ID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeUnneededFiles() throws IOException {
        if (!this.conf.getBoolean("hbase.store.delete.expired.storefile", true)) {
            return;
        }
        if (this.getFamily().getMinVersions() > 0) {
            LOG.debug((Object)("Skipping expired store file removal due to min version being " + this.getFamily().getMinVersions()));
            return;
        }
        this.lock.readLock().lock();
        Collection<StoreFile> delSfs = null;
        try {
            List<StoreFile> list = this.filesCompacting;
            synchronized (list) {
                long cfTtl = this.getStoreFileTtl();
                if (cfTtl != Long.MAX_VALUE) {
                    delSfs = this.storeEngine.getStoreFileManager().getUnneededFiles(EnvironmentEdgeManager.currentTime() - cfTtl, this.filesCompacting);
                    this.addToCompactingFiles(delSfs);
                }
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (delSfs == null || delSfs.isEmpty()) {
            return;
        }
        ArrayList<StoreFile> newFiles = new ArrayList<StoreFile>();
        this.writeCompactionWalRecord(delSfs, newFiles);
        this.replaceStoreFiles(delSfs, newFiles);
        this.completeCompaction(delSfs);
        LOG.info((Object)("Completed removal of " + delSfs.size() + " unnecessary (expired) file(s) in " + this + " of " + this.getRegionInfo().getRegionNameAsString() + "; total size for store is " + StringUtils.humanReadableInt((long)this.storeSize)));
    }

    @Override
    public void cancelRequestedCompaction(CompactionContext compaction) {
        this.finishCompactionRequest(compaction.getRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishCompactionRequest(CompactionRequest cr) {
        this.region.reportCompactionRequestEnd(cr.isMajor(), cr.getFiles().size(), cr.getSize());
        if (cr.isOffPeak()) {
            offPeakCompactionTracker.set(false);
            cr.setOffPeak(false);
        }
        List<StoreFile> list = this.filesCompacting;
        synchronized (list) {
            this.filesCompacting.removeAll(cr.getFiles());
        }
    }

    private void validateStoreFile(Path path) throws IOException {
        StoreFile storeFile = null;
        try {
            storeFile = this.createStoreFileAndReader(path);
        }
        catch (IOException e) {
            LOG.error((Object)("Failed to open store file : " + path + ", keeping it in tmp location"), (Throwable)e);
            throw e;
        }
        finally {
            if (storeFile != null) {
                storeFile.closeReader(false);
            }
        }
    }

    @VisibleForTesting
    protected void completeCompaction(Collection<StoreFile> compactedFiles) throws IOException {
        this.completeCompaction(compactedFiles, true);
    }

    @VisibleForTesting
    protected void completeCompaction(Collection<StoreFile> compactedFiles, boolean removeFiles) throws IOException {
        try {
            this.notifyChangedReadersObservers();
            LOG.debug((Object)"Removing store files after compaction...");
            for (StoreFile compactedFile : compactedFiles) {
                compactedFile.closeReader(true);
            }
            if (removeFiles) {
                this.fs.removeStoreFiles(this.getColumnFamilyName(), compactedFiles);
            }
        }
        catch (IOException e) {
            e = RemoteExceptionHandler.checkIOException((IOException)e);
            LOG.error((Object)("Failed removing compacted files in " + this + ". Files we were trying to remove are " + compactedFiles.toString() + "; some of them may have been already removed"), (Throwable)e);
        }
        this.storeSize = 0L;
        this.totalUncompressedBytes = 0L;
        for (StoreFile hsf : this.storeEngine.getStoreFileManager().getStorefiles()) {
            StoreFile.Reader r = hsf.getReader();
            if (r == null) {
                LOG.warn((Object)("StoreFile " + hsf + " has a null Reader"));
                continue;
            }
            this.storeSize += r.length();
            this.totalUncompressedBytes += r.getTotalUncompressedBytes();
        }
    }

    int versionsToReturn(int wantedVersions) {
        if (wantedVersions <= 0) {
            throw new IllegalArgumentException("Number of versions must be > 0");
        }
        int maxVersions = this.family.getMaxVersions();
        return wantedVersions > maxVersions ? maxVersions : wantedVersions;
    }

    static boolean isCellTTLExpired(Cell cell, long oldestTimestamp, long now) {
        if (cell.getTagsLength() > 0) {
            Iterator i = CellUtil.tagsIterator((byte[])cell.getTagsArray(), (int)cell.getTagsOffset(), (int)cell.getTagsLength());
            while (i.hasNext()) {
                Tag t = (Tag)i.next();
                if (8 != t.getType()) continue;
                long ts = cell.getTimestamp();
                assert (t.getTagLength() == 8);
                long ttl = Bytes.toLong((byte[])t.getBuffer(), (int)t.getTagOffset(), (int)t.getTagLength());
                if (ts + ttl >= now) break;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cell getRowKeyAtOrBefore(byte[] row) throws IOException {
        long ttlToUse = this.scanInfo.getMinVersions() > 0 ? Long.MAX_VALUE : this.scanInfo.getTtl();
        KeyValue kv = new KeyValue(row, Long.MAX_VALUE);
        GetClosestRowBeforeTracker state = new GetClosestRowBeforeTracker(this.comparator, kv, ttlToUse, this.getRegionInfo().isMetaRegion());
        this.lock.readLock().lock();
        try {
            this.memstore.getRowKeyAtOrBefore(state);
            Iterator<StoreFile> sfIterator = this.storeEngine.getStoreFileManager().getCandidateFilesForRowKeyBefore(state.getTargetKey());
            while (sfIterator.hasNext()) {
                StoreFile sf = sfIterator.next();
                sfIterator.remove();
                boolean haveNewCandidate = this.rowAtOrBeforeFromStoreFile(sf, state);
                Cell candidate = state.getCandidate();
                if (candidate != null && CellUtil.matchingRow((Cell)candidate, (byte[])row)) {
                    Cell cell = candidate;
                    return cell;
                }
                if (!haveNewCandidate) continue;
                sfIterator = this.storeEngine.getStoreFileManager().updateCandidateFilesForRowKeyBefore(sfIterator, state.getTargetKey(), candidate);
            }
            Cell cell = state.getCandidate();
            return cell;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private boolean rowAtOrBeforeFromStoreFile(StoreFile f, GetClosestRowBeforeTracker state) throws IOException {
        Cell kv;
        HFileScanner scanner;
        KeyValue firstOnRow;
        StoreFile.Reader r = f.getReader();
        if (r == null) {
            LOG.warn((Object)("StoreFile " + f + " has a null Reader"));
            return false;
        }
        if (r.getEntries() == 0L) {
            LOG.warn((Object)("StoreFile " + f + " is a empty store file"));
            return false;
        }
        byte[] fk = r.getFirstKey();
        if (fk == null) {
            return false;
        }
        KeyValue firstKV = KeyValue.createKeyValueFromKey((byte[])fk, (int)0, (int)fk.length);
        byte[] lk = r.getLastKey();
        KeyValue lastKV = KeyValue.createKeyValueFromKey((byte[])lk, (int)0, (int)lk.length);
        if (this.comparator.compareRows((Cell)lastKV, (Cell)(firstOnRow = state.getTargetKey())) < 0) {
            if (!state.isTargetTable((Cell)lastKV)) {
                return false;
            }
            firstOnRow = new KeyValue(lastKV.getRow(), Long.MAX_VALUE);
        }
        if (!this.seekToScanner(scanner = r.getScanner(true, true, false), firstOnRow, firstKV)) {
            return false;
        }
        if (this.walkForwardInSingleRow(scanner, firstOnRow, state)) {
            return true;
        }
        while (scanner.seekBefore(firstOnRow.getBuffer(), firstOnRow.getKeyOffset(), firstOnRow.getKeyLength()) && state.isTargetTable(kv = scanner.getKeyValue()) && state.isBetterCandidate(kv)) {
            firstOnRow = new KeyValue(kv.getRow(), Long.MAX_VALUE);
            if (!this.seekToScanner(scanner, firstOnRow, firstKV)) {
                return false;
            }
            if (!this.walkForwardInSingleRow(scanner, firstOnRow, state)) continue;
            return true;
        }
        return false;
    }

    private boolean seekToScanner(HFileScanner scanner, KeyValue firstOnRow, KeyValue firstKV) throws IOException {
        int result;
        KeyValue kv = firstOnRow;
        if (this.comparator.compareRows((Cell)firstKV, (Cell)firstOnRow) == 0) {
            kv = firstKV;
        }
        return (result = scanner.seekTo((Cell)kv)) != -1;
    }

    private boolean walkForwardInSingleRow(HFileScanner scanner, KeyValue firstOnRow, GetClosestRowBeforeTracker state) throws IOException {
        boolean foundCandidate = false;
        do {
            Cell kv;
            if (this.comparator.compareRows(kv = scanner.getKeyValue(), (Cell)firstOnRow) < 0) continue;
            if (state.isTooFar(kv, (Cell)firstOnRow)) break;
            if (state.isExpired(kv) || !state.handle(kv)) continue;
            foundCandidate = true;
            break;
        } while (scanner.next());
        return foundCandidate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canSplit() {
        this.lock.readLock().lock();
        try {
            boolean result;
            boolean bl = result = !this.hasReferences();
            if (!result && LOG.isDebugEnabled()) {
                LOG.debug((Object)"Cannot split region due to reference files being there");
            }
            boolean bl2 = result;
            return bl2;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getSplitPoint() {
        this.lock.readLock().lock();
        try {
            assert (!this.getRegionInfo().isMetaRegion());
            if (this.hasReferences()) {
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = this.storeEngine.getStoreFileManager().getSplitPoint();
            return byArray;
        }
        catch (IOException e) {
            LOG.warn((Object)("Failed getting store size for " + this), (Throwable)e);
        }
        finally {
            this.lock.readLock().unlock();
        }
        return null;
    }

    @Override
    public long getLastCompactSize() {
        return this.lastCompactSize;
    }

    @Override
    public long getSize() {
        return this.storeSize;
    }

    @Override
    public void triggerMajorCompaction() {
        this.forceMajor = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyValueScanner getScanner(Scan scan, NavigableSet<byte[]> targetCols, long readPt) throws IOException {
        this.lock.readLock().lock();
        try {
            KeyValueScanner scanner = null;
            if (this.getCoprocessorHost() != null) {
                scanner = this.getCoprocessorHost().preStoreScannerOpen(this, scan, targetCols);
            }
            if (scanner == null) {
                scanner = scan.isReversed() ? new ReversedStoreScanner(this, this.getScanInfo(), scan, targetCols, readPt) : new StoreScanner(this, this.getScanInfo(), scan, targetCols, readPt);
            }
            KeyValueScanner keyValueScanner = scanner;
            return keyValueScanner;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public String toString() {
        return this.getColumnFamilyName();
    }

    @Override
    public int getStorefilesCount() {
        return this.storeEngine.getStoreFileManager().getStorefileCount();
    }

    @Override
    public long getStoreSizeUncompressed() {
        return this.totalUncompressedBytes;
    }

    @Override
    public long getStorefilesSize() {
        long size = 0L;
        for (StoreFile s : this.storeEngine.getStoreFileManager().getStorefiles()) {
            StoreFile.Reader r = s.getReader();
            if (r == null) {
                LOG.warn((Object)("StoreFile " + s + " has a null Reader"));
                continue;
            }
            size += r.length();
        }
        return size;
    }

    @Override
    public long getStorefilesIndexSize() {
        long size = 0L;
        for (StoreFile s : this.storeEngine.getStoreFileManager().getStorefiles()) {
            StoreFile.Reader r = s.getReader();
            if (r == null) {
                LOG.warn((Object)("StoreFile " + s + " has a null Reader"));
                continue;
            }
            size += r.indexSize();
        }
        return size;
    }

    @Override
    public long getTotalStaticIndexSize() {
        long size = 0L;
        for (StoreFile s : this.storeEngine.getStoreFileManager().getStorefiles()) {
            size += s.getReader().getUncompressedDataIndexSize();
        }
        return size;
    }

    @Override
    public long getTotalStaticBloomSize() {
        long size = 0L;
        for (StoreFile s : this.storeEngine.getStoreFileManager().getStorefiles()) {
            StoreFile.Reader r = s.getReader();
            size += r.getTotalBloomSize();
        }
        return size;
    }

    @Override
    public long getMemStoreSize() {
        return this.memstore.size();
    }

    @Override
    public int getCompactPriority() {
        int priority = this.storeEngine.getStoreFileManager().getStoreCompactionPriority();
        if (priority == 1) {
            LOG.warn((Object)"Compaction priority is USER despite there being no user compaction");
        }
        return priority;
    }

    @Override
    public boolean throttleCompaction(long compactionSize) {
        return this.storeEngine.getCompactionPolicy().throttleCompaction(compactionSize);
    }

    public HRegion getHRegion() {
        return this.region;
    }

    @Override
    public RegionCoprocessorHost getCoprocessorHost() {
        return this.region.getCoprocessorHost();
    }

    @Override
    public HRegionInfo getRegionInfo() {
        return this.fs.getRegionInfo();
    }

    @Override
    public boolean areWritesEnabled() {
        return this.region.areWritesEnabled();
    }

    @Override
    public long getSmallestReadPoint() {
        return this.region.getSmallestReadPoint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long updateColumnValue(byte[] row, byte[] f, byte[] qualifier, long newValue) throws IOException {
        this.lock.readLock().lock();
        try {
            long now = EnvironmentEdgeManager.currentTime();
            long l = this.memstore.updateColumnValue(row, f, qualifier, newValue, now);
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long upsert(Iterable<Cell> cells, long readpoint) throws IOException {
        this.lock.readLock().lock();
        try {
            long l = this.memstore.upsert(cells, readpoint);
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public StoreFlushContext createFlushContext(long cacheFlushId) {
        return new StoreFlusherImpl(cacheFlushId);
    }

    @Override
    public boolean needsCompaction() {
        return this.storeEngine.needsCompaction(this.filesCompacting);
    }

    @Override
    public CacheConfig getCacheConfig() {
        return this.cacheConf;
    }

    public long heapSize() {
        return DEEP_OVERHEAD + this.memstore.heapSize();
    }

    @Override
    public KeyValue.KVComparator getComparator() {
        return this.comparator;
    }

    @Override
    public ScanInfo getScanInfo() {
        return this.scanInfo;
    }

    void setScanInfo(ScanInfo scanInfo) {
        this.scanInfo = scanInfo;
    }

    @Override
    public boolean hasTooManyStoreFiles() {
        return (long)this.getStorefilesCount() > this.blockingFileCount;
    }

    @Override
    public long getFlushedCellsCount() {
        return this.flushedCellsCount;
    }

    @Override
    public long getFlushedCellsSize() {
        return this.flushedCellsSize;
    }

    @Override
    public long getCompactedCellsCount() {
        return this.compactedCellsCount;
    }

    @Override
    public long getCompactedCellsSize() {
        return this.compactedCellsSize;
    }

    @Override
    public long getMajorCompactedCellsCount() {
        return this.majorCompactedCellsCount;
    }

    @Override
    public long getMajorCompactedCellsSize() {
        return this.majorCompactedCellsSize;
    }

    protected StoreEngine<?, ?, ?, ?> getStoreEngine() {
        return this.storeEngine;
    }

    protected OffPeakHours getOffPeakHours() {
        return this.offPeakHours;
    }

    @Override
    public void onConfigurationChange(Configuration conf) {
        this.conf = new CompoundConfiguration().add(conf).addWritableMap(this.family.getValues());
        ((CompactionPolicy)this.storeEngine.compactionPolicy).setConf(conf);
        this.offPeakHours = OffPeakHours.getInstance(conf);
    }

    @Override
    public void registerChildren(ConfigurationManager manager) {
    }

    @Override
    public void deregisterChildren(ConfigurationManager manager) {
    }

    private class StoreFlusherImpl
    implements StoreFlushContext {
        private long cacheFlushSeqNum;
        private MemStoreSnapshot snapshot;
        private List<Path> tempFiles;
        private List<Path> committedFiles;
        private long cacheFlushCount;
        private long cacheFlushSize;

        private StoreFlusherImpl(long cacheFlushSeqNum) {
            this.cacheFlushSeqNum = cacheFlushSeqNum;
        }

        @Override
        public void prepare() {
            this.snapshot = HStore.this.memstore.snapshot();
            this.cacheFlushCount = this.snapshot.getCellsCount();
            this.cacheFlushSize = this.snapshot.getSize();
            this.committedFiles = new ArrayList<Path>(1);
        }

        @Override
        public void flushCache(MonitoredTask status) throws IOException {
            this.tempFiles = HStore.this.flushCache(this.cacheFlushSeqNum, this.snapshot, status);
        }

        @Override
        public boolean commit(MonitoredTask status) throws IOException {
            if (this.tempFiles == null || this.tempFiles.isEmpty()) {
                return false;
            }
            ArrayList<StoreFile> storeFiles = new ArrayList<StoreFile>(this.tempFiles.size());
            for (Path storeFilePath : this.tempFiles) {
                try {
                    storeFiles.add(HStore.this.commitFile(storeFilePath, this.cacheFlushSeqNum, status));
                }
                catch (IOException ex) {
                    LOG.error((Object)("Failed to commit store file " + storeFilePath), (Throwable)ex);
                    for (StoreFile sf : storeFiles) {
                        Path pathToDelete = sf.getPath();
                        try {
                            sf.deleteReader();
                        }
                        catch (IOException deleteEx) {
                            LOG.fatal((Object)("Failed to delete store file we committed, halting " + pathToDelete), (Throwable)ex);
                            Runtime.getRuntime().halt(1);
                        }
                    }
                    throw new IOException("Failed to commit the flush", ex);
                }
            }
            for (StoreFile sf : storeFiles) {
                if (HStore.this.getCoprocessorHost() != null) {
                    HStore.this.getCoprocessorHost().postFlush(HStore.this, sf);
                }
                this.committedFiles.add(sf.getPath());
            }
            HStore.this.flushedCellsCount += this.cacheFlushCount;
            HStore.this.flushedCellsSize += this.cacheFlushSize;
            return HStore.this.updateStorefiles(storeFiles, this.snapshot.getId());
        }

        @Override
        public List<Path> getCommittedFiles() {
            return this.committedFiles;
        }
    }
}

