/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.codec;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.codec.BaseDecoder;
import org.apache.hadoop.hbase.codec.BaseEncoder;
import org.apache.hadoop.hbase.codec.Codec;
import org.apache.hadoop.hbase.protobuf.generated.CellProtos;
import org.apache.hadoop.hbase.util.ByteStringer;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class MessageCodec
implements Codec {
    public Codec.Decoder getDecoder(InputStream is) {
        return new MessageDecoder(is);
    }

    public Codec.Encoder getEncoder(OutputStream os) {
        return new MessageEncoder(os);
    }

    static class MessageDecoder
    extends BaseDecoder {
        MessageDecoder(InputStream in) {
            super(in);
        }

        protected Cell parseCell() throws IOException {
            CellProtos.Cell pbcell = CellProtos.Cell.parseDelimitedFrom((InputStream)this.in);
            return CellUtil.createCell((byte[])pbcell.getRow().toByteArray(), (byte[])pbcell.getFamily().toByteArray(), (byte[])pbcell.getQualifier().toByteArray(), (long)pbcell.getTimestamp(), (byte)((byte)pbcell.getCellType().getNumber()), (byte[])pbcell.getValue().toByteArray());
        }
    }

    static class MessageEncoder
    extends BaseEncoder {
        MessageEncoder(OutputStream out) {
            super(out);
        }

        public void write(Cell cell) throws IOException {
            this.checkFlushed();
            CellProtos.Cell.Builder builder = CellProtos.Cell.newBuilder();
            builder.setRow(ByteStringer.wrap((byte[])cell.getRowArray(), (int)cell.getRowOffset(), (int)cell.getRowLength()));
            builder.setFamily(ByteStringer.wrap((byte[])cell.getFamilyArray(), (int)cell.getFamilyOffset(), (int)cell.getFamilyLength()));
            builder.setQualifier(ByteStringer.wrap((byte[])cell.getQualifierArray(), (int)cell.getQualifierOffset(), (int)cell.getQualifierLength()));
            builder.setTimestamp(cell.getTimestamp());
            builder.setCellType(CellProtos.CellType.valueOf((int)cell.getTypeByte()));
            builder.setValue(ByteStringer.wrap((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength()));
            CellProtos.Cell pbcell = builder.build();
            pbcell.writeDelimitedTo(this.out);
        }
    }
}

