/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import com.google.common.base.Joiner;
import com.google.common.base.Supplier;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Random;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hbase.TimedOutTestsListener;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Time;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.WriterAppender;
import org.junit.Assert;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public abstract class GenericTestUtils {
    private static final AtomicInteger sequence = new AtomicInteger();

    public static String getMethodName() {
        return Thread.currentThread().getStackTrace()[2].getMethodName();
    }

    public static int uniqueSequenceId() {
        return sequence.incrementAndGet();
    }

    public static void assertExists(File f) {
        Assert.assertTrue((String)("File " + f + " should exist"), (boolean)f.exists());
    }

    public static void assertGlobEquals(File dir, String pattern, String ... expectedMatches) throws IOException {
        TreeSet found = Sets.newTreeSet();
        for (File f : FileUtil.listFiles((File)dir)) {
            if (!f.getName().matches(pattern)) continue;
            found.add(f.getName());
        }
        TreeSet expectedSet = Sets.newTreeSet(Arrays.asList(expectedMatches));
        Assert.assertEquals((String)("Bad files matching " + pattern + " in " + dir), (Object)Joiner.on((String)",").join((Iterable)expectedSet), (Object)Joiner.on((String)",").join((Iterable)found));
    }

    public static void assertExceptionContains(String string, Throwable t) {
        String msg = t.getMessage();
        Assert.assertTrue((String)("Expected to find '" + string + "' but got unexpected exception:" + StringUtils.stringifyException((Throwable)t)), (boolean)msg.contains(string));
    }

    public static void waitFor(Supplier<Boolean> check, int checkEveryMillis, int waitForMillis) throws TimeoutException, InterruptedException {
        long st = Time.now();
        do {
            boolean result;
            if (result = ((Boolean)check.get()).booleanValue()) {
                return;
            }
            Thread.sleep(checkEveryMillis);
        } while (Time.now() - st < (long)waitForMillis);
        throw new TimeoutException("Timed out waiting for condition. Thread diagnostics:\n" + TimedOutTestsListener.buildThreadDiagnosticString());
    }

    public static void assertMatches(String output, String pattern) {
        Assert.assertTrue((String)("Expected output to match /" + pattern + "/" + " but got:\n" + output), (boolean)Pattern.compile(pattern).matcher(output).find());
    }

    public static void assertValueNear(long expected, long actual, long allowedError) {
        GenericTestUtils.assertValueWithinRange(expected - allowedError, expected + allowedError, actual);
    }

    public static void assertValueWithinRange(long expectedMin, long expectedMax, long actual) {
        Assert.assertTrue((String)("Expected " + actual + " to be in range (" + expectedMin + "," + expectedMax + ")"), (expectedMin <= actual && actual <= expectedMax ? 1 : 0) != 0);
    }

    public static void assertNoThreadsMatching(String regex) {
        ThreadInfo[] infos;
        Pattern pattern = Pattern.compile(regex);
        ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        for (ThreadInfo info : infos = threadBean.getThreadInfo(threadBean.getAllThreadIds(), 20)) {
            if (info == null || !pattern.matcher(info.getThreadName()).matches()) continue;
            Assert.fail((String)("Leaked thread: " + info + "\n" + Joiner.on((String)"\n").join((Object[])info.getStackTrace())));
        }
    }

    public static class SleepAnswer
    implements Answer<Object> {
        private final int maxSleepTime;
        private static Random r = new Random();

        public SleepAnswer(int maxSleepTime) {
            this.maxSleepTime = maxSleepTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object answer(InvocationOnMock invocation) throws Throwable {
            boolean interrupted = false;
            try {
                Thread.sleep(r.nextInt(this.maxSleepTime));
            }
            catch (InterruptedException ie) {
                interrupted = true;
            }
            try {
                Object object = invocation.callRealMethod();
                return object;
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    public static class DelegateAnswer
    implements Answer<Object> {
        private final Object delegate;
        private final Log log;

        public DelegateAnswer(Object delegate) {
            this(null, delegate);
        }

        public DelegateAnswer(Log log, Object delegate) {
            this.log = log;
            this.delegate = delegate;
        }

        public Object answer(InvocationOnMock invocation) throws Throwable {
            try {
                if (this.log != null) {
                    this.log.info((Object)("Call to " + invocation + " on " + this.delegate), (Throwable)new Exception("TRACE"));
                }
                return invocation.getMethod().invoke(this.delegate, invocation.getArguments());
            }
            catch (InvocationTargetException ite) {
                throw ite.getCause();
            }
        }
    }

    public static class DelayAnswer
    implements Answer<Object> {
        private final Log LOG;
        private final CountDownLatch fireLatch = new CountDownLatch(1);
        private final CountDownLatch waitLatch = new CountDownLatch(1);
        private final CountDownLatch resultLatch = new CountDownLatch(1);
        private final AtomicInteger fireCounter = new AtomicInteger(0);
        private final AtomicInteger resultCounter = new AtomicInteger(0);
        private volatile Throwable thrown;
        private volatile Object returnValue;

        public DelayAnswer(Log log) {
            this.LOG = log;
        }

        public void waitForCall() throws InterruptedException {
            this.fireLatch.await();
        }

        public void proceed() {
            this.waitLatch.countDown();
        }

        public Object answer(InvocationOnMock invocation) throws Throwable {
            this.LOG.info((Object)"DelayAnswer firing fireLatch");
            this.fireCounter.getAndIncrement();
            this.fireLatch.countDown();
            try {
                this.LOG.info((Object)"DelayAnswer waiting on waitLatch");
                this.waitLatch.await();
                this.LOG.info((Object)"DelayAnswer delay complete");
            }
            catch (InterruptedException ie) {
                throw new IOException("Interrupted waiting on latch", ie);
            }
            return this.passThrough(invocation);
        }

        protected Object passThrough(InvocationOnMock invocation) throws Throwable {
            try {
                Object ret;
                this.returnValue = ret = invocation.callRealMethod();
                Object object = ret;
                return object;
            }
            catch (Throwable t) {
                this.thrown = t;
                throw t;
            }
            finally {
                this.resultCounter.incrementAndGet();
                this.resultLatch.countDown();
            }
        }

        public void waitForResult() throws InterruptedException {
            this.resultLatch.await();
        }

        public Throwable getThrown() {
            return this.thrown;
        }

        public Object getReturnValue() {
            return this.returnValue;
        }

        public int getFireCount() {
            return this.fireCounter.get();
        }

        public int getResultCount() {
            return this.resultCounter.get();
        }
    }

    public static class LogCapturer {
        private StringWriter sw = new StringWriter();
        private WriterAppender appender;
        private Logger logger;

        public static LogCapturer captureLogs(Log l) {
            Logger logger = ((Log4JLogger)l).getLogger();
            LogCapturer c = new LogCapturer(logger);
            return c;
        }

        private LogCapturer(Logger logger) {
            this.logger = logger;
            Layout layout = Logger.getRootLogger().getAppender("stdout").getLayout();
            WriterAppender wa = new WriterAppender(layout, (Writer)this.sw);
            logger.addAppender((Appender)wa);
        }

        public String getOutput() {
            return this.sw.toString();
        }

        public void stopCapturing() {
            this.logger.removeAppender((Appender)this.appender);
        }
    }
}

