/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.util.Random;
import org.apache.hadoop.hbase.io.hfile.RandomDistribution;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.WritableComparator;

class KVGenerator {
    private final Random random;
    private final byte[][] dict;
    private final boolean sorted;
    private final RandomDistribution.DiscreteRNG keyLenRNG;
    private final RandomDistribution.DiscreteRNG valLenRNG;
    private BytesWritable lastKey;
    private static final int MIN_KEY_LEN = 4;
    private final byte[] prefix = new byte[4];

    public KVGenerator(Random random, boolean sorted, RandomDistribution.DiscreteRNG keyLenRNG, RandomDistribution.DiscreteRNG valLenRNG, RandomDistribution.DiscreteRNG wordLenRNG, int dictSize) {
        this.random = random;
        this.dict = new byte[dictSize][];
        this.sorted = sorted;
        this.keyLenRNG = keyLenRNG;
        this.valLenRNG = valLenRNG;
        for (int i = 0; i < dictSize; ++i) {
            int wordLen = wordLenRNG.nextInt();
            this.dict[i] = new byte[wordLen];
            random.nextBytes(this.dict[i]);
        }
        this.lastKey = new BytesWritable();
        this.fillKey(this.lastKey);
    }

    private void fillKey(BytesWritable o) {
        int l;
        int len = this.keyLenRNG.nextInt();
        if (len < 4) {
            len = 4;
        }
        o.setSize(len);
        for (int n = 4; n < len; n += l) {
            byte[] word = this.dict[this.random.nextInt(this.dict.length)];
            l = Math.min(word.length, len - n);
            System.arraycopy(word, 0, o.get(), n, l);
        }
        if (this.sorted && WritableComparator.compareBytes((byte[])this.lastKey.get(), (int)4, (int)(this.lastKey.getSize() - 4), (byte[])o.get(), (int)4, (int)(o.getSize() - 4)) > 0) {
            this.incrementPrefix();
        }
        System.arraycopy(this.prefix, 0, o.get(), 0, 4);
        this.lastKey.set(o);
    }

    private void fillValue(BytesWritable o) {
        int l;
        int len = this.valLenRNG.nextInt();
        o.setSize(len);
        for (int n = 0; n < len; n += l) {
            byte[] word = this.dict[this.random.nextInt(this.dict.length)];
            l = Math.min(word.length, len - n);
            System.arraycopy(word, 0, o.get(), n, l);
        }
    }

    private void incrementPrefix() {
        for (int i = 3; i >= 0; --i) {
            int n = i;
            this.prefix[n] = (byte)(this.prefix[n] + 1);
            if (this.prefix[i] == 0) continue;
            return;
        }
        throw new RuntimeException("Prefix overflown");
    }

    public void next(BytesWritable key, BytesWritable value, boolean dupKey) {
        if (dupKey) {
            key.set(this.lastKey);
        } else {
            this.fillKey(key);
        }
        this.fillValue(value);
    }
}

