/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.namespace;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.CategoryBasedTimeout;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.coprocessor.BaseMasterObserver;
import org.apache.hadoop.hbase.coprocessor.BaseRegionObserver;
import org.apache.hadoop.hbase.coprocessor.BaseRegionServerObserver;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionServerCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionServerObserver;
import org.apache.hadoop.hbase.mapreduce.TableInputFormatBase;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.RegionStates;
import org.apache.hadoop.hbase.namespace.NamespaceAuditor;
import org.apache.hadoop.hbase.namespace.NamespaceTableAndRegionInfo;
import org.apache.hadoop.hbase.quotas.MasterQuotaManager;
import org.apache.hadoop.hbase.quotas.QuotaExceededException;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionServerCoprocessorHost;
import org.apache.hadoop.hbase.snapshot.RestoreSnapshotException;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.zookeeper.KeeperException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestRule;

@Category(value={MediumTests.class})
public class TestNamespaceAuditor {
    @Rule
    public final TestRule timeout = CategoryBasedTimeout.builder().withTimeout(this.getClass()).withLookingForStuckThread(true).build();
    private static final Log LOG = LogFactory.getLog(TestNamespaceAuditor.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static HBaseAdmin ADMIN;
    private String prefix = "TestNamespaceAuditor";

    @BeforeClass
    public static void before() throws Exception {
        UTIL.getConfiguration().setBoolean("hbase.assignment.usezk", true);
        TestNamespaceAuditor.setupOnce();
    }

    public static void setupOnce() throws Exception, IOException {
        Configuration conf = UTIL.getConfiguration();
        conf.set("hbase.coprocessor.region.classes", CustomObserver.class.getName());
        conf.set("hbase.coprocessor.master.classes", MasterSyncObserver.class.getName());
        conf.setInt("hbase.client.retries.number", 5);
        conf.setBoolean("hbase.quota.enabled", true);
        conf.setClass("hbase.coprocessor.regionserver.classes", CPRegionServerObserver.class, RegionServerObserver.class);
        UTIL.startMiniCluster(1, 1);
        TestNamespaceAuditor.waitForQuotaEnabled();
        ADMIN = UTIL.getHBaseAdmin();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @After
    public void cleanup() throws Exception, KeeperException {
        for (HTableDescriptor hTableDescriptor : ADMIN.listTables()) {
            ADMIN.disableTable(hTableDescriptor.getTableName());
            this.deleteTable(hTableDescriptor.getTableName());
        }
        for (HTableDescriptor hTableDescriptor : ADMIN.listNamespaceDescriptors()) {
            if (!hTableDescriptor.getName().startsWith(this.prefix)) continue;
            ADMIN.deleteNamespace(hTableDescriptor.getName());
        }
        Assert.assertTrue((String)"Quota manager not enabled", (boolean)UTIL.getHBaseCluster().getMaster().getMasterQuotaManager().isQuotaEnabled());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTableOperations() throws Exception {
        String nsp = this.prefix + "_np2";
        NamespaceDescriptor nspDesc = NamespaceDescriptor.create((String)nsp).addConfiguration("hbase.namespace.quota.maxregions", "5").addConfiguration("hbase.namespace.quota.maxtables", "2").build();
        ADMIN.createNamespace(nspDesc);
        Assert.assertNotNull((String)"Namespace descriptor found null.", (Object)ADMIN.getNamespaceDescriptor(nsp));
        Assert.assertEquals((long)ADMIN.listNamespaceDescriptors().length, (long)3L);
        HTableDescriptor tableDescOne = new HTableDescriptor(TableName.valueOf((String)(nsp + ':' + "table1")));
        HTableDescriptor tableDescTwo = new HTableDescriptor(TableName.valueOf((String)(nsp + ':' + "table2")));
        HTableDescriptor tableDescThree = new HTableDescriptor(TableName.valueOf((String)(nsp + ':' + "table3")));
        ADMIN.createTable(tableDescOne);
        boolean constraintViolated = false;
        try {
            ADMIN.createTable(tableDescTwo, Bytes.toBytes((String)"AAA"), Bytes.toBytes((String)"ZZZ"), 5);
        }
        catch (Exception exp) {
            Assert.assertTrue((boolean)(exp instanceof IOException));
            constraintViolated = true;
        }
        finally {
            Assert.assertTrue((String)("Constraint not violated for table " + tableDescTwo.getTableName()), (boolean)constraintViolated);
        }
        ADMIN.createTable(tableDescTwo, Bytes.toBytes((String)"AAA"), Bytes.toBytes((String)"ZZZ"), 4);
        NamespaceTableAndRegionInfo nspState = this.getQuotaManager().getState(nsp);
        Assert.assertNotNull((Object)nspState);
        Assert.assertTrue((nspState.getTables().size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((nspState.getRegionCount() == 5 ? 1 : 0) != 0);
        constraintViolated = false;
        try {
            ADMIN.createTable(tableDescThree);
        }
        catch (Exception exp) {
            Assert.assertTrue((boolean)(exp instanceof IOException));
            constraintViolated = true;
        }
        finally {
            Assert.assertTrue((String)("Constraint not violated for table " + tableDescThree.getTableName()), (boolean)constraintViolated);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testValidQuotas() throws Exception {
        boolean exceptionCaught = false;
        FileSystem fs = UTIL.getHBaseCluster().getMaster().getMasterFileSystem().getFileSystem();
        Path rootDir = UTIL.getHBaseCluster().getMaster().getMasterFileSystem().getRootDir();
        NamespaceDescriptor nspDesc = NamespaceDescriptor.create((String)(this.prefix + "vq1")).addConfiguration("hbase.namespace.quota.maxregions", "hihdufh").addConfiguration("hbase.namespace.quota.maxtables", "2").build();
        try {
            ADMIN.createNamespace(nspDesc);
        }
        catch (Exception exp) {
            LOG.warn((Object)exp);
            exceptionCaught = true;
        }
        finally {
            Assert.assertTrue((boolean)exceptionCaught);
            Assert.assertFalse((boolean)fs.exists(FSUtils.getNamespaceDir((Path)rootDir, (String)nspDesc.getName())));
        }
        nspDesc = NamespaceDescriptor.create((String)(this.prefix + "vq2")).addConfiguration("hbase.namespace.quota.maxregions", "-456").addConfiguration("hbase.namespace.quota.maxtables", "2").build();
        try {
            ADMIN.createNamespace(nspDesc);
        }
        catch (Exception exp) {
            LOG.warn((Object)exp);
            exceptionCaught = true;
        }
        finally {
            Assert.assertTrue((boolean)exceptionCaught);
            Assert.assertFalse((boolean)fs.exists(FSUtils.getNamespaceDir((Path)rootDir, (String)nspDesc.getName())));
        }
        nspDesc = NamespaceDescriptor.create((String)(this.prefix + "vq3")).addConfiguration("hbase.namespace.quota.maxregions", "10").addConfiguration("hbase.namespace.quota.maxtables", "sciigd").build();
        try {
            ADMIN.createNamespace(nspDesc);
        }
        catch (Exception exp) {
            LOG.warn((Object)exp);
            exceptionCaught = true;
        }
        finally {
            Assert.assertTrue((boolean)exceptionCaught);
            Assert.assertFalse((boolean)fs.exists(FSUtils.getNamespaceDir((Path)rootDir, (String)nspDesc.getName())));
        }
        nspDesc = NamespaceDescriptor.create((String)(this.prefix + "vq4")).addConfiguration("hbase.namespace.quota.maxregions", "10").addConfiguration("hbase.namespace.quota.maxtables", "-1500").build();
        try {
            ADMIN.createNamespace(nspDesc);
        }
        catch (Exception exp) {
            LOG.warn((Object)exp);
            exceptionCaught = true;
        }
        finally {
            Assert.assertTrue((boolean)exceptionCaught);
            Assert.assertFalse((boolean)fs.exists(FSUtils.getNamespaceDir((Path)rootDir, (String)nspDesc.getName())));
        }
    }

    @Test
    public void testDeleteTable() throws Exception {
        String namespace = this.prefix + "_dummy";
        NamespaceDescriptor nspDesc = NamespaceDescriptor.create((String)namespace).addConfiguration("hbase.namespace.quota.maxregions", "100").addConfiguration("hbase.namespace.quota.maxtables", "3").build();
        ADMIN.createNamespace(nspDesc);
        Assert.assertNotNull((String)"Namespace descriptor found null.", (Object)ADMIN.getNamespaceDescriptor(namespace));
        NamespaceTableAndRegionInfo stateInfo = this.getNamespaceState(nspDesc.getName());
        Assert.assertNotNull((String)("Namespace state found null for " + namespace), (Object)stateInfo);
        HTableDescriptor tableDescOne = new HTableDescriptor(TableName.valueOf((String)(namespace + ':' + "table1")));
        HTableDescriptor tableDescTwo = new HTableDescriptor(TableName.valueOf((String)(namespace + ':' + "table2")));
        ADMIN.createTable(tableDescOne);
        ADMIN.createTable(tableDescTwo, Bytes.toBytes((String)"AAA"), Bytes.toBytes((String)"ZZZ"), 5);
        stateInfo = this.getNamespaceState(nspDesc.getName());
        Assert.assertNotNull((String)"Namespace state found to be null.", (Object)stateInfo);
        Assert.assertEquals((long)2L, (long)stateInfo.getTables().size());
        Assert.assertEquals((long)5L, (long)stateInfo.getRegionCountOfTable(tableDescTwo.getTableName()));
        Assert.assertEquals((long)6L, (long)stateInfo.getRegionCount());
        ADMIN.disableTable(tableDescOne.getTableName());
        this.deleteTable(tableDescOne.getTableName());
        stateInfo = this.getNamespaceState(nspDesc.getName());
        Assert.assertNotNull((String)"Namespace state found to be null.", (Object)stateInfo);
        Assert.assertEquals((long)5L, (long)stateInfo.getRegionCount());
        Assert.assertEquals((long)1L, (long)stateInfo.getTables().size());
        ADMIN.disableTable(tableDescTwo.getTableName());
        this.deleteTable(tableDescTwo.getTableName());
        ADMIN.deleteNamespace(namespace);
        stateInfo = this.getNamespaceState(namespace);
        Assert.assertNull((String)"Namespace state not found to be null.", (Object)stateInfo);
    }

    @Test
    public void testRegionMerge() throws Exception {
        String nsp1 = this.prefix + "_regiontest";
        NamespaceDescriptor nspDesc = NamespaceDescriptor.create((String)nsp1).addConfiguration("hbase.namespace.quota.maxregions", "3").addConfiguration("hbase.namespace.quota.maxtables", "2").build();
        ADMIN.createNamespace(nspDesc);
        final TableName tableTwo = TableName.valueOf((String)(nsp1 + ':' + "table2"));
        byte[] columnFamily = Bytes.toBytes((String)"info");
        HTableDescriptor tableDescOne = new HTableDescriptor(tableTwo);
        tableDescOne.addFamily(new HColumnDescriptor(columnFamily));
        int initialRegions = 3;
        ADMIN.createTable(tableDescOne, Bytes.toBytes((String)"1"), Bytes.toBytes((String)"2000"), 3);
        try (Connection connection = ConnectionFactory.createConnection((Configuration)UTIL.getConfiguration());
             Table table = connection.getTable(tableTwo);){
            UTIL.loadNumericRows(table, Bytes.toBytes((String)"info"), 1000, 1999);
        }
        ADMIN.flush(tableTwo);
        List hris = ADMIN.getTableRegions(tableTwo);
        Collections.sort(hris);
        HashSet encodedRegionNamesToMerge = Sets.newHashSet((Object[])new String[]{((HRegionInfo)hris.get(0)).getEncodedName(), ((HRegionInfo)hris.get(1)).getEncodedName()});
        ADMIN.mergeRegions(((HRegionInfo)hris.get(0)).getEncodedNameAsBytes(), ((HRegionInfo)hris.get(1)).getEncodedNameAsBytes(), false);
        this.waitForMergeToComplete(tableTwo, encodedRegionNamesToMerge);
        hris = ADMIN.getTableRegions(tableTwo);
        Assert.assertEquals((long)2L, (long)hris.size());
        Collections.sort(hris);
        final HRegionInfo hriToSplit = (HRegionInfo)hris.get(1);
        ADMIN.split(tableTwo, Bytes.toBytes((String)"500"));
        UTIL.waitFor(10000L, 100L, new Waiter.ExplainingPredicate<Exception>(){

            public boolean evaluate() throws Exception {
                RegionStates regionStates = UTIL.getMiniHBaseCluster().getMaster().getAssignmentManager().getRegionStates();
                for (HRegionInfo hri : ADMIN.getTableRegions(tableTwo)) {
                    if (hri.getEncodedName().equals(hriToSplit.getEncodedName())) {
                        return false;
                    }
                    if (regionStates.isRegionInState(hri, new RegionState.State[]{RegionState.State.OPEN})) continue;
                    return false;
                }
                return true;
            }

            public String explainFailure() throws Exception {
                RegionStates regionStates = UTIL.getMiniHBaseCluster().getMaster().getAssignmentManager().getRegionStates();
                for (HRegionInfo hri : ADMIN.getTableRegions(tableTwo)) {
                    if (hri.getEncodedName().equals(hriToSplit.getEncodedName())) {
                        return hriToSplit + " which is expected to be split is still online";
                    }
                    if (regionStates.isRegionInState(hri, new RegionState.State[]{RegionState.State.OPEN})) continue;
                    return hri + " is still in not opened";
                }
                return "Unknown";
            }
        });
        hris = ADMIN.getTableRegions(tableTwo);
        Assert.assertEquals((long)3L, (long)hris.size());
        Collections.sort(hris);
        MiniHBaseCluster cluster = UTIL.getHBaseCluster();
        HRegionServer regionServer = cluster.getRegionServer(0);
        RegionServerCoprocessorHost cpHost = regionServer.getRegionServerCoprocessorHost();
        Coprocessor coprocessor = cpHost.findCoprocessor(CPRegionServerObserver.class.getName());
        CPRegionServerObserver regionServerObserver = (CPRegionServerObserver)coprocessor;
        regionServerObserver.failMerge(true);
        regionServerObserver.triggered = false;
        ADMIN.mergeRegions(((HRegionInfo)hris.get(1)).getEncodedNameAsBytes(), ((HRegionInfo)hris.get(2)).getEncodedNameAsBytes(), false);
        regionServerObserver.waitUtilTriggered();
        hris = ADMIN.getTableRegions(tableTwo);
        Assert.assertEquals((long)3L, (long)hris.size());
        Collections.sort(hris);
        HRegionInfo hriToSplit2 = (HRegionInfo)hris.get(1);
        ADMIN.split(tableTwo, TableInputFormatBase.getSplitKey((byte[])hriToSplit2.getStartKey(), (byte[])hriToSplit2.getEndKey(), (boolean)true));
        this.waitForMergeToComplete(tableTwo, encodedRegionNamesToMerge);
        Assert.assertEquals((long)3L, (long)ADMIN.getTableRegions(tableTwo).size());
    }

    private void waitForMergeToComplete(final TableName tableTwo, final Set<String> encodedRegionNamesToMerge) throws Exception {
        UTIL.waitFor(10000L, 100L, new Waiter.ExplainingPredicate<Exception>(){

            public boolean evaluate() throws Exception {
                RegionStates regionStates = UTIL.getMiniHBaseCluster().getMaster().getAssignmentManager().getRegionStates();
                for (HRegionInfo hri : ADMIN.getTableRegions(tableTwo)) {
                    if (encodedRegionNamesToMerge.contains(hri.getEncodedName())) {
                        return false;
                    }
                    if (regionStates.isRegionInState(hri, new RegionState.State[]{RegionState.State.OPEN})) continue;
                    return false;
                }
                return true;
            }

            public String explainFailure() throws Exception {
                RegionStates regionStates = UTIL.getMiniHBaseCluster().getMaster().getAssignmentManager().getRegionStates();
                for (HRegionInfo hri : ADMIN.getTableRegions(tableTwo)) {
                    if (encodedRegionNamesToMerge.contains(hri.getEncodedName())) {
                        return hri + " which is expected to be merged is still online";
                    }
                    if (regionStates.isRegionInState(hri, new RegionState.State[]{RegionState.State.OPEN})) continue;
                    return hri + " is still in not opened";
                }
                return "Unknown";
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore(value="Hangs on occasion waiting on countdown latch")
    @Test
    public void testRegionOperations() throws Exception {
        String nsp1 = this.prefix + "_regiontest";
        NamespaceDescriptor nspDesc = NamespaceDescriptor.create((String)nsp1).addConfiguration("hbase.namespace.quota.maxregions", "2").addConfiguration("hbase.namespace.quota.maxtables", "2").build();
        ADMIN.createNamespace(nspDesc);
        boolean constraintViolated = false;
        TableName tableOne = TableName.valueOf((String)(nsp1 + ':' + "table1"));
        byte[] columnFamily = Bytes.toBytes((String)"info");
        HTableDescriptor tableDescOne = new HTableDescriptor(tableOne);
        tableDescOne.addFamily(new HColumnDescriptor(columnFamily));
        try {
            ADMIN.createTable(tableDescOne, Bytes.toBytes((String)"1"), Bytes.toBytes((String)"1000"), 7);
        }
        catch (Exception exp) {
            Assert.assertTrue((boolean)(exp instanceof DoNotRetryIOException));
            LOG.info((Object)exp);
            constraintViolated = true;
        }
        finally {
            Assert.assertTrue((boolean)constraintViolated);
        }
        Assert.assertFalse((boolean)ADMIN.tableExists(tableOne));
        ADMIN.createTable(tableDescOne);
        Connection connection = ConnectionFactory.createConnection((Configuration)UTIL.getConfiguration());
        HTable htable = (HTable)connection.getTable(tableOne);
        UTIL.loadNumericRows((Table)htable, Bytes.toBytes((String)"info"), 1, 1000);
        ADMIN.flush(tableOne);
        NamespaceTableAndRegionInfo stateInfo = this.getNamespaceState(nsp1);
        Assert.assertEquals((long)1L, (long)stateInfo.getTables().size());
        Assert.assertEquals((long)1L, (long)stateInfo.getRegionCount());
        this.restartMaster();
        ADMIN.split(tableOne, Bytes.toBytes((String)"500"));
        HRegion actualRegion = UTIL.getHBaseCluster().getRegions(tableOne).get(0);
        CustomObserver observer = (CustomObserver)actualRegion.getCoprocessorHost().findCoprocessor(CustomObserver.class.getName());
        Assert.assertNotNull((Object)((Object)observer));
        observer.postSplit.await();
        Assert.assertEquals((long)2L, (long)ADMIN.getTableRegions(tableOne).size());
        actualRegion = UTIL.getHBaseCluster().getRegions(tableOne).get(0);
        observer = (CustomObserver)actualRegion.getCoprocessorHost().findCoprocessor(CustomObserver.class.getName());
        Assert.assertNotNull((Object)((Object)observer));
        ADMIN.split(tableOne, this.getSplitKey(actualRegion.getRegionInfo().getStartKey(), actualRegion.getRegionInfo().getEndKey()));
        observer.postSplit.await();
        List hris = ADMIN.getTableRegions(tableOne);
        Assert.assertEquals((long)2L, (long)hris.size());
        Assert.assertTrue((String)"split completed", (observer.preSplitBeforePONR.getCount() == 1L ? 1 : 0) != 0);
        htable.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRecreateTableWithSameNameAfterFirstTimeFailure() throws Exception {
        String nsp1 = this.prefix + "_testRecreateTable";
        NamespaceDescriptor nspDesc = NamespaceDescriptor.create((String)nsp1).addConfiguration("hbase.namespace.quota.maxregions", "20").addConfiguration("hbase.namespace.quota.maxtables", "1").build();
        ADMIN.createNamespace(nspDesc);
        TableName tableOne = TableName.valueOf((String)(nsp1 + ':' + "table1"));
        byte[] columnFamily = Bytes.toBytes((String)"info");
        HTableDescriptor tableDescOne = new HTableDescriptor(tableOne);
        tableDescOne.addFamily(new HColumnDescriptor(columnFamily));
        MasterSyncObserver.throwExceptionInPreCreateTableHandler = true;
        try {
            try {
                ADMIN.createTable(tableDescOne);
                Assert.fail((String)("Table " + tableOne.toString() + "creation should fail."));
            }
            catch (Exception exp) {
                LOG.error((Object)exp);
            }
            Assert.assertFalse((boolean)ADMIN.tableExists(tableOne));
            NamespaceTableAndRegionInfo nstate = this.getNamespaceState(nsp1);
            Assert.assertEquals((String)"First table creation failed in namespace so number of tables in namespace should be 0.", (long)0L, (long)nstate.getTables().size());
            MasterSyncObserver.throwExceptionInPreCreateTableHandler = false;
            try {
                ADMIN.createTable(tableDescOne);
            }
            catch (Exception e) {
                Assert.fail((String)("Table " + tableOne.toString() + "creation should succeed."));
                LOG.error((Object)e);
            }
            Assert.assertTrue((boolean)ADMIN.tableExists(tableOne));
            nstate = this.getNamespaceState(nsp1);
            Assert.assertEquals((String)"First table was created successfully so table size in namespace should be one now.", (long)1L, (long)nstate.getTables().size());
        }
        finally {
            MasterSyncObserver.throwExceptionInPreCreateTableHandler = false;
            if (ADMIN.tableExists(tableOne)) {
                ADMIN.disableTable(tableOne);
                this.deleteTable(tableOne);
            }
            ADMIN.deleteNamespace(nsp1);
        }
    }

    private NamespaceTableAndRegionInfo getNamespaceState(String namespace) throws KeeperException, IOException {
        return this.getQuotaManager().getState(namespace);
    }

    byte[] getSplitKey(byte[] startKey, byte[] endKey) {
        String skey = Bytes.toString((byte[])startKey);
        int key = StringUtils.isBlank((String)skey) ? Integer.parseInt(Bytes.toString((byte[])endKey)) / 2 : (int)((double)Integer.parseInt(skey) * 1.5);
        return Bytes.toBytes((String)("" + key));
    }

    @Test
    public void testStatePreserve() throws Exception {
        final String nsp1 = this.prefix + "_testStatePreserve";
        NamespaceDescriptor nspDesc = NamespaceDescriptor.create((String)nsp1).addConfiguration("hbase.namespace.quota.maxregions", "20").addConfiguration("hbase.namespace.quota.maxtables", "10").build();
        ADMIN.createNamespace(nspDesc);
        TableName tableOne = TableName.valueOf((String)(nsp1 + ':' + "table1"));
        TableName tableTwo = TableName.valueOf((String)(nsp1 + ':' + "table2"));
        TableName tableThree = TableName.valueOf((String)(nsp1 + ':' + "table3"));
        HTableDescriptor tableDescOne = new HTableDescriptor(tableOne);
        HTableDescriptor tableDescTwo = new HTableDescriptor(tableTwo);
        HTableDescriptor tableDescThree = new HTableDescriptor(tableThree);
        ADMIN.createTable(tableDescOne, Bytes.toBytes((String)"1"), Bytes.toBytes((String)"1000"), 3);
        ADMIN.createTable(tableDescTwo, Bytes.toBytes((String)"1"), Bytes.toBytes((String)"1000"), 3);
        ADMIN.createTable(tableDescThree, Bytes.toBytes((String)"1"), Bytes.toBytes((String)"1000"), 4);
        ADMIN.disableTable(tableThree);
        this.deleteTable(tableThree);
        UTIL.waitFor(1000L, new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return TestNamespaceAuditor.this.getNamespaceState(nsp1).getTables().size() == 2;
            }
        });
        NamespaceTableAndRegionInfo before = this.getNamespaceState(nsp1);
        this.restartMaster();
        NamespaceTableAndRegionInfo after = this.getNamespaceState(nsp1);
        Assert.assertEquals((String)("Expected: " + before.getTables() + " Found: " + after.getTables()), (long)before.getTables().size(), (long)after.getTables().size());
    }

    private static void waitForQuotaEnabled() throws Exception {
        UTIL.waitFor(60000L, new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                HMaster master = UTIL.getHBaseCluster().getMaster();
                if (master == null) {
                    return false;
                }
                MasterQuotaManager quotaManager = master.getMasterQuotaManager();
                return quotaManager != null && quotaManager.isQuotaEnabled();
            }
        });
    }

    private void restartMaster() throws Exception {
        UTIL.getHBaseCluster().getMaster(0).stop("Stopping to start again");
        UTIL.getHBaseCluster().waitOnMaster(0);
        UTIL.getHBaseCluster().startMaster();
        TestNamespaceAuditor.waitForQuotaEnabled();
    }

    private NamespaceAuditor getQuotaManager() {
        return UTIL.getHBaseCluster().getMaster().getMasterQuotaManager().getNamespaceQuotaManager();
    }

    private void deleteTable(TableName tableName) throws Exception {
        MasterSyncObserver observer = (MasterSyncObserver)UTIL.getHBaseCluster().getMaster().getMasterCoprocessorHost().findCoprocessor(MasterSyncObserver.class.getName());
        ADMIN.deleteTable(tableName);
        observer.tableDeletionLatch.await();
    }

    @Test(expected=QuotaExceededException.class)
    public void testExceedTableQuotaInNamespace() throws Exception {
        String nsp = this.prefix + "_testExceedTableQuotaInNamespace";
        NamespaceDescriptor nspDesc = NamespaceDescriptor.create((String)nsp).addConfiguration("hbase.namespace.quota.maxtables", "1").build();
        ADMIN.createNamespace(nspDesc);
        Assert.assertNotNull((String)"Namespace descriptor found null.", (Object)ADMIN.getNamespaceDescriptor(nsp));
        Assert.assertEquals((long)ADMIN.listNamespaceDescriptors().length, (long)3L);
        HTableDescriptor tableDescOne = new HTableDescriptor(TableName.valueOf((String)(nsp + ':' + "table1")));
        HTableDescriptor tableDescTwo = new HTableDescriptor(TableName.valueOf((String)(nsp + ':' + "table2")));
        ADMIN.createTable(tableDescOne);
        ADMIN.createTable(tableDescTwo, Bytes.toBytes((String)"AAA"), Bytes.toBytes((String)"ZZZ"), 4);
    }

    @Test(expected=QuotaExceededException.class)
    public void testCloneSnapshotQuotaExceed() throws Exception {
        String nsp = this.prefix + "_testTableQuotaExceedWithCloneSnapshot";
        NamespaceDescriptor nspDesc = NamespaceDescriptor.create((String)nsp).addConfiguration("hbase.namespace.quota.maxtables", "1").build();
        ADMIN.createNamespace(nspDesc);
        Assert.assertNotNull((String)"Namespace descriptor found null.", (Object)ADMIN.getNamespaceDescriptor(nsp));
        TableName tableName = TableName.valueOf((String)(nsp + ':' + "table1"));
        TableName cloneTableName = TableName.valueOf((String)(nsp + ':' + "table2"));
        HTableDescriptor tableDescOne = new HTableDescriptor(tableName);
        ADMIN.createTable(tableDescOne);
        String snapshot = "snapshot_testTableQuotaExceedWithCloneSnapshot";
        ADMIN.snapshot(snapshot, tableName);
        ADMIN.cloneSnapshot(snapshot, cloneTableName);
        ADMIN.deleteSnapshot(snapshot);
    }

    @Test
    public void testCloneSnapshot() throws Exception {
        int tableLength;
        String nsp = this.prefix + "_testCloneSnapshot";
        NamespaceDescriptor nspDesc = NamespaceDescriptor.create((String)nsp).addConfiguration("hbase.namespace.quota.maxtables", "2").addConfiguration("hbase.namespace.quota.maxregions", "20").build();
        ADMIN.createNamespace(nspDesc);
        Assert.assertNotNull((String)"Namespace descriptor found null.", (Object)ADMIN.getNamespaceDescriptor(nsp));
        TableName tableName = TableName.valueOf((String)(nsp + ':' + "table1"));
        TableName cloneTableName = TableName.valueOf((String)(nsp + ':' + "table2"));
        HTableDescriptor tableDescOne = new HTableDescriptor(tableName);
        ADMIN.createTable(tableDescOne, Bytes.toBytes((String)"AAA"), Bytes.toBytes((String)"ZZZ"), 4);
        String snapshot = "snapshot_testCloneSnapshot";
        ADMIN.snapshot(snapshot, tableName);
        ADMIN.cloneSnapshot(snapshot, cloneTableName);
        try (RegionLocator locator = ADMIN.getConnection().getRegionLocator(tableName);){
            tableLength = locator.getStartKeys().length;
        }
        Assert.assertEquals((String)(tableName.getNameAsString() + " should have four regions."), (long)4L, (long)tableLength);
        locator = ADMIN.getConnection().getRegionLocator(cloneTableName);
        var9_8 = null;
        try {
            tableLength = locator.getStartKeys().length;
        }
        catch (Throwable throwable) {
            var9_8 = throwable;
            throw throwable;
        }
        finally {
            if (locator != null) {
                if (var9_8 != null) {
                    try {
                        locator.close();
                    }
                    catch (Throwable x2) {
                        var9_8.addSuppressed(x2);
                    }
                } else {
                    locator.close();
                }
            }
        }
        Assert.assertEquals((String)(cloneTableName.getNameAsString() + " should have four regions."), (long)4L, (long)tableLength);
        NamespaceTableAndRegionInfo nstate = this.getNamespaceState(nsp);
        Assert.assertEquals((String)"Total tables count should be 2.", (long)2L, (long)nstate.getTables().size());
        Assert.assertEquals((String)"Total regions count should be.", (long)8L, (long)nstate.getRegionCount());
        ADMIN.deleteSnapshot(snapshot);
    }

    @Test
    public void testRestoreSnapshot() throws Exception {
        String nsp = this.prefix + "_testRestoreSnapshot";
        NamespaceDescriptor nspDesc = NamespaceDescriptor.create((String)nsp).addConfiguration("hbase.namespace.quota.maxregions", "10").build();
        ADMIN.createNamespace(nspDesc);
        Assert.assertNotNull((String)"Namespace descriptor found null.", (Object)ADMIN.getNamespaceDescriptor(nsp));
        TableName tableName1 = TableName.valueOf((String)(nsp + ':' + "table1"));
        HTableDescriptor tableDescOne = new HTableDescriptor(tableName1);
        ADMIN.createTable(tableDescOne, Bytes.toBytes((String)"AAA"), Bytes.toBytes((String)"ZZZ"), 4);
        NamespaceTableAndRegionInfo nstate = this.getNamespaceState(nsp);
        Assert.assertEquals((String)"Intial region count should be 4.", (long)4L, (long)nstate.getRegionCount());
        String snapshot = "snapshot_testRestoreSnapshot";
        ADMIN.snapshot(snapshot, tableName1);
        List regions = ADMIN.getTableRegions(tableName1);
        Collections.sort(regions);
        ADMIN.split(tableName1, Bytes.toBytes((String)"JJJ"));
        Thread.sleep(2000L);
        Assert.assertEquals((String)"Total regions count should be 5.", (long)5L, (long)nstate.getRegionCount());
        ADMIN.disableTable(tableName1);
        ADMIN.restoreSnapshot(snapshot);
        Assert.assertEquals((String)"Total regions count should be 4 after restore.", (long)4L, (long)nstate.getRegionCount());
        ADMIN.enableTable(tableName1);
        ADMIN.deleteSnapshot(snapshot);
    }

    @Test
    public void testRestoreSnapshotQuotaExceed() throws Exception {
        String nsp = this.prefix + "_testRestoreSnapshotQuotaExceed";
        NamespaceDescriptor nspDesc = NamespaceDescriptor.create((String)nsp).addConfiguration("hbase.namespace.quota.maxregions", "10").build();
        ADMIN.createNamespace(nspDesc);
        NamespaceDescriptor ndesc = ADMIN.getNamespaceDescriptor(nsp);
        Assert.assertNotNull((String)"Namespace descriptor found null.", (Object)ndesc);
        TableName tableName1 = TableName.valueOf((String)(nsp + ':' + "table1"));
        HTableDescriptor tableDescOne = new HTableDescriptor(tableName1);
        ADMIN.createTable(tableDescOne, Bytes.toBytes((String)"AAA"), Bytes.toBytes((String)"ZZZ"), 4);
        NamespaceTableAndRegionInfo nstate = this.getNamespaceState(nsp);
        Assert.assertEquals((String)"Intial region count should be 4.", (long)4L, (long)nstate.getRegionCount());
        String snapshot = "snapshot_testRestoreSnapshotQuotaExceed";
        ADMIN.snapshot(snapshot, tableName1);
        List regions = ADMIN.getTableRegions(tableName1);
        Collections.sort(regions);
        ADMIN.split(tableName1, Bytes.toBytes((String)"JJJ"));
        Thread.sleep(2000L);
        Assert.assertEquals((String)"Total regions count should be 5.", (long)5L, (long)nstate.getRegionCount());
        ndesc.setConfiguration("hbase.namespace.quota.maxregions", "2");
        ADMIN.modifyNamespace(ndesc);
        ADMIN.disableTable(tableName1);
        try {
            ADMIN.restoreSnapshot(snapshot);
            Assert.fail((String)"Region quota is exceeded so QuotaExceededException should be thrown but HBaseAdmin wraps IOException into RestoreSnapshotException");
        }
        catch (RestoreSnapshotException restoreSnapshotException) {
            // empty catch block
        }
        ADMIN.enableTable(tableName1);
        ADMIN.deleteSnapshot(snapshot);
    }

    public static class MasterSyncObserver
    extends BaseMasterObserver {
        volatile CountDownLatch tableDeletionLatch;
        static boolean throwExceptionInPreCreateTableHandler;

        public void preDeleteTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
            this.tableDeletionLatch = new CountDownLatch(1);
        }

        public void postDeleteTableHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
            this.tableDeletionLatch.countDown();
        }

        public void preCreateTableHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, HTableDescriptor desc, HRegionInfo[] regions) throws IOException {
            if (throwExceptionInPreCreateTableHandler) {
                throw new IOException("Throw exception as it is demanded.");
            }
        }
    }

    public static class CustomObserver
    extends BaseRegionObserver {
        volatile CountDownLatch postSplit;
        volatile CountDownLatch preSplitBeforePONR;

        public void postCompleteSplit(ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
            this.postSplit.countDown();
        }

        public void preSplitBeforePONR(ObserverContext<RegionCoprocessorEnvironment> ctx, byte[] splitKey, List<Mutation> metaEntries) throws IOException {
            this.preSplitBeforePONR.countDown();
        }

        public void start(CoprocessorEnvironment e) throws IOException {
            this.postSplit = new CountDownLatch(1);
            this.preSplitBeforePONR = new CountDownLatch(1);
        }
    }

    public static class CPRegionServerObserver
    extends BaseRegionServerObserver {
        private volatile boolean shouldFailMerge = false;
        private boolean triggered = false;

        public void failMerge(boolean fail) {
            this.shouldFailMerge = fail;
        }

        public synchronized void waitUtilTriggered() throws InterruptedException {
            while (!this.triggered) {
                ((Object)((Object)this)).wait();
            }
        }

        public synchronized void preMerge(ObserverContext<RegionServerCoprocessorEnvironment> ctx, Region regionA, Region regionB) throws IOException {
            this.triggered = true;
            ((Object)((Object)this)).notifyAll();
            if (this.shouldFailMerge) {
                throw new IOException("fail merge");
            }
        }
    }
}

