/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.replication.HBaseReplicationEndpoint;
import org.apache.hadoop.hbase.replication.ReplicationPeers;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSinkManager;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestReplicationSinkManager {
    private static final String PEER_CLUSTER_ID = "PEER_CLUSTER_ID";
    private ReplicationPeers replicationPeers;
    private HBaseReplicationEndpoint replicationEndpoint;
    private ReplicationSinkManager sinkManager;

    @Before
    public void setUp() {
        this.replicationPeers = (ReplicationPeers)Mockito.mock(ReplicationPeers.class);
        this.replicationEndpoint = (HBaseReplicationEndpoint)Mockito.mock(HBaseReplicationEndpoint.class);
        this.sinkManager = new ReplicationSinkManager((HConnection)Mockito.mock(HConnection.class), PEER_CLUSTER_ID, this.replicationEndpoint, new Configuration());
    }

    @Test
    public void testChooseSinks() {
        ArrayList serverNames = Lists.newArrayList();
        for (int i = 0; i < 20; ++i) {
            serverNames.add(Mockito.mock(ServerName.class));
        }
        Mockito.when((Object)this.replicationEndpoint.getRegionServers()).thenReturn((Object)serverNames);
        this.sinkManager.chooseSinks();
        Assert.assertEquals((long)2L, (long)this.sinkManager.getNumSinks());
    }

    @Test
    public void testChooseSinks_LessThanRatioAvailable() {
        ArrayList serverNames = Lists.newArrayList((Object[])new ServerName[]{(ServerName)Mockito.mock(ServerName.class), (ServerName)Mockito.mock(ServerName.class)});
        Mockito.when((Object)this.replicationEndpoint.getRegionServers()).thenReturn((Object)serverNames);
        this.sinkManager.chooseSinks();
        Assert.assertEquals((long)1L, (long)this.sinkManager.getNumSinks());
    }

    @Test
    public void testReportBadSink() {
        ServerName serverNameA = (ServerName)Mockito.mock(ServerName.class);
        ServerName serverNameB = (ServerName)Mockito.mock(ServerName.class);
        Mockito.when((Object)this.replicationEndpoint.getRegionServers()).thenReturn((Object)Lists.newArrayList((Object[])new ServerName[]{serverNameA, serverNameB}));
        this.sinkManager.chooseSinks();
        Assert.assertEquals((long)1L, (long)this.sinkManager.getNumSinks());
        ReplicationSinkManager.SinkPeer sinkPeer = new ReplicationSinkManager.SinkPeer(serverNameA, (AdminProtos.AdminService.BlockingInterface)Mockito.mock(AdminProtos.AdminService.BlockingInterface.class));
        this.sinkManager.reportBadSink(sinkPeer);
        Assert.assertEquals((long)1L, (long)this.sinkManager.getNumSinks());
    }

    @Test
    public void testReportBadSink_PastThreshold() {
        int i;
        ArrayList serverNames = Lists.newArrayList();
        for (int i2 = 0; i2 < 30; ++i2) {
            serverNames.add(Mockito.mock(ServerName.class));
        }
        Mockito.when((Object)this.replicationEndpoint.getRegionServers()).thenReturn((Object)serverNames);
        this.sinkManager.chooseSinks();
        Assert.assertEquals((long)3L, (long)this.sinkManager.getNumSinks());
        ServerName serverName = (ServerName)this.sinkManager.getSinksForTesting().get(0);
        ReplicationSinkManager.SinkPeer sinkPeer = new ReplicationSinkManager.SinkPeer(serverName, (AdminProtos.AdminService.BlockingInterface)Mockito.mock(AdminProtos.AdminService.BlockingInterface.class));
        this.sinkManager.reportSinkSuccess(sinkPeer);
        for (i = 0; i <= 3; ++i) {
            this.sinkManager.reportBadSink(sinkPeer);
        }
        Assert.assertEquals((long)2L, (long)this.sinkManager.getNumSinks());
        serverName = (ServerName)this.sinkManager.getSinksForTesting().get(0);
        sinkPeer = new ReplicationSinkManager.SinkPeer(serverName, (AdminProtos.AdminService.BlockingInterface)Mockito.mock(AdminProtos.AdminService.BlockingInterface.class));
        for (i = 0; i <= 2; ++i) {
            this.sinkManager.reportBadSink(sinkPeer);
        }
        this.sinkManager.reportSinkSuccess(sinkPeer);
        this.sinkManager.reportBadSink(sinkPeer);
        Assert.assertEquals((long)2L, (long)this.sinkManager.getNumSinks());
        for (i = 0; i <= 1; ++i) {
            this.sinkManager.reportBadSink(sinkPeer);
        }
        Assert.assertEquals((long)2L, (long)this.sinkManager.getNumSinks());
        this.sinkManager.reportBadSink(sinkPeer);
        Assert.assertEquals((long)1L, (long)this.sinkManager.getNumSinks());
    }

    @Test
    public void testReportBadSink_DownToZeroSinks() {
        ArrayList serverNames = Lists.newArrayList();
        for (int i = 0; i < 20; ++i) {
            serverNames.add(Mockito.mock(ServerName.class));
        }
        Mockito.when((Object)this.replicationEndpoint.getRegionServers()).thenReturn((Object)serverNames);
        this.sinkManager.chooseSinks();
        List sinkList = this.sinkManager.getSinksForTesting();
        Assert.assertEquals((long)2L, (long)sinkList.size());
        ServerName serverNameA = (ServerName)sinkList.get(0);
        ServerName serverNameB = (ServerName)sinkList.get(1);
        ReplicationSinkManager.SinkPeer sinkPeerA = new ReplicationSinkManager.SinkPeer(serverNameA, (AdminProtos.AdminService.BlockingInterface)Mockito.mock(AdminProtos.AdminService.BlockingInterface.class));
        ReplicationSinkManager.SinkPeer sinkPeerB = new ReplicationSinkManager.SinkPeer(serverNameB, (AdminProtos.AdminService.BlockingInterface)Mockito.mock(AdminProtos.AdminService.BlockingInterface.class));
        for (int i = 0; i <= 3; ++i) {
            this.sinkManager.reportBadSink(sinkPeerA);
            this.sinkManager.reportBadSink(sinkPeerB);
        }
        Assert.assertEquals((long)2L, (long)this.sinkManager.getNumSinks());
    }
}

