/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import com.google.protobuf.Service;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CoordinatedStateException;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.PleaseHoldException;
import org.apache.hadoop.hbase.ProcedureInfo;
import org.apache.hadoop.hbase.ServerLoad;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.UnknownRegionException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.errorhandling.ForeignException;
import org.apache.hadoop.hbase.exceptions.MergeRegionException;
import org.apache.hadoop.hbase.exceptions.UnknownProtocolException;
import org.apache.hadoop.hbase.ipc.PriorityFunction;
import org.apache.hadoop.hbase.ipc.QosPriority;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.ipc.ServerRpcController;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.master.MasterAnnotationReadingPriorityFunction;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.RegionStates;
import org.apache.hadoop.hbase.procedure.MasterProcedureManager;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.RequestConverter;
import org.apache.hadoop.hbase.protobuf.ResponseConverter;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.ClusterStatusProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.regionserver.RSRpcServices;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.AccessController;
import org.apache.hadoop.hbase.security.visibility.VisibilityController;
import org.apache.hadoop.hbase.snapshot.ClientSnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class MasterRpcServices
extends RSRpcServices
implements MasterProtos.MasterService.BlockingInterface,
RegionServerStatusProtos.RegionServerStatusService.BlockingInterface {
    private static final Log LOG = LogFactory.getLog((String)MasterRpcServices.class.getName());
    private final HMaster master;

    private RegionServerStatusProtos.RegionServerStartupResponse.Builder createConfigurationSubset() {
        RegionServerStatusProtos.RegionServerStartupResponse.Builder resp = this.addConfig(RegionServerStatusProtos.RegionServerStartupResponse.newBuilder(), "hbase.rootdir");
        resp = this.addConfig(resp, "fs.defaultFS");
        return this.addConfig(resp, "hbase.master.info.port");
    }

    private RegionServerStatusProtos.RegionServerStartupResponse.Builder addConfig(RegionServerStatusProtos.RegionServerStartupResponse.Builder resp, String key) {
        HBaseProtos.NameStringPair.Builder entry = HBaseProtos.NameStringPair.newBuilder().setName(key).setValue(this.master.getConfiguration().get(key));
        resp.addMapEntries(entry.build());
        return resp;
    }

    public MasterRpcServices(HMaster m) throws IOException {
        super(m);
        this.master = m;
    }

    @Override
    protected PriorityFunction createPriority() {
        return new MasterAnnotationReadingPriorityFunction(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean switchBalancer(boolean b, BalanceSwitchMode mode) throws IOException {
        boolean oldValue = this.master.loadBalancerTracker.isBalancerOn();
        boolean newValue = b;
        try {
            block10: {
                if (this.master.cpHost != null) {
                    newValue = this.master.cpHost.preBalanceSwitch(newValue);
                }
                try {
                    if (mode == BalanceSwitchMode.SYNC) {
                        LoadBalancer loadBalancer = this.master.balancer;
                        synchronized (loadBalancer) {
                            this.master.loadBalancerTracker.setBalancerOn(newValue);
                            break block10;
                        }
                    }
                    this.master.loadBalancerTracker.setBalancerOn(newValue);
                }
                catch (KeeperException ke) {
                    throw new IOException(ke);
                }
            }
            LOG.info((Object)(this.master.getClientIdAuditPrefix() + " set balanceSwitch=" + newValue));
            if (this.master.cpHost != null) {
                this.master.cpHost.postBalanceSwitch(oldValue, newValue);
            }
        }
        catch (IOException ioe) {
            LOG.warn((Object)"Error flipping balance switch", (Throwable)ioe);
        }
        return oldValue;
    }

    boolean synchronousBalanceSwitch(boolean b) throws IOException {
        return this.switchBalancer(b, BalanceSwitchMode.SYNC);
    }

    public boolean normalizerSwitch(boolean on) {
        boolean oldValue = this.master.getRegionNormalizerTracker().isNormalizerOn();
        boolean newValue = on;
        try {
            try {
                this.master.getRegionNormalizerTracker().setNormalizerOn(newValue);
            }
            catch (KeeperException ke) {
                throw new IOException(ke);
            }
            LOG.info((Object)(this.master.getClientIdAuditPrefix() + " set normalizerSwitch=" + newValue));
        }
        catch (IOException ioe) {
            LOG.warn((Object)"Error flipping normalizer switch", (Throwable)ioe);
        }
        return oldValue;
    }

    @Override
    protected List<RpcServer.BlockingServiceAndInterface> getServices() {
        ArrayList<RpcServer.BlockingServiceAndInterface> bssi = new ArrayList<RpcServer.BlockingServiceAndInterface>(4);
        bssi.add(new RpcServer.BlockingServiceAndInterface(MasterProtos.MasterService.newReflectiveBlockingService((MasterProtos.MasterService.BlockingInterface)this), MasterProtos.MasterService.BlockingInterface.class));
        bssi.add(new RpcServer.BlockingServiceAndInterface(RegionServerStatusProtos.RegionServerStatusService.newReflectiveBlockingService((RegionServerStatusProtos.RegionServerStatusService.BlockingInterface)this), RegionServerStatusProtos.RegionServerStatusService.BlockingInterface.class));
        bssi.addAll(super.getServices());
        return bssi;
    }

    @QosPriority(priority=100)
    public RegionServerStatusProtos.GetLastFlushedSequenceIdResponse getLastFlushedSequenceId(RpcController controller, RegionServerStatusProtos.GetLastFlushedSequenceIdRequest request) throws ServiceException {
        try {
            this.master.checkServiceStarted();
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
        byte[] encodedRegionName = request.getRegionName().toByteArray();
        ClusterStatusProtos.RegionStoreSequenceIds ids = this.master.serverManager.getLastFlushedSequenceId(encodedRegionName);
        return ResponseConverter.buildGetLastFlushedSequenceIdResponse((ClusterStatusProtos.RegionStoreSequenceIds)ids);
    }

    public RegionServerStatusProtos.RegionServerReportResponse regionServerReport(RpcController controller, RegionServerStatusProtos.RegionServerReportRequest request) throws ServiceException {
        try {
            this.master.checkServiceStarted();
            ClusterStatusProtos.ServerLoad sl = request.getLoad();
            ServerName serverName = ProtobufUtil.toServerName((HBaseProtos.ServerName)request.getServer());
            ServerLoad oldLoad = this.master.serverManager.getLoad(serverName);
            this.master.serverManager.regionServerReport(serverName, new ServerLoad(sl));
            if (sl != null && this.master.metricsMaster != null) {
                this.master.metricsMaster.incrementRequests(sl.getTotalNumberOfRequests() - (oldLoad != null ? oldLoad.getTotalNumberOfRequests() : 0L));
            }
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
        return RegionServerStatusProtos.RegionServerReportResponse.newBuilder().build();
    }

    public RegionServerStatusProtos.RegionServerStartupResponse regionServerStartup(RpcController controller, RegionServerStatusProtos.RegionServerStartupRequest request) throws ServiceException {
        try {
            this.master.checkServiceStarted();
            InetAddress ia = this.master.getRemoteInetAddress(request.getPort(), request.getServerStartCode());
            ServerName rs = this.master.serverManager.regionServerStartup(request, ia);
            RegionServerStatusProtos.RegionServerStartupResponse.Builder resp = this.createConfigurationSubset();
            HBaseProtos.NameStringPair.Builder entry = HBaseProtos.NameStringPair.newBuilder().setName("hbase.regionserver.hostname.seen.by.master").setValue(rs.getHostname());
            resp.addMapEntries(entry.build());
            return resp.build();
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    public RegionServerStatusProtos.ReportRSFatalErrorResponse reportRSFatalError(RpcController controller, RegionServerStatusProtos.ReportRSFatalErrorRequest request) throws ServiceException {
        String errorText = request.getErrorMessage();
        ServerName sn = ProtobufUtil.toServerName((HBaseProtos.ServerName)request.getServer());
        String msg = "Region server " + sn + " reported a fatal error:\n" + errorText;
        LOG.error((Object)msg);
        this.master.rsFatals.add(msg);
        return RegionServerStatusProtos.ReportRSFatalErrorResponse.newBuilder().build();
    }

    public MasterProtos.AddColumnResponse addColumn(RpcController controller, MasterProtos.AddColumnRequest req) throws ServiceException {
        try {
            this.master.addColumn(ProtobufUtil.toTableName((HBaseProtos.TableName)req.getTableName()), HColumnDescriptor.convert((HBaseProtos.ColumnFamilySchema)req.getColumnFamilies()), req.getNonceGroup(), req.getNonce());
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
        return MasterProtos.AddColumnResponse.newBuilder().build();
    }

    public MasterProtos.AssignRegionResponse assignRegion(RpcController controller, MasterProtos.AssignRegionRequest req) throws ServiceException {
        try {
            RegionStates regionStates;
            HRegionInfo regionInfo;
            byte[] regionName = req.getRegion().getValue().toByteArray();
            HBaseProtos.RegionSpecifier.RegionSpecifierType type = req.getRegion().getType();
            MasterProtos.AssignRegionResponse arr = MasterProtos.AssignRegionResponse.newBuilder().build();
            this.master.checkInitialized();
            if (type != HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME) {
                LOG.warn((Object)("assignRegion specifier type: expected: " + HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME + " actual: " + type));
            }
            if ((regionInfo = (regionStates = this.master.assignmentManager.getRegionStates()).getRegionInfo(regionName)) == null) {
                throw new UnknownRegionException(Bytes.toString((byte[])regionName));
            }
            if (this.master.cpHost != null && this.master.cpHost.preAssign(regionInfo)) {
                return arr;
            }
            LOG.info((Object)(this.master.getClientIdAuditPrefix() + " assign " + regionInfo.getRegionNameAsString()));
            this.master.assignmentManager.assign(regionInfo, true, true);
            if (this.master.cpHost != null) {
                this.master.cpHost.postAssign(regionInfo);
            }
            return arr;
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    public MasterProtos.BalanceResponse balance(RpcController controller, MasterProtos.BalanceRequest request) throws ServiceException {
        try {
            return MasterProtos.BalanceResponse.newBuilder().setBalancerRan(this.master.balance()).build();
        }
        catch (IOException ex) {
            throw new ServiceException((Throwable)ex);
        }
    }

    public MasterProtos.CreateNamespaceResponse createNamespace(RpcController controller, MasterProtos.CreateNamespaceRequest request) throws ServiceException {
        try {
            this.master.createNamespace(ProtobufUtil.toNamespaceDescriptor((HBaseProtos.NamespaceDescriptor)request.getNamespaceDescriptor()));
            return MasterProtos.CreateNamespaceResponse.getDefaultInstance();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.CreateTableResponse createTable(RpcController controller, MasterProtos.CreateTableRequest req) throws ServiceException {
        HTableDescriptor hTableDescriptor = HTableDescriptor.convert((HBaseProtos.TableSchema)req.getTableSchema());
        byte[][] splitKeys = ProtobufUtil.getSplitKeysArray((MasterProtos.CreateTableRequest)req);
        try {
            long procId = this.master.createTable(hTableDescriptor, splitKeys, req.getNonceGroup(), req.getNonce());
            return MasterProtos.CreateTableResponse.newBuilder().setProcId(procId).build();
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    public MasterProtos.DeleteColumnResponse deleteColumn(RpcController controller, MasterProtos.DeleteColumnRequest req) throws ServiceException {
        try {
            this.master.deleteColumn(ProtobufUtil.toTableName((HBaseProtos.TableName)req.getTableName()), req.getColumnName().toByteArray(), req.getNonceGroup(), req.getNonce());
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
        return MasterProtos.DeleteColumnResponse.newBuilder().build();
    }

    public MasterProtos.DeleteNamespaceResponse deleteNamespace(RpcController controller, MasterProtos.DeleteNamespaceRequest request) throws ServiceException {
        try {
            this.master.deleteNamespace(request.getNamespaceName());
            return MasterProtos.DeleteNamespaceResponse.getDefaultInstance();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.DeleteSnapshotResponse deleteSnapshot(RpcController controller, MasterProtos.DeleteSnapshotRequest request) throws ServiceException {
        try {
            this.master.checkInitialized();
            this.master.snapshotManager.checkSnapshotSupport();
            LOG.info((Object)(this.master.getClientIdAuditPrefix() + " delete " + request.getSnapshot()));
            this.master.snapshotManager.deleteSnapshot(request.getSnapshot());
            return MasterProtos.DeleteSnapshotResponse.newBuilder().build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.DeleteTableResponse deleteTable(RpcController controller, MasterProtos.DeleteTableRequest request) throws ServiceException {
        try {
            long procId = this.master.deleteTable(ProtobufUtil.toTableName((HBaseProtos.TableName)request.getTableName()), request.getNonceGroup(), request.getNonce());
            return MasterProtos.DeleteTableResponse.newBuilder().setProcId(procId).build();
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    public MasterProtos.TruncateTableResponse truncateTable(RpcController controller, MasterProtos.TruncateTableRequest request) throws ServiceException {
        try {
            this.master.truncateTable(ProtobufUtil.toTableName((HBaseProtos.TableName)request.getTableName()), request.getPreserveSplits(), request.getNonceGroup(), request.getNonce());
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
        return MasterProtos.TruncateTableResponse.newBuilder().build();
    }

    public MasterProtos.DisableTableResponse disableTable(RpcController controller, MasterProtos.DisableTableRequest request) throws ServiceException {
        try {
            long procId = this.master.disableTable(ProtobufUtil.toTableName((HBaseProtos.TableName)request.getTableName()), request.getNonceGroup(), request.getNonce());
            return MasterProtos.DisableTableResponse.newBuilder().setProcId(procId).build();
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    public MasterProtos.DispatchMergingRegionsResponse dispatchMergingRegions(RpcController c, MasterProtos.DispatchMergingRegionsRequest request) throws ServiceException {
        try {
            this.master.checkInitialized();
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
        byte[] encodedNameOfRegionA = request.getRegionA().getValue().toByteArray();
        byte[] encodedNameOfRegionB = request.getRegionB().getValue().toByteArray();
        boolean forcible = request.getForcible();
        if (request.getRegionA().getType() != HBaseProtos.RegionSpecifier.RegionSpecifierType.ENCODED_REGION_NAME || request.getRegionB().getType() != HBaseProtos.RegionSpecifier.RegionSpecifierType.ENCODED_REGION_NAME) {
            LOG.warn((Object)("mergeRegions specifier type: expected: " + HBaseProtos.RegionSpecifier.RegionSpecifierType.ENCODED_REGION_NAME + " actual: region_a=" + request.getRegionA().getType() + ", region_b=" + request.getRegionB().getType()));
        }
        RegionStates regionStates = this.master.assignmentManager.getRegionStates();
        RegionState regionStateA = regionStates.getRegionState(Bytes.toString((byte[])encodedNameOfRegionA));
        RegionState regionStateB = regionStates.getRegionState(Bytes.toString((byte[])encodedNameOfRegionB));
        if (regionStateA == null || regionStateB == null) {
            throw new ServiceException((Throwable)new UnknownRegionException(Bytes.toStringBinary((byte[])(regionStateA == null ? encodedNameOfRegionA : encodedNameOfRegionB))));
        }
        if (!regionStateA.isOpened() || !regionStateB.isOpened()) {
            throw new ServiceException((Throwable)new MergeRegionException("Unable to merge regions not online " + regionStateA + ", " + regionStateB));
        }
        HRegionInfo regionInfoA = regionStateA.getRegion();
        HRegionInfo regionInfoB = regionStateB.getRegion();
        if (regionInfoA.getReplicaId() != 0 || regionInfoB.getReplicaId() != 0) {
            throw new ServiceException((Throwable)new MergeRegionException("Can't merge non-default replicas"));
        }
        if (regionInfoA.compareTo(regionInfoB) == 0) {
            throw new ServiceException((Throwable)new MergeRegionException("Unable to merge a region to itself " + regionInfoA + ", " + regionInfoB));
        }
        if (!forcible && !HRegionInfo.areAdjacent((HRegionInfo)regionInfoA, (HRegionInfo)regionInfoB)) {
            throw new ServiceException((Throwable)new MergeRegionException("Unable to merge not adjacent regions " + regionInfoA.getRegionNameAsString() + ", " + regionInfoB.getRegionNameAsString() + " where forcible = " + forcible));
        }
        try {
            this.master.dispatchMergingRegions(regionInfoA, regionInfoB, forcible);
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
        return MasterProtos.DispatchMergingRegionsResponse.newBuilder().build();
    }

    public MasterProtos.EnableCatalogJanitorResponse enableCatalogJanitor(RpcController c, MasterProtos.EnableCatalogJanitorRequest req) throws ServiceException {
        try {
            this.master.checkInitialized();
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
        return MasterProtos.EnableCatalogJanitorResponse.newBuilder().setPrevValue(this.master.catalogJanitorChore.setEnabled(req.getEnable())).build();
    }

    public MasterProtos.EnableTableResponse enableTable(RpcController controller, MasterProtos.EnableTableRequest request) throws ServiceException {
        try {
            long procId = this.master.enableTable(ProtobufUtil.toTableName((HBaseProtos.TableName)request.getTableName()), request.getNonceGroup(), request.getNonce());
            return MasterProtos.EnableTableResponse.newBuilder().setProcId(procId).build();
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    public ClientProtos.CoprocessorServiceResponse execMasterService(RpcController controller, ClientProtos.CoprocessorServiceRequest request) throws ServiceException {
        try {
            this.master.checkInitialized();
            ServerRpcController execController = new ServerRpcController();
            ClientProtos.CoprocessorServiceCall call = request.getCall();
            String serviceName = call.getServiceName();
            String methodName = call.getMethodName();
            if (!this.master.coprocessorServiceHandlers.containsKey(serviceName)) {
                throw new UnknownProtocolException(null, "No registered master coprocessor service found for name " + serviceName);
            }
            Service service = this.master.coprocessorServiceHandlers.get(serviceName);
            Descriptors.ServiceDescriptor serviceDesc = service.getDescriptorForType();
            Descriptors.MethodDescriptor methodDesc = serviceDesc.findMethodByName(methodName);
            if (methodDesc == null) {
                throw new UnknownProtocolException(service.getClass(), "Unknown method " + methodName + " called on master service " + serviceName);
            }
            Message.Builder builderForType = service.getRequestPrototype(methodDesc).newBuilderForType();
            ProtobufUtil.mergeFrom((Message.Builder)builderForType, (ByteString)call.getRequest());
            Message execRequest = builderForType.build();
            final Message.Builder responseBuilder = service.getResponsePrototype(methodDesc).newBuilderForType();
            service.callMethod(methodDesc, (RpcController)execController, execRequest, (RpcCallback)new RpcCallback<Message>(){

                public void run(Message message) {
                    if (message != null) {
                        responseBuilder.mergeFrom(message);
                    }
                }
            });
            Message execResult = responseBuilder.build();
            if (execController.getFailedOn() != null) {
                throw execController.getFailedOn();
            }
            ClientProtos.CoprocessorServiceResponse.Builder builder = ClientProtos.CoprocessorServiceResponse.newBuilder();
            builder.setRegion(RequestConverter.buildRegionSpecifier((HBaseProtos.RegionSpecifier.RegionSpecifierType)HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, (byte[])HConstants.EMPTY_BYTE_ARRAY));
            builder.setValue(builder.getValueBuilder().setName(execResult.getClass().getName()).setValue(execResult.toByteString()));
            return builder.build();
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
    }

    public MasterProtos.ExecProcedureResponse execProcedure(RpcController controller, MasterProtos.ExecProcedureRequest request) throws ServiceException {
        try {
            this.master.checkInitialized();
            HBaseProtos.ProcedureDescription desc = request.getProcedure();
            MasterProcedureManager mpm = this.master.mpmHost.getProcedureManager(desc.getSignature());
            if (mpm == null) {
                throw new ServiceException("The procedure is not registered: " + desc.getSignature());
            }
            LOG.info((Object)(this.master.getClientIdAuditPrefix() + " procedure request for: " + desc.getSignature()));
            mpm.execProcedure(desc);
            long waitTime = 300000L;
            return MasterProtos.ExecProcedureResponse.newBuilder().setExpectedTimeout(waitTime).build();
        }
        catch (ForeignException e) {
            throw new ServiceException(e.getCause());
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.ExecProcedureResponse execProcedureWithRet(RpcController controller, MasterProtos.ExecProcedureRequest request) throws ServiceException {
        try {
            this.master.checkInitialized();
            HBaseProtos.ProcedureDescription desc = request.getProcedure();
            MasterProcedureManager mpm = this.master.mpmHost.getProcedureManager(desc.getSignature());
            if (mpm == null) {
                throw new ServiceException("The procedure is not registered: " + desc.getSignature());
            }
            LOG.info((Object)(this.master.getClientIdAuditPrefix() + " procedure request for: " + desc.getSignature()));
            byte[] data = mpm.execProcedureWithRet(desc);
            MasterProtos.ExecProcedureResponse.Builder builder = MasterProtos.ExecProcedureResponse.newBuilder();
            if (data != null) {
                builder.setReturnData(ByteString.copyFrom((byte[])data));
            }
            return builder.build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.GetClusterStatusResponse getClusterStatus(RpcController controller, MasterProtos.GetClusterStatusRequest req) throws ServiceException {
        MasterProtos.GetClusterStatusResponse.Builder response = MasterProtos.GetClusterStatusResponse.newBuilder();
        try {
            this.master.checkInitialized();
            response.setClusterStatus(this.master.getClusterStatus().convert());
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return response.build();
    }

    public MasterProtos.GetCompletedSnapshotsResponse getCompletedSnapshots(RpcController controller, MasterProtos.GetCompletedSnapshotsRequest request) throws ServiceException {
        try {
            this.master.checkInitialized();
            MasterProtos.GetCompletedSnapshotsResponse.Builder builder = MasterProtos.GetCompletedSnapshotsResponse.newBuilder();
            List<HBaseProtos.SnapshotDescription> snapshots = this.master.snapshotManager.getCompletedSnapshots();
            for (HBaseProtos.SnapshotDescription snapshot : snapshots) {
                builder.addSnapshots(snapshot);
            }
            return builder.build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.GetNamespaceDescriptorResponse getNamespaceDescriptor(RpcController controller, MasterProtos.GetNamespaceDescriptorRequest request) throws ServiceException {
        try {
            return MasterProtos.GetNamespaceDescriptorResponse.newBuilder().setNamespaceDescriptor(ProtobufUtil.toProtoNamespaceDescriptor((NamespaceDescriptor)this.master.getNamespaceDescriptor(request.getNamespaceName()))).build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.GetSchemaAlterStatusResponse getSchemaAlterStatus(RpcController controller, MasterProtos.GetSchemaAlterStatusRequest req) throws ServiceException {
        TableName tableName = ProtobufUtil.toTableName((HBaseProtos.TableName)req.getTableName());
        try {
            this.master.checkInitialized();
            Pair<Integer, Integer> pair = this.master.assignmentManager.getReopenStatus(tableName);
            MasterProtos.GetSchemaAlterStatusResponse.Builder ret = MasterProtos.GetSchemaAlterStatusResponse.newBuilder();
            ret.setYetToUpdateRegions(((Integer)pair.getFirst()).intValue());
            ret.setTotalRegions(((Integer)pair.getSecond()).intValue());
            return ret.build();
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    public MasterProtos.GetTableDescriptorsResponse getTableDescriptors(RpcController c, MasterProtos.GetTableDescriptorsRequest req) throws ServiceException {
        try {
            this.master.checkInitialized();
            String regex = req.hasRegex() ? req.getRegex() : null;
            String namespace = req.hasNamespace() ? req.getNamespace() : null;
            ArrayList<TableName> tableNameList = null;
            if (req.getTableNamesCount() > 0) {
                tableNameList = new ArrayList<TableName>(req.getTableNamesCount());
                for (HBaseProtos.TableName tableNamePB : req.getTableNamesList()) {
                    tableNameList.add(ProtobufUtil.toTableName((HBaseProtos.TableName)tableNamePB));
                }
            }
            List<HTableDescriptor> descriptors = this.master.listTableDescriptors(namespace, regex, tableNameList, req.getIncludeSysTables());
            MasterProtos.GetTableDescriptorsResponse.Builder builder = MasterProtos.GetTableDescriptorsResponse.newBuilder();
            if (descriptors != null && descriptors.size() > 0) {
                for (HTableDescriptor htd : descriptors) {
                    builder.addTableSchema(htd.convert());
                }
            }
            return builder.build();
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    public MasterProtos.GetTableNamesResponse getTableNames(RpcController controller, MasterProtos.GetTableNamesRequest req) throws ServiceException {
        try {
            this.master.checkInitialized();
            String regex = req.hasRegex() ? req.getRegex() : null;
            String namespace = req.hasNamespace() ? req.getNamespace() : null;
            List<TableName> tableNames = this.master.listTableNames(namespace, regex, req.getIncludeSysTables());
            MasterProtos.GetTableNamesResponse.Builder builder = MasterProtos.GetTableNamesResponse.newBuilder();
            if (tableNames != null && tableNames.size() > 0) {
                for (TableName table : tableNames) {
                    builder.addTableNames(ProtobufUtil.toProtoTableName((TableName)table));
                }
            }
            return builder.build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.IsCatalogJanitorEnabledResponse isCatalogJanitorEnabled(RpcController c, MasterProtos.IsCatalogJanitorEnabledRequest req) throws ServiceException {
        return MasterProtos.IsCatalogJanitorEnabledResponse.newBuilder().setValue(this.master.isCatalogJanitorEnabled()).build();
    }

    public MasterProtos.IsMasterRunningResponse isMasterRunning(RpcController c, MasterProtos.IsMasterRunningRequest req) throws ServiceException {
        try {
            this.master.checkServiceStarted();
            return MasterProtos.IsMasterRunningResponse.newBuilder().setIsMasterRunning(!this.master.isStopped()).build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.IsProcedureDoneResponse isProcedureDone(RpcController controller, MasterProtos.IsProcedureDoneRequest request) throws ServiceException {
        try {
            this.master.checkInitialized();
            HBaseProtos.ProcedureDescription desc = request.getProcedure();
            MasterProcedureManager mpm = this.master.mpmHost.getProcedureManager(desc.getSignature());
            if (mpm == null) {
                throw new ServiceException("The procedure is not registered: " + desc.getSignature());
            }
            LOG.debug((Object)("Checking to see if procedure from request:" + desc.getSignature() + " is done"));
            MasterProtos.IsProcedureDoneResponse.Builder builder = MasterProtos.IsProcedureDoneResponse.newBuilder();
            boolean done = mpm.isProcedureDone(desc);
            builder.setDone(done);
            return builder.build();
        }
        catch (ForeignException e) {
            throw new ServiceException(e.getCause());
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.IsRestoreSnapshotDoneResponse isRestoreSnapshotDone(RpcController controller, MasterProtos.IsRestoreSnapshotDoneRequest request) throws ServiceException {
        try {
            this.master.checkInitialized();
            HBaseProtos.SnapshotDescription snapshot = request.getSnapshot();
            MasterProtos.IsRestoreSnapshotDoneResponse.Builder builder = MasterProtos.IsRestoreSnapshotDoneResponse.newBuilder();
            boolean done = this.master.snapshotManager.isRestoreDone(snapshot);
            builder.setDone(done);
            return builder.build();
        }
        catch (ForeignException e) {
            throw new ServiceException(e.getCause());
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.IsSnapshotDoneResponse isSnapshotDone(RpcController controller, MasterProtos.IsSnapshotDoneRequest request) throws ServiceException {
        LOG.debug((Object)("Checking to see if snapshot from request:" + ClientSnapshotDescriptionUtils.toString((HBaseProtos.SnapshotDescription)request.getSnapshot()) + " is done"));
        try {
            this.master.checkInitialized();
            MasterProtos.IsSnapshotDoneResponse.Builder builder = MasterProtos.IsSnapshotDoneResponse.newBuilder();
            boolean done = this.master.snapshotManager.isSnapshotDone(request.getSnapshot());
            builder.setDone(done);
            return builder.build();
        }
        catch (ForeignException e) {
            throw new ServiceException(e.getCause());
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.GetProcedureResultResponse getProcedureResult(RpcController controller, MasterProtos.GetProcedureResultRequest request) throws ServiceException {
        LOG.debug((Object)("Checking to see if procedure is done procId=" + request.getProcId()));
        try {
            this.master.checkInitialized();
            MasterProtos.GetProcedureResultResponse.Builder builder = MasterProtos.GetProcedureResultResponse.newBuilder();
            Pair v = this.master.getMasterProcedureExecutor().getResultOrProcedure(request.getProcId());
            if (v.getFirst() != null) {
                ProcedureInfo result = (ProcedureInfo)v.getFirst();
                builder.setState(MasterProtos.GetProcedureResultResponse.State.FINISHED);
                builder.setStartTime(result.getStartTime());
                builder.setLastUpdate(result.getLastUpdate());
                if (result.isFailed()) {
                    builder.setException(result.getForeignExceptionMessage());
                }
                if (result.hasResultData()) {
                    builder.setResult(ByteStringer.wrap((byte[])result.getResult()));
                }
                this.master.getMasterProcedureExecutor().removeResult(request.getProcId());
            } else {
                Procedure proc = (Procedure)v.getSecond();
                if (proc == null) {
                    builder.setState(MasterProtos.GetProcedureResultResponse.State.NOT_FOUND);
                } else {
                    builder.setState(MasterProtos.GetProcedureResultResponse.State.RUNNING);
                    builder.setStartTime(proc.getStartTime());
                    builder.setLastUpdate(proc.getLastUpdate());
                }
            }
            return builder.build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.AbortProcedureResponse abortProcedure(RpcController rpcController, MasterProtos.AbortProcedureRequest request) throws ServiceException {
        try {
            MasterProtos.AbortProcedureResponse.Builder response = MasterProtos.AbortProcedureResponse.newBuilder();
            boolean abortResult = this.master.abortProcedure(request.getProcId(), request.getMayInterruptIfRunning());
            response.setIsProcedureAborted(abortResult);
            return response.build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.ListProceduresResponse listProcedures(RpcController rpcController, MasterProtos.ListProceduresRequest request) throws ServiceException {
        try {
            MasterProtos.ListProceduresResponse.Builder response = MasterProtos.ListProceduresResponse.newBuilder();
            for (ProcedureInfo p : this.master.listProcedures()) {
                response.addProcedure(ProcedureInfo.convertToProcedureProto((ProcedureInfo)p));
            }
            return response.build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.ListNamespaceDescriptorsResponse listNamespaceDescriptors(RpcController c, MasterProtos.ListNamespaceDescriptorsRequest request) throws ServiceException {
        try {
            MasterProtos.ListNamespaceDescriptorsResponse.Builder response = MasterProtos.ListNamespaceDescriptorsResponse.newBuilder();
            for (NamespaceDescriptor ns : this.master.listNamespaceDescriptors()) {
                response.addNamespaceDescriptor(ProtobufUtil.toProtoNamespaceDescriptor((NamespaceDescriptor)ns));
            }
            return response.build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.ListTableDescriptorsByNamespaceResponse listTableDescriptorsByNamespace(RpcController c, MasterProtos.ListTableDescriptorsByNamespaceRequest request) throws ServiceException {
        try {
            MasterProtos.ListTableDescriptorsByNamespaceResponse.Builder b = MasterProtos.ListTableDescriptorsByNamespaceResponse.newBuilder();
            for (HTableDescriptor htd : this.master.listTableDescriptorsByNamespace(request.getNamespaceName())) {
                b.addTableSchema(htd.convert());
            }
            return b.build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.ListTableNamesByNamespaceResponse listTableNamesByNamespace(RpcController c, MasterProtos.ListTableNamesByNamespaceRequest request) throws ServiceException {
        try {
            MasterProtos.ListTableNamesByNamespaceResponse.Builder b = MasterProtos.ListTableNamesByNamespaceResponse.newBuilder();
            for (TableName tableName : this.master.listTableNamesByNamespace(request.getNamespaceName())) {
                b.addTableName(ProtobufUtil.toProtoTableName((TableName)tableName));
            }
            return b.build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.ModifyColumnResponse modifyColumn(RpcController controller, MasterProtos.ModifyColumnRequest req) throws ServiceException {
        try {
            this.master.modifyColumn(ProtobufUtil.toTableName((HBaseProtos.TableName)req.getTableName()), HColumnDescriptor.convert((HBaseProtos.ColumnFamilySchema)req.getColumnFamilies()), req.getNonceGroup(), req.getNonce());
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
        return MasterProtos.ModifyColumnResponse.newBuilder().build();
    }

    public MasterProtos.ModifyNamespaceResponse modifyNamespace(RpcController controller, MasterProtos.ModifyNamespaceRequest request) throws ServiceException {
        try {
            this.master.modifyNamespace(ProtobufUtil.toNamespaceDescriptor((HBaseProtos.NamespaceDescriptor)request.getNamespaceDescriptor()));
            return MasterProtos.ModifyNamespaceResponse.getDefaultInstance();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.ModifyTableResponse modifyTable(RpcController controller, MasterProtos.ModifyTableRequest req) throws ServiceException {
        try {
            this.master.modifyTable(ProtobufUtil.toTableName((HBaseProtos.TableName)req.getTableName()), HTableDescriptor.convert((HBaseProtos.TableSchema)req.getTableSchema()), req.getNonceGroup(), req.getNonce());
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
        return MasterProtos.ModifyTableResponse.newBuilder().build();
    }

    public MasterProtos.MoveRegionResponse moveRegion(RpcController controller, MasterProtos.MoveRegionRequest req) throws ServiceException {
        byte[] encodedRegionName = req.getRegion().getValue().toByteArray();
        HBaseProtos.RegionSpecifier.RegionSpecifierType type = req.getRegion().getType();
        byte[] destServerName = req.hasDestServerName() ? Bytes.toBytes((String)ProtobufUtil.toServerName((HBaseProtos.ServerName)req.getDestServerName()).getServerName()) : null;
        MasterProtos.MoveRegionResponse mrr = MasterProtos.MoveRegionResponse.newBuilder().build();
        if (type != HBaseProtos.RegionSpecifier.RegionSpecifierType.ENCODED_REGION_NAME) {
            LOG.warn((Object)("moveRegion specifier type: expected: " + HBaseProtos.RegionSpecifier.RegionSpecifierType.ENCODED_REGION_NAME + " actual: " + type));
        }
        try {
            this.master.checkInitialized();
            this.master.move(encodedRegionName, destServerName);
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
        return mrr;
    }

    public MasterProtos.OfflineRegionResponse offlineRegion(RpcController controller, MasterProtos.OfflineRegionRequest request) throws ServiceException {
        byte[] regionName = request.getRegion().getValue().toByteArray();
        HBaseProtos.RegionSpecifier.RegionSpecifierType type = request.getRegion().getType();
        if (type != HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME) {
            LOG.warn((Object)("moveRegion specifier type: expected: " + HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME + " actual: " + type));
        }
        try {
            this.master.checkInitialized();
            Pair pair = MetaTableAccessor.getRegion((Connection)this.master.getConnection(), (byte[])regionName);
            if (pair == null) {
                throw new UnknownRegionException(Bytes.toStringBinary((byte[])regionName));
            }
            HRegionInfo hri = (HRegionInfo)pair.getFirst();
            if (this.master.cpHost != null) {
                this.master.cpHost.preRegionOffline(hri);
            }
            LOG.info((Object)(this.master.getClientIdAuditPrefix() + " offline " + hri.getRegionNameAsString()));
            this.master.assignmentManager.regionOffline(hri);
            if (this.master.cpHost != null) {
                this.master.cpHost.postRegionOffline(hri);
            }
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
        return MasterProtos.OfflineRegionResponse.newBuilder().build();
    }

    public MasterProtos.RestoreSnapshotResponse restoreSnapshot(RpcController controller, MasterProtos.RestoreSnapshotRequest request) throws ServiceException {
        try {
            this.master.checkInitialized();
            this.master.snapshotManager.checkSnapshotSupport();
            TableName dstTable = TableName.valueOf((String)request.getSnapshot().getTable());
            this.master.getNamespaceDescriptor(dstTable.getNamespaceAsString());
            HBaseProtos.SnapshotDescription reqSnapshot = request.getSnapshot();
            this.master.snapshotManager.restoreSnapshot(reqSnapshot);
            return MasterProtos.RestoreSnapshotResponse.newBuilder().build();
        }
        catch (ForeignException e) {
            throw new ServiceException(e.getCause());
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.RunCatalogScanResponse runCatalogScan(RpcController c, MasterProtos.RunCatalogScanRequest req) throws ServiceException {
        try {
            this.master.checkInitialized();
            return ResponseConverter.buildRunCatalogScanResponse((int)this.master.catalogJanitorChore.scan());
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    public MasterProtos.SetBalancerRunningResponse setBalancerRunning(RpcController c, MasterProtos.SetBalancerRunningRequest req) throws ServiceException {
        try {
            this.master.checkInitialized();
            boolean prevValue = req.getSynchronous() ? this.synchronousBalanceSwitch(req.getOn()) : this.master.balanceSwitch(req.getOn());
            return MasterProtos.SetBalancerRunningResponse.newBuilder().setPrevBalanceValue(prevValue).build();
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    public MasterProtos.ShutdownResponse shutdown(RpcController controller, MasterProtos.ShutdownRequest request) throws ServiceException {
        LOG.info((Object)(this.master.getClientIdAuditPrefix() + " shutdown"));
        this.master.shutdown();
        return MasterProtos.ShutdownResponse.newBuilder().build();
    }

    public MasterProtos.SnapshotResponse snapshot(RpcController controller, MasterProtos.SnapshotRequest request) throws ServiceException {
        try {
            this.master.checkInitialized();
            this.master.snapshotManager.checkSnapshotSupport();
            LOG.info((Object)(this.master.getClientIdAuditPrefix() + " snapshot request for:" + ClientSnapshotDescriptionUtils.toString((HBaseProtos.SnapshotDescription)request.getSnapshot())));
            HBaseProtos.SnapshotDescription snapshot = SnapshotDescriptionUtils.validate(request.getSnapshot(), this.master.getConfiguration());
            this.master.snapshotManager.takeSnapshot(snapshot);
            long waitTime = SnapshotDescriptionUtils.getMaxMasterTimeout(this.master.getConfiguration(), snapshot.getType(), 300000L);
            return MasterProtos.SnapshotResponse.newBuilder().setExpectedTimeout(waitTime).build();
        }
        catch (ForeignException e) {
            throw new ServiceException(e.getCause());
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.StopMasterResponse stopMaster(RpcController controller, MasterProtos.StopMasterRequest request) throws ServiceException {
        LOG.info((Object)(this.master.getClientIdAuditPrefix() + " stop"));
        this.master.stopMaster();
        return MasterProtos.StopMasterResponse.newBuilder().build();
    }

    public MasterProtos.UnassignRegionResponse unassignRegion(RpcController controller, MasterProtos.UnassignRegionRequest req) throws ServiceException {
        try {
            Pair pair;
            byte[] regionName = req.getRegion().getValue().toByteArray();
            HBaseProtos.RegionSpecifier.RegionSpecifierType type = req.getRegion().getType();
            boolean force = req.getForce();
            MasterProtos.UnassignRegionResponse urr = MasterProtos.UnassignRegionResponse.newBuilder().build();
            this.master.checkInitialized();
            if (type != HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME) {
                LOG.warn((Object)("unassignRegion specifier type: expected: " + HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME + " actual: " + type));
            }
            if ((pair = MetaTableAccessor.getRegion((Connection)this.master.getConnection(), (byte[])regionName)) == null) {
                throw new UnknownRegionException(Bytes.toString((byte[])regionName));
            }
            HRegionInfo hri = (HRegionInfo)pair.getFirst();
            if (this.master.cpHost != null && this.master.cpHost.preUnassign(hri, force)) {
                return urr;
            }
            LOG.debug((Object)(this.master.getClientIdAuditPrefix() + " unassign " + hri.getRegionNameAsString() + " in current location if it is online and reassign.force=" + force));
            this.master.assignmentManager.unassign(hri, force);
            if (this.master.assignmentManager.getRegionStates().isRegionOffline(hri)) {
                LOG.debug((Object)("Region " + hri.getRegionNameAsString() + " is not online on any region server, reassigning it."));
                this.master.assignRegion(hri);
            }
            if (this.master.cpHost != null) {
                this.master.cpHost.postUnassign(hri, force);
            }
            return urr;
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    public RegionServerStatusProtos.ReportRegionStateTransitionResponse reportRegionStateTransition(RpcController c, RegionServerStatusProtos.ReportRegionStateTransitionRequest req) throws ServiceException {
        try {
            this.master.checkServiceStarted();
            RegionServerStatusProtos.RegionStateTransition rt = req.getTransition(0);
            TableName tableName = ProtobufUtil.toTableName((HBaseProtos.TableName)rt.getRegionInfo(0).getTableName());
            RegionStates regionStates = this.master.assignmentManager.getRegionStates();
            if (!(TableName.META_TABLE_NAME.equals((Object)tableName) && regionStates.getRegionState(HRegionInfo.FIRST_META_REGIONINFO) != null || this.master.assignmentManager.isFailoverCleanupDone())) {
                throw new PleaseHoldException("Master is rebuilding user regions");
            }
            ServerName sn = ProtobufUtil.toServerName((HBaseProtos.ServerName)req.getServer());
            String error = this.master.assignmentManager.onRegionTransition(sn, rt);
            RegionServerStatusProtos.ReportRegionStateTransitionResponse.Builder rrtr = RegionServerStatusProtos.ReportRegionStateTransitionResponse.newBuilder();
            if (error != null) {
                rrtr.setErrorMessage(error);
            }
            return rrtr.build();
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    public MasterProtos.MajorCompactionTimestampResponse getLastMajorCompactionTimestamp(RpcController controller, MasterProtos.MajorCompactionTimestampRequest request) throws ServiceException {
        MasterProtos.MajorCompactionTimestampResponse.Builder response = MasterProtos.MajorCompactionTimestampResponse.newBuilder();
        try {
            this.master.checkInitialized();
            response.setCompactionTimestamp(this.master.getLastMajorCompactionTimestamp(ProtobufUtil.toTableName((HBaseProtos.TableName)request.getTableName())));
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return response.build();
    }

    public MasterProtos.MajorCompactionTimestampResponse getLastMajorCompactionTimestampForRegion(RpcController controller, MasterProtos.MajorCompactionTimestampForRegionRequest request) throws ServiceException {
        MasterProtos.MajorCompactionTimestampResponse.Builder response = MasterProtos.MajorCompactionTimestampResponse.newBuilder();
        try {
            this.master.checkInitialized();
            response.setCompactionTimestamp(this.master.getLastMajorCompactionTimestampForRegion(request.getRegion().getValue().toByteArray()));
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return response.build();
    }

    public MasterProtos.IsBalancerEnabledResponse isBalancerEnabled(RpcController controller, MasterProtos.IsBalancerEnabledRequest request) throws ServiceException {
        MasterProtos.IsBalancerEnabledResponse.Builder response = MasterProtos.IsBalancerEnabledResponse.newBuilder();
        response.setEnabled(this.master.isBalancerOn());
        return response.build();
    }

    public MasterProtos.NormalizeResponse normalize(RpcController controller, MasterProtos.NormalizeRequest request) throws ServiceException {
        try {
            return MasterProtos.NormalizeResponse.newBuilder().setNormalizerRan(this.master.normalizeRegions()).build();
        }
        catch (IOException | CoordinatedStateException ex) {
            throw new ServiceException(ex);
        }
    }

    public MasterProtos.SetNormalizerRunningResponse setNormalizerRunning(RpcController controller, MasterProtos.SetNormalizerRunningRequest request) throws ServiceException {
        try {
            this.master.checkInitialized();
            boolean prevValue = this.normalizerSwitch(request.getOn());
            return MasterProtos.SetNormalizerRunningResponse.newBuilder().setPrevNormalizerValue(prevValue).build();
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    public MasterProtos.IsNormalizerEnabledResponse isNormalizerEnabled(RpcController controller, MasterProtos.IsNormalizerEnabledRequest request) throws ServiceException {
        MasterProtos.IsNormalizerEnabledResponse.Builder response = MasterProtos.IsNormalizerEnabledResponse.newBuilder();
        response.setEnabled(this.master.isNormalizerOn());
        return response.build();
    }

    public MasterProtos.SetQuotaResponse setQuota(RpcController c, MasterProtos.SetQuotaRequest req) throws ServiceException {
        try {
            this.master.checkInitialized();
            return this.master.getMasterQuotaManager().setQuota(req);
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.SecurityCapabilitiesResponse getSecurityCapabilities(RpcController controller, MasterProtos.SecurityCapabilitiesRequest request) throws ServiceException {
        MasterProtos.SecurityCapabilitiesResponse.Builder response = MasterProtos.SecurityCapabilitiesResponse.newBuilder();
        try {
            this.master.checkInitialized();
            HashSet<MasterProtos.SecurityCapabilitiesResponse.Capability> capabilities = new HashSet<MasterProtos.SecurityCapabilitiesResponse.Capability>();
            if (User.isHBaseSecurityEnabled((Configuration)this.master.getConfiguration())) {
                capabilities.add(MasterProtos.SecurityCapabilitiesResponse.Capability.SECURE_AUTHENTICATION);
            } else {
                capabilities.add(MasterProtos.SecurityCapabilitiesResponse.Capability.SIMPLE_AUTHENTICATION);
            }
            if (this.master.cpHost != null && this.master.cpHost.findCoprocessor(AccessController.class.getName()) != null) {
                if (AccessController.isAuthorizationSupported(this.master.getConfiguration())) {
                    capabilities.add(MasterProtos.SecurityCapabilitiesResponse.Capability.AUTHORIZATION);
                }
                if (AccessController.isCellAuthorizationSupported(this.master.getConfiguration())) {
                    capabilities.add(MasterProtos.SecurityCapabilitiesResponse.Capability.CELL_AUTHORIZATION);
                }
            }
            if (this.master.cpHost != null && this.master.cpHost.findCoprocessor(VisibilityController.class.getName()) != null && VisibilityController.isCellAuthorizationSupported(this.master.getConfiguration())) {
                capabilities.add(MasterProtos.SecurityCapabilitiesResponse.Capability.CELL_VISIBILITY);
            }
            response.addAllCapabilities(capabilities);
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return response.build();
    }

    static enum BalanceSwitchMode {
        SYNC,
        ASYNC;

    }
}

