/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.quotas.RateLimiter;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class AverageIntervalRateLimiter
extends RateLimiter {
    private long nextRefillTime = -1L;

    @Override
    public long refill(long limit) {
        long now = EnvironmentEdgeManager.currentTime();
        if (this.nextRefillTime == -1L) {
            this.nextRefillTime = EnvironmentEdgeManager.currentTime();
            return limit;
        }
        long delta = limit * (now - this.nextRefillTime) / super.getTimeUnitInMillis();
        if (delta > 0L) {
            this.nextRefillTime = now;
            return Math.min(limit, delta);
        }
        return 0L;
    }

    @Override
    public long getWaitInterval(long limit, long available, long amount) {
        if (this.nextRefillTime == -1L) {
            return 0L;
        }
        long timeUnitInMillis = super.getTimeUnitInMillis();
        return amount * timeUnitInMillis / limit - available * timeUnitInMillis / limit;
    }

    @Override
    @VisibleForTesting
    public void setNextRefillTime(long nextRefillTime) {
        this.nextRefillTime = nextRefillTime;
    }

    @Override
    @VisibleForTesting
    public long getNextRefillTime() {
        return this.nextRefillTime;
    }
}

