/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.HFileOutputFormat2;
import org.apache.hadoop.hbase.mapreduce.KeyValueSortReducer;
import org.apache.hadoop.hbase.mapreduce.MultiTableOutputFormat;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.WALInputFormat;
import org.apache.hadoop.hbase.regionserver.wal.WALCellCodec;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class WALPlayer
extends Configured
implements Tool {
    private static final Log LOG = LogFactory.getLog(WALPlayer.class);
    static final String NAME = "WALPlayer";
    static final String BULK_OUTPUT_CONF_KEY = "wal.bulk.output";
    static final String TABLES_KEY = "wal.input.tables";
    static final String TABLE_MAP_KEY = "wal.input.tablesmap";

    public WALPlayer(Configuration conf) {
        super(conf);
    }

    void setupTime(Configuration conf, String option) throws IOException {
        long ms;
        String val = conf.get(option);
        if (null == val) {
            return;
        }
        try {
            ms = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SS").parse(val).getTime();
        }
        catch (ParseException pe) {
            try {
                ms = Long.parseLong(val);
            }
            catch (NumberFormatException nfe) {
                throw new IOException(option + " must be specified either in the form 2001-02-20T16:35:06.99 " + "or as number of milliseconds");
            }
        }
        conf.setLong(option, ms);
    }

    public Job createSubmittableJob(String[] args) throws IOException {
        String[] tableMap;
        Configuration conf = this.getConf();
        this.setupTime(conf, "hlog.start.time");
        this.setupTime(conf, "hlog.end.time");
        Path inputDir = new Path(args[0]);
        String[] tables = args[1].split(",");
        if (args.length > 2) {
            tableMap = args[2].split(",");
            if (tableMap.length != tables.length) {
                throw new IOException("The same number of tables and mapping must be provided.");
            }
        } else {
            tableMap = tables;
        }
        conf.setStrings(TABLES_KEY, tables);
        conf.setStrings(TABLE_MAP_KEY, tableMap);
        Job job = new Job(conf, "WALPlayer_" + inputDir);
        job.setJarByClass(WALPlayer.class);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{inputDir});
        job.setInputFormatClass(WALInputFormat.class);
        job.setMapOutputKeyClass(ImmutableBytesWritable.class);
        String hfileOutPath = conf.get(BULK_OUTPUT_CONF_KEY);
        if (hfileOutPath != null) {
            if (tables.length != 1) {
                throw new IOException("Exactly one table must be specified for the bulk export option");
            }
            TableName tableName = TableName.valueOf((String)tables[0]);
            job.setMapperClass(WALKeyValueMapper.class);
            job.setReducerClass(KeyValueSortReducer.class);
            Path outputDir = new Path(hfileOutPath);
            FileOutputFormat.setOutputPath((Job)job, (Path)outputDir);
            job.setMapOutputValueClass(KeyValue.class);
            try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);
                 Table table = conn.getTable(tableName);
                 RegionLocator regionLocator = conn.getRegionLocator(tableName);){
                HFileOutputFormat2.configureIncrementalLoad(job, table.getTableDescriptor(), regionLocator);
            }
            TableMapReduceUtil.addDependencyJars(job.getConfiguration(), Preconditions.class);
        } else {
            job.setMapperClass(WALMapper.class);
            job.setOutputFormatClass(MultiTableOutputFormat.class);
            TableMapReduceUtil.addDependencyJars(job);
            TableMapReduceUtil.initCredentials(job);
            job.setNumReduceTasks(0);
        }
        String codecCls = WALCellCodec.getWALCellCodecClass(conf).getName();
        try {
            TableMapReduceUtil.addDependencyJars(conf, Class.forName(codecCls));
        }
        catch (Exception e) {
            throw new IOException("Cannot determine wal codec class " + codecCls, e);
        }
        return job;
    }

    private void usage(String errorMsg) {
        if (errorMsg != null && errorMsg.length() > 0) {
            System.err.println("ERROR: " + errorMsg);
        }
        System.err.println("Usage: WALPlayer [options] <wal inputdir> <tables> [<tableMappings>]");
        System.err.println("Read all WAL entries for <tables>.");
        System.err.println("If no tables (\"\") are specific, all tables are imported.");
        System.err.println("(Careful, even -ROOT- and hbase:meta entries will be imported in that case.)");
        System.err.println("Otherwise <tables> is a comma separated list of tables.\n");
        System.err.println("The WAL entries can be mapped to new set of tables via <tableMapping>.");
        System.err.println("<tableMapping> is a command separated list of targettables.");
        System.err.println("If specified, each table in <tables> must have a mapping.\n");
        System.err.println("By default WALPlayer will load data directly into HBase.");
        System.err.println("To generate HFiles for a bulk data load instead, pass the option:");
        System.err.println("  -Dwal.bulk.output=/path/for/output");
        System.err.println("  (Only one table can be specified, and no mapping is allowed!)");
        System.err.println("Other options: (specify time range to WAL edit to consider)");
        System.err.println("  -Dwal.start.time=[date|ms]");
        System.err.println("  -Dwal.end.time=[date|ms]");
        System.err.println("For performance also consider the following options:\n  -Dmapreduce.map.speculative=false\n  -Dmapreduce.reduce.speculative=false");
    }

    public static void main(String[] args) throws Exception {
        int ret = ToolRunner.run((Tool)new WALPlayer(HBaseConfiguration.create()), (String[])args);
        System.exit(ret);
    }

    public int run(String[] args) throws Exception {
        Job job;
        String[] otherArgs = new GenericOptionsParser(this.getConf(), args).getRemainingArgs();
        if (otherArgs.length < 2) {
            this.usage("Wrong number of arguments: " + otherArgs.length);
            System.exit(-1);
        }
        return (job = this.createSubmittableJob(otherArgs)).waitForCompletion(true) ? 0 : 1;
    }

    static {
        Configuration.addDeprecation((String)"hlog.bulk.output", (String)BULK_OUTPUT_CONF_KEY);
        Configuration.addDeprecation((String)"hlog.input.tables", (String)TABLES_KEY);
        Configuration.addDeprecation((String)"hlog.input.tablesmap", (String)TABLE_MAP_KEY);
        Configuration.addDeprecation((String)"hlog.start.time", (String)"wal.start.time");
        Configuration.addDeprecation((String)"hlog.end.time", (String)"wal.end.time");
    }

    protected static class WALMapper
    extends Mapper<WALKey, WALEdit, ImmutableBytesWritable, Mutation> {
        private Map<TableName, TableName> tables = new TreeMap<TableName, TableName>();

        protected WALMapper() {
        }

        public void map(WALKey key, WALEdit value, Mapper.Context context) throws IOException {
            try {
                if (this.tables.isEmpty() || this.tables.containsKey(key.getTablename())) {
                    TableName targetTable = this.tables.isEmpty() ? key.getTablename() : this.tables.get(key.getTablename());
                    ImmutableBytesWritable tableOut = new ImmutableBytesWritable(targetTable.getName());
                    Put put = null;
                    Delete del = null;
                    Cell lastCell = null;
                    for (Cell cell : value.getCells()) {
                        if (WALEdit.isMetaEditFamily(cell.getFamily())) continue;
                        if (this.filter(context, cell)) {
                            if (lastCell == null || lastCell.getTypeByte() != cell.getTypeByte() || !CellUtil.matchingRow((Cell)lastCell, (Cell)cell)) {
                                if (put != null) {
                                    context.write((Object)tableOut, put);
                                }
                                if (del != null) {
                                    context.write((Object)tableOut, del);
                                }
                                if (CellUtil.isDelete((Cell)cell)) {
                                    del = new Delete(cell.getRow());
                                } else {
                                    put = new Put(cell.getRow());
                                }
                            }
                            if (CellUtil.isDelete((Cell)cell)) {
                                del.addDeleteMarker(cell);
                            } else {
                                put.add(cell);
                            }
                        }
                        lastCell = cell;
                    }
                    if (put != null) {
                        context.write((Object)tableOut, put);
                    }
                    if (del != null) {
                        context.write((Object)tableOut, del);
                    }
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        protected boolean filter(Mapper.Context context, Cell cell) {
            return true;
        }

        public void setup(Mapper.Context context) throws IOException {
            String[] tableMap = context.getConfiguration().getStrings(WALPlayer.TABLE_MAP_KEY);
            String[] tablesToUse = context.getConfiguration().getStrings(WALPlayer.TABLES_KEY);
            if (!(tablesToUse == null && tableMap == null || tablesToUse != null && tableMap != null && tablesToUse.length == tableMap.length)) {
                throw new IOException("No tables or incorrect table mapping specified.");
            }
            int i = 0;
            if (tablesToUse != null) {
                for (String table : tablesToUse) {
                    this.tables.put(TableName.valueOf((String)table), TableName.valueOf((String)tableMap[i++]));
                }
            }
        }
    }

    static class WALKeyValueMapper
    extends Mapper<WALKey, WALEdit, ImmutableBytesWritable, KeyValue> {
        private byte[] table;

        WALKeyValueMapper() {
        }

        public void map(WALKey key, WALEdit value, Mapper.Context context) throws IOException {
            try {
                if (Bytes.equals((byte[])this.table, (byte[])key.getTablename().getName())) {
                    for (Cell cell : value.getCells()) {
                        KeyValue kv = KeyValueUtil.ensureKeyValueTypeForMR((Cell)cell);
                        if (WALEdit.isMetaEditFamily(kv.getFamily())) continue;
                        context.write((Object)new ImmutableBytesWritable(kv.getRow()), (Object)kv);
                    }
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        public void setup(Mapper.Context context) throws IOException {
            String[] tables = context.getConfiguration().getStrings(WALPlayer.TABLES_KEY);
            if (tables == null || tables.length != 1) {
                throw new IOException("Exactly one table must be specified for bulk HFile case.");
            }
            this.table = Bytes.toBytes((String)tables[0]);
        }
    }
}

