/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.encoding;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.CategoryBasedTimeout;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.io.ByteArrayOutputStream;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoder;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDefaultEncodingContext;
import org.apache.hadoop.hbase.io.encoding.HFileBlockEncodingContext;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.RedundantKVGenerator;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={LargeTests.class})
@RunWith(value=Parameterized.class)
public class TestDataBlockEncoders {
    private static final Log LOG = LogFactory.getLog(TestDataBlockEncoders.class);
    @Rule
    public final TestRule timeout = CategoryBasedTimeout.builder().withTimeout(this.getClass()).withLookingForStuckThread(true).build();
    private static int NUMBER_OF_KV = 10000;
    private static int NUM_RANDOM_SEEKS = 1000;
    private static int ENCODED_DATA_OFFSET = 35;
    static final byte[] HFILEBLOCK_DUMMY_HEADER = new byte[33];
    private RedundantKVGenerator generator = new RedundantKVGenerator();
    private Random randomizer = new Random(42L);
    private final boolean includesMemstoreTS;
    private final boolean includesTags;

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return HBaseTestingUtility.MEMSTORETS_TAGS_PARAMETRIZED;
    }

    public TestDataBlockEncoders(boolean includesMemstoreTS, boolean includesTag) {
        this.includesMemstoreTS = includesMemstoreTS;
        this.includesTags = includesTag;
    }

    private HFileBlockEncodingContext getEncodingContext(Compression.Algorithm algo, DataBlockEncoding encoding) {
        DataBlockEncoder encoder = encoding.getEncoder();
        HFileContext meta = new HFileContextBuilder().withHBaseCheckSum(false).withIncludesMvcc(this.includesMemstoreTS).withIncludesTags(this.includesTags).withCompression(algo).build();
        if (encoder != null) {
            return encoder.newDataBlockEncodingContext(encoding, HFILEBLOCK_DUMMY_HEADER, meta);
        }
        return new HFileBlockDefaultEncodingContext(encoding, HFILEBLOCK_DUMMY_HEADER, meta);
    }

    @Test
    public void testEmptyKeyValues() throws IOException {
        ArrayList<KeyValue> kvList = new ArrayList<KeyValue>();
        byte[] row = new byte[]{};
        byte[] family = new byte[]{};
        byte[] qualifier = new byte[]{};
        byte[] value = new byte[]{};
        if (!this.includesTags) {
            kvList.add(new KeyValue(row, family, qualifier, 0L, value));
            kvList.add(new KeyValue(row, family, qualifier, 0L, value));
        } else {
            byte[] metaValue1 = Bytes.toBytes((String)"metaValue1");
            byte[] metaValue2 = Bytes.toBytes((String)"metaValue2");
            kvList.add(new KeyValue(row, family, qualifier, 0L, value, new Tag[]{new Tag(1, metaValue1)}));
            kvList.add(new KeyValue(row, family, qualifier, 0L, value, new Tag[]{new Tag(1, metaValue2)}));
        }
        this.testEncodersOnDataset(kvList, this.includesMemstoreTS, this.includesTags);
    }

    @Test
    public void testNegativeTimestamps() throws IOException {
        ArrayList<KeyValue> kvList = new ArrayList<KeyValue>();
        byte[] row = new byte[]{};
        byte[] family = new byte[]{};
        byte[] qualifier = new byte[]{};
        byte[] value = new byte[]{};
        if (this.includesTags) {
            byte[] metaValue1 = Bytes.toBytes((String)"metaValue1");
            byte[] metaValue2 = Bytes.toBytes((String)"metaValue2");
            kvList.add(new KeyValue(row, family, qualifier, 0L, value, new Tag[]{new Tag(1, metaValue1)}));
            kvList.add(new KeyValue(row, family, qualifier, 0L, value, new Tag[]{new Tag(1, metaValue2)}));
        } else {
            kvList.add(new KeyValue(row, family, qualifier, -1L, KeyValue.Type.Put, value));
            kvList.add(new KeyValue(row, family, qualifier, -2L, KeyValue.Type.Put, value));
        }
        this.testEncodersOnDataset(kvList, this.includesMemstoreTS, this.includesTags);
    }

    @Test
    public void testExecutionOnSample() throws IOException {
        List kvList = this.generator.generateTestKeyValues(NUMBER_OF_KV, this.includesTags);
        this.testEncodersOnDataset(kvList, this.includesMemstoreTS, this.includesTags);
    }

    @Test
    public void testSeekingOnSample() throws IOException {
        List sampleKv = this.generator.generateTestKeyValues(NUMBER_OF_KV, this.includesTags);
        ArrayList<DataBlockEncoder.EncodedSeeker> encodedSeekers = new ArrayList<DataBlockEncoder.EncodedSeeker>();
        for (DataBlockEncoding encoding : DataBlockEncoding.values()) {
            DataBlockEncoder encoder;
            LOG.info((Object)("Encoding: " + encoding));
            if (encoding == DataBlockEncoding.PREFIX_TREE || (encoder = encoding.getEncoder()) == null) continue;
            LOG.info((Object)("Encoder: " + encoder));
            ByteBuffer encodedBuffer = TestDataBlockEncoders.encodeKeyValues(encoding, sampleKv, this.getEncodingContext(Compression.Algorithm.NONE, encoding));
            HFileContext meta = new HFileContextBuilder().withHBaseCheckSum(false).withIncludesMvcc(this.includesMemstoreTS).withIncludesTags(this.includesTags).withCompression(Compression.Algorithm.NONE).build();
            DataBlockEncoder.EncodedSeeker seeker = encoder.createSeeker(KeyValue.COMPARATOR, encoder.newDataBlockDecodingContext(meta));
            seeker.setCurrentBuffer(encodedBuffer);
            encodedSeekers.add(seeker);
        }
        LOG.info((Object)"Testing it!");
        for (boolean seekBefore : new boolean[]{false, true}) {
            for (int i = 0; i < NUM_RANDOM_SEEKS; ++i) {
                int keyValueId = !seekBefore ? this.randomizer.nextInt(sampleKv.size()) : this.randomizer.nextInt(sampleKv.size() - 1) + 1;
                KeyValue keyValue = (KeyValue)sampleKv.get(keyValueId);
                this.checkSeekingConsistency(encodedSeekers, seekBefore, keyValue);
            }
        }
        LOG.info((Object)"Checking edge cases");
        this.checkSeekingConsistency(encodedSeekers, false, (KeyValue)sampleKv.get(0));
        for (boolean seekBefore : new boolean[]{false, true}) {
            this.checkSeekingConsistency(encodedSeekers, seekBefore, (KeyValue)sampleKv.get(sampleKv.size() - 1));
            KeyValue midKv = (KeyValue)sampleKv.get(sampleKv.size() / 2);
            KeyValue lastMidKv = KeyValueUtil.createLastOnRowCol((Cell)midKv);
            this.checkSeekingConsistency(encodedSeekers, seekBefore, lastMidKv);
        }
        LOG.info((Object)"Done");
    }

    static ByteBuffer encodeKeyValues(DataBlockEncoding encoding, List<KeyValue> kvs, HFileBlockEncodingContext encodingContext) throws IOException {
        DataBlockEncoder encoder = encoding.getEncoder();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(HFILEBLOCK_DUMMY_HEADER);
        DataOutputStream dos = new DataOutputStream((OutputStream)baos);
        encoder.startBlockEncoding(encodingContext, dos);
        for (KeyValue kv : kvs) {
            encoder.encode((Cell)kv, encodingContext, dos);
        }
        encoder.endBlockEncoding(encodingContext, dos, baos.getBuffer());
        byte[] encodedData = new byte[baos.size() - ENCODED_DATA_OFFSET];
        System.arraycopy(baos.toByteArray(), ENCODED_DATA_OFFSET, encodedData, 0, encodedData.length);
        return ByteBuffer.wrap(encodedData);
    }

    @Test
    public void testNextOnSample() throws IOException {
        List sampleKv = this.generator.generateTestKeyValues(NUMBER_OF_KV, this.includesTags);
        for (DataBlockEncoding encoding : DataBlockEncoding.values()) {
            if (encoding.getEncoder() == null) continue;
            DataBlockEncoder encoder = encoding.getEncoder();
            ByteBuffer encodedBuffer = TestDataBlockEncoders.encodeKeyValues(encoding, sampleKv, this.getEncodingContext(Compression.Algorithm.NONE, encoding));
            HFileContext meta = new HFileContextBuilder().withHBaseCheckSum(false).withIncludesMvcc(this.includesMemstoreTS).withIncludesTags(this.includesTags).withCompression(Compression.Algorithm.NONE).build();
            DataBlockEncoder.EncodedSeeker seeker = encoder.createSeeker(KeyValue.COMPARATOR, encoder.newDataBlockDecodingContext(meta));
            seeker.setCurrentBuffer(encodedBuffer);
            int i = 0;
            do {
                KeyValue expectedKeyValue = (KeyValue)sampleKv.get(i);
                KeyValue keyValue = KeyValueUtil.copyToNewKeyValue((Cell)seeker.getKeyValue());
                if (0 != Bytes.compareTo((byte[])keyValue.getBuffer(), (int)keyValue.getOffset(), (int)keyValue.getLength(), (byte[])expectedKeyValue.getBuffer(), (int)expectedKeyValue.getOffset(), (int)expectedKeyValue.getLength())) {
                    int commonPrefix;
                    byte[] left = keyValue.getBuffer();
                    byte[] right = expectedKeyValue.getBuffer();
                    int leftOff = keyValue.getOffset();
                    int rightOff = expectedKeyValue.getOffset();
                    int length = Math.min(keyValue.getLength(), expectedKeyValue.getLength());
                    for (commonPrefix = 0; commonPrefix < length && left[commonPrefix + leftOff] == right[commonPrefix + rightOff]; ++commonPrefix) {
                    }
                    Assert.fail((String)String.format("next() produces wrong results encoder: %s i: %d commonPrefix: %d\n expected %s\n actual      %s", encoder.toString(), i, commonPrefix, Bytes.toStringBinary((byte[])expectedKeyValue.getBuffer(), (int)expectedKeyValue.getOffset(), (int)expectedKeyValue.getLength()), Bytes.toStringBinary((byte[])keyValue.getBuffer())));
                }
                ++i;
            } while (seeker.next());
        }
    }

    @Test
    public void testFirstKeyInBlockOnSample() throws IOException {
        List sampleKv = this.generator.generateTestKeyValues(NUMBER_OF_KV, this.includesTags);
        for (DataBlockEncoding encoding : DataBlockEncoding.values()) {
            int commonPrefix;
            if (encoding.getEncoder() == null) continue;
            DataBlockEncoder encoder = encoding.getEncoder();
            ByteBuffer encodedBuffer = TestDataBlockEncoders.encodeKeyValues(encoding, sampleKv, this.getEncodingContext(Compression.Algorithm.NONE, encoding));
            ByteBuffer keyBuffer = encoder.getFirstKeyInBlock(encodedBuffer);
            KeyValue firstKv = (KeyValue)sampleKv.get(0);
            if (0 == Bytes.compareTo((byte[])keyBuffer.array(), (int)keyBuffer.arrayOffset(), (int)keyBuffer.limit(), (byte[])firstKv.getBuffer(), (int)firstKv.getKeyOffset(), (int)firstKv.getKeyLength())) continue;
            int length = Math.min(keyBuffer.limit(), firstKv.getKeyLength());
            for (commonPrefix = 0; commonPrefix < length && keyBuffer.array()[keyBuffer.arrayOffset() + commonPrefix] == firstKv.getBuffer()[firstKv.getKeyOffset() + commonPrefix]; ++commonPrefix) {
            }
            Assert.fail((String)String.format("Bug in '%s' commonPrefix %d", encoder.toString(), commonPrefix));
        }
    }

    private void checkSeekingConsistency(List<DataBlockEncoder.EncodedSeeker> encodedSeekers, boolean seekBefore, KeyValue keyValue) {
        ByteBuffer expectedKeyValue = null;
        ByteBuffer expectedKey = null;
        ByteBuffer expectedValue = null;
        for (DataBlockEncoder.EncodedSeeker seeker : encodedSeekers) {
            seeker.seekToKeyInBlock((Cell)keyValue, seekBefore);
            seeker.rewind();
            ByteBuffer actualKeyValue = KeyValueUtil.copyKeyToNewByteBuffer((Cell)seeker.getKeyValue());
            ByteBuffer actualKey = seeker.getKeyDeepCopy();
            ByteBuffer actualValue = seeker.getValueShallowCopy();
            if (expectedKeyValue != null) {
                Assert.assertEquals((Object)expectedKeyValue, (Object)actualKeyValue);
            } else {
                expectedKeyValue = actualKeyValue;
            }
            if (expectedKey != null) {
                Assert.assertEquals((Object)expectedKey, (Object)actualKey);
            } else {
                expectedKey = actualKey;
            }
            if (expectedValue != null) {
                Assert.assertEquals((Object)expectedValue, (Object)actualValue);
                continue;
            }
            expectedValue = actualValue;
        }
    }

    private void testEncodersOnDataset(List<KeyValue> kvList, boolean includesMemstoreTS, boolean includesTags) throws IOException {
        ByteBuffer unencodedDataBuf = RedundantKVGenerator.convertKvToByteBuffer(kvList, (boolean)includesMemstoreTS);
        HFileContext fileContext = new HFileContextBuilder().withIncludesMvcc(includesMemstoreTS).withIncludesTags(includesTags).build();
        for (DataBlockEncoding encoding : DataBlockEncoding.values()) {
            DataBlockEncoder encoder = encoding.getEncoder();
            if (encoder == null) continue;
            HFileBlockDefaultEncodingContext encodingContext = new HFileBlockDefaultEncodingContext(encoding, HFILEBLOCK_DUMMY_HEADER, fileContext);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(HFILEBLOCK_DUMMY_HEADER);
            DataOutputStream dos = new DataOutputStream((OutputStream)baos);
            encoder.startBlockEncoding((HFileBlockEncodingContext)encodingContext, dos);
            for (KeyValue kv : kvList) {
                encoder.encode((Cell)kv, (HFileBlockEncodingContext)encodingContext, dos);
            }
            encoder.endBlockEncoding((HFileBlockEncodingContext)encodingContext, dos, baos.getBuffer());
            byte[] encodedData = baos.toByteArray();
            this.testAlgorithm(encodedData, unencodedDataBuf, encoder);
        }
    }

    @Test
    public void testZeroByte() throws IOException {
        ArrayList<KeyValue> kvList = new ArrayList<KeyValue>();
        byte[] row = Bytes.toBytes((String)"abcd");
        byte[] family = new byte[]{102};
        byte[] qualifier0 = new byte[]{98};
        byte[] qualifier1 = new byte[]{99};
        byte[] value0 = new byte[]{100};
        byte[] value1 = new byte[]{0};
        if (this.includesTags) {
            kvList.add(new KeyValue(row, family, qualifier0, 0L, value0, new Tag[]{new Tag(1, "value1")}));
            kvList.add(new KeyValue(row, family, qualifier1, 0L, value1, new Tag[]{new Tag(1, "value1")}));
        } else {
            kvList.add(new KeyValue(row, family, qualifier0, 0L, KeyValue.Type.Put, value0));
            kvList.add(new KeyValue(row, family, qualifier1, 0L, KeyValue.Type.Put, value1));
        }
        this.testEncodersOnDataset(kvList, this.includesMemstoreTS, this.includesTags);
    }

    private void testAlgorithm(byte[] encodedData, ByteBuffer unencodedDataBuf, DataBlockEncoder encoder) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(encodedData, ENCODED_DATA_OFFSET, encodedData.length - ENCODED_DATA_OFFSET);
        DataInputStream dis = new DataInputStream(bais);
        HFileContext meta = new HFileContextBuilder().withHBaseCheckSum(false).withIncludesMvcc(this.includesMemstoreTS).withIncludesTags(this.includesTags).withCompression(Compression.Algorithm.NONE).build();
        ByteBuffer actualDataset = encoder.decodeKeyValues(dis, encoder.newDataBlockDecodingContext(meta));
        actualDataset.rewind();
        Assert.assertEquals((String)("Encoding -> decoding gives different results for " + encoder), (Object)Bytes.toStringBinary((ByteBuffer)unencodedDataBuf), (Object)Bytes.toStringBinary((ByteBuffer)actualDataset));
    }
}

