/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.NavigableMap;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ChoreService;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.MetaScanner;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.ipc.HBaseRpcControllerImpl;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.RequestConverter;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.SplitTransactionImpl;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.PairOfSameType;
import org.apache.hadoop.hbase.util.StoppableImplementation;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestEndToEndSplitTransaction {
    private static final Log LOG = LogFactory.getLog(TestEndToEndSplitTransaction.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final Configuration CONF = TEST_UTIL.getConfiguration();

    @BeforeClass
    public static void beforeAllTests() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hbase.client.retries.number", 5);
        TEST_UTIL.startMiniCluster();
    }

    @AfterClass
    public static void afterAllTests() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testMasterOpsWhileSplitting() throws Exception {
        TableName tableName = TableName.valueOf((String)"TestSplit");
        byte[] familyName = Bytes.toBytes((String)"fam");
        try (HTable ht = TEST_UTIL.createTable(tableName, familyName);){
            TEST_UTIL.loadTable((Table)ht, familyName, false);
        }
        HRegionServer server = TEST_UTIL.getHBaseCluster().getRegionServer(0);
        byte[] firstRow = Bytes.toBytes((String)"aaa");
        byte[] splitRow = Bytes.toBytes((String)"lll");
        byte[] lastRow = Bytes.toBytes((String)"zzz");
        try (Connection conn = ConnectionFactory.createConnection((Configuration)TEST_UTIL.getConfiguration());){
            byte[] regionName = conn.getRegionLocator(tableName).getRegionLocation(splitRow).getRegionInfo().getRegionName();
            Region region = server.getRegion(regionName);
            SplitTransactionImpl split = new SplitTransactionImpl((Region)((HRegion)region), splitRow);
            split.prepare();
            PairOfSameType regions = split.createDaughters((Server)server, (RegionServerServices)server, null);
            Assert.assertFalse((boolean)this.test(conn, tableName, firstRow, server));
            Assert.assertFalse((boolean)this.test(conn, tableName, lastRow, server));
            split.openDaughters((Server)server, null, (Region)regions.getFirst(), (Region)regions.getSecond());
            Assert.assertFalse((boolean)this.test(conn, tableName, firstRow, server));
            Assert.assertFalse((boolean)this.test(conn, tableName, lastRow, server));
            if (split.useZKForAssignment) {
                server.postOpenDeployTasks((Region)regions.getSecond());
            } else {
                server.reportRegionStateTransition(RegionServerStatusProtos.RegionStateTransition.TransitionCode.SPLIT, new HRegionInfo[]{region.getRegionInfo(), ((Region)regions.getFirst()).getRegionInfo(), ((Region)regions.getSecond()).getRegionInfo()});
            }
            if (split.useZKForAssignment) {
                server.postOpenDeployTasks((Region)regions.getFirst());
            }
            server.addToOnlineRegions((Region)regions.getSecond());
            Assert.assertFalse((boolean)this.test(conn, tableName, firstRow, server));
            Assert.assertTrue((boolean)this.test(conn, tableName, lastRow, server));
            server.addToOnlineRegions((Region)regions.getFirst());
            Assert.assertTrue((boolean)this.test(conn, tableName, firstRow, server));
            Assert.assertTrue((boolean)this.test(conn, tableName, lastRow, server));
            if (split.useZKForAssignment) {
                server.getCoordinatedStateManager().getSplitTransactionCoordination().completeSplitTransaction((RegionServerServices)server, (Region)regions.getFirst(), (Region)regions.getSecond(), split.std, region);
            }
            Assert.assertTrue((boolean)this.test(conn, tableName, firstRow, server));
            Assert.assertTrue((boolean)this.test(conn, tableName, lastRow, server));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTableAvailableWhileSplitting() throws Exception {
        TableName tableName = TableName.valueOf((String)"TestTableAvailableWhileSplitting");
        byte[] familyName = Bytes.toBytes((String)"fam");
        try (HTable ht = TEST_UTIL.createTable(tableName, familyName);){
            TEST_UTIL.loadTable((Table)ht, familyName, false);
        }
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        HRegionServer server = TEST_UTIL.getHBaseCluster().getRegionServer(0);
        byte[] splitRow = Bytes.toBytes((String)"lll");
        try (Connection conn = ConnectionFactory.createConnection((Configuration)TEST_UTIL.getConfiguration());){
            byte[] regionName = conn.getRegionLocator(tableName).getRegionLocation(splitRow).getRegionInfo().getRegionName();
            Region region = server.getRegion(regionName);
            SplitTransactionImpl split = new SplitTransactionImpl((Region)((HRegion)region), splitRow);
            split.prepare();
            Assert.assertTrue((boolean)admin.isTableAvailable(tableName));
            PairOfSameType regions = split.createDaughters((Server)server, (RegionServerServices)server, null);
            Assert.assertFalse((boolean)admin.isTableAvailable(tableName));
            split.openDaughters((Server)server, null, (Region)regions.getFirst(), (Region)regions.getSecond());
            Assert.assertFalse((boolean)admin.isTableAvailable(tableName));
            if (split.useZKForAssignment) {
                server.postOpenDeployTasks((Region)regions.getSecond());
            } else {
                server.reportRegionStateTransition(RegionServerStatusProtos.RegionStateTransition.TransitionCode.SPLIT, new HRegionInfo[]{region.getRegionInfo(), ((Region)regions.getFirst()).getRegionInfo(), ((Region)regions.getSecond()).getRegionInfo()});
            }
            if (split.useZKForAssignment) {
                server.postOpenDeployTasks((Region)regions.getFirst());
            }
            Assert.assertTrue((boolean)admin.isTableAvailable(tableName));
            server.addToOnlineRegions((Region)regions.getSecond());
            server.addToOnlineRegions((Region)regions.getFirst());
            Assert.assertTrue((boolean)admin.isTableAvailable(tableName));
        }
        finally {
            if (admin != null) {
                admin.close();
            }
        }
    }

    private boolean test(Connection conn, TableName tableName, byte[] row, HRegionServer server) {
        try {
            byte[] regionName = conn.getRegionLocator(tableName).getRegionLocation(row, true).getRegionInfo().getRegionName();
            ClientProtos.GetRequest request = RequestConverter.buildGetRequest((byte[])regionName, (Get)new Get(row));
            server.getRSRpcServices().get(null, request);
            ClientProtos.ScanRequest scanRequest = RequestConverter.buildScanRequest((byte[])regionName, (Scan)new Scan(row), (int)1, (boolean)true);
            try {
                server.getRSRpcServices().scan((RpcController)new HBaseRpcControllerImpl(), scanRequest);
            }
            catch (ServiceException se) {
                throw ProtobufUtil.getRemoteException((ServiceException)se);
            }
        }
        catch (IOException e) {
            return false;
        }
        catch (ServiceException e) {
            return false;
        }
        return true;
    }

    @Test
    public void testFromClientSideWhileSplitting() throws Throwable {
        LOG.info((Object)"Starting testFromClientSideWhileSplitting");
        TableName TABLENAME = TableName.valueOf((String)"testFromClientSideWhileSplitting");
        byte[] FAMILY = Bytes.toBytes((String)"family");
        HTable table = TEST_UTIL.createTable(TABLENAME, FAMILY);
        StoppableImplementation stopper = new StoppableImplementation();
        RegionSplitter regionSplitter = new RegionSplitter((Table)table);
        RegionChecker regionChecker = new RegionChecker(CONF, stopper, TABLENAME);
        ChoreService choreService = new ChoreService("TEST_SERVER");
        choreService.scheduleChore((ScheduledChore)regionChecker);
        regionSplitter.start();
        regionSplitter.join();
        stopper.stop(null);
        if (regionChecker.ex != null) {
            throw regionChecker.ex;
        }
        if (regionSplitter.ex != null) {
            throw regionSplitter.ex;
        }
        regionChecker.verify();
    }

    public static void log(String msg) {
        LOG.info((Object)msg);
    }

    public static void flushAndBlockUntilDone(Admin admin, HRegionServer rs, byte[] regionName) throws IOException, InterruptedException {
        TestEndToEndSplitTransaction.log("flushing region: " + Bytes.toStringBinary((byte[])regionName));
        admin.flushRegion(regionName);
        TestEndToEndSplitTransaction.log("blocking until flush is complete: " + Bytes.toStringBinary((byte[])regionName));
        Threads.sleepWithoutInterrupt((long)500L);
        while (rs.getOnlineRegion(regionName).getMemstoreSize() > 0L) {
            Threads.sleep((long)50L);
        }
    }

    public static void compactAndBlockUntilDone(Admin admin, HRegionServer rs, byte[] regionName) throws IOException, InterruptedException {
        TestEndToEndSplitTransaction.log("Compacting region: " + Bytes.toStringBinary((byte[])regionName));
        admin.majorCompactRegion(regionName);
        TestEndToEndSplitTransaction.log("blocking until compaction is complete: " + Bytes.toStringBinary((byte[])regionName));
        Threads.sleepWithoutInterrupt((long)500L);
        block0: while (true) {
            for (Store store : rs.getOnlineRegion(regionName).getStores()) {
                if (store.getStorefilesCount() <= 1) continue;
                Threads.sleep((long)50L);
                continue block0;
            }
            break;
        }
    }

    public static void blockUntilRegionSplit(Configuration conf, long timeout, byte[] regionName, boolean waitForDaughters) throws IOException, InterruptedException {
        long start = System.currentTimeMillis();
        TestEndToEndSplitTransaction.log("blocking until region is split:" + Bytes.toStringBinary((byte[])regionName));
        HRegionInfo daughterA = null;
        HRegionInfo daughterB = null;
        try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);
             Table metaTable = conn.getTable(TableName.META_TABLE_NAME);){
            Result result = null;
            HRegionInfo region = null;
            while (System.currentTimeMillis() - start < timeout && (result = metaTable.get(new Get(regionName))) != null) {
                region = MetaTableAccessor.getHRegionInfo((Result)result);
                if (region.isSplitParent()) {
                    TestEndToEndSplitTransaction.log("found parent region: " + region.toString());
                    PairOfSameType pair = MetaTableAccessor.getDaughterRegions((Result)result);
                    daughterA = (HRegionInfo)pair.getFirst();
                    daughterB = (HRegionInfo)pair.getSecond();
                    break;
                }
                Threads.sleep((long)100L);
            }
            if (daughterA == null || daughterB == null) {
                throw new IOException("Failed to get daughters, daughterA=" + daughterA + ", daughterB=" + daughterB + ", timeout=" + timeout + ", result=" + result + ", regionName=" + Bytes.toString((byte[])regionName) + ", region=" + region);
            }
            if (waitForDaughters) {
                long rem = timeout - (System.currentTimeMillis() - start);
                TestEndToEndSplitTransaction.blockUntilRegionIsInMeta(conn, rem, daughterA);
                rem = timeout - (System.currentTimeMillis() - start);
                TestEndToEndSplitTransaction.blockUntilRegionIsInMeta(conn, rem, daughterB);
                rem = timeout - (System.currentTimeMillis() - start);
                TestEndToEndSplitTransaction.blockUntilRegionIsOpened(conf, rem, daughterA);
                rem = timeout - (System.currentTimeMillis() - start);
                TestEndToEndSplitTransaction.blockUntilRegionIsOpened(conf, rem, daughterB);
            }
        }
    }

    public static void blockUntilRegionIsInMeta(Connection conn, long timeout, HRegionInfo hri) throws IOException, InterruptedException {
        TestEndToEndSplitTransaction.log("blocking until region is in META: " + hri.getRegionNameAsString());
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < timeout) {
            HRegionLocation loc = MetaTableAccessor.getRegionLocation((Connection)conn, (HRegionInfo)hri);
            if (loc != null && !loc.getRegionInfo().isOffline()) {
                TestEndToEndSplitTransaction.log("found region in META: " + hri.getRegionNameAsString());
                break;
            }
            Threads.sleep((long)10L);
        }
    }

    public static void blockUntilRegionIsOpened(Configuration conf, long timeout, HRegionInfo hri) throws IOException, InterruptedException {
        TestEndToEndSplitTransaction.log("blocking until region is opened for reading:" + hri.getRegionNameAsString());
        long start = System.currentTimeMillis();
        try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);
             Table table = conn.getTable(hri.getTable());){
            byte[] row = hri.getStartKey();
            if (row == null || row.length <= 0) {
                row = new byte[]{48};
            }
            Get get = new Get(row);
            while (System.currentTimeMillis() - start < timeout) {
                try {
                    table.get(get);
                    break;
                }
                catch (IOException iOException) {
                    Threads.sleep((long)10L);
                }
            }
        }
    }

    static class RegionChecker
    extends ScheduledChore {
        Connection connection;
        Configuration conf;
        TableName tableName;
        Throwable ex;

        RegionChecker(Configuration conf, Stoppable stopper, TableName tableName) throws IOException {
            super("RegionChecker", stopper, 10);
            this.conf = conf;
            this.tableName = tableName;
            this.connection = ConnectionFactory.createConnection((Configuration)conf);
        }

        void verifyRegionsUsingMetaScanner() throws Exception {
            NavigableMap regions = MetaScanner.allTableRegions((Connection)this.connection, (TableName)this.tableName);
            this.verifyTableRegions(regions.keySet());
            List regionList = MetaScanner.listAllRegions((Configuration)this.conf, (Connection)this.connection, (boolean)false);
            this.verifyTableRegions(Sets.newTreeSet((Iterable)regionList));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void verifyRegionsUsingHTable() throws IOException {
            HTable table = null;
            try {
                table = (HTable)this.connection.getTable(this.tableName);
                Pair keys = table.getRegionLocator().getStartEndKeys();
                this.verifyStartEndKeys((Pair<byte[][], byte[][]>)keys);
                TreeSet<HRegionInfo> regions = new TreeSet<HRegionInfo>();
                for (HRegionLocation loc : table.getRegionLocator().getAllRegionLocations()) {
                    regions.add(loc.getRegionInfo());
                }
                this.verifyTableRegions(regions);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(table);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)table);
        }

        void verify() throws Exception {
            this.verifyRegionsUsingMetaScanner();
            this.verifyRegionsUsingHTable();
        }

        void verifyTableRegions(Set<HRegionInfo> regions) {
            TestEndToEndSplitTransaction.log("Verifying " + regions.size() + " regions: " + regions);
            byte[][] startKeys = new byte[regions.size()][];
            byte[][] endKeys = new byte[regions.size()][];
            int i = 0;
            for (HRegionInfo region : regions) {
                startKeys[i] = region.getStartKey();
                endKeys[i] = region.getEndKey();
                ++i;
            }
            Pair keys = new Pair((Object)startKeys, (Object)endKeys);
            this.verifyStartEndKeys((Pair<byte[][], byte[][]>)keys);
        }

        void verifyStartEndKeys(Pair<byte[][], byte[][]> keys) {
            byte[][] startKeys = (byte[][])keys.getFirst();
            byte[][] endKeys = (byte[][])keys.getSecond();
            Assert.assertEquals((long)startKeys.length, (long)endKeys.length);
            Assert.assertTrue((String)"Found 0 regions for the table", (startKeys.length > 0 ? 1 : 0) != 0);
            Assert.assertArrayEquals((String)"Start key for the first region is not byte[0]", (byte[])HConstants.EMPTY_START_ROW, (byte[])startKeys[0]);
            byte[] prevEndKey = HConstants.EMPTY_START_ROW;
            for (int i = 0; i < startKeys.length; ++i) {
                Assert.assertArrayEquals((String)("Hole in hbase:meta is detected. prevEndKey=" + Bytes.toStringBinary((byte[])prevEndKey) + " ,regionStartKey=" + Bytes.toStringBinary((byte[])startKeys[i])), (byte[])prevEndKey, (byte[])startKeys[i]);
                prevEndKey = endKeys[i];
            }
            Assert.assertArrayEquals((String)"End key for the last region is not byte[0]", (byte[])HConstants.EMPTY_END_ROW, (byte[])endKeys[endKeys.length - 1]);
        }

        protected void chore() {
            try {
                this.verify();
            }
            catch (Throwable ex) {
                this.ex = ex;
                this.getStopper().stop("caught exception");
            }
        }
    }

    static class RegionSplitter
    extends Thread {
        final Connection connection;
        Throwable ex;
        Table table;
        TableName tableName;
        byte[] family;
        Admin admin;
        HRegionServer rs;

        RegionSplitter(Table table) throws IOException {
            this.table = table;
            this.tableName = table.getName();
            this.family = (byte[])table.getTableDescriptor().getFamiliesKeys().iterator().next();
            this.admin = TEST_UTIL.getHBaseAdmin();
            this.rs = TEST_UTIL.getMiniHBaseCluster().getRegionServer(0);
            this.connection = TEST_UTIL.getConnection();
        }

        @Override
        public void run() {
            try {
                Random random = new Random();
                for (int i = 0; i < 5; ++i) {
                    NavigableMap regions = MetaScanner.allTableRegions((Connection)this.connection, (TableName)this.tableName);
                    if (regions.size() == 0) continue;
                    int regionIndex = random.nextInt(regions.size());
                    HRegionInfo region = (HRegionInfo)Iterators.get(regions.keySet().iterator(), (int)regionIndex);
                    int start = 0;
                    int end = Integer.MAX_VALUE;
                    if (region.getStartKey().length > 0) {
                        start = Bytes.toInt((byte[])region.getStartKey());
                    }
                    if (region.getEndKey().length > 0) {
                        end = Bytes.toInt((byte[])region.getEndKey());
                    }
                    int mid = start + (end - start) / 2;
                    byte[] splitPoint = Bytes.toBytes((int)mid);
                    this.addData(start);
                    this.addData(mid);
                    TestEndToEndSplitTransaction.flushAndBlockUntilDone(this.admin, this.rs, region.getRegionName());
                    TestEndToEndSplitTransaction.compactAndBlockUntilDone(this.admin, this.rs, region.getRegionName());
                    TestEndToEndSplitTransaction.log("Initiating region split for:" + region.getRegionNameAsString());
                    try {
                        this.admin.splitRegion(region.getRegionName(), splitPoint);
                        TestEndToEndSplitTransaction.blockUntilRegionSplit(CONF, 50000L, region.getRegionName(), true);
                        continue;
                    }
                    catch (NotServingRegionException notServingRegionException) {
                        // empty catch block
                    }
                }
            }
            catch (Throwable ex) {
                this.ex = ex;
            }
        }

        void addData(int start) throws IOException {
            ArrayList<Put> puts = new ArrayList<Put>();
            for (int i = start; i < start + 100; ++i) {
                Put put = new Put(Bytes.toBytes((int)i));
                put.addColumn(this.family, this.family, Bytes.toBytes((int)i));
                puts.add(put);
            }
            this.table.put(puts);
        }
    }
}

