/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.replication.ReplicationAdmin;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationQueues;
import org.apache.hadoop.hbase.replication.ReplicationQueuesZKImpl;
import org.apache.hadoop.hbase.replication.TestReplicationBase;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.MiniZooKeeperCluster;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestMultiSlaveReplication {
    private static final Log LOG = LogFactory.getLog(TestReplicationBase.class);
    private static Configuration conf1;
    private static Configuration conf2;
    private static Configuration conf3;
    private static HBaseTestingUtility utility1;
    private static HBaseTestingUtility utility2;
    private static HBaseTestingUtility utility3;
    private static final long SLEEP_TIME = 500L;
    private static final int NB_RETRIES = 100;
    private static final TableName tableName;
    private static final byte[] famName;
    private static final byte[] row;
    private static final byte[] row1;
    private static final byte[] row2;
    private static final byte[] row3;
    private static final byte[] noRepfamName;
    private static HTableDescriptor table;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        conf1 = HBaseConfiguration.create();
        conf1.set("zookeeper.znode.parent", "/1");
        conf1.setInt("hbase.regionserver.hlog.blocksize", 20480);
        conf1.setInt("replication.source.size.capacity", 1024);
        conf1.setLong("replication.source.sleepforretries", 100L);
        conf1.setInt("hbase.regionserver.maxlogs", 10);
        conf1.setLong("hbase.master.logcleaner.ttl", 10L);
        conf1.setBoolean("hbase.replication", true);
        conf1.setBoolean("dfs.support.append", true);
        conf1.setLong("hbase.server.thread.wakefrequency", 100L);
        conf1.setStrings("hbase.coprocessor.user.region.classes", new String[]{"org.apache.hadoop.hbase.replication.TestMasterReplication$CoprocessorCounter"});
        conf1.setBoolean("hbase.zookeeper.useMulti", false);
        conf1.setInt("hbase.master.cleaner.interval", 5000);
        conf1.setClass("hbase.region.replica.replication.replicationQueues.class", ReplicationQueuesZKImpl.class, ReplicationQueues.class);
        conf1.setLong("hbase.replication.zk.deadrs.lock.ttl", 0L);
        utility1 = new HBaseTestingUtility(conf1);
        conf2 = new Configuration(conf1);
        conf2.set("zookeeper.znode.parent", "/2");
        conf3 = new Configuration(conf1);
        conf3.set("zookeeper.znode.parent", "/3");
        utility2 = new HBaseTestingUtility(conf2);
        utility3 = new HBaseTestingUtility(conf3);
        table = new HTableDescriptor(tableName);
        HColumnDescriptor fam = new HColumnDescriptor(famName);
        fam.setScope(1);
        table.addFamily(fam);
        fam = new HColumnDescriptor(noRepfamName);
        table.addFamily(fam);
    }

    @Before
    public void startup() throws Exception {
        utility1.startMiniZKCluster();
        MiniZooKeeperCluster miniZK = utility1.getZkCluster();
        utility1.setZkCluster(miniZK);
        new ZooKeeperWatcher(conf1, "cluster1", null, true);
        utility2.setZkCluster(miniZK);
        new ZooKeeperWatcher(conf2, "cluster2", null, true);
        utility3.setZkCluster(miniZK);
        new ZooKeeperWatcher(conf3, "cluster3", null, true);
    }

    @After
    public void tearDown() throws Exception {
        utility1.shutdownMiniZKCluster();
    }

    @Test(timeout=300000L)
    public void testMultiSlaveReplication() throws Exception {
        LOG.info((Object)"Start the testMultiSlaveReplication Test");
        MiniHBaseCluster master = utility1.startMiniCluster();
        utility2.startMiniCluster();
        utility3.startMiniCluster();
        ReplicationAdmin admin1 = new ReplicationAdmin(conf1);
        new HBaseAdmin(conf1).createTable(table);
        new HBaseAdmin(conf2).createTable(table);
        new HBaseAdmin(conf3).createTable(table);
        HTable htable1 = new HTable(conf1, tableName);
        htable1.setWriteBufferSize(1024L);
        HTable htable2 = new HTable(conf2, tableName);
        htable2.setWriteBufferSize(1024L);
        HTable htable3 = new HTable(conf3, tableName);
        htable3.setWriteBufferSize(1024L);
        ReplicationPeerConfig rpc = new ReplicationPeerConfig();
        rpc.setClusterKey(utility2.getClusterKey());
        admin1.addPeer("1", rpc);
        this.putAndWait(row, famName, (Table)htable1, new Table[]{htable2});
        this.deleteAndWait(row, (Table)htable1, new Table[]{htable2});
        this.checkRow(row, 0, new Table[]{htable3});
        this.putAndWait(row2, famName, (Table)htable1, new Table[]{htable2});
        this.rollWALAndWait(utility1, htable1.getName(), row2);
        this.putAndWait(row3, famName, (Table)htable1, new Table[]{htable2});
        rpc = new ReplicationPeerConfig();
        rpc.setClusterKey(utility3.getClusterKey());
        admin1.addPeer("2", rpc);
        this.putAndWait(row1, famName, (Table)htable1, new Table[]{htable2, htable3});
        this.deleteAndWait(row1, (Table)htable1, new Table[]{htable2, htable3});
        this.checkRow(row2, 0, new Table[]{htable3});
        this.checkRow(row3, 1, new Table[]{htable3});
        Put p = new Put(row);
        p.add(famName, row, row);
        htable1.put(p);
        this.rollWALAndWait(utility1, htable1.getName(), row);
        this.deleteAndWait(row2, (Table)htable1, new Table[]{htable2, htable3});
        this.checkRow(row, 1, new Table[]{htable2});
        this.checkWithWait(row, 1, (Table)htable3);
        this.deleteAndWait(row, (Table)htable1, new Table[]{htable2, htable3});
        this.deleteAndWait(row3, (Table)htable1, new Table[]{htable2, htable3});
        utility3.shutdownMiniCluster();
        utility2.shutdownMiniCluster();
        utility1.shutdownMiniCluster();
    }

    @Test
    public void testZKLockCleaner() throws Exception {
        MiniHBaseCluster cluster = utility1.startMiniCluster(1, 2);
        HTableDescriptor table = new HTableDescriptor(TableName.valueOf((byte[])Bytes.toBytes((String)"zk")));
        HColumnDescriptor fam = new HColumnDescriptor(famName);
        fam.setScope(1);
        table.addFamily(fam);
        new HBaseAdmin(conf1).createTable(table);
        ReplicationAdmin replicationAdmin = new ReplicationAdmin(conf1);
        ReplicationPeerConfig rpc = new ReplicationPeerConfig();
        rpc.setClusterKey(utility2.getClusterKey());
        replicationAdmin.addPeer("cluster2", rpc, null);
        HRegionServer rs = cluster.getRegionServer(0);
        ReplicationQueuesZKImpl zk = new ReplicationQueuesZKImpl(rs.getZooKeeper(), conf1, (Abortable)rs);
        zk.init(rs.getServerName().toString());
        List replicators = zk.getListOfReplicators();
        Assert.assertEquals((long)2L, (long)replicators.size());
        String zNode = cluster.getRegionServer(1).getServerName().toString();
        Assert.assertTrue((boolean)zk.lockOtherRS(zNode));
        Assert.assertTrue((boolean)zk.checkLockExists(zNode));
        Thread.sleep(10000L);
        Assert.assertTrue((boolean)zk.checkLockExists(zNode));
        cluster.abortRegionServer(0);
        Thread.sleep(10000L);
        HRegionServer rs1 = cluster.getRegionServer(1);
        zk = new ReplicationQueuesZKImpl(rs1.getZooKeeper(), conf1, (Abortable)rs1);
        zk.init(rs1.getServerName().toString());
        Assert.assertFalse((boolean)zk.checkLockExists(zNode));
        utility1.shutdownMiniCluster();
    }

    private void rollWALAndWait(HBaseTestingUtility utility, TableName table, byte[] row) throws IOException {
        HBaseAdmin admin = utility.getHBaseAdmin();
        MiniHBaseCluster cluster = utility.getMiniHBaseCluster();
        HRegion region = null;
        for (HRegion candidate : cluster.getRegions(table)) {
            if (!HRegion.rowIsInRange((HRegionInfo)candidate.getRegionInfo(), (byte[])row)) continue;
            region = candidate;
            break;
        }
        Assert.assertNotNull((String)("Couldn't find the region for row '" + Arrays.toString(row) + "'"), (Object)region);
        final CountDownLatch latch = new CountDownLatch(1);
        WALActionsListener.Base listener = new WALActionsListener.Base(){

            public void postLogRoll(Path oldPath, Path newPath) throws IOException {
                latch.countDown();
            }
        };
        region.getWAL().registerWALActionsListener((WALActionsListener)listener);
        admin.rollWALWriter(cluster.getServerHoldingRegion(region.getTableDesc().getTableName(), region.getRegionInfo().getRegionName()));
        try {
            latch.await();
        }
        catch (InterruptedException exception) {
            LOG.warn((Object)("Interrupted while waiting for the wal of '" + region + "' to roll. If later " + "replication tests fail, it's probably because we should still be waiting."));
            Thread.currentThread().interrupt();
        }
        region.getWAL().unregisterWALActionsListener((WALActionsListener)listener);
    }

    private void checkWithWait(byte[] row, int count, Table table) throws Exception {
        Get get = new Get(row);
        for (int i = 0; i < 100; ++i) {
            if (i == 99) {
                Assert.fail((String)"Waited too much time while getting the row.");
            }
            boolean rowReplicated = false;
            Result res = table.get(get);
            if (res.size() >= 1) {
                LOG.info((Object)"Row is replicated");
                rowReplicated = true;
                Assert.assertEquals((String)("Table '" + table + "' did not have the expected number of  results."), (long)count, (long)res.size());
                break;
            }
            if (rowReplicated) break;
            Thread.sleep(500L);
        }
    }

    private void checkRow(byte[] row, int count, Table ... tables) throws IOException {
        Get get = new Get(row);
        for (Table table : tables) {
            Result res = table.get(get);
            Assert.assertEquals((String)("Table '" + table + "' did not have the expected number of results."), (long)count, (long)res.size());
        }
    }

    private void deleteAndWait(byte[] row, Table source, Table ... targets) throws Exception {
        Delete del = new Delete(row);
        source.delete(del);
        Get get = new Get(row);
        for (int i = 0; i < 100; ++i) {
            if (i == 99) {
                Assert.fail((String)"Waited too much time for del replication");
            }
            boolean removedFromAll = true;
            for (Table target : targets) {
                Result res = target.get(get);
                if (res.size() < 1) continue;
                LOG.info((Object)"Row not deleted");
                removedFromAll = false;
                break;
            }
            if (removedFromAll) break;
            Thread.sleep(500L);
        }
    }

    private void putAndWait(byte[] row, byte[] fam, Table source, Table ... targets) throws Exception {
        Put put = new Put(row);
        put.add(fam, row, row);
        source.put(put);
        Get get = new Get(row);
        for (int i = 0; i < 100; ++i) {
            if (i == 99) {
                Assert.fail((String)"Waited too much time for put replication");
            }
            boolean replicatedToAll = true;
            for (Table target : targets) {
                Result res = target.get(get);
                if (res.size() == 0) {
                    LOG.info((Object)"Row not available");
                    replicatedToAll = false;
                    break;
                }
                Assert.assertArrayEquals((byte[])res.value(), (byte[])row);
            }
            if (replicatedToAll) break;
            Thread.sleep(500L);
        }
    }

    static {
        tableName = TableName.valueOf((String)"test");
        famName = Bytes.toBytes((String)"f");
        row = Bytes.toBytes((String)"row");
        row1 = Bytes.toBytes((String)"row1");
        row2 = Bytes.toBytes((String)"row2");
        row3 = Bytes.toBytes((String)"row3");
        noRepfamName = Bytes.toBytes((String)"norep");
    }
}

