/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.common.annotations.VisibleForTesting;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.exceptions.UnexpectedStateException;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.regionserver.CellSkipListSet;
import org.apache.hadoop.hbase.regionserver.GetClosestRowBeforeTracker;
import org.apache.hadoop.hbase.regionserver.HeapMemStoreLAB;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.MemStore;
import org.apache.hadoop.hbase.regionserver.MemStoreLAB;
import org.apache.hadoop.hbase.regionserver.MemStoreSnapshot;
import org.apache.hadoop.hbase.regionserver.NonLazyKeyValueScanner;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.TimeRangeTracker;
import org.apache.hadoop.hbase.util.ByteRange;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.hadoop.hbase.util.CollectionBackedScanner;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.ReflectionUtils;
import org.apache.htrace.Trace;

@InterfaceAudience.Private
public class DefaultMemStore
implements MemStore {
    private static final Log LOG = LogFactory.getLog(DefaultMemStore.class);
    @VisibleForTesting
    static final String USEMSLAB_KEY = "hbase.hregion.memstore.mslab.enabled";
    private static final boolean USEMSLAB_DEFAULT = true;
    private static final String MSLAB_CLASS_NAME = "hbase.regionserver.mslab.class";
    private Configuration conf;
    @VisibleForTesting
    final KeyValue.KVComparator comparator;
    private volatile long timeOfOldestEdit = Long.MAX_VALUE;
    private volatile long snapshotId;
    private volatile boolean tagsPresent;
    @VisibleForTesting
    volatile Section activeSection;
    @VisibleForTesting
    volatile Section snapshotSection;
    public static final long FIXED_OVERHEAD = ClassSize.align((int)(ClassSize.OBJECT + 4 * ClassSize.REFERENCE + 16 + 1));
    public static final long DEEP_OVERHEAD = ClassSize.align((long)(FIXED_OVERHEAD + (long)(2 * ClassSize.ATOMIC_LONG) + (long)(2 * ClassSize.TIMERANGE_TRACKER) + (long)(2 * ClassSize.CELL_SKIPLIST_SET) + (long)(2 * ClassSize.CONCURRENT_SKIPLISTMAP)));

    public DefaultMemStore() {
        this(HBaseConfiguration.create(), KeyValue.COMPARATOR);
    }

    public DefaultMemStore(Configuration conf, KeyValue.KVComparator c) {
        this.conf = conf;
        this.comparator = c;
        this.activeSection = Section.newActiveSection(this.comparator, conf);
        this.snapshotSection = Section.newSnapshotSection(this.comparator);
    }

    @Override
    public MemStoreSnapshot snapshot() {
        if (!this.snapshotSection.getCellSkipListSet().isEmpty()) {
            LOG.warn((Object)"Snapshot called again without clearing previous. Doing nothing. Another ongoing flush or did we fail last attempt?");
        } else {
            this.snapshotId = EnvironmentEdgeManager.currentTime();
            if (!this.activeSection.getCellSkipListSet().isEmpty()) {
                this.snapshotSection = this.activeSection;
                this.activeSection = Section.newActiveSection(this.comparator, this.conf);
                this.snapshotSection.getHeapSize().addAndGet(-DEEP_OVERHEAD);
                this.timeOfOldestEdit = Long.MAX_VALUE;
            }
        }
        MemStoreSnapshot memStoreSnapshot = new MemStoreSnapshot(this.snapshotId, this.snapshotSection.getCellSkipListSet().size(), this.snapshotSection.getHeapSize().get(), this.snapshotSection.getTimeRangeTracker(), new CollectionBackedScanner(this.snapshotSection.getCellSkipListSet(), this.comparator), this.tagsPresent);
        this.tagsPresent = false;
        return memStoreSnapshot;
    }

    @Override
    public void clearSnapshot(long id) throws UnexpectedStateException {
        if (this.snapshotId == -1L) {
            return;
        }
        if (this.snapshotId != id) {
            throw new UnexpectedStateException("Current snapshot id is " + this.snapshotId + ",passed " + id);
        }
        MemStoreLAB tmpAllocator = this.snapshotSection.getMemStoreLAB();
        this.snapshotSection = Section.newSnapshotSection(this.comparator);
        if (tmpAllocator != null) {
            tmpAllocator.close();
        }
        this.snapshotId = -1L;
    }

    @Override
    public long getFlushableSize() {
        long snapshotSize = this.snapshotSection.getHeapSize().get();
        return snapshotSize > 0L ? snapshotSize : this.keySize();
    }

    @Override
    public long getSnapshotSize() {
        return this.snapshotSection.getHeapSize().get();
    }

    @Override
    public long add(Cell cell) {
        Cell toAdd = this.maybeCloneWithAllocator(cell);
        boolean mslabUsed = toAdd != cell;
        return this.internalAdd(toAdd, mslabUsed);
    }

    @Override
    public long add(Iterable<Cell> cells) {
        long size = 0L;
        for (Cell cell : cells) {
            size += this.add(cell);
        }
        return size;
    }

    @Override
    public long timeOfOldestEdit() {
        return this.timeOfOldestEdit;
    }

    private boolean addToCellSet(Cell e) {
        boolean b = this.activeSection.getCellSkipListSet().add(e);
        if (e.getTagsLength() > 0) {
            this.tagsPresent = true;
        }
        this.setOldestEditTimeToNow();
        return b;
    }

    private boolean removeFromCellSet(Cell e) {
        boolean b = this.activeSection.getCellSkipListSet().remove(e);
        this.setOldestEditTimeToNow();
        return b;
    }

    void setOldestEditTimeToNow() {
        if (this.timeOfOldestEdit == Long.MAX_VALUE) {
            this.timeOfOldestEdit = EnvironmentEdgeManager.currentTime();
        }
    }

    private long internalAdd(Cell toAdd, boolean mslabUsed) {
        boolean notPresent = this.addToCellSet(toAdd);
        long s = DefaultMemStore.heapSizeChange(toAdd, notPresent);
        if (!notPresent && mslabUsed) {
            s += (long)this.getCellLength(toAdd);
        }
        this.activeSection.getTimeRangeTracker().includeTimestamp(toAdd);
        this.activeSection.getHeapSize().addAndGet(s);
        return s;
    }

    @VisibleForTesting
    int getCellLength(Cell cell) {
        return KeyValueUtil.length((Cell)cell);
    }

    private Cell maybeCloneWithAllocator(Cell cell) {
        if (this.activeSection.getMemStoreLAB() == null) {
            return cell;
        }
        int len = this.getCellLength(cell);
        ByteRange alloc = this.activeSection.getMemStoreLAB().allocateBytes(len);
        if (alloc == null) {
            return cell;
        }
        assert (alloc.getBytes() != null);
        KeyValueUtil.appendToByteArray((Cell)cell, (byte[])alloc.getBytes(), (int)alloc.getOffset());
        KeyValue newKv = new KeyValue(alloc.getBytes(), alloc.getOffset(), len);
        newKv.setSequenceId(cell.getSequenceId());
        return newKv;
    }

    @Override
    public void rollback(Cell cell) {
        long sz;
        Cell found = this.snapshotSection.getCellSkipListSet().get(cell);
        if (found != null && found.getSequenceId() == cell.getSequenceId()) {
            this.snapshotSection.getCellSkipListSet().remove(cell);
            sz = DefaultMemStore.heapSizeChange(cell, true);
            this.snapshotSection.getHeapSize().addAndGet(-sz);
        }
        if ((found = this.activeSection.getCellSkipListSet().get(cell)) != null && found.getSequenceId() == cell.getSequenceId()) {
            this.removeFromCellSet(found);
            sz = DefaultMemStore.heapSizeChange(found, true);
            this.activeSection.getHeapSize().addAndGet(-sz);
        }
    }

    @Override
    public long delete(Cell deleteCell) {
        Cell toAdd = this.maybeCloneWithAllocator(deleteCell);
        boolean mslabUsed = toAdd != deleteCell;
        return this.internalAdd(toAdd, mslabUsed);
    }

    Cell getNextRow(Cell cell) {
        return this.getLowest(this.getNextRow(cell, this.activeSection.getCellSkipListSet()), this.getNextRow(cell, this.snapshotSection.getCellSkipListSet()));
    }

    private Cell getLowest(Cell a, Cell b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return this.comparator.compareRows(a, b) <= 0 ? a : b;
    }

    private Cell getNextRow(Cell key, NavigableSet<Cell> set) {
        Cell result = null;
        NavigableSet<Cell> tail = key == null ? set : set.tailSet(key);
        for (Cell cell : tail) {
            if (this.comparator.compareRows(cell, key) <= 0) continue;
            result = cell;
            break;
        }
        return result;
    }

    @Override
    public void getRowKeyAtOrBefore(GetClosestRowBeforeTracker state) {
        this.getRowKeyAtOrBefore(this.activeSection.getCellSkipListSet(), state);
        this.getRowKeyAtOrBefore(this.snapshotSection.getCellSkipListSet(), state);
    }

    private void getRowKeyAtOrBefore(NavigableSet<Cell> set, GetClosestRowBeforeTracker state) {
        if (set.isEmpty()) {
            return;
        }
        if (!this.walkForwardInSingleRow(set, (Cell)state.getTargetKey(), state)) {
            this.getRowKeyBefore(set, state);
        }
    }

    private boolean walkForwardInSingleRow(SortedSet<Cell> set, Cell firstOnRow, GetClosestRowBeforeTracker state) {
        Cell kv;
        boolean foundCandidate = false;
        SortedSet<Cell> tail = set.tailSet(firstOnRow);
        if (tail.isEmpty()) {
            return foundCandidate;
        }
        Iterator i = tail.iterator();
        while (i.hasNext() && !state.isTooFar(kv = (Cell)i.next(), firstOnRow)) {
            if (state.isExpired(kv)) {
                i.remove();
                continue;
            }
            if (!state.handle(kv)) continue;
            foundCandidate = true;
            break;
        }
        return foundCandidate;
    }

    private void getRowKeyBefore(NavigableSet<Cell> set, GetClosestRowBeforeTracker state) {
        KeyValue firstOnRow = state.getTargetKey();
        Member p = this.memberOfPreviousRow(set, state, (Cell)firstOnRow);
        while (p != null && state.isTargetTable(p.cell) && state.isBetterCandidate(p.cell) && !this.walkForwardInSingleRow(p.set, (Cell)(firstOnRow = new KeyValue(p.cell.getRowArray(), p.cell.getRowOffset(), (int)p.cell.getRowLength(), Long.MAX_VALUE)), state)) {
            p = this.memberOfPreviousRow(p.set, state, (Cell)firstOnRow);
        }
    }

    @Override
    public long updateColumnValue(byte[] row, byte[] family, byte[] qualifier, long newValue, long now) {
        Cell cell;
        Cell snc;
        KeyValue firstCell = KeyValueUtil.createFirstOnRow((byte[])row, (byte[])family, (byte[])qualifier);
        SortedSet<Cell> snSs = this.snapshotSection.getCellSkipListSet().tailSet((Cell)firstCell);
        if (!snSs.isEmpty() && CellUtil.matchingRow((Cell)(snc = snSs.first()), (Cell)firstCell) && CellUtil.matchingQualifier((Cell)snc, (Cell)firstCell) && snc.getTimestamp() == now) {
            ++now;
        }
        SortedSet<Cell> ss = this.activeSection.getCellSkipListSet().tailSet((Cell)firstCell);
        Iterator i$ = ss.iterator();
        while (i$.hasNext() && CellUtil.matchingColumn((Cell)(cell = (Cell)i$.next()), (byte[])family, (byte[])qualifier) && CellUtil.matchingRow((Cell)cell, (Cell)firstCell)) {
            if (cell.getTypeByte() != KeyValue.Type.Put.getCode() || cell.getTimestamp() <= now || !CellUtil.matchingQualifier((Cell)firstCell, (Cell)cell)) continue;
            now = cell.getTimestamp();
        }
        ArrayList<Cell> cells = new ArrayList<Cell>(1);
        cells.add((Cell)new KeyValue(row, family, qualifier, now, Bytes.toBytes((long)newValue)));
        return this.upsert(cells, 1L, null);
    }

    @Override
    public long upsert(Iterable<Cell> cells, long readpoint, List<Cell> removedCells) {
        long size = 0L;
        for (Cell cell : cells) {
            size += this.upsert(cell, readpoint, removedCells);
        }
        return size;
    }

    private long upsert(Cell cell, long readpoint, List<Cell> removedCells) {
        long addedSize = this.internalAdd(cell, false);
        KeyValue firstCell = KeyValueUtil.createFirstOnRow((byte[])cell.getRowArray(), (int)cell.getRowOffset(), (int)cell.getRowLength(), (byte[])cell.getFamilyArray(), (int)cell.getFamilyOffset(), (int)cell.getFamilyLength(), (byte[])cell.getQualifierArray(), (int)cell.getQualifierOffset(), (int)cell.getQualifierLength());
        SortedSet<Cell> ss = this.activeSection.getCellSkipListSet().tailSet((Cell)firstCell);
        Iterator it = ss.iterator();
        int versionsVisible = 0;
        while (it.hasNext()) {
            Cell cur = (Cell)it.next();
            if (cell == cur) continue;
            if (!CellUtil.matchingRow((Cell)cell, (Cell)cur) || !CellUtil.matchingQualifier((Cell)cell, (Cell)cur)) break;
            if (cur.getTypeByte() != KeyValue.Type.Put.getCode() || cur.getSequenceId() > readpoint) continue;
            if (versionsVisible >= 1) {
                long delta = DefaultMemStore.heapSizeChange(cur, true);
                addedSize -= delta;
                this.activeSection.getHeapSize().addAndGet(-delta);
                if (removedCells != null) {
                    removedCells.add(cur);
                }
                it.remove();
                this.setOldestEditTimeToNow();
                continue;
            }
            ++versionsVisible;
        }
        return addedSize;
    }

    private Member memberOfPreviousRow(NavigableSet<Cell> set, GetClosestRowBeforeTracker state, Cell firstOnRow) {
        NavigableSet<Cell> head = set.headSet(firstOnRow, false);
        if (head.isEmpty()) {
            return null;
        }
        Iterator<Cell> i = head.descendingIterator();
        while (i.hasNext()) {
            Cell found = i.next();
            if (state.isExpired(found)) {
                i.remove();
                continue;
            }
            return new Member(head, found);
        }
        return null;
    }

    @Override
    public List<KeyValueScanner> getScanners(long readPt) {
        MemStoreScanner scanner = new MemStoreScanner(this.activeSection, this.snapshotSection, readPt, this.comparator);
        scanner.seek(CellUtil.createCell((byte[])HConstants.EMPTY_START_ROW));
        if (scanner.peek() == null) {
            scanner.close();
            return null;
        }
        return Collections.singletonList(scanner);
    }

    public boolean shouldSeek(Scan scan, Store store, long oldestUnexpiredTS) {
        return DefaultMemStore.shouldSeek(this.activeSection.getTimeRangeTracker(), this.snapshotSection.getTimeRangeTracker(), scan, store, oldestUnexpiredTS);
    }

    private static boolean shouldSeek(TimeRangeTracker activeTimeRangeTracker, TimeRangeTracker snapshotTimeRangeTracker, Scan scan, Store store, long oldestUnexpiredTS) {
        byte[] cf = store.getFamily().getName();
        TimeRange timeRange = (TimeRange)scan.getColumnFamilyTimeRange().get(cf);
        if (timeRange == null) {
            timeRange = scan.getTimeRange();
        }
        return (activeTimeRangeTracker.includesTimeRange(timeRange) || snapshotTimeRangeTracker.includesTimeRange(timeRange)) && Math.max(activeTimeRangeTracker.getMax(), snapshotTimeRangeTracker.getMax()) >= oldestUnexpiredTS;
    }

    static long heapSizeChange(Cell cell, boolean notpresent) {
        return notpresent ? ClassSize.align((long)((long)ClassSize.CONCURRENT_SKIPLISTMAP_ENTRY + CellUtil.estimatedHeapSizeOf((Cell)cell))) : 0L;
    }

    private long keySize() {
        return this.heapSize() - DEEP_OVERHEAD;
    }

    public long heapSize() {
        return this.activeSection.getHeapSize().get();
    }

    @Override
    public long size() {
        return this.heapSize();
    }

    public static void main(String[] args) {
        int i;
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        LOG.info((Object)("vmName=" + runtime.getVmName() + ", vmVendor=" + runtime.getVmVendor() + ", vmVersion=" + runtime.getVmVersion()));
        LOG.info((Object)("vmInputArguments=" + runtime.getInputArguments()));
        DefaultMemStore memstore1 = new DefaultMemStore();
        long size = 0L;
        int count = 10000;
        byte[] fam = Bytes.toBytes((String)"col");
        byte[] qf = Bytes.toBytes((String)"umn");
        byte[] empty = new byte[]{};
        for (i = 0; i < 10000; ++i) {
            size += memstore1.add((Cell)new KeyValue(Bytes.toBytes((int)i), fam, qf, (long)i, empty));
        }
        LOG.info((Object)("memstore1 estimated size=" + size));
        for (i = 0; i < 10000; ++i) {
            size += memstore1.add((Cell)new KeyValue(Bytes.toBytes((int)i), fam, qf, (long)i, empty));
        }
        LOG.info((Object)("memstore1 estimated size (2nd loading of same data)=" + size));
        DefaultMemStore memstore2 = new DefaultMemStore();
        for (int i2 = 0; i2 < 10000; ++i2) {
            size += memstore2.add((Cell)new KeyValue(Bytes.toBytes((int)i2), fam, qf, (long)i2, new byte[i2]));
        }
        LOG.info((Object)("memstore2 estimated size=" + size));
        int seconds = 30;
        LOG.info((Object)"Waiting 30 seconds while heap dump is taken");
        for (int i3 = 0; i3 < 30; ++i3) {
        }
        LOG.info((Object)"Exiting.");
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    static class Section {
        private final CellSkipListSet cellSet;
        private final TimeRangeTracker tracker = new TimeRangeTracker();
        private final AtomicLong heapSize;
        private final MemStoreLAB allocator;

        static Section newSnapshotSection(KeyValue.KVComparator c) {
            return new Section(c, null, 0L);
        }

        static Section newActiveSection(KeyValue.KVComparator c, Configuration conf) {
            return new Section(c, conf, DEEP_OVERHEAD);
        }

        private Section(KeyValue.KVComparator c, Configuration conf, long initHeapSize) {
            this.cellSet = new CellSkipListSet(c);
            this.heapSize = new AtomicLong(initHeapSize);
            if (conf != null && conf.getBoolean(DefaultMemStore.USEMSLAB_KEY, true)) {
                String className = conf.get(DefaultMemStore.MSLAB_CLASS_NAME, HeapMemStoreLAB.class.getName());
                this.allocator = (MemStoreLAB)ReflectionUtils.instantiateWithCustomCtor((String)className, (Class[])new Class[]{Configuration.class}, (Object[])new Object[]{conf});
            } else {
                this.allocator = null;
            }
        }

        CellSkipListSet getCellSkipListSet() {
            return this.cellSet;
        }

        TimeRangeTracker getTimeRangeTracker() {
            return this.tracker;
        }

        AtomicLong getHeapSize() {
            return this.heapSize;
        }

        MemStoreLAB getMemStoreLAB() {
            return this.allocator;
        }
    }

    protected static class MemStoreScanner
    extends NonLazyKeyValueScanner {
        private Cell cellSetNextRow = null;
        private Cell snapshotNextRow = null;
        private Cell cellSetItRow = null;
        private Cell snapshotItRow = null;
        private Iterator<Cell> cellSetIt;
        private Iterator<Cell> snapshotIt;
        private final Section activeAtCreation;
        private final Section snapshotAtCreation;
        private Cell theNext;
        private boolean stopSkippingCellsIfNextRow = false;
        private final long readPoint;
        private final KeyValue.KVComparator comparator;

        MemStoreScanner(Section activeSection, Section snapshotSection, long readPoint, KeyValue.KVComparator c) {
            this.readPoint = readPoint;
            this.comparator = c;
            this.activeAtCreation = activeSection;
            this.snapshotAtCreation = snapshotSection;
            if (this.activeAtCreation.getMemStoreLAB() != null) {
                this.activeAtCreation.getMemStoreLAB().incScannerCount();
            }
            if (this.snapshotAtCreation.getMemStoreLAB() != null) {
                this.snapshotAtCreation.getMemStoreLAB().incScannerCount();
            }
            if (Trace.isTracing() && Trace.currentSpan() != null) {
                Trace.currentSpan().addTimelineAnnotation("Creating MemStoreScanner");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Cell getNext(Iterator<Cell> it) {
            Cell startCell = this.theNext;
            Cell v = null;
            try {
                while (it.hasNext()) {
                    v = it.next();
                    if (v.getSequenceId() <= this.readPoint) {
                        Cell cell = v;
                        return cell;
                    }
                    if (!this.stopSkippingCellsIfNextRow || startCell == null || this.comparator.compareRows(v, startCell) <= 0) continue;
                    Cell cell = null;
                    return cell;
                }
                Cell cell = null;
                return cell;
            }
            finally {
                if (v != null) {
                    if (it == this.snapshotIt) {
                        this.snapshotItRow = v;
                    } else {
                        this.cellSetItRow = v;
                    }
                }
            }
        }

        @Override
        public synchronized boolean seek(Cell key) {
            if (key == null) {
                this.close();
                return false;
            }
            this.cellSetIt = this.activeAtCreation.getCellSkipListSet().tailSet(key).iterator();
            this.snapshotIt = this.snapshotAtCreation.getCellSkipListSet().tailSet(key).iterator();
            this.cellSetItRow = null;
            this.snapshotItRow = null;
            return this.seekInSubLists(key);
        }

        private synchronized boolean seekInSubLists(Cell key) {
            this.cellSetNextRow = this.getNext(this.cellSetIt);
            this.snapshotNextRow = this.getNext(this.snapshotIt);
            this.theNext = this.getLowest(this.cellSetNextRow, this.snapshotNextRow);
            return this.theNext != null;
        }

        @Override
        public synchronized boolean reseek(Cell key) {
            this.cellSetIt = this.activeAtCreation.getCellSkipListSet().tailSet(this.getHighest(key, this.cellSetItRow)).iterator();
            this.snapshotIt = this.snapshotAtCreation.getCellSkipListSet().tailSet(this.getHighest(key, this.snapshotItRow)).iterator();
            return this.seekInSubLists(key);
        }

        @Override
        public synchronized Cell peek() {
            return this.theNext;
        }

        @Override
        public synchronized Cell next() {
            if (this.theNext == null) {
                return null;
            }
            Cell ret = this.theNext;
            if (this.theNext == this.cellSetNextRow) {
                this.cellSetNextRow = this.getNext(this.cellSetIt);
            } else {
                this.snapshotNextRow = this.getNext(this.snapshotIt);
            }
            this.theNext = this.getLowest(this.cellSetNextRow, this.snapshotNextRow);
            return ret;
        }

        private Cell getLowest(Cell first, Cell second) {
            if (first == null && second == null) {
                return null;
            }
            if (first != null && second != null) {
                int compare = this.comparator.compare(first, second);
                return compare <= 0 ? first : second;
            }
            return first != null ? first : second;
        }

        private Cell getHighest(Cell first, Cell second) {
            if (first == null && second == null) {
                return null;
            }
            if (first != null && second != null) {
                int compare = this.comparator.compare(first, second);
                return compare > 0 ? first : second;
            }
            return first != null ? first : second;
        }

        @Override
        public synchronized void close() {
            this.cellSetNextRow = null;
            this.snapshotNextRow = null;
            this.cellSetIt = null;
            this.snapshotIt = null;
            if (this.activeAtCreation != null && this.activeAtCreation.getMemStoreLAB() != null) {
                this.activeAtCreation.getMemStoreLAB().decScannerCount();
            }
            if (this.snapshotAtCreation != null && this.snapshotAtCreation.getMemStoreLAB() != null) {
                this.snapshotAtCreation.getMemStoreLAB().decScannerCount();
            }
            this.cellSetItRow = null;
            this.snapshotItRow = null;
        }

        @Override
        public long getScannerOrder() {
            return Long.MAX_VALUE;
        }

        @Override
        public boolean shouldUseScanner(Scan scan, Store store, long oldestUnexpiredTS) {
            return DefaultMemStore.shouldSeek(this.activeAtCreation.getTimeRangeTracker(), this.snapshotAtCreation.getTimeRangeTracker(), scan, store, oldestUnexpiredTS);
        }

        @Override
        public synchronized boolean backwardSeek(Cell key) {
            this.seek(key);
            if (this.peek() == null || this.comparator.compareRows(this.peek(), key) > 0) {
                return this.seekToPreviousRow(key);
            }
            return true;
        }

        @Override
        public synchronized boolean seekToPreviousRow(Cell originalKey) {
            boolean keepSeeking = false;
            Cell key = originalKey;
            do {
                SortedSet<Cell> snapshotHead;
                Cell snapshotBeforeRow;
                KeyValue firstKeyOnRow = KeyValueUtil.createFirstOnRow((byte[])key.getRowArray(), (int)key.getRowOffset(), (short)key.getRowLength());
                SortedSet<Cell> cellHead = this.activeAtCreation.getCellSkipListSet().headSet((Cell)firstKeyOnRow);
                Cell cellSetBeforeRow = cellHead.isEmpty() ? null : cellHead.last();
                Cell lastCellBeforeRow = this.getHighest(cellSetBeforeRow, snapshotBeforeRow = (snapshotHead = this.snapshotAtCreation.getCellSkipListSet().headSet((Cell)firstKeyOnRow)).isEmpty() ? null : snapshotHead.last());
                if (lastCellBeforeRow == null) {
                    this.theNext = null;
                    return false;
                }
                KeyValue firstKeyOnPreviousRow = KeyValueUtil.createFirstOnRow((byte[])lastCellBeforeRow.getRowArray(), (int)lastCellBeforeRow.getRowOffset(), (short)lastCellBeforeRow.getRowLength());
                this.stopSkippingCellsIfNextRow = true;
                this.seek((Cell)firstKeyOnPreviousRow);
                this.stopSkippingCellsIfNextRow = false;
                if (this.peek() == null || this.comparator.compareRows(this.peek(), (Cell)firstKeyOnPreviousRow) > 0) {
                    keepSeeking = true;
                    key = firstKeyOnPreviousRow;
                    continue;
                }
                keepSeeking = false;
            } while (keepSeeking);
            return true;
        }

        @Override
        public synchronized boolean seekToLastRow() {
            Cell second;
            Cell first = this.activeAtCreation.getCellSkipListSet().isEmpty() ? null : this.activeAtCreation.getCellSkipListSet().last();
            Cell higherCell = this.getHighest(first, second = this.snapshotAtCreation.getCellSkipListSet().isEmpty() ? null : this.snapshotAtCreation.getCellSkipListSet().last());
            if (higherCell == null) {
                return false;
            }
            KeyValue firstCellOnLastRow = KeyValueUtil.createFirstOnRow((byte[])higherCell.getRowArray(), (int)higherCell.getRowOffset(), (short)higherCell.getRowLength());
            if (this.seek((Cell)firstCellOnLastRow)) {
                return true;
            }
            return this.seekToPreviousRow(higherCell);
        }
    }

    private static class Member {
        final Cell cell;
        final NavigableSet<Cell> set;

        Member(NavigableSet<Cell> s, Cell kv) {
            this.cell = kv;
            this.set = s;
        }
    }
}

