/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.stats.Sample;
import com.yammer.metrics.stats.Snapshot;
import java.lang.reflect.Constructor;
import java.text.DecimalFormat;

public final class YammerHistogramUtils {
    private static DecimalFormat DOUBLE_FORMAT = new DecimalFormat("#0.00");

    private YammerHistogramUtils() {
    }

    public static Histogram newHistogram(Sample sample) {
        try {
            Constructor ctor = Histogram.class.getDeclaredConstructor(Sample.class);
            ctor.setAccessible(true);
            return (Histogram)ctor.newInstance(sample);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String getShortHistogramReport(Histogram hist) {
        Snapshot sn = hist.getSnapshot();
        return "mean=" + DOUBLE_FORMAT.format(hist.mean()) + ", min=" + DOUBLE_FORMAT.format(hist.min()) + ", max=" + DOUBLE_FORMAT.format(hist.max()) + ", stdDev=" + DOUBLE_FORMAT.format(hist.stdDev()) + ", 95th=" + DOUBLE_FORMAT.format(sn.get95thPercentile()) + ", 99th=" + DOUBLE_FORMAT.format(sn.get99thPercentile());
    }

    public static String getHistogramReport(Histogram hist) {
        Snapshot sn = hist.getSnapshot();
        return "mean=" + DOUBLE_FORMAT.format(hist.mean()) + ", min=" + DOUBLE_FORMAT.format(hist.min()) + ", max=" + DOUBLE_FORMAT.format(hist.max()) + ", stdDev=" + DOUBLE_FORMAT.format(hist.stdDev()) + ", 50th=" + DOUBLE_FORMAT.format(sn.getMedian()) + ", 75th=" + DOUBLE_FORMAT.format(sn.get75thPercentile()) + ", 95th=" + DOUBLE_FORMAT.format(sn.get95thPercentile()) + ", 99th=" + DOUBLE_FORMAT.format(sn.get99thPercentile()) + ", 99.9th=" + DOUBLE_FORMAT.format(sn.get999thPercentile()) + ", 99.99th=" + DOUBLE_FORMAT.format(sn.getValue(0.9999)) + ", 99.999th=" + DOUBLE_FORMAT.format(sn.getValue(0.99999));
    }

    public static String getPrettyHistogramReport(Histogram h) {
        Snapshot sn = h.getSnapshot();
        return "Mean      = " + DOUBLE_FORMAT.format(h.mean()) + "\n" + "Min       = " + DOUBLE_FORMAT.format(h.min()) + "\n" + "Max       = " + DOUBLE_FORMAT.format(h.max()) + "\n" + "StdDev    = " + DOUBLE_FORMAT.format(h.stdDev()) + "\n" + "50th      = " + DOUBLE_FORMAT.format(sn.getMedian()) + "\n" + "75th      = " + DOUBLE_FORMAT.format(sn.get75thPercentile()) + "\n" + "95th      = " + DOUBLE_FORMAT.format(sn.get95thPercentile()) + "\n" + "99th      = " + DOUBLE_FORMAT.format(sn.get99thPercentile()) + "\n" + "99.9th    = " + DOUBLE_FORMAT.format(sn.get999thPercentile()) + "\n" + "99.99th   = " + DOUBLE_FORMAT.format(sn.getValue(0.9999)) + "\n" + "99.999th  = " + DOUBLE_FORMAT.format(sn.getValue(0.99999));
    }
}

