/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AbstractClientScanner;
import org.apache.hadoop.hbase.client.IsolationLevel;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.client.metrics.ScanMetrics;
import org.apache.hadoop.hbase.io.hfile.BlockCacheFactory;
import org.apache.hadoop.hbase.mob.MobFileCache;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ClientSideRegionScanner
extends AbstractClientScanner {
    private static final Logger LOG = LoggerFactory.getLogger(ClientSideRegionScanner.class);
    private HRegion region;
    RegionScanner scanner;
    List<Cell> values;

    public ClientSideRegionScanner(Configuration conf, FileSystem fs, Path rootDir, TableDescriptor htd, RegionInfo hri, Scan scan, ScanMetrics scanMetrics) throws IOException {
        scan.setIsolationLevel(IsolationLevel.READ_UNCOMMITTED);
        htd = TableDescriptorBuilder.newBuilder((TableDescriptor)htd).setReadOnly(true).build();
        this.region = HRegion.newHRegion(CommonFSUtils.getTableDir((Path)rootDir, (TableName)htd.getTableName()), null, fs, conf, hri, htd, null);
        this.region.setRestoredRegion(true);
        conf.set("hfile.block.cache.policy", "IndexOnlyLRU");
        conf.setIfUnset("hfile.onheap.block.cache.fixed.size", String.valueOf(0x2000000L));
        conf.unset("hbase.bucketcache.ioengine");
        this.region.setBlockCache(BlockCacheFactory.createBlockCache(conf));
        this.region.setMobFileCache(new MobFileCache(conf));
        this.region.initialize();
        this.scanner = this.region.getScanner(scan);
        this.values = new ArrayList<Cell>();
        if (scanMetrics == null) {
            this.initScanMetrics(scan);
        } else {
            this.scanMetrics = scanMetrics;
        }
        this.region.startRegionOperation();
    }

    public Result next() throws IOException {
        this.values.clear();
        this.scanner.nextRaw(this.values);
        if (this.values.isEmpty()) {
            return null;
        }
        Result result = Result.create(this.values);
        if (this.scanMetrics != null) {
            long resultSize = 0L;
            for (Cell cell : this.values) {
                resultSize += (long)PrivateCellUtil.estimatedSerializedSizeOf((Cell)cell);
            }
            this.scanMetrics.countOfBytesInResults.addAndGet(resultSize);
            this.scanMetrics.countOfRowsScanned.incrementAndGet();
        }
        return result;
    }

    public void close() {
        if (this.scanner != null) {
            try {
                this.scanner.close();
                this.scanner = null;
            }
            catch (IOException ex) {
                LOG.warn("Exception while closing scanner", (Throwable)ex);
            }
        }
        if (this.region != null) {
            try {
                this.region.closeRegionOperation();
                this.region.close(true);
                this.region = null;
            }
            catch (IOException ex) {
                LOG.warn("Exception while closing region", (Throwable)ex);
            }
        }
    }

    HRegion getRegion() {
        return this.region;
    }

    public boolean renewLease() {
        throw new UnsupportedOperationException();
    }
}

