/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hbase.ChoreService;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.SplitLogCounters;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.coordination.SplitLogManagerCoordination;
import org.apache.hadoop.hbase.log.HBaseMarkers;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.monitoring.TaskMonitor;
import org.apache.hadoop.hbase.procedure2.util.StringUtils;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class SplitLogManager {
    private static final Logger LOG = LoggerFactory.getLogger(SplitLogManager.class);
    private final MasterServices server;
    private final Configuration conf;
    private final ChoreService choreService;
    public static final int DEFAULT_UNASSIGNED_TIMEOUT = 180000;
    private long unassignedTimeout;
    private long lastTaskCreateTime = Long.MAX_VALUE;
    @VisibleForTesting
    final ConcurrentMap<String, Task> tasks = new ConcurrentHashMap<String, Task>();
    private TimeoutMonitor timeoutMonitor;
    private volatile Set<ServerName> deadWorkers = null;
    private final Object deadWorkersLock = new Object();

    public SplitLogManager(MasterServices master, Configuration conf) throws IOException {
        this.server = master;
        this.conf = conf;
        if (this.server.getCoordinatedStateManager() != null) {
            this.choreService = new ChoreService(master.getServerName().toShortString() + ".splitLogManager.");
            SplitLogManagerCoordination coordination = this.getSplitLogManagerCoordination();
            Set<String> failedDeletions = Collections.synchronizedSet(new HashSet());
            SplitLogManagerCoordination.SplitLogManagerDetails details = new SplitLogManagerCoordination.SplitLogManagerDetails(this.tasks, master, failedDeletions);
            coordination.setDetails(details);
            coordination.init();
            this.unassignedTimeout = conf.getInt("hbase.splitlog.manager.unassigned.timeout", 180000);
            this.timeoutMonitor = new TimeoutMonitor(conf.getInt("hbase.splitlog.manager.timeoutmonitor.period", 1000), master);
            this.choreService.scheduleChore((ScheduledChore)this.timeoutMonitor);
        } else {
            this.choreService = null;
            this.timeoutMonitor = null;
        }
    }

    private SplitLogManagerCoordination getSplitLogManagerCoordination() {
        return this.server.getCoordinatedStateManager().getSplitLogManagerCoordination();
    }

    private FileStatus[] getFileList(List<Path> logDirs, PathFilter filter) throws IOException {
        return SplitLogManager.getFileList(this.conf, logDirs, filter);
    }

    @VisibleForTesting
    public static FileStatus[] getFileList(Configuration conf, List<Path> logDirs, PathFilter filter) throws IOException {
        ArrayList fileStatus = new ArrayList();
        for (Path logDir : logDirs) {
            FileSystem fs = logDir.getFileSystem(conf);
            if (!fs.exists(logDir)) {
                LOG.warn(logDir + " doesn't exist. Nothing to do!");
                continue;
            }
            FileStatus[] logfiles = CommonFSUtils.listStatus((FileSystem)fs, (Path)logDir, (PathFilter)filter);
            if (logfiles == null || logfiles.length == 0) {
                LOG.info("{} dir is empty, no logs to split.", (Object)logDir);
                continue;
            }
            Collections.addAll(fileStatus, logfiles);
        }
        FileStatus[] a = new FileStatus[fileStatus.size()];
        return fileStatus.toArray(a);
    }

    public long splitLogDistributed(Path logDir) throws IOException {
        ArrayList<Path> logDirs = new ArrayList<Path>();
        logDirs.add(logDir);
        return this.splitLogDistributed(logDirs);
    }

    public long splitLogDistributed(List<Path> logDirs) throws IOException {
        if (logDirs.isEmpty()) {
            return 0L;
        }
        HashSet<ServerName> serverNames = new HashSet<ServerName>();
        for (Path logDir : logDirs) {
            try {
                ServerName serverName = AbstractFSWALProvider.getServerNameFromWALDirectoryName(logDir);
                if (serverName == null) continue;
                serverNames.add(serverName);
            }
            catch (IllegalArgumentException e) {
                LOG.warn("Cannot parse server name from " + logDir);
            }
        }
        return this.splitLogDistributed(serverNames, logDirs, null);
    }

    public long splitLogDistributed(Set<ServerName> serverNames, List<Path> logDirs, PathFilter filter) throws IOException {
        Object msg;
        MonitoredTask status = TaskMonitor.get().createStatus("Doing distributed log split in " + logDirs + " for serverName=" + serverNames);
        long totalSize = 0L;
        TaskBatch batch = null;
        long startTime = 0L;
        FileStatus[] logfiles = this.getFileList(logDirs, filter);
        if (logfiles.length != 0) {
            status.setStatus("Checking directory contents...");
            SplitLogCounters.tot_mgr_log_split_batch_start.increment();
            LOG.info("Started splitting " + logfiles.length + " logs in " + logDirs + " for " + serverNames);
            startTime = EnvironmentEdgeManager.currentTime();
            batch = new TaskBatch();
            for (FileStatus lf : logfiles) {
                totalSize += lf.getLen();
                String pathToLog = CommonFSUtils.removeWALRootPath((Path)lf.getPath(), (Configuration)this.conf);
                if (this.enqueueSplitTask(pathToLog, batch)) continue;
                throw new IOException("duplicate log split scheduled for " + lf.getPath());
            }
            this.waitForSplittingCompletion(batch, status);
        }
        if (batch != null && batch.done != batch.installed) {
            batch.isDead = true;
            SplitLogCounters.tot_mgr_log_split_batch_err.increment();
            LOG.warn("error while splitting logs in " + logDirs + " installed = " + batch.installed + " but only " + batch.done + " done");
            msg = "error or interrupted while splitting logs in " + logDirs + " Task = " + batch;
            status.abort((String)msg);
            throw new IOException((String)msg);
        }
        for (Path logDir : logDirs) {
            status.setStatus("Cleaning up log directory...");
            FileSystem fs = logDir.getFileSystem(this.conf);
            try {
                if (fs.exists(logDir) && !fs.delete(logDir, false)) {
                    LOG.warn("Unable to delete log src dir. Ignoring. " + logDir);
                }
            }
            catch (IOException ioe) {
                Object[] files = fs.listStatus(logDir);
                if (files != null && files.length > 0) {
                    LOG.warn("Returning success without actually splitting and deleting all the log files in path " + logDir + ": " + Arrays.toString(files), (Throwable)ioe);
                }
                LOG.warn("Unable to delete log src dir. Ignoring. " + logDir, (Throwable)ioe);
            }
            SplitLogCounters.tot_mgr_log_split_batch_success.increment();
        }
        msg = "Finished splitting (more than or equal to) " + StringUtils.humanSize((double)totalSize) + " (" + totalSize + " bytes) in " + (batch == null ? 0 : batch.installed) + " log files in " + logDirs + " in " + (startTime == 0L ? startTime : EnvironmentEdgeManager.currentTime() - startTime) + "ms";
        status.markComplete((String)msg);
        LOG.info((String)msg);
        return totalSize;
    }

    boolean enqueueSplitTask(String taskname, TaskBatch batch) {
        this.lastTaskCreateTime = EnvironmentEdgeManager.currentTime();
        String task = this.getSplitLogManagerCoordination().prepareTask(taskname);
        Task oldtask = this.createTaskIfAbsent(task, batch);
        if (oldtask == null) {
            this.getSplitLogManagerCoordination().submitTask(task);
            return true;
        }
        return false;
    }

    static int getBatchWaitTimeMillis(int remainingTasks) {
        return remainingTasks < 10 ? 100 : (remainingTasks < 100 ? 1000 : 60000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForSplittingCompletion(TaskBatch batch, MonitoredTask status) {
        TaskBatch taskBatch = batch;
        synchronized (taskBatch) {
            while (batch.done + batch.error != batch.installed) {
                try {
                    int remainingTasks;
                    status.setStatus("Waiting for distributed tasks to finish.  scheduled=" + batch.installed + " done=" + batch.done + " error=" + batch.error);
                    int remaining = batch.installed - (batch.done + batch.error);
                    int actual = this.activeTasks(batch);
                    if (remaining != actual) {
                        LOG.warn("Expected " + remaining + " active tasks, but actually there are " + actual);
                    }
                    if ((remainingTasks = this.getSplitLogManagerCoordination().remainingTasksInCoordination()) >= 0 && actual > remainingTasks) {
                        LOG.warn("Expected at least" + actual + " tasks remaining, but actually there are " + remainingTasks);
                    }
                    if (remainingTasks == 0 || actual == 0) {
                        LOG.warn("No more task remaining, splitting should have completed. Remaining tasks is " + remainingTasks + ", active tasks in map " + actual);
                        if (remainingTasks == 0 && actual == 0) {
                            return;
                        }
                    }
                    batch.wait(SplitLogManager.getBatchWaitTimeMillis(remainingTasks));
                    if (!this.server.isStopped()) continue;
                    LOG.warn("Stopped while waiting for log splits to be completed");
                    return;
                }
                catch (InterruptedException e) {
                    LOG.warn("Interrupted while waiting for log splits to be completed");
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        }
    }

    @VisibleForTesting
    ConcurrentMap<String, Task> getTasks() {
        return this.tasks;
    }

    private int activeTasks(TaskBatch batch) {
        int count = 0;
        for (Task t : this.tasks.values()) {
            if (t.batch != batch || t.status != TerminationStatus.IN_PROGRESS) continue;
            ++count;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Task createTaskIfAbsent(String path, TaskBatch batch) {
        Task newtask = new Task();
        newtask.batch = batch;
        Task oldtask = this.tasks.putIfAbsent(path, newtask);
        if (oldtask == null) {
            ++batch.installed;
            return null;
        }
        Task task = oldtask;
        synchronized (task) {
            if (oldtask.isOrphan()) {
                if (oldtask.status == TerminationStatus.SUCCESS) {
                    return null;
                }
                if (oldtask.status == TerminationStatus.IN_PROGRESS) {
                    oldtask.batch = batch;
                    ++batch.installed;
                    LOG.debug("Previously orphan task " + path + " is now being waited upon");
                    return null;
                }
                while (oldtask.status == TerminationStatus.FAILURE) {
                    LOG.debug("wait for status of task " + path + " to change to DELETED");
                    SplitLogCounters.tot_mgr_wait_for_zk_delete.increment();
                    try {
                        oldtask.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        LOG.warn("Interrupted when waiting for znode delete callback");
                        break;
                    }
                }
                if (oldtask.status != TerminationStatus.DELETED) {
                    LOG.warn("Failure because previously failed task state still present. Waiting for znode delete callback path=" + path);
                    return oldtask;
                }
                Task t = this.tasks.putIfAbsent(path, newtask);
                if (t == null) {
                    ++batch.installed;
                    return null;
                }
                LOG.error(HBaseMarkers.FATAL, "Logic error. Deleted task still present in tasks map");
                assert (false) : "Deleted task still present in tasks map";
                return t;
            }
            LOG.warn("Failure because two threads can't wait for the same task; path=" + path);
            return oldtask;
        }
    }

    public void stop() {
        if (this.choreService != null) {
            this.choreService.shutdown();
        }
        if (this.timeoutMonitor != null) {
            this.timeoutMonitor.cancel(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleDeadWorker(ServerName workerName) {
        Object object = this.deadWorkersLock;
        synchronized (object) {
            if (this.deadWorkers == null) {
                this.deadWorkers = new HashSet<ServerName>(100);
            }
            this.deadWorkers.add(workerName);
        }
        LOG.info("Dead splitlog worker {}", (Object)workerName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleDeadWorkers(Set<ServerName> serverNames) {
        Object object = this.deadWorkersLock;
        synchronized (object) {
            if (this.deadWorkers == null) {
                this.deadWorkers = new HashSet<ServerName>(100);
            }
            this.deadWorkers.addAll(serverNames);
        }
        LOG.info("dead splitlog workers " + serverNames);
    }

    public static enum TerminationStatus {
        IN_PROGRESS("in_progress"),
        SUCCESS("success"),
        FAILURE("failure"),
        DELETED("deleted");

        final String statusMsg;

        private TerminationStatus(String msg) {
            this.statusMsg = msg;
        }

        public String toString() {
            return this.statusMsg;
        }
    }

    public static enum ResubmitDirective {
        CHECK,
        FORCE;

    }

    private class TimeoutMonitor
    extends ScheduledChore {
        private long lastLog;

        public TimeoutMonitor(int period, Stoppable stopper) {
            super("SplitLogManager Timeout Monitor", stopper, period);
            this.lastLog = 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void chore() {
            Set<String> failedDeletions;
            long now;
            Task task;
            Set localDeadWorkers;
            if (SplitLogManager.this.server.getCoordinatedStateManager() == null) {
                return;
            }
            int resubmitted = 0;
            int unassigned = 0;
            int tot = 0;
            boolean found_assigned_task = false;
            Iterator iterator = SplitLogManager.this.deadWorkersLock;
            synchronized (iterator) {
                localDeadWorkers = SplitLogManager.this.deadWorkers;
                SplitLogManager.this.deadWorkers = null;
            }
            for (Map.Entry e : SplitLogManager.this.tasks.entrySet()) {
                String path = (String)e.getKey();
                task = (Task)e.getValue();
                ServerName cur_worker = task.cur_worker_name;
                ++tot;
                if (task.isUnassigned()) {
                    ++unassigned;
                    continue;
                }
                found_assigned_task = true;
                if (localDeadWorkers != null && localDeadWorkers.contains(cur_worker)) {
                    SplitLogCounters.tot_mgr_resubmit_dead_server_task.increment();
                    if (SplitLogManager.this.getSplitLogManagerCoordination().resubmitTask(path, task, ResubmitDirective.FORCE)) {
                        ++resubmitted;
                        continue;
                    }
                    SplitLogManager.this.handleDeadWorker(cur_worker);
                    LOG.warn("Failed to resubmit task " + path + " owned by dead " + cur_worker + ", will retry.");
                    continue;
                }
                if (!SplitLogManager.this.getSplitLogManagerCoordination().resubmitTask(path, task, ResubmitDirective.CHECK)) continue;
                ++resubmitted;
            }
            if (tot > 0 && (now = EnvironmentEdgeManager.currentTime()) > this.lastLog + 5000L) {
                this.lastLog = now;
                LOG.info("total=" + tot + ", unassigned=" + unassigned + ", tasks=" + SplitLogManager.this.tasks);
            }
            if (resubmitted > 0) {
                LOG.info("resubmitted " + resubmitted + " out of " + tot + " tasks");
            }
            if (tot > 0 && !found_assigned_task && EnvironmentEdgeManager.currentTime() - SplitLogManager.this.lastTaskCreateTime > SplitLogManager.this.unassignedTimeout) {
                for (Map.Entry e : SplitLogManager.this.tasks.entrySet()) {
                    String key = (String)e.getKey();
                    task = (Task)e.getValue();
                    if (!task.isUnassigned() || task.status == TerminationStatus.FAILURE) continue;
                    SplitLogManager.this.getSplitLogManagerCoordination().checkTaskStillAvailable(key);
                }
                SplitLogManager.this.getSplitLogManagerCoordination().checkTasks();
                SplitLogCounters.tot_mgr_resubmit_unassigned.increment();
                LOG.debug("resubmitting unassigned task(s) after timeout");
            }
            if ((failedDeletions = SplitLogManager.this.getSplitLogManagerCoordination().getDetails().getFailedDeletions()).size() > 0) {
                ArrayList<String> tmpPaths = new ArrayList<String>(failedDeletions);
                for (String tmpPath : tmpPaths) {
                    SplitLogManager.this.getSplitLogManagerCoordination().deleteTask(tmpPath);
                }
                failedDeletions.removeAll(tmpPaths);
            }
        }
    }

    @InterfaceAudience.Private
    public static class Task {
        public volatile long last_update;
        public volatile int last_version = -1;
        public volatile ServerName cur_worker_name;
        public volatile TaskBatch batch;
        public volatile TerminationStatus status;
        public volatile AtomicInteger incarnation = new AtomicInteger(0);
        public final AtomicInteger unforcedResubmits = new AtomicInteger();
        public volatile boolean resubmitThresholdReached;

        public String toString() {
            return "last_update = " + this.last_update + " last_version = " + this.last_version + " cur_worker_name = " + this.cur_worker_name + " status = " + (Object)((Object)this.status) + " incarnation = " + this.incarnation + " resubmits = " + this.unforcedResubmits.get() + " batch = " + this.batch;
        }

        public Task() {
            this.status = TerminationStatus.IN_PROGRESS;
            this.setUnassigned();
        }

        public boolean isOrphan() {
            return this.batch == null || this.batch.isDead;
        }

        public boolean isUnassigned() {
            return this.cur_worker_name == null;
        }

        public void heartbeatNoDetails(long time) {
            this.last_update = time;
        }

        public void heartbeat(long time, int version, ServerName worker) {
            this.last_version = version;
            this.last_update = time;
            this.cur_worker_name = worker;
        }

        public void setUnassigned() {
            this.cur_worker_name = null;
            this.last_update = -1L;
        }
    }

    @InterfaceAudience.Private
    public static class TaskBatch {
        public int installed = 0;
        public int done = 0;
        public int error = 0;
        public volatile boolean isDead = false;

        public String toString() {
            return "installed = " + this.installed + " done = " + this.done + " error = " + this.error;
        }
    }
}

