/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.merge;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.AbstractFileMergeOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.merge.MergeFileWork;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;

public class MergeFileMapper
extends MapReduceBase
implements Mapper {
    public static final Log LOG = LogFactory.getLog((String)"MergeFileMapper");
    private static final String PLAN_KEY = "__MAP_PLAN__";
    private JobConf jc;
    private Operator<? extends OperatorDesc> op;
    private AbstractFileMergeOperator mergeOp;
    private Object[] row;
    private boolean abort;

    public void configure(JobConf job) {
        this.jc = job;
        MapWork mapWork = Utilities.getMapWork((Configuration)job);
        try {
            if (mapWork instanceof MergeFileWork) {
                MergeFileWork mfWork = (MergeFileWork)mapWork;
                String alias = mfWork.getAliasToWork().keySet().iterator().next();
                this.op = mfWork.getAliasToWork().get(alias);
                if (!(this.op instanceof AbstractFileMergeOperator)) {
                    this.abort = true;
                    throw new RuntimeException("Merge file work's top operator should be an instance of AbstractFileMergeOperator");
                }
            } else {
                this.abort = true;
                throw new RuntimeException("Map work should be a merge file work.");
            }
            this.mergeOp = (AbstractFileMergeOperator)this.op;
            this.mergeOp.initializeOp((Configuration)this.jc);
            this.row = new Object[2];
            this.abort = false;
        }
        catch (HiveException e) {
            this.abort = true;
            throw new RuntimeException(e);
        }
    }

    public void close() throws IOException {
        try {
            this.mergeOp.closeOp(this.abort);
        }
        catch (HiveException e) {
            throw new IOException(e);
        }
        super.close();
    }

    public void map(Object key, Object value, OutputCollector output, Reporter reporter) throws IOException {
        this.row[0] = key;
        this.row[1] = value;
        try {
            this.mergeOp.process(this.row, 0);
        }
        catch (HiveException e) {
            this.abort = true;
            throw new IOException(e);
        }
    }
}

