/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFDateDiffColCol;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFDateDiffColScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFDateDiffScalarCol;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorConverter;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableIntObjectInspector;
import org.apache.hadoop.io.IntWritable;

@Description(name="datediff", value="_FUNC_(date1, date2) - Returns the number of days between date1 and date2", extended="date1 and date2 are strings in the format 'yyyy-MM-dd HH:mm:ss' or 'yyyy-MM-dd'. The time parts are ignored.If date1 is earlier than date2, the result is negative.\nExample:\n   > SELECT _FUNC_('2009-07-30', '2009-07-31') FROM src LIMIT 1;\n  1")
@VectorizedExpressions(value={VectorUDFDateDiffColScalar.class, VectorUDFDateDiffColCol.class, VectorUDFDateDiffScalarCol.class})
public class GenericUDFDateDiff
extends GenericUDF {
    private transient SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
    private transient ObjectInspectorConverters.Converter inputConverter1;
    private transient ObjectInspectorConverters.Converter inputConverter2;
    private IntWritable output = new IntWritable();
    private transient PrimitiveObjectInspector.PrimitiveCategory inputType1;
    private transient PrimitiveObjectInspector.PrimitiveCategory inputType2;
    private IntWritable result = new IntWritable();

    public GenericUDFDateDiff() {
        this.formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 2) {
            throw new UDFArgumentLengthException("datediff() requires 2 argument, got " + arguments.length);
        }
        this.inputConverter1 = this.checkArguments(arguments, 0);
        this.inputConverter2 = this.checkArguments(arguments, 1);
        this.inputType1 = ((PrimitiveObjectInspector)arguments[0]).getPrimitiveCategory();
        this.inputType2 = ((PrimitiveObjectInspector)arguments[1]).getPrimitiveCategory();
        WritableIntObjectInspector outputOI = PrimitiveObjectInspectorFactory.writableIntObjectInspector;
        return outputOI;
    }

    public IntWritable evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        this.output = this.evaluate(this.convertToDate(this.inputType1, this.inputConverter1, arguments[0]), this.convertToDate(this.inputType2, this.inputConverter2, arguments[1]));
        return this.output;
    }

    @Override
    public String getDisplayString(String[] children) {
        return this.getStandardDisplayString("datediff", children);
    }

    private Date convertToDate(PrimitiveObjectInspector.PrimitiveCategory inputType, ObjectInspectorConverters.Converter converter, GenericUDF.DeferredObject argument) throws HiveException {
        assert (converter != null);
        assert (argument != null);
        if (argument.get() == null) {
            return null;
        }
        Date date = new Date();
        switch (inputType) {
            case STRING: 
            case VARCHAR: 
            case CHAR: {
                String dateString = converter.convert(argument.get()).toString();
                try {
                    date = this.formatter.parse(dateString);
                    break;
                }
                catch (ParseException e) {
                    return null;
                }
            }
            case TIMESTAMP: {
                Timestamp ts = ((TimestampWritable)converter.convert(argument.get())).getTimestamp();
                date.setTime(ts.getTime());
                break;
            }
            case DATE: {
                DateWritable dw = (DateWritable)converter.convert(argument.get());
                date = dw.get();
                break;
            }
            default: {
                throw new UDFArgumentException("TO_DATE() only takes STRING/TIMESTAMP/DATEWRITABLE types, got " + (Object)((Object)inputType));
            }
        }
        return date;
    }

    private ObjectInspectorConverters.Converter checkArguments(ObjectInspector[] arguments, int i) throws UDFArgumentException {
        ObjectInspectorConverters.Converter converter;
        if (arguments[i].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(0, "Only primitive type arguments are accepted but " + arguments[i].getTypeName() + " is passed. as first arguments");
        }
        PrimitiveObjectInspector.PrimitiveCategory inputType = ((PrimitiveObjectInspector)arguments[i]).getPrimitiveCategory();
        switch (inputType) {
            case STRING: 
            case VARCHAR: 
            case CHAR: {
                converter = ObjectInspectorConverters.getConverter((ObjectInspector)((PrimitiveObjectInspector)arguments[i]), (ObjectInspector)PrimitiveObjectInspectorFactory.writableStringObjectInspector);
                break;
            }
            case TIMESTAMP: {
                converter = new PrimitiveObjectInspectorConverter.TimestampConverter((PrimitiveObjectInspector)arguments[i], PrimitiveObjectInspectorFactory.writableTimestampObjectInspector);
                break;
            }
            case DATE: {
                converter = ObjectInspectorConverters.getConverter((ObjectInspector)((PrimitiveObjectInspector)arguments[i]), (ObjectInspector)PrimitiveObjectInspectorFactory.writableDateObjectInspector);
                break;
            }
            default: {
                throw new UDFArgumentException(" DATEDIFF() only takes STRING/TIMESTAMP/DATEWRITABLE types as " + (i + 1) + "-th argument, got " + (Object)((Object)inputType));
            }
        }
        return converter;
    }

    private IntWritable evaluate(Date date, Date date2) {
        if (date == null || date2 == null) {
            return null;
        }
        long diffInMilliSeconds = date.getTime() - date2.getTime();
        this.result.set((int)(diffInMilliSeconds / 86400000L));
        return this.result;
    }
}

