/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.cache;

import com.google.common.annotations.VisibleForTesting;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.hive.common.io.Allocator;
import org.apache.hadoop.hive.common.io.DataCache;
import org.apache.hadoop.hive.common.io.DiskRange;
import org.apache.hadoop.hive.common.io.DiskRangeList;
import org.apache.hadoop.hive.common.io.encoded.MemoryBuffer;
import org.apache.hadoop.hive.llap.cache.BufferUsageManager;
import org.apache.hadoop.hive.llap.cache.EvictionAwareAllocator;
import org.apache.hadoop.hive.llap.cache.LlapDataBuffer;
import org.apache.hadoop.hive.llap.cache.LlapOomDebugDump;
import org.apache.hadoop.hive.llap.cache.LowLevelCache;
import org.apache.hadoop.hive.llap.cache.LowLevelCacheCounters;
import org.apache.hadoop.hive.llap.cache.LowLevelCachePolicy;
import org.apache.hadoop.hive.llap.io.api.impl.LlapIoImpl;
import org.apache.hadoop.hive.llap.metrics.LlapDaemonCacheMetrics;

public class LowLevelCacheImpl
implements LowLevelCache,
BufferUsageManager,
LlapOomDebugDump {
    private static final int DEFAULT_CLEANUP_INTERVAL = 600;
    private final EvictionAwareAllocator allocator;
    private final AtomicInteger newEvictions = new AtomicInteger(0);
    private Thread cleanupThread = null;
    private final ConcurrentHashMap<Object, FileCache> cache = new ConcurrentHashMap();
    private final LowLevelCachePolicy cachePolicy;
    private final long cleanupInterval;
    private final LlapDaemonCacheMetrics metrics;
    private final boolean doAssumeGranularBlocks;
    private static final ByteBuffer fakeBuf = ByteBuffer.wrap(new byte[1]);

    public LowLevelCacheImpl(LlapDaemonCacheMetrics metrics, LowLevelCachePolicy cachePolicy, EvictionAwareAllocator allocator, boolean doAssumeGranularBlocks) {
        this(metrics, cachePolicy, allocator, doAssumeGranularBlocks, 600L);
    }

    @VisibleForTesting
    LowLevelCacheImpl(LlapDaemonCacheMetrics metrics, LowLevelCachePolicy cachePolicy, EvictionAwareAllocator allocator, boolean doAssumeGranularBlocks, long cleanupInterval) {
        LlapIoImpl.LOG.info("Low level cache; cleanup interval {} sec", (Object)cleanupInterval);
        this.cachePolicy = cachePolicy;
        this.allocator = allocator;
        this.cleanupInterval = cleanupInterval;
        this.metrics = metrics;
        this.doAssumeGranularBlocks = doAssumeGranularBlocks;
    }

    public void startThreads() {
        if (this.cleanupInterval < 0L) {
            return;
        }
        this.cleanupThread = new CleanupThread(this.cleanupInterval);
        this.cleanupThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DiskRangeList getFileData(Object fileKey, DiskRangeList ranges, long baseOffset, DataCache.DiskRangeListFactory factory, LowLevelCacheCounters qfCounters, DataCache.BooleanRef gotAllData) {
        DiskRangeList current;
        if (ranges == null) {
            return null;
        }
        DiskRangeList prev = ranges.prev;
        FileCache subCache = this.cache.get(fileKey);
        if (subCache == null || !subCache.incRef()) {
            long totalMissed = ranges.getTotalLength();
            this.metrics.incrCacheRequestedBytes(totalMissed);
            if (qfCounters != null) {
                qfCounters.recordCacheMiss(totalMissed);
            }
            if (prev != null && gotAllData != null) {
                gotAllData.value = false;
            }
            return ranges;
        }
        try {
            if (prev == null) {
                prev = new DiskRangeList.MutateHelper(ranges);
            }
            if (gotAllData != null) {
                gotAllData.value = true;
            }
            current = ranges;
            while (current != null) {
                this.metrics.incrCacheRequestedBytes(current.getLength());
                DiskRangeList next = current.next;
                this.getOverlappingRanges(baseOffset, current, subCache.cache, factory, gotAllData);
                current = next;
            }
        }
        finally {
            subCache.decRef();
        }
        if (qfCounters != null) {
            current = prev.next;
            long bytesHit = 0L;
            long bytesMissed = 0L;
            while (current != null) {
                if (current.hasData()) {
                    bytesHit += (long)current.getLength();
                } else {
                    bytesMissed += (long)current.getLength();
                }
                current = current.next;
            }
            qfCounters.recordCacheHit(bytesHit);
            qfCounters.recordCacheMiss(bytesMissed);
        }
        return prev.next;
    }

    private void getOverlappingRanges(long baseOffset, DiskRangeList currentNotCached, ConcurrentSkipListMap<Long, LlapDataBuffer> cache, DataCache.DiskRangeListFactory factory, DataCache.BooleanRef gotAllData) {
        Long prevOffset;
        long absOffset = currentNotCached.getOffset() + baseOffset;
        if (!this.doAssumeGranularBlocks && (prevOffset = cache.floorKey(absOffset)) != null) {
            absOffset = prevOffset;
        }
        Iterator matches = cache.subMap((Object)absOffset, (Object)(currentNotCached.getEnd() + baseOffset)).entrySet().iterator();
        long cacheEnd = -1L;
        while (matches.hasNext()) {
            assert (currentNotCached != null);
            Map.Entry e = matches.next();
            LlapDataBuffer buffer = (LlapDataBuffer)e.getValue();
            long requestedLength = currentNotCached.getLength();
            if (LlapIoImpl.LOCKING_LOGGER.isTraceEnabled()) {
                LlapIoImpl.LOCKING_LOGGER.trace("Locking {} during get", (Object)buffer);
            }
            if (!this.lockBuffer(buffer, true)) {
                matches.remove();
                if (gotAllData == null) continue;
                gotAllData.value = false;
                continue;
            }
            long cacheOffset = (Long)e.getKey();
            if (cacheEnd > cacheOffset) {
                throw new AssertionError((Object)("Cache has overlapping buffers: " + cacheEnd + ") and [" + cacheOffset + ", " + (cacheOffset + (long)buffer.declaredCachedLength) + ")"));
            }
            cacheEnd = cacheOffset + (long)buffer.declaredCachedLength;
            DiskRangeList currentCached = factory.createCacheChunk((MemoryBuffer)buffer, cacheOffset - baseOffset, cacheEnd - baseOffset);
            currentNotCached = this.addCachedBufferToIter(currentNotCached, currentCached, gotAllData);
            this.metrics.incrCacheHitBytes(Math.min(requestedLength, (long)currentCached.getLength()));
        }
        if (currentNotCached != null) {
            assert (!currentNotCached.hasData());
            if (gotAllData != null) {
                gotAllData.value = false;
            }
        }
    }

    private DiskRangeList addCachedBufferToIter(DiskRangeList currentNotCached, DiskRangeList currentCached, DataCache.BooleanRef gotAllData) {
        if (currentNotCached.getOffset() >= currentCached.getOffset()) {
            if (currentNotCached.getEnd() <= currentCached.getEnd()) {
                currentNotCached.replaceSelfWith(currentCached);
                return null;
            }
            currentNotCached.insertPartBefore(currentCached);
            return currentNotCached;
        }
        if (gotAllData != null) {
            gotAllData.value = false;
        }
        assert (currentNotCached.getOffset() < currentCached.getOffset() || currentNotCached.prev == null || currentNotCached.prev.getEnd() <= currentCached.getOffset());
        long endOffset = currentNotCached.getEnd();
        currentNotCached.insertPartAfter(currentCached);
        if (endOffset <= currentCached.getEnd()) {
            return null;
        }
        currentNotCached = new DiskRangeList(currentCached.getEnd(), endOffset);
        currentCached.insertAfter(currentNotCached);
        return currentNotCached;
    }

    private boolean lockBuffer(LlapDataBuffer buffer, boolean doNotifyPolicy) {
        int rc = buffer.incRef();
        if (rc > 0) {
            this.metrics.incrCacheNumLockedBuffers();
        }
        if (doNotifyPolicy && rc == 1) {
            this.cachePolicy.notifyLock(buffer);
        }
        return rc > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] putFileData(Object fileKey, DiskRange[] ranges, MemoryBuffer[] buffers, long baseOffset, LowLevelCache.Priority priority, LowLevelCacheCounters qfCounters) {
        long[] result = null;
        assert (buffers.length == ranges.length);
        FileCache subCache = this.getOrAddFileSubCache(fileKey);
        try {
            block3: for (int i = 0; i < ranges.length; ++i) {
                LlapDataBuffer buffer = (LlapDataBuffer)buffers[i];
                if (LlapIoImpl.LOCKING_LOGGER.isTraceEnabled()) {
                    LlapIoImpl.LOCKING_LOGGER.trace("Locking {} at put time", (Object)buffer);
                }
                boolean canLock = this.lockBuffer(buffer, false);
                assert (canLock);
                long offset = ranges[i].getOffset() + baseOffset;
                assert (buffer.declaredCachedLength == -1);
                buffer.declaredCachedLength = ranges[i].getLength();
                while (true) {
                    LlapDataBuffer oldVal;
                    if ((oldVal = subCache.cache.putIfAbsent(offset, buffer)) == null) {
                        this.cachePolicy.cache(buffer, priority);
                        if (qfCounters == null) continue block3;
                        qfCounters.recordAllocBytes(buffer.byteBuffer.remaining(), buffer.allocSize);
                        continue block3;
                    }
                    if (LlapIoImpl.CACHE_LOGGER.isTraceEnabled()) {
                        LlapIoImpl.CACHE_LOGGER.trace("Trying to cache when the chunk is already cached for {}@{} (base {}); old {}, new {}", new Object[]{fileKey, offset, baseOffset, oldVal, buffer});
                    }
                    if (LlapIoImpl.LOCKING_LOGGER.isTraceEnabled()) {
                        LlapIoImpl.LOCKING_LOGGER.trace("Locking {} due to cache collision", (Object)oldVal);
                    }
                    if (this.lockBuffer(oldVal, true)) {
                        if (oldVal.declaredCachedLength != buffer.declaredCachedLength) {
                            throw new RuntimeException("Found a block with different length at the same offset: " + oldVal.declaredCachedLength + " vs " + buffer.declaredCachedLength + " @" + offset + " (base " + baseOffset + ")");
                        }
                        if (LlapIoImpl.LOCKING_LOGGER.isTraceEnabled()) {
                            LlapIoImpl.LOCKING_LOGGER.trace("Unlocking {} due to cache collision with {}", (Object)buffer, (Object)oldVal);
                        }
                        this.unlockBuffer(buffer, false);
                        buffers[i] = oldVal;
                        if (result == null) {
                            result = new long[LowLevelCacheImpl.align64(buffers.length) >>> 6];
                        }
                        int n = i >>> 6;
                        result[n] = result[n] | (long)(1 << (i & 0x3F));
                        continue block3;
                    }
                    subCache.cache.remove(offset, oldVal);
                }
            }
        }
        finally {
            subCache.decRef();
        }
        return result;
    }

    private FileCache getOrAddFileSubCache(Object fileKey) {
        FileCache newSubCache = null;
        while (true) {
            FileCache oldSubCache;
            FileCache subCache;
            if ((subCache = this.cache.get(fileKey)) != null) {
                if (subCache.incRef()) {
                    return subCache;
                }
                if (newSubCache == null) {
                    newSubCache = new FileCache();
                    newSubCache.incRef();
                }
                if (!this.cache.replace(fileKey, subCache, newSubCache)) continue;
                return newSubCache;
            }
            if (newSubCache == null) {
                newSubCache = new FileCache();
                newSubCache.incRef();
            }
            if ((oldSubCache = this.cache.putIfAbsent(fileKey, newSubCache)) == null) {
                return newSubCache;
            }
            if (oldSubCache.incRef()) {
                return oldSubCache;
            }
            if (this.cache.replace(fileKey, oldSubCache, newSubCache)) break;
        }
        return newSubCache;
    }

    private static int align64(int number) {
        return number + 63 & 0xFFFFFFC0;
    }

    @Override
    public void decRefBuffer(MemoryBuffer buffer) {
        this.unlockBuffer((LlapDataBuffer)buffer, true);
    }

    @Override
    public void decRefBuffers(List<MemoryBuffer> cacheBuffers) {
        for (MemoryBuffer b : cacheBuffers) {
            this.unlockBuffer((LlapDataBuffer)b, true);
        }
    }

    private void unlockBuffer(LlapDataBuffer buffer, boolean handleLastDecRef) {
        boolean isLastDecref;
        boolean bl = isLastDecref = buffer.decRef() == 0;
        if (handleLastDecRef && isLastDecref) {
            if (buffer.declaredCachedLength != -1) {
                this.cachePolicy.notifyUnlock(buffer);
            } else {
                if (LlapIoImpl.CACHE_LOGGER.isTraceEnabled()) {
                    LlapIoImpl.CACHE_LOGGER.trace("Deallocating {} that was not cached", (Object)buffer);
                }
                this.allocator.deallocate(buffer);
            }
        }
        this.metrics.decrCacheNumLockedBuffers();
    }

    public static LlapDataBuffer allocateFake() {
        LlapDataBuffer fake = new LlapDataBuffer();
        fake.initialize(-1, fakeBuf, 0, 1);
        return fake;
    }

    @Override
    public final void notifyEvicted(MemoryBuffer buffer) {
        this.allocator.deallocateEvicted(buffer);
        this.newEvictions.incrementAndGet();
    }

    @Override
    public boolean incRefBuffer(MemoryBuffer buffer) {
        return this.lockBuffer((LlapDataBuffer)buffer, false);
    }

    @Override
    public Allocator getAllocator() {
        return this.allocator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String debugDumpForOom() {
        StringBuilder sb = new StringBuilder("File cache state ");
        for (Map.Entry<Object, FileCache> e : this.cache.entrySet()) {
            if (!e.getValue().incRef()) continue;
            try {
                sb.append("\n  file " + e.getKey());
                for (Map.Entry e2 : e.getValue().cache.entrySet()) {
                    if (((LlapDataBuffer)e2.getValue()).incRef() < 0) continue;
                    try {
                        sb.append("\n    [").append(e2.getKey()).append(", ").append((Long)e2.getKey() + (long)((LlapDataBuffer)e2.getValue()).declaredCachedLength).append(") => ").append(((LlapDataBuffer)e2.getValue()).toString()).append(" alloc ").append(((LlapDataBuffer)e2.getValue()).byteBuffer.position());
                    }
                    finally {
                        ((LlapDataBuffer)e2.getValue()).decRef();
                    }
                }
            }
            finally {
                e.getValue().decRef();
            }
        }
        return sb.toString();
    }

    private final class CleanupThread
    extends Thread {
        private final long approxCleanupIntervalSec;

        public CleanupThread(long cleanupInterval) {
            super("Llap low level cache cleanup thread");
            this.approxCleanupIntervalSec = cleanupInterval;
            this.setDaemon(true);
            this.setPriority(1);
        }

        @Override
        public void run() {
            try {
                while (true) {
                    this.doOneCleanupRound();
                }
            }
            catch (InterruptedException ex) {
                LlapIoImpl.LOG.warn("Cleanup thread has been interrupted");
                Thread.currentThread().interrupt();
            }
            catch (Throwable t) {
                LlapIoImpl.LOG.error("Cleanup has failed; the thread will now exit", t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doOneCleanupRound() throws InterruptedException {
            int evictionsSinceLast;
            while ((evictionsSinceLast = LowLevelCacheImpl.this.newEvictions.getAndSet(0)) <= 0) {
                AtomicInteger atomicInteger = LowLevelCacheImpl.this.newEvictions;
                synchronized (atomicInteger) {
                    LowLevelCacheImpl.this.newEvictions.wait(10000L);
                }
            }
            long endTime = System.nanoTime() + this.approxCleanupIntervalSec * 1000000000L;
            int leftToCheck = 0;
            for (FileCache fc : LowLevelCacheImpl.this.cache.values()) {
                leftToCheck += fc.cache.size();
            }
            Iterator iter = LowLevelCacheImpl.this.cache.entrySet().iterator();
            boolean isPastEndTime = false;
            while (iter.hasNext()) {
                FileCache fc = (FileCache)iter.next().getValue();
                if (!fc.incRef()) {
                    throw new AssertionError((Object)"Something other than cleanup is removing elements from map");
                }
                Iterator subIter = fc.cache.entrySet().iterator();
                boolean isEmpty = true;
                while (subIter.hasNext()) {
                    long time = -1L;
                    isPastEndTime = isPastEndTime || (time = System.nanoTime()) >= endTime;
                    Thread.sleep(leftToCheck <= 0 || isPastEndTime ? 1L : (endTime - time) / (1000000L * (long)leftToCheck));
                    if (((LlapDataBuffer)subIter.next().getValue()).isInvalid()) {
                        subIter.remove();
                    } else {
                        isEmpty = false;
                    }
                    --leftToCheck;
                }
                if (!isEmpty) {
                    fc.decRef();
                    continue;
                }
                if (!fc.startEvicting()) continue;
                if (fc.cache.isEmpty()) {
                    fc.commitEvicting();
                    iter.remove();
                    continue;
                }
                fc.abortEvicting();
            }
        }
    }

    private static class FileCache {
        private static final int EVICTED_REFCOUNT = -1;
        private static final int EVICTING_REFCOUNT = -2;
        private final ConcurrentSkipListMap<Long, LlapDataBuffer> cache = new ConcurrentSkipListMap();
        private final AtomicInteger refCount = new AtomicInteger(0);

        private FileCache() {
        }

        boolean incRef() {
            while (true) {
                int value;
                if ((value = this.refCount.get()) == -1) {
                    return false;
                }
                if (value == -2) continue;
                assert (value >= 0);
                if (this.refCount.compareAndSet(value, value + 1)) break;
            }
            return true;
        }

        void decRef() {
            int value = this.refCount.decrementAndGet();
            if (value < 0) {
                throw new AssertionError((Object)("Unexpected refCount " + value));
            }
        }

        boolean startEvicting() {
            int value;
            do {
                if ((value = this.refCount.get()) == 1) continue;
                return false;
            } while (!this.refCount.compareAndSet(value, -2));
            return true;
        }

        void commitEvicting() {
            boolean result = this.refCount.compareAndSet(-2, -1);
            assert (result);
        }

        void abortEvicting() {
            boolean result = this.refCount.compareAndSet(-2, 0);
            assert (result);
        }
    }
}

