/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.daemon.impl;

import java.util.Comparator;
import org.apache.hadoop.hive.llap.daemon.impl.PriorityBlockingDeque;

public class EvictingPriorityBlockingQueue<E> {
    private final PriorityBlockingDeque<E> deque;
    private final Comparator<E> comparator;

    public EvictingPriorityBlockingQueue(Comparator<E> comparator, int maxSize) {
        this.deque = new PriorityBlockingDeque<E>(comparator, maxSize);
        this.comparator = comparator;
    }

    public synchronized E offer(E e) {
        if (this.deque.offer(e)) {
            return null;
        }
        E last = this.deque.peekLast();
        if (this.comparator.compare(e, last) < 0) {
            this.deque.removeLast();
            this.deque.offer(e);
            return last;
        }
        return e;
    }

    public synchronized boolean isEmpty() {
        return this.deque.isEmpty();
    }

    public synchronized E peek() {
        return this.deque.peek();
    }

    public synchronized E take() throws InterruptedException {
        return this.deque.take();
    }

    public synchronized boolean remove(E e) {
        return this.deque.remove(e);
    }

    public synchronized int size() {
        return this.deque.size();
    }

    public synchronized String toString() {
        return this.deque.toString();
    }
}

