/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.io.api.impl;

import com.google.common.base.Joiner;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.ConsumerFeedback;
import org.apache.hadoop.hive.llap.counters.FragmentCountersMap;
import org.apache.hadoop.hive.llap.counters.LlapIOCounters;
import org.apache.hadoop.hive.llap.counters.QueryFragmentCounters;
import org.apache.hadoop.hive.llap.io.api.impl.ColumnVectorBatch;
import org.apache.hadoop.hive.llap.io.api.impl.LlapIoImpl;
import org.apache.hadoop.hive.llap.io.decode.ColumnVectorProducer;
import org.apache.hadoop.hive.llap.io.decode.ReadPipeline;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedInputFormatInterface;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatchCtx;
import org.apache.hadoop.hive.ql.io.CombineHiveInputFormat;
import org.apache.hadoop.hive.ql.io.LlapAwareSplit;
import org.apache.hadoop.hive.ql.io.SelfDescribingInputFormatInterface;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.orc.encoded.Consumer;
import org.apache.hadoop.hive.ql.io.sarg.ConvertAstToSearchArg;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hive.common.util.HiveStringUtils;
import org.apache.orc.TypeDescription;
import org.apache.orc.impl.SchemaEvolution;
import org.apache.tez.common.counters.TezCounters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LlapInputFormat
implements InputFormat<NullWritable, VectorizedRowBatch>,
VectorizedInputFormatInterface,
SelfDescribingInputFormatInterface,
CombineHiveInputFormat.AvoidSplitCombination {
    private final InputFormat sourceInputFormat;
    private final CombineHiveInputFormat.AvoidSplitCombination sourceASC;
    private final ColumnVectorProducer cvp;
    private final ListeningExecutorService executor;
    private final String hostName;

    LlapInputFormat(InputFormat sourceInputFormat, ColumnVectorProducer cvp, ListeningExecutorService executor) {
        assert (sourceInputFormat instanceof OrcInputFormat);
        this.executor = executor;
        this.cvp = cvp;
        this.sourceInputFormat = sourceInputFormat;
        this.sourceASC = sourceInputFormat instanceof CombineHiveInputFormat.AvoidSplitCombination ? (CombineHiveInputFormat.AvoidSplitCombination)sourceInputFormat : null;
        this.hostName = HiveStringUtils.getHostname();
    }

    public RecordReader<NullWritable, VectorizedRowBatch> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        boolean useLlapIo = true;
        if (split instanceof LlapAwareSplit) {
            useLlapIo = ((LlapAwareSplit)split).canUseLlapIo();
        }
        if (useLlapIo) {
            useLlapIo = Utilities.checkLlapIOSupportedTypes((Configuration)job);
        }
        if (!useLlapIo) {
            LlapIoImpl.LOG.warn("Not using LLAP IO for an unsupported split: " + split);
            return this.sourceInputFormat.getRecordReader(split, job, reporter);
        }
        boolean isVectorMode = Utilities.getUseVectorizedInputFileFormat((Configuration)job);
        if (!isVectorMode) {
            LlapIoImpl.LOG.error("No LLAP IO in non-vectorized mode");
            throw new UnsupportedOperationException("No LLAP IO in non-vectorized mode");
        }
        FileSplit fileSplit = (FileSplit)split;
        reporter.setStatus(fileSplit.toString());
        try {
            List includedCols = ColumnProjectionUtils.isReadAllColumns((Configuration)job) ? null : ColumnProjectionUtils.getReadColumnIDs((Configuration)job);
            LlapRecordReader rr = new LlapRecordReader(job, fileSplit, includedCols, this.hostName);
            if (!rr.init()) {
                return this.sourceInputFormat.getRecordReader(split, job, reporter);
            }
            return rr;
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        return this.sourceInputFormat.getSplits(job, numSplits);
    }

    public boolean shouldSkipCombine(Path path, Configuration conf) throws IOException {
        return this.sourceASC == null ? false : this.sourceASC.shouldSkipCombine(path, conf);
    }

    private class LlapRecordReader
    implements RecordReader<NullWritable, VectorizedRowBatch>,
    Consumer<ColumnVectorBatch> {
        private final Logger LOG = LoggerFactory.getLogger(LlapRecordReader.class);
        private final FileSplit split;
        private final List<Integer> columnIds;
        private final SearchArgument sarg;
        private final String[] columnNames;
        private final VectorizedRowBatchCtx rbCtx;
        private final boolean[] columnsToIncludeTruncated;
        private final Object[] partitionValues;
        private final LinkedList<ColumnVectorBatch> pendingData = new LinkedList();
        private ColumnVectorBatch lastCvb = null;
        private boolean isFirst = true;
        private Throwable pendingError = null;
        private boolean isDone = false;
        private final boolean isClosed = false;
        private final ConsumerFeedback<ColumnVectorBatch> feedback;
        private final QueryFragmentCounters counters;
        private long firstReturnTime;
        private final JobConf jobConf;
        private final TypeDescription fileSchema;
        private final boolean[] includedColumns;
        private final ReadPipeline rp;

        public LlapRecordReader(JobConf job, FileSplit split, List<Integer> includedCols, String hostName) throws IOException, HiveException {
            this.jobConf = job;
            this.split = split;
            this.columnIds = includedCols;
            this.sarg = ConvertAstToSearchArg.createFromConf((Configuration)job);
            this.columnNames = ColumnProjectionUtils.getReadColumnNames((Configuration)job);
            String dagId = job.get("tez.mapreduce.dag.index");
            String vertexId = job.get("tez.mapreduce.vertex.index");
            String taskId = job.get("tez.mapreduce.task.index");
            String taskAttemptId = job.get("tez.mapreduce.task.attempt.index");
            TezCounters taskCounters = null;
            if (dagId != null && vertexId != null && taskId != null && taskAttemptId != null) {
                String fullId = Joiner.on((char)'_').join((Object)dagId, (Object)vertexId, new Object[]{taskId, taskAttemptId});
                taskCounters = FragmentCountersMap.getCountersForFragment(fullId);
                this.LOG.info("Received dagid_vertexid_taskid_attempid: {}", (Object)fullId);
            } else {
                this.LOG.warn("Not using tez counters as some identifier is null. dagId: {} vertexId: {} taskId: {} taskAttempId: {}", new Object[]{dagId, vertexId, taskId, taskAttemptId});
            }
            this.counters = new QueryFragmentCounters((Configuration)job, taskCounters);
            this.counters.setDesc(QueryFragmentCounters.Desc.MACHINE, hostName);
            MapWork mapWork = Utilities.getMapWork((Configuration)job);
            this.rbCtx = mapWork.getVectorizedRowBatchCtx();
            this.columnsToIncludeTruncated = this.rbCtx.getColumnsToIncludeTruncated((Configuration)job);
            int partitionColumnCount = this.rbCtx.getPartitionColumnCount();
            if (partitionColumnCount > 0) {
                this.partitionValues = new Object[partitionColumnCount];
                VectorizedRowBatchCtx.getPartitionValues((VectorizedRowBatchCtx)this.rbCtx, (Configuration)job, (FileSplit)split, (Object[])this.partitionValues);
            } else {
                this.partitionValues = null;
            }
            this.feedback = this.rp = LlapInputFormat.this.cvp.createReadPipeline(this, split, this.columnIds, this.sarg, this.columnNames, this.counters);
            this.fileSchema = this.rp.getFileSchema();
            this.includedColumns = this.rp.getIncludedColumns();
        }

        public boolean init() {
            boolean isAcidScan = HiveConf.getBoolVar((Configuration)this.jobConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_TRANSACTIONAL_TABLE_SCAN);
            TypeDescription readerSchema = OrcInputFormat.getDesiredRowTypeDescr((Configuration)this.jobConf, (boolean)isAcidScan, (int)Integer.MAX_VALUE);
            SchemaEvolution schemaEvolution = new SchemaEvolution(this.fileSchema, readerSchema, this.includedColumns);
            for (Integer colId : this.columnIds) {
                if (schemaEvolution.isPPDSafeConversion(colId.intValue())) continue;
                LlapIoImpl.LOG.warn("Unsupported schema evolution! Disabling Llap IO for {}", (Object)this.split);
                return false;
            }
            ListenableFuture future = LlapInputFormat.this.executor.submit(this.rp.getReadCallable());
            Futures.addCallback((ListenableFuture)future, (FutureCallback)new UncaughtErrorHandler());
            return true;
        }

        public boolean next(NullWritable key, VectorizedRowBatch value) throws IOException {
            assert (value != null);
            boolean wasFirst = this.isFirst;
            if (this.isFirst) {
                if (this.partitionValues != null) {
                    this.rbCtx.addPartitionColsToBatch(value, this.partitionValues);
                }
                this.isFirst = false;
            }
            ColumnVectorBatch cvb = null;
            try {
                cvb = this.nextCvb();
            }
            catch (InterruptedException e) {
                this.feedback.stop();
                throw new IOException(e);
            }
            if (cvb == null) {
                if (wasFirst) {
                    this.firstReturnTime = this.counters.startTimeCounter();
                }
                this.counters.incrTimeCounter(LlapIOCounters.CONSUMER_TIME_NS, this.firstReturnTime);
                return false;
            }
            if (this.columnIds.size() != cvb.cols.length) {
                throw new RuntimeException("Unexpected number of columns, VRB has " + this.columnIds.size() + " included, but the reader returned " + cvb.cols.length);
            }
            for (int i = 0; i < cvb.cols.length; ++i) {
                cvb.swapColumnVector(i, value.cols, this.columnIds.get(i));
            }
            value.selectedInUse = false;
            value.size = cvb.size;
            if (wasFirst) {
                this.firstReturnTime = this.counters.startTimeCounter();
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ColumnVectorBatch nextCvb() throws InterruptedException, IOException {
            boolean isFirst;
            boolean bl = isFirst = this.lastCvb == null;
            if (!isFirst) {
                this.feedback.returnData(this.lastCvb);
            }
            LinkedList<ColumnVectorBatch> linkedList = this.pendingData;
            synchronized (linkedList) {
                boolean doLogBlocking;
                boolean bl2 = doLogBlocking = LlapIoImpl.LOG.isTraceEnabled() && this.isNothingToReport();
                if (doLogBlocking) {
                    LlapIoImpl.LOG.trace("next will block");
                }
                while (this.isNothingToReport()) {
                    this.pendingData.wait(100L);
                }
                if (doLogBlocking) {
                    LlapIoImpl.LOG.trace("next is unblocked");
                }
                this.rethrowErrorIfAny();
                this.lastCvb = this.pendingData.poll();
            }
            if (LlapIoImpl.LOG.isTraceEnabled() && this.lastCvb != null) {
                LlapIoImpl.LOG.trace("Processing will receive vector {}", (Object)this.lastCvb);
            }
            return this.lastCvb;
        }

        private boolean isNothingToReport() {
            return !this.isDone && this.pendingData.isEmpty() && this.pendingError == null;
        }

        public NullWritable createKey() {
            return NullWritable.get();
        }

        public VectorizedRowBatch createValue() {
            return this.rbCtx.createVectorizedRowBatch(this.columnsToIncludeTruncated);
        }

        public long getPos() throws IOException {
            return -1L;
        }

        public void close() throws IOException {
            if (LlapIoImpl.LOG.isTraceEnabled()) {
                LlapIoImpl.LOG.trace("close called; closed {}, done {}, err {}, pending {}", new Object[]{false, this.isDone, this.pendingError, this.pendingData.size()});
            }
            LlapIoImpl.LOG.info("Llap counters: {}", (Object)this.counters);
            this.feedback.stop();
            this.rethrowErrorIfAny();
        }

        private void rethrowErrorIfAny() throws IOException {
            if (this.pendingError == null) {
                return;
            }
            if (this.pendingError instanceof IOException) {
                throw (IOException)this.pendingError;
            }
            throw new IOException(this.pendingError);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setDone() {
            if (LlapIoImpl.LOG.isTraceEnabled()) {
                LlapIoImpl.LOG.trace("setDone called; closed {}, done {}, err {}, pending {}", new Object[]{false, this.isDone, this.pendingError, this.pendingData.size()});
            }
            LinkedList<ColumnVectorBatch> linkedList = this.pendingData;
            synchronized (linkedList) {
                this.isDone = true;
                this.pendingData.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void consumeData(ColumnVectorBatch data) {
            if (LlapIoImpl.LOG.isTraceEnabled()) {
                LlapIoImpl.LOG.trace("consume called; closed {}, done {}, err {}, pending {}", new Object[]{false, this.isDone, this.pendingError, this.pendingData.size()});
            }
            LinkedList<ColumnVectorBatch> linkedList = this.pendingData;
            synchronized (linkedList) {
                this.pendingData.add(data);
                this.pendingData.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setError(Throwable t) {
            this.counters.incrCounter(LlapIOCounters.NUM_ERRORS);
            LlapIoImpl.LOG.info("setError called; closed {}, done {}, err {}, pending {}", new Object[]{false, this.isDone, this.pendingError, this.pendingData.size()});
            assert (t != null);
            LinkedList<ColumnVectorBatch> linkedList = this.pendingData;
            synchronized (linkedList) {
                this.pendingError = t;
                this.pendingData.notifyAll();
            }
        }

        public float getProgress() throws IOException {
            return 0.0f;
        }

        private final class UncaughtErrorHandler
        implements FutureCallback<Void> {
            private UncaughtErrorHandler() {
            }

            public void onSuccess(Void result) {
            }

            public void onFailure(Throwable t) {
                LlapIoImpl.LOG.error("Unhandled error from reader thread " + t.getMessage());
                LlapRecordReader.this.setError(t);
            }
        }
    }
}

