/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.io.encoded;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.hadoop.hive.llap.io.api.impl.LlapIoImpl;
import org.apache.hadoop.hive.llap.io.encoded.PassThruOffsetReader;
import org.apache.hadoop.hive.llap.io.encoded.SerDeEncodedDataReader;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapred.LineRecordReader;
import org.apache.hadoop.mapred.RecordReader;

final class LineRrOffsetReader
extends PassThruOffsetReader {
    private static final Method isCompressedMethod;
    private final LineRecordReader lrReader;
    private final LongWritable posKey;

    static SerDeEncodedDataReader.ReaderWithOffsets create(LineRecordReader sourceReader) {
        if (isCompressedMethod == null) {
            return new PassThruOffsetReader((RecordReader)sourceReader);
        }
        Boolean isCompressed = null;
        try {
            isCompressed = (Boolean)isCompressedMethod.invoke((Object)sourceReader, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            LlapIoImpl.LOG.error("Cannot check the reader for compression; offsets not supported", (Throwable)e);
            return new PassThruOffsetReader((RecordReader)sourceReader);
        }
        if (isCompressed.booleanValue()) {
            LlapIoImpl.LOG.info("Reader is compressed; offsets not supported");
            return new PassThruOffsetReader((RecordReader)sourceReader);
        }
        return new LineRrOffsetReader(sourceReader);
    }

    private LineRrOffsetReader(LineRecordReader sourceReader) {
        super((RecordReader)sourceReader);
        this.lrReader = sourceReader;
        this.posKey = (LongWritable)this.key;
    }

    @Override
    public long getCurrentRowStartOffset() {
        return this.posKey.get();
    }

    @Override
    public long getCurrentRowEndOffset() {
        try {
            return this.lrReader.getPos();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean hasOffsets() {
        return true;
    }

    static {
        Method isCompressedMethodTmp;
        try {
            isCompressedMethodTmp = LineRecordReader.class.getDeclaredMethod("isCompressedInput", new Class[0]);
            isCompressedMethodTmp.setAccessible(true);
        }
        catch (Throwable t) {
            isCompressedMethodTmp = null;
            LlapIoImpl.LOG.warn("Cannot get LineRecordReader isCompressedInput method", t);
        }
        isCompressedMethod = isCompressedMethodTmp;
    }
}

