/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.io.metadata;

public class CompressionBuffer {
    private int stripePos;
    private int rowGroupPos;
    private long startOffset;
    private long length;
    private int uncompressedOffset;
    private int consume;
    private int consumeBits;
    private boolean lastRowGroup;

    private CompressionBuffer(int sp, int rgp, long s, long len, int u, int c, int cb, boolean last) {
        this.stripePos = sp;
        this.rowGroupPos = rgp;
        this.startOffset = s;
        this.length = len;
        this.uncompressedOffset = u;
        this.consume = c;
        this.consumeBits = cb;
        this.lastRowGroup = last;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static class Builder {
        private int stripePos;
        private int rowGroupPos;
        private long startOffset;
        private long length;
        private int offsetWithinBuffer;
        private int consume;
        private int consumeBits;
        private boolean lastRowGroup;

        private Builder() {
        }

        public Builder setStripePosition(int stripePos) {
            this.stripePos = stripePos;
            return this;
        }

        public Builder setRowGroupPosition(int rowGroupPos) {
            this.rowGroupPos = rowGroupPos;
            return this;
        }

        public Builder setStartOffset(long startOffset) {
            this.startOffset = startOffset;
            return this;
        }

        public Builder setLength(long length) {
            this.length = length;
            return this;
        }

        public Builder setOffsetWithInBuffer(int offsetWithInBuffer) {
            this.offsetWithinBuffer = offsetWithInBuffer;
            return this;
        }

        public Builder consumeRuns(int consume) {
            this.consume = consume;
            return this;
        }

        public Builder consumeBits(int consumeBits) {
            this.consumeBits = consumeBits;
            return this;
        }

        public Builder setLastRowGroup(boolean lastRowGroup) {
            this.lastRowGroup = lastRowGroup;
            return this;
        }

        public CompressionBuffer build() {
            return new CompressionBuffer(this.stripePos, this.rowGroupPos, this.startOffset, this.length, this.offsetWithinBuffer, this.consume, this.consumeBits, this.lastRowGroup);
        }
    }
}

