/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.orc.impl;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.io.DiskRange;
import org.apache.hadoop.hive.common.io.DiskRangeList;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.io.sarg.PredicateLeaf;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.ql.util.TimestampUtils;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.io.Text;
import org.apache.hive.orc.BloomFilterIO;
import org.apache.hive.orc.BooleanColumnStatistics;
import org.apache.hive.orc.ColumnStatistics;
import org.apache.hive.orc.CompressionCodec;
import org.apache.hive.orc.DataReader;
import org.apache.hive.orc.DateColumnStatistics;
import org.apache.hive.orc.DecimalColumnStatistics;
import org.apache.hive.orc.DoubleColumnStatistics;
import org.apache.hive.orc.IntegerColumnStatistics;
import org.apache.hive.orc.OrcConf;
import org.apache.hive.orc.OrcProto;
import org.apache.hive.orc.Reader;
import org.apache.hive.orc.RecordReader;
import org.apache.hive.orc.StringColumnStatistics;
import org.apache.hive.orc.StripeInformation;
import org.apache.hive.orc.TimestampColumnStatistics;
import org.apache.hive.orc.TypeDescription;
import org.apache.hive.orc.impl.BufferChunk;
import org.apache.hive.orc.impl.ColumnStatisticsImpl;
import org.apache.hive.orc.impl.DataReaderProperties;
import org.apache.hive.orc.impl.InStream;
import org.apache.hive.orc.impl.OrcIndex;
import org.apache.hive.orc.impl.PositionProvider;
import org.apache.hive.orc.impl.ReaderImpl;
import org.apache.hive.orc.impl.RecordReaderUtils;
import org.apache.hive.orc.impl.SchemaEvolution;
import org.apache.hive.orc.impl.StreamName;
import org.apache.hive.orc.impl.TreeReaderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordReaderImpl
implements RecordReader {
    static final Logger LOG = LoggerFactory.getLogger(RecordReaderImpl.class);
    private static final boolean isLogDebugEnabled = LOG.isDebugEnabled();
    private static final Object UNKNOWN_VALUE = new Object();
    protected final Path path;
    private final long firstRow;
    private final List<StripeInformation> stripes = new ArrayList<StripeInformation>();
    private OrcProto.StripeFooter stripeFooter;
    private final long totalRowCount;
    private final CompressionCodec codec;
    protected final TypeDescription schema;
    private final List<OrcProto.Type> types;
    private final int bufferSize;
    private final SchemaEvolution evolution;
    private final boolean[] included;
    private final long rowIndexStride;
    private long rowInStripe = 0L;
    private int currentStripe = -1;
    private long rowBaseInStripe = 0L;
    private long rowCountInStripe = 0L;
    private final Map<StreamName, InStream> streams = new HashMap<StreamName, InStream>();
    DiskRangeList bufferChunks = null;
    private final TreeReaderFactory.TreeReader reader;
    private final OrcProto.RowIndex[] indexes;
    private final OrcProto.BloomFilterIndex[] bloomFilterIndices;
    private final SargApplier sargApp;
    private boolean[] includedRowGroups = null;
    private final DataReader dataReader;
    private static final String TRANSLATED_SARG_SEPARATOR = "_";

    static int findColumns(SchemaEvolution evolution, String columnName) {
        TypeDescription readerSchema = evolution.getReaderBaseSchema();
        List<String> fieldNames = readerSchema.getFieldNames();
        List<TypeDescription> children = readerSchema.getChildren();
        for (int i = 0; i < fieldNames.size(); ++i) {
            if (!columnName.equals(fieldNames.get(i))) continue;
            TypeDescription result = evolution.getFileType(children.get(i).getId());
            return result == null ? -1 : result.getId();
        }
        return -1;
    }

    public static int[] mapSargColumnsToOrcInternalColIdx(List<PredicateLeaf> sargLeaves, SchemaEvolution evolution) {
        int[] result = new int[sargLeaves.size()];
        Arrays.fill(result, -1);
        for (int i = 0; i < result.length; ++i) {
            String colName = sargLeaves.get(i).getColumnName();
            result[i] = RecordReaderImpl.findColumns(evolution, colName);
        }
        return result;
    }

    protected RecordReaderImpl(ReaderImpl fileReader, Reader.Options options) throws IOException {
        boolean[] readerIncluded = options.getInclude();
        if (options.getSchema() == null) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Reader schema not provided -- using file schema " + fileReader.getSchema());
            }
            this.evolution = new SchemaEvolution(fileReader.getSchema(), readerIncluded);
        } else {
            this.evolution = new SchemaEvolution(fileReader.getSchema(), options.getSchema(), readerIncluded);
            if (LOG.isDebugEnabled() && this.evolution.hasConversion()) {
                LOG.debug("ORC file " + fileReader.path.toString() + " has data type conversion --\nreader schema: " + options.getSchema().toString() + "\nfile schema:   " + fileReader.getSchema());
            }
        }
        this.schema = this.evolution.getReaderSchema();
        this.path = fileReader.path;
        this.codec = fileReader.codec;
        this.types = fileReader.types;
        this.bufferSize = fileReader.bufferSize;
        this.rowIndexStride = fileReader.rowIndexStride;
        SearchArgument sarg = options.getSearchArgument();
        this.sargApp = sarg != null && this.rowIndexStride != 0L ? new SargApplier(sarg, options.getColumnNames(), this.rowIndexStride, this.evolution) : null;
        long rows = 0L;
        long skippedRows = 0L;
        long offset = options.getOffset();
        long maxOffset = options.getMaxOffset();
        for (StripeInformation stripe : fileReader.getStripes()) {
            long stripeStart = stripe.getOffset();
            if (offset > stripeStart) {
                skippedRows += stripe.getNumberOfRows();
                continue;
            }
            if (stripeStart >= maxOffset) continue;
            this.stripes.add(stripe);
            rows += stripe.getNumberOfRows();
        }
        Boolean zeroCopy = options.getUseZeroCopy();
        if (zeroCopy == null) {
            zeroCopy = OrcConf.USE_ZEROCOPY.getBoolean(fileReader.conf);
        }
        this.dataReader = options.getDataReader() != null ? options.getDataReader() : RecordReaderUtils.createDefaultDataReader(DataReaderProperties.builder().withBufferSize(this.bufferSize).withCompression(fileReader.compressionKind).withFileSystem(fileReader.fileSystem).withPath(fileReader.path).withTypeCount(this.types.size()).withZeroCopy(zeroCopy).build());
        this.dataReader.open();
        this.firstRow = skippedRows;
        this.totalRowCount = rows;
        Boolean skipCorrupt = options.getSkipCorruptRecords();
        if (skipCorrupt == null) {
            skipCorrupt = OrcConf.SKIP_CORRUPT_DATA.getBoolean(fileReader.conf);
        }
        this.reader = TreeReaderFactory.createTreeReader(this.evolution.getReaderSchema(), this.evolution, readerIncluded, skipCorrupt);
        this.indexes = new OrcProto.RowIndex[this.types.size()];
        this.bloomFilterIndices = new OrcProto.BloomFilterIndex[this.types.size()];
        this.included = this.evolution.getFileIncluded();
        this.advanceToNextRow(this.reader, 0L, true);
    }

    public OrcProto.StripeFooter readStripeFooter(StripeInformation stripe) throws IOException {
        return this.dataReader.readStripeFooter(stripe);
    }

    static <T> Location compareToRange(Comparable<T> point, T min, T max) {
        int minCompare = point.compareTo(min);
        if (minCompare < 0) {
            return Location.BEFORE;
        }
        if (minCompare == 0) {
            return Location.MIN;
        }
        int maxCompare = point.compareTo(max);
        if (maxCompare > 0) {
            return Location.AFTER;
        }
        if (maxCompare == 0) {
            return Location.MAX;
        }
        return Location.MIDDLE;
    }

    static Object getMax(ColumnStatistics index) {
        if (index instanceof IntegerColumnStatistics) {
            return ((IntegerColumnStatistics)index).getMaximum();
        }
        if (index instanceof DoubleColumnStatistics) {
            return ((DoubleColumnStatistics)index).getMaximum();
        }
        if (index instanceof StringColumnStatistics) {
            return ((StringColumnStatistics)index).getMaximum();
        }
        if (index instanceof DateColumnStatistics) {
            return ((DateColumnStatistics)index).getMaximum();
        }
        if (index instanceof DecimalColumnStatistics) {
            return ((DecimalColumnStatistics)index).getMaximum();
        }
        if (index instanceof TimestampColumnStatistics) {
            return ((TimestampColumnStatistics)index).getMaximum();
        }
        if (index instanceof BooleanColumnStatistics) {
            if (((BooleanColumnStatistics)index).getTrueCount() != 0L) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return null;
    }

    static Object getMin(ColumnStatistics index) {
        if (index instanceof IntegerColumnStatistics) {
            return ((IntegerColumnStatistics)index).getMinimum();
        }
        if (index instanceof DoubleColumnStatistics) {
            return ((DoubleColumnStatistics)index).getMinimum();
        }
        if (index instanceof StringColumnStatistics) {
            return ((StringColumnStatistics)index).getMinimum();
        }
        if (index instanceof DateColumnStatistics) {
            return ((DateColumnStatistics)index).getMinimum();
        }
        if (index instanceof DecimalColumnStatistics) {
            return ((DecimalColumnStatistics)index).getMinimum();
        }
        if (index instanceof TimestampColumnStatistics) {
            return ((TimestampColumnStatistics)index).getMinimum();
        }
        if (index instanceof BooleanColumnStatistics) {
            if (((BooleanColumnStatistics)index).getFalseCount() != 0L) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        return UNKNOWN_VALUE;
    }

    static SearchArgument.TruthValue evaluatePredicateProto(OrcProto.ColumnStatistics statsProto, PredicateLeaf predicate, OrcProto.BloomFilter bloomFilter) {
        ColumnStatisticsImpl cs = ColumnStatisticsImpl.deserialize(statsProto);
        Object minValue = RecordReaderImpl.getMin(cs);
        Object maxValue = RecordReaderImpl.getMax(cs);
        BloomFilterIO bf = null;
        if (bloomFilter != null) {
            bf = new BloomFilterIO(bloomFilter);
        }
        return RecordReaderImpl.evaluatePredicateRange(predicate, minValue, maxValue, cs.hasNull(), bf);
    }

    public static SearchArgument.TruthValue evaluatePredicate(ColumnStatistics stats, PredicateLeaf predicate, BloomFilterIO bloomFilter) {
        Object minValue = RecordReaderImpl.getMin(stats);
        Object maxValue = RecordReaderImpl.getMax(stats);
        return RecordReaderImpl.evaluatePredicateRange(predicate, minValue, maxValue, stats.hasNull(), bloomFilter);
    }

    static SearchArgument.TruthValue evaluatePredicateRange(PredicateLeaf predicate, Object min, Object max, boolean hasNull, BloomFilterIO bloomFilter) {
        SearchArgument.TruthValue result;
        if (min == null) {
            if (predicate.getOperator() == PredicateLeaf.Operator.IS_NULL) {
                return SearchArgument.TruthValue.YES;
            }
            return SearchArgument.TruthValue.NULL;
        }
        if (min == UNKNOWN_VALUE) {
            return SearchArgument.TruthValue.YES_NO_NULL;
        }
        if (min != null && min instanceof Timestamp) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Not using predication pushdown on {} because it doesn't include ORC-135.", (Object)predicate.getColumnName());
            }
            return SearchArgument.TruthValue.YES_NO_NULL;
        }
        Object baseObj = predicate.getLiteral();
        try {
            Object minValue = RecordReaderImpl.getBaseObjectForComparison(predicate.getType(), min);
            Object maxValue = RecordReaderImpl.getBaseObjectForComparison(predicate.getType(), max);
            Object predObj = RecordReaderImpl.getBaseObjectForComparison(predicate.getType(), baseObj);
            result = RecordReaderImpl.evaluatePredicateMinMax(predicate, predObj, minValue, maxValue, hasNull);
            if (RecordReaderImpl.shouldEvaluateBloomFilter(predicate, result, bloomFilter)) {
                result = RecordReaderImpl.evaluatePredicateBloomFilter(predicate, predObj, bloomFilter, hasNull);
            }
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                String statsType = min == null ? (max == null ? "null" : max.getClass().getSimpleName()) : min.getClass().getSimpleName();
                String predicateType = baseObj == null ? "null" : baseObj.getClass().getSimpleName();
                String reason = e.getClass().getSimpleName() + " when evaluating predicate. Skipping ORC PPD. Exception: " + e.getMessage() + " StatsType: " + statsType + " PredicateType: " + predicateType;
                LOG.debug(reason);
            }
            result = predicate.getOperator().equals((Object)PredicateLeaf.Operator.NULL_SAFE_EQUALS) || !hasNull ? SearchArgument.TruthValue.YES_NO : SearchArgument.TruthValue.YES_NO_NULL;
        }
        return result;
    }

    private static boolean shouldEvaluateBloomFilter(PredicateLeaf predicate, SearchArgument.TruthValue result, BloomFilterIO bloomFilter) {
        return bloomFilter != null && result != SearchArgument.TruthValue.NO_NULL && result != SearchArgument.TruthValue.NO && (predicate.getOperator().equals((Object)PredicateLeaf.Operator.EQUALS) || predicate.getOperator().equals((Object)PredicateLeaf.Operator.NULL_SAFE_EQUALS) || predicate.getOperator().equals((Object)PredicateLeaf.Operator.IN));
    }

    private static SearchArgument.TruthValue evaluatePredicateMinMax(PredicateLeaf predicate, Object predObj, Object minValue, Object maxValue, boolean hasNull) {
        switch (predicate.getOperator()) {
            case NULL_SAFE_EQUALS: {
                Location loc = RecordReaderImpl.compareToRange((Comparable)predObj, minValue, maxValue);
                if (loc == Location.BEFORE || loc == Location.AFTER) {
                    return SearchArgument.TruthValue.NO;
                }
                return SearchArgument.TruthValue.YES_NO;
            }
            case EQUALS: {
                Location loc = RecordReaderImpl.compareToRange((Comparable)predObj, minValue, maxValue);
                if (minValue.equals(maxValue) && loc == Location.MIN) {
                    return hasNull ? SearchArgument.TruthValue.YES_NULL : SearchArgument.TruthValue.YES;
                }
                if (loc == Location.BEFORE || loc == Location.AFTER) {
                    return hasNull ? SearchArgument.TruthValue.NO_NULL : SearchArgument.TruthValue.NO;
                }
                return hasNull ? SearchArgument.TruthValue.YES_NO_NULL : SearchArgument.TruthValue.YES_NO;
            }
            case LESS_THAN: {
                Location loc = RecordReaderImpl.compareToRange((Comparable)predObj, minValue, maxValue);
                if (loc == Location.AFTER) {
                    return hasNull ? SearchArgument.TruthValue.YES_NULL : SearchArgument.TruthValue.YES;
                }
                if (loc == Location.BEFORE || loc == Location.MIN) {
                    return hasNull ? SearchArgument.TruthValue.NO_NULL : SearchArgument.TruthValue.NO;
                }
                return hasNull ? SearchArgument.TruthValue.YES_NO_NULL : SearchArgument.TruthValue.YES_NO;
            }
            case LESS_THAN_EQUALS: {
                Location loc = RecordReaderImpl.compareToRange((Comparable)predObj, minValue, maxValue);
                if (loc == Location.AFTER || loc == Location.MAX) {
                    return hasNull ? SearchArgument.TruthValue.YES_NULL : SearchArgument.TruthValue.YES;
                }
                if (loc == Location.BEFORE) {
                    return hasNull ? SearchArgument.TruthValue.NO_NULL : SearchArgument.TruthValue.NO;
                }
                return hasNull ? SearchArgument.TruthValue.YES_NO_NULL : SearchArgument.TruthValue.YES_NO;
            }
            case IN: {
                if (minValue.equals(maxValue)) {
                    for (Object arg : predicate.getLiteralList()) {
                        predObj = RecordReaderImpl.getBaseObjectForComparison(predicate.getType(), arg);
                        Location loc = RecordReaderImpl.compareToRange((Comparable)predObj, minValue, maxValue);
                        if (loc != Location.MIN) continue;
                        return hasNull ? SearchArgument.TruthValue.YES_NULL : SearchArgument.TruthValue.YES;
                    }
                    return hasNull ? SearchArgument.TruthValue.NO_NULL : SearchArgument.TruthValue.NO;
                }
                for (Object arg : predicate.getLiteralList()) {
                    predObj = RecordReaderImpl.getBaseObjectForComparison(predicate.getType(), arg);
                    Location loc = RecordReaderImpl.compareToRange((Comparable)predObj, minValue, maxValue);
                    if (loc != Location.MIN && loc != Location.MIDDLE && loc != Location.MAX) continue;
                    return hasNull ? SearchArgument.TruthValue.YES_NO_NULL : SearchArgument.TruthValue.YES_NO;
                }
                return hasNull ? SearchArgument.TruthValue.NO_NULL : SearchArgument.TruthValue.NO;
            }
            case BETWEEN: {
                List args = predicate.getLiteralList();
                Object predObj1 = RecordReaderImpl.getBaseObjectForComparison(predicate.getType(), args.get(0));
                Location loc = RecordReaderImpl.compareToRange((Comparable)predObj1, minValue, maxValue);
                if (loc == Location.BEFORE || loc == Location.MIN) {
                    Object predObj2 = RecordReaderImpl.getBaseObjectForComparison(predicate.getType(), args.get(1));
                    Location loc2 = RecordReaderImpl.compareToRange((Comparable)predObj2, minValue, maxValue);
                    if (loc2 == Location.AFTER || loc2 == Location.MAX) {
                        return hasNull ? SearchArgument.TruthValue.YES_NULL : SearchArgument.TruthValue.YES;
                    }
                    if (loc2 == Location.BEFORE) {
                        return hasNull ? SearchArgument.TruthValue.NO_NULL : SearchArgument.TruthValue.NO;
                    }
                    return hasNull ? SearchArgument.TruthValue.YES_NO_NULL : SearchArgument.TruthValue.YES_NO;
                }
                if (loc == Location.AFTER) {
                    return hasNull ? SearchArgument.TruthValue.NO_NULL : SearchArgument.TruthValue.NO;
                }
                return hasNull ? SearchArgument.TruthValue.YES_NO_NULL : SearchArgument.TruthValue.YES_NO;
            }
            case IS_NULL: {
                return hasNull ? SearchArgument.TruthValue.YES_NO : SearchArgument.TruthValue.NO;
            }
        }
        return hasNull ? SearchArgument.TruthValue.YES_NO_NULL : SearchArgument.TruthValue.YES_NO;
    }

    private static SearchArgument.TruthValue evaluatePredicateBloomFilter(PredicateLeaf predicate, Object predObj, BloomFilterIO bloomFilter, boolean hasNull) {
        switch (predicate.getOperator()) {
            case NULL_SAFE_EQUALS: {
                return RecordReaderImpl.checkInBloomFilter(bloomFilter, predObj, false);
            }
            case EQUALS: {
                return RecordReaderImpl.checkInBloomFilter(bloomFilter, predObj, hasNull);
            }
            case IN: {
                for (Object arg : predicate.getLiteralList()) {
                    Object predObjItem = RecordReaderImpl.getBaseObjectForComparison(predicate.getType(), arg);
                    SearchArgument.TruthValue result = RecordReaderImpl.checkInBloomFilter(bloomFilter, predObjItem, hasNull);
                    if (result != SearchArgument.TruthValue.YES_NO_NULL && result != SearchArgument.TruthValue.YES_NO) continue;
                    return result;
                }
                return hasNull ? SearchArgument.TruthValue.NO_NULL : SearchArgument.TruthValue.NO;
            }
        }
        return hasNull ? SearchArgument.TruthValue.YES_NO_NULL : SearchArgument.TruthValue.YES_NO;
    }

    private static SearchArgument.TruthValue checkInBloomFilter(BloomFilterIO bf, Object predObj, boolean hasNull) {
        SearchArgument.TruthValue result;
        SearchArgument.TruthValue truthValue = result = hasNull ? SearchArgument.TruthValue.NO_NULL : SearchArgument.TruthValue.NO;
        if (predObj instanceof Long) {
            if (bf.testLong((Long)predObj)) {
                result = SearchArgument.TruthValue.YES_NO_NULL;
            }
        } else if (predObj instanceof Double) {
            if (bf.testDouble((Double)predObj)) {
                result = SearchArgument.TruthValue.YES_NO_NULL;
            }
        } else if (predObj instanceof String || predObj instanceof Text || predObj instanceof HiveDecimalWritable || predObj instanceof BigDecimal) {
            if (bf.testString(predObj.toString())) {
                result = SearchArgument.TruthValue.YES_NO_NULL;
            }
        } else if (predObj instanceof Timestamp) {
            if (bf.testLong(((Timestamp)predObj).getTime())) {
                result = SearchArgument.TruthValue.YES_NO_NULL;
            }
        } else if (predObj instanceof Date) {
            if (bf.testLong(DateWritable.dateToDays((Date)((Date)predObj)))) {
                result = SearchArgument.TruthValue.YES_NO_NULL;
            }
        } else {
            result = predObj == null && !hasNull ? SearchArgument.TruthValue.NO : SearchArgument.TruthValue.YES_NO_NULL;
        }
        if (result == SearchArgument.TruthValue.YES_NO_NULL && !hasNull) {
            result = SearchArgument.TruthValue.YES_NO;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Bloom filter evaluation: " + result.toString());
        }
        return result;
    }

    private static Object getBaseObjectForComparison(PredicateLeaf.Type type, Object obj) {
        if (obj == null) {
            return null;
        }
        switch (type) {
            case BOOLEAN: {
                if (obj instanceof Boolean) {
                    return obj;
                }
                return Boolean.valueOf(obj.toString());
            }
            case DATE: {
                if (obj instanceof Date) {
                    return obj;
                }
                if (obj instanceof String) {
                    return Date.valueOf((String)obj);
                }
                if (!(obj instanceof Timestamp)) break;
                return DateWritable.timeToDate((long)(((Timestamp)obj).getTime() / 1000L));
            }
            case DECIMAL: {
                if (obj instanceof Boolean) {
                    return new HiveDecimalWritable((Boolean)obj != false ? HiveDecimal.ONE : HiveDecimal.ZERO);
                }
                if (obj instanceof Integer) {
                    return new HiveDecimalWritable((long)((Integer)obj).intValue());
                }
                if (obj instanceof Long) {
                    return new HiveDecimalWritable(((Long)obj).longValue());
                }
                if (obj instanceof Float || obj instanceof Double || obj instanceof String) {
                    return new HiveDecimalWritable(obj.toString());
                }
                if (obj instanceof BigDecimal) {
                    return new HiveDecimalWritable(HiveDecimal.create((BigDecimal)((BigDecimal)obj)));
                }
                if (obj instanceof HiveDecimal) {
                    return new HiveDecimalWritable((HiveDecimal)obj);
                }
                if (obj instanceof HiveDecimalWritable) {
                    return obj;
                }
                if (!(obj instanceof Timestamp)) break;
                return new HiveDecimalWritable(Double.toString(TimestampUtils.getDouble((Timestamp)((Timestamp)obj))));
            }
            case FLOAT: {
                if (obj instanceof Number) {
                    return ((Number)obj).doubleValue();
                }
                if (obj instanceof HiveDecimal) {
                    return ((HiveDecimal)obj).doubleValue();
                }
                if (obj instanceof String) {
                    return Double.valueOf(obj.toString());
                }
                if (obj instanceof Timestamp) {
                    return TimestampUtils.getDouble((Timestamp)((Timestamp)obj));
                }
                if (obj instanceof HiveDecimal) {
                    return ((HiveDecimal)obj).doubleValue();
                }
                if (!(obj instanceof BigDecimal)) break;
                return ((BigDecimal)obj).doubleValue();
            }
            case LONG: {
                if (obj instanceof Number) {
                    return ((Number)obj).longValue();
                }
                if (obj instanceof HiveDecimal) {
                    return ((HiveDecimal)obj).longValue();
                }
                if (!(obj instanceof String)) break;
                return Long.valueOf(obj.toString());
            }
            case STRING: {
                if (obj == null) break;
                return obj.toString();
            }
            case TIMESTAMP: {
                if (obj instanceof Timestamp) {
                    return obj;
                }
                if (obj instanceof Integer) {
                    return new Timestamp(((Number)obj).longValue());
                }
                if (obj instanceof Float) {
                    return TimestampUtils.doubleToTimestamp((double)((Float)obj).doubleValue());
                }
                if (obj instanceof Double) {
                    return TimestampUtils.doubleToTimestamp((double)((Double)obj));
                }
                if (obj instanceof HiveDecimal) {
                    return TimestampUtils.decimalToTimestamp((HiveDecimal)((HiveDecimal)obj));
                }
                if (obj instanceof HiveDecimalWritable) {
                    return TimestampUtils.decimalToTimestamp((HiveDecimal)((HiveDecimalWritable)obj).getHiveDecimal());
                }
                if (!(obj instanceof Date)) break;
                return new Timestamp(((Date)obj).getTime());
            }
        }
        throw new IllegalArgumentException(String.format("ORC SARGS could not convert from %s to %s", obj == null ? "(null)" : obj.getClass().getSimpleName(), type));
    }

    protected boolean[] pickRowGroups() throws IOException {
        if (this.sargApp == null) {
            return null;
        }
        this.readRowIndex(this.currentStripe, this.included, this.sargApp.sargColumns);
        return this.sargApp.pickRowGroups(this.stripes.get(this.currentStripe), this.indexes, this.bloomFilterIndices, false);
    }

    private void clearStreams() {
        for (InStream is : this.streams.values()) {
            is.close();
        }
        if (this.bufferChunks != null && this.dataReader.isTrackingDiskRanges()) {
            DiskRangeList range = this.bufferChunks;
            while (range != null) {
                if (range instanceof BufferChunk) {
                    this.dataReader.releaseBuffer(((BufferChunk)range).getChunk());
                }
                range = range.next;
            }
        }
        this.bufferChunks = null;
        this.streams.clear();
    }

    private void readStripe() throws IOException {
        StripeInformation stripe = this.beginReadStripe();
        this.includedRowGroups = this.pickRowGroups();
        if (this.includedRowGroups != null) {
            while (this.rowInStripe < this.rowCountInStripe && !this.includedRowGroups[(int)(this.rowInStripe / this.rowIndexStride)]) {
                this.rowInStripe = Math.min(this.rowCountInStripe, this.rowInStripe + this.rowIndexStride);
            }
        }
        if (this.rowInStripe < this.rowCountInStripe) {
            if (this.included == null && this.includedRowGroups == null) {
                this.readAllDataStreams(stripe);
            } else {
                this.readPartialDataStreams(stripe);
            }
            this.reader.startStripe(this.streams, this.stripeFooter);
            if (this.rowInStripe != 0L) {
                this.seekToRowEntry(this.reader, (int)(this.rowInStripe / this.rowIndexStride));
            }
        }
    }

    private StripeInformation beginReadStripe() throws IOException {
        int i;
        StripeInformation stripe = this.stripes.get(this.currentStripe);
        this.stripeFooter = this.readStripeFooter(stripe);
        this.clearStreams();
        this.rowCountInStripe = stripe.getNumberOfRows();
        this.rowInStripe = 0L;
        this.rowBaseInStripe = 0L;
        for (i = 0; i < this.currentStripe; ++i) {
            this.rowBaseInStripe += this.stripes.get(i).getNumberOfRows();
        }
        for (i = 0; i < this.indexes.length; ++i) {
            this.indexes[i] = null;
        }
        return stripe;
    }

    private void readAllDataStreams(StripeInformation stripe) throws IOException {
        long start = stripe.getIndexLength();
        long end = start + stripe.getDataLength();
        DiskRangeList toRead = new DiskRangeList(start, end);
        this.bufferChunks = this.dataReader.readFileData(toRead, stripe.getOffset(), false);
        List<OrcProto.Stream> streamDescriptions = this.stripeFooter.getStreamsList();
        this.createStreams(streamDescriptions, this.bufferChunks, null, this.codec, this.bufferSize, this.streams);
    }

    static DiskRangeList planReadPartialDataStreams(List<OrcProto.Stream> streamList, OrcProto.RowIndex[] indexes, boolean[] includedColumns, boolean[] includedRowGroups, boolean isCompressed, List<OrcProto.ColumnEncoding> encodings, List<OrcProto.Type> types, int compressionSize, boolean doMergeBuffers) {
        long offset = 0L;
        boolean[] hasNull = RecordReaderUtils.findPresentStreamsByColumn(streamList, types);
        DiskRangeList.CreateHelper list = new DiskRangeList.CreateHelper();
        for (OrcProto.Stream stream : streamList) {
            long length = stream.getLength();
            int column = stream.getColumn();
            OrcProto.Stream.Kind streamKind = stream.getKind();
            if (stream.hasKind() && StreamName.getArea(streamKind) == StreamName.Area.DATA && column < includedColumns.length && includedColumns[column]) {
                if (includedRowGroups == null || RecordReaderUtils.isDictionary(streamKind, encodings.get(column))) {
                    RecordReaderUtils.addEntireStreamToRanges(offset, length, list, doMergeBuffers);
                } else {
                    RecordReaderUtils.addRgFilteredStreamToRanges(stream, includedRowGroups, isCompressed, indexes[column], encodings.get(column), types.get(column), compressionSize, hasNull[column], offset, length, list, doMergeBuffers);
                }
            }
            offset += length;
        }
        return list.extract();
    }

    void createStreams(List<OrcProto.Stream> streamDescriptions, DiskRangeList ranges, boolean[] includeColumn, CompressionCodec codec, int bufferSize, Map<StreamName, InStream> streams) throws IOException {
        long streamOffset = 0L;
        for (OrcProto.Stream streamDesc : streamDescriptions) {
            int column = streamDesc.getColumn();
            if (includeColumn != null && column < this.included.length && !includeColumn[column] || streamDesc.hasKind() && StreamName.getArea(streamDesc.getKind()) != StreamName.Area.DATA) {
                streamOffset += streamDesc.getLength();
                continue;
            }
            List<DiskRange> buffers = RecordReaderUtils.getStreamBuffers(ranges, streamOffset, streamDesc.getLength());
            StreamName name = new StreamName(column, streamDesc.getKind());
            streams.put(name, InStream.create(name.toString(), buffers, streamDesc.getLength(), codec, bufferSize));
            streamOffset += streamDesc.getLength();
        }
    }

    private void readPartialDataStreams(StripeInformation stripe) throws IOException {
        List<OrcProto.Stream> streamList = this.stripeFooter.getStreamsList();
        DiskRangeList toRead = RecordReaderImpl.planReadPartialDataStreams(streamList, this.indexes, this.included, this.includedRowGroups, this.codec != null, this.stripeFooter.getColumnsList(), this.types, this.bufferSize, true);
        if (LOG.isDebugEnabled()) {
            LOG.debug("chunks = " + RecordReaderUtils.stringifyDiskRanges(toRead));
        }
        this.bufferChunks = this.dataReader.readFileData(toRead, stripe.getOffset(), false);
        if (LOG.isDebugEnabled()) {
            LOG.debug("merge = " + RecordReaderUtils.stringifyDiskRanges(this.bufferChunks));
        }
        this.createStreams(streamList, this.bufferChunks, this.included, this.codec, this.bufferSize, this.streams);
    }

    private void advanceStripe() throws IOException {
        this.rowInStripe = this.rowCountInStripe;
        while (this.rowInStripe >= this.rowCountInStripe && this.currentStripe < this.stripes.size() - 1) {
            ++this.currentStripe;
            this.readStripe();
        }
    }

    private boolean advanceToNextRow(TreeReaderFactory.TreeReader reader, long nextRow, boolean canAdvanceStripe) throws IOException {
        int rowGroup;
        long nextRowInStripe = nextRow - this.rowBaseInStripe;
        if (this.rowIndexStride != 0L && this.includedRowGroups != null && nextRowInStripe < this.rowCountInStripe && !this.includedRowGroups[rowGroup = (int)(nextRowInStripe / this.rowIndexStride)]) {
            while (rowGroup < this.includedRowGroups.length && !this.includedRowGroups[rowGroup]) {
                ++rowGroup;
            }
            if (rowGroup >= this.includedRowGroups.length) {
                if (canAdvanceStripe) {
                    this.advanceStripe();
                }
                return canAdvanceStripe;
            }
            nextRowInStripe = Math.min(this.rowCountInStripe, (long)rowGroup * this.rowIndexStride);
        }
        if (nextRowInStripe >= this.rowCountInStripe) {
            if (canAdvanceStripe) {
                this.advanceStripe();
            }
            return canAdvanceStripe;
        }
        if (nextRowInStripe != this.rowInStripe) {
            if (this.rowIndexStride != 0L) {
                rowGroup = (int)(nextRowInStripe / this.rowIndexStride);
                this.seekToRowEntry(reader, rowGroup);
                reader.skipRows(nextRowInStripe - (long)rowGroup * this.rowIndexStride);
            } else {
                reader.skipRows(nextRowInStripe - this.rowInStripe);
            }
            this.rowInStripe = nextRowInStripe;
        }
        return true;
    }

    @Override
    public boolean nextBatch(VectorizedRowBatch batch) throws IOException {
        try {
            if (this.rowInStripe >= this.rowCountInStripe) {
                ++this.currentStripe;
                if (this.currentStripe >= this.stripes.size()) {
                    batch.size = 0;
                    return false;
                }
                this.readStripe();
            }
            int batchSize = this.computeBatchSize(batch.getMaxSize());
            this.rowInStripe += (long)batchSize;
            this.reader.setVectorColumnCount(batch.getDataColumnCount());
            this.reader.nextBatch(batch, batchSize);
            batch.selectedInUse = false;
            batch.size = batchSize;
            this.advanceToNextRow(this.reader, this.rowInStripe + this.rowBaseInStripe, true);
            return batch.size != 0;
        }
        catch (IOException e) {
            throw new IOException("Error reading file: " + this.path, e);
        }
    }

    private int computeBatchSize(long targetBatchSize) {
        int batchSize;
        if (this.rowIndexStride != 0L && this.includedRowGroups != null && this.rowInStripe < this.rowCountInStripe) {
            int endRowGroup;
            int startRowGroup = (int)(this.rowInStripe / this.rowIndexStride);
            if (!this.includedRowGroups[startRowGroup]) {
                while (startRowGroup < this.includedRowGroups.length && !this.includedRowGroups[startRowGroup]) {
                    ++startRowGroup;
                }
            }
            for (endRowGroup = startRowGroup; endRowGroup < this.includedRowGroups.length && this.includedRowGroups[endRowGroup]; ++endRowGroup) {
            }
            long markerPosition = (long)endRowGroup * this.rowIndexStride < this.rowCountInStripe ? (long)endRowGroup * this.rowIndexStride : this.rowCountInStripe;
            batchSize = (int)Math.min(targetBatchSize, markerPosition - this.rowInStripe);
            if (isLogDebugEnabled && (long)batchSize < targetBatchSize) {
                LOG.debug("markerPosition: " + markerPosition + " batchSize: " + batchSize);
            }
        } else {
            batchSize = (int)Math.min(targetBatchSize, this.rowCountInStripe - this.rowInStripe);
        }
        return batchSize;
    }

    @Override
    public void close() throws IOException {
        this.clearStreams();
        this.dataReader.close();
    }

    @Override
    public long getRowNumber() {
        return this.rowInStripe + this.rowBaseInStripe + this.firstRow;
    }

    @Override
    public float getProgress() {
        return ((float)this.rowBaseInStripe + (float)this.rowInStripe) / (float)this.totalRowCount;
    }

    private int findStripe(long rowNumber) {
        for (int i = 0; i < this.stripes.size(); ++i) {
            StripeInformation stripe = this.stripes.get(i);
            if (stripe.getNumberOfRows() > rowNumber) {
                return i;
            }
            rowNumber -= stripe.getNumberOfRows();
        }
        throw new IllegalArgumentException("Seek after the end of reader range");
    }

    public OrcIndex readRowIndex(int stripeIndex, boolean[] included, boolean[] sargColumns) throws IOException {
        return this.readRowIndex(stripeIndex, included, null, null, sargColumns);
    }

    public OrcIndex readRowIndex(int stripeIndex, boolean[] included, OrcProto.RowIndex[] indexes, OrcProto.BloomFilterIndex[] bloomFilterIndex, boolean[] sargColumns) throws IOException {
        StripeInformation stripe = this.stripes.get(stripeIndex);
        OrcProto.StripeFooter stripeFooter = null;
        if (stripeIndex == this.currentStripe) {
            stripeFooter = this.stripeFooter;
            indexes = indexes == null ? this.indexes : indexes;
            OrcProto.BloomFilterIndex[] bloomFilterIndexArray = bloomFilterIndex = bloomFilterIndex == null ? this.bloomFilterIndices : bloomFilterIndex;
            sargColumns = sargColumns == null ? (Object)(this.sargApp == null ? null : this.sargApp.sargColumns) : sargColumns;
        }
        return this.dataReader.readRowIndex(stripe, stripeFooter, included, indexes, sargColumns, bloomFilterIndex);
    }

    private void seekToRowEntry(TreeReaderFactory.TreeReader reader, int rowEntry) throws IOException {
        PositionProvider[] index = new PositionProvider[this.indexes.length];
        for (int i = 0; i < this.indexes.length; ++i) {
            if (this.indexes[i] == null) continue;
            index[i] = new PositionProviderImpl(this.indexes[i].getEntry(rowEntry));
        }
        reader.seek(index);
    }

    @Override
    public void seekToRow(long rowNumber) throws IOException {
        if (rowNumber < 0L) {
            throw new IllegalArgumentException("Seek to a negative row number " + rowNumber);
        }
        if (rowNumber < this.firstRow) {
            throw new IllegalArgumentException("Seek before reader range " + rowNumber);
        }
        int rightStripe = this.findStripe(rowNumber -= this.firstRow);
        if (rightStripe != this.currentStripe) {
            this.currentStripe = rightStripe;
            this.readStripe();
        }
        this.readRowIndex(this.currentStripe, this.included, this.sargApp == null ? null : this.sargApp.sargColumns);
        this.advanceToNextRow(this.reader, rowNumber, true);
    }

    public static String encodeTranslatedSargColumn(int rootColumn, Integer indexInSourceTable) {
        return rootColumn + TRANSLATED_SARG_SEPARATOR + (indexInSourceTable == null ? -1 : indexInSourceTable);
    }

    public static int[] mapTranslatedSargColumns(List<OrcProto.Type> types, List<PredicateLeaf> sargLeaves) {
        int[] result = new int[sargLeaves.size()];
        OrcProto.Type lastRoot = null;
        String lastRootStr = null;
        for (int i = 0; i < result.length; ++i) {
            String[] rootAndIndex = sargLeaves.get(i).getColumnName().split(TRANSLATED_SARG_SEPARATOR);
            assert (rootAndIndex.length == 2);
            String rootStr = rootAndIndex[0];
            String indexStr = rootAndIndex[1];
            int index = Integer.parseInt(indexStr);
            if (index == -1) {
                result[i] = -1;
                continue;
            }
            assert (index >= 0);
            if (!rootStr.equals(lastRootStr)) {
                lastRoot = types.get(Integer.parseInt(rootStr));
                lastRootStr = rootStr;
            }
            result[i] = lastRoot.getSubtypes(index);
        }
        return result;
    }

    public static class SargApplier {
        public static final boolean[] READ_ALL_RGS = null;
        public static final boolean[] READ_NO_RGS = new boolean[0];
        private final SearchArgument sarg;
        private final List<PredicateLeaf> sargLeaves;
        private final int[] filterColumns;
        private final long rowIndexStride;
        private final boolean[] sargColumns;
        private SchemaEvolution evolution;

        public SargApplier(SearchArgument sarg, String[] columnNames, long rowIndexStride, SchemaEvolution evolution) {
            this.sarg = sarg;
            this.sargLeaves = sarg.getLeaves();
            this.filterColumns = RecordReaderImpl.mapSargColumnsToOrcInternalColIdx(this.sargLeaves, evolution);
            this.rowIndexStride = rowIndexStride;
            this.sargColumns = new boolean[evolution.getFileIncluded().length];
            for (int i : this.filterColumns) {
                if (i <= 0) continue;
                this.sargColumns[i] = true;
            }
            this.evolution = evolution;
        }

        public boolean[] pickRowGroups(StripeInformation stripe, OrcProto.RowIndex[] indexes, OrcProto.BloomFilterIndex[] bloomFilterIndices, boolean returnNone) throws IOException {
            long rowsInStripe = stripe.getNumberOfRows();
            int groupsInStripe = (int)((rowsInStripe + this.rowIndexStride - 1L) / this.rowIndexStride);
            boolean[] result = new boolean[groupsInStripe];
            SearchArgument.TruthValue[] leafValues = new SearchArgument.TruthValue[this.sargLeaves.size()];
            boolean hasSelected = false;
            boolean hasSkipped = false;
            for (int rowGroup = 0; rowGroup < result.length; ++rowGroup) {
                for (int pred = 0; pred < leafValues.length; ++pred) {
                    int columnIx = this.filterColumns[pred];
                    if (columnIx != -1) {
                        if (indexes[columnIx] == null) {
                            throw new AssertionError((Object)("Index is not populated for " + columnIx));
                        }
                        OrcProto.RowIndexEntry entry = indexes[columnIx].getEntry(rowGroup);
                        if (entry == null) {
                            throw new AssertionError((Object)("RG is not populated for " + columnIx + " rg " + rowGroup));
                        }
                        OrcProto.ColumnStatistics stats = entry.getStatistics();
                        OrcProto.BloomFilter bf = null;
                        if (bloomFilterIndices != null && bloomFilterIndices[columnIx] != null) {
                            bf = bloomFilterIndices[columnIx].getBloomFilter(rowGroup);
                        }
                        leafValues[pred] = this.evolution != null && this.evolution.isPPDSafeConversion(columnIx) ? RecordReaderImpl.evaluatePredicateProto(stats, this.sargLeaves.get(pred), bf) : SearchArgument.TruthValue.YES_NO_NULL;
                        if (!LOG.isTraceEnabled()) continue;
                        LOG.trace("Stats = " + stats);
                        LOG.trace("Setting " + this.sargLeaves.get(pred) + " to " + leafValues[pred]);
                        continue;
                    }
                    leafValues[pred] = SearchArgument.TruthValue.YES_NO_NULL;
                }
                result[rowGroup] = this.sarg.evaluate(leafValues).isNeeded();
                hasSelected = hasSelected || result[rowGroup];
                boolean bl = hasSkipped = hasSkipped || !result[rowGroup];
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Row group " + this.rowIndexStride * (long)rowGroup + " to " + (this.rowIndexStride * (long)(rowGroup + 1) - 1L) + " is " + (result[rowGroup] ? "" : "not ") + "included.");
            }
            return hasSkipped ? (hasSelected || !returnNone ? result : READ_NO_RGS) : READ_ALL_RGS;
        }
    }

    static enum Location {
        BEFORE,
        MIN,
        MIDDLE,
        MAX,
        AFTER;

    }

    public static final class PositionProviderImpl
    implements PositionProvider {
        private final OrcProto.RowIndexEntry entry;
        private int index;

        public PositionProviderImpl(OrcProto.RowIndexEntry entry) {
            this(entry, 0);
        }

        public PositionProviderImpl(OrcProto.RowIndexEntry entry, int startPos) {
            this.entry = entry;
            this.index = startPos;
        }

        @Override
        public long getNext() {
            return this.entry.getPositions(this.index++);
        }

        public String toString() {
            return "{" + this.entry.getPositionsList() + "; " + this.index + "}";
        }
    }
}

