/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hive;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.iceberg.BaseMetastoreCatalog;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.ClientPool;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableMetadataParser;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.SupportsNamespaces;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.NamespaceNotEmptyException;
import org.apache.iceberg.exceptions.NoSuchNamespaceException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.exceptions.NotFoundException;
import org.apache.iceberg.hadoop.HadoopFileIO;
import org.apache.iceberg.hive.CachedClientPool;
import org.apache.iceberg.hive.HiveTableOperations;
import org.apache.iceberg.hive.MetastoreUtil;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.util.LocationUtil;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveCatalog
extends BaseMetastoreCatalog
implements SupportsNamespaces,
Configurable {
    public static final String LIST_ALL_TABLES = "list-all-tables";
    public static final String LIST_ALL_TABLES_DEFAULT = "false";
    private static final Logger LOG = LoggerFactory.getLogger(HiveCatalog.class);
    private String name;
    private Configuration conf;
    private FileIO fileIO;
    private ClientPool<IMetaStoreClient, TException> clients;
    private boolean listAllTables = false;
    private Map<String, String> catalogProperties;

    public void initialize(String inputName, Map<String, String> properties) {
        this.catalogProperties = ImmutableMap.copyOf(properties);
        this.name = inputName;
        if (this.conf == null) {
            LOG.warn("No Hadoop Configuration was set, using the default environment Configuration");
            this.conf = new Configuration();
        }
        if (properties.containsKey("uri")) {
            this.conf.set(HiveConf.ConfVars.METASTOREURIS.varname, properties.get("uri"));
        }
        if (properties.containsKey("warehouse")) {
            this.conf.set(HiveConf.ConfVars.METASTOREWAREHOUSE.varname, LocationUtil.stripTrailingSlash((String)properties.get("warehouse")));
        }
        this.listAllTables = Boolean.parseBoolean(properties.getOrDefault(LIST_ALL_TABLES, LIST_ALL_TABLES_DEFAULT));
        String fileIOImpl = properties.get("io-impl");
        this.fileIO = fileIOImpl == null ? new HadoopFileIO(this.conf) : CatalogUtil.loadFileIO((String)fileIOImpl, properties, (Object)this.conf);
        this.clients = new CachedClientPool(this.conf, properties);
    }

    public List<TableIdentifier> listTables(Namespace namespace) {
        Preconditions.checkArgument((boolean)this.isValidateNamespace(namespace), (String)"Missing database in namespace: %s", (Object)namespace);
        String database = namespace.level(0);
        try {
            List<Object> tableIdentifiers;
            List tableNames = (List)this.clients.run(client -> client.getAllTables(database));
            if (this.listAllTables) {
                tableIdentifiers = tableNames.stream().map(t -> TableIdentifier.of((Namespace)namespace, (String)t)).collect(Collectors.toList());
            } else {
                List tableObjects = (List)this.clients.run(client -> client.getTableObjectsByName(database, tableNames));
                tableIdentifiers = tableObjects.stream().filter(table -> table.getParameters() != null && "iceberg".equalsIgnoreCase((String)table.getParameters().get("table_type"))).map(table -> TableIdentifier.of((Namespace)namespace, (String)table.getTableName())).collect(Collectors.toList());
            }
            LOG.debug("Listing of namespace: {} resulted in the following tables: {}", (Object)namespace, tableIdentifiers);
            return tableIdentifiers;
        }
        catch (UnknownDBException e) {
            throw new NoSuchNamespaceException("Namespace does not exist: %s", new Object[]{namespace});
        }
        catch (TException e) {
            throw new RuntimeException("Failed to list all tables under namespace " + namespace, e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted in call to listTables", e);
        }
    }

    public String name() {
        return this.name;
    }

    public boolean dropTable(TableIdentifier identifier, boolean purge) {
        if (!this.isValidIdentifier(identifier)) {
            return false;
        }
        String database = identifier.namespace().level(0);
        TableOperations ops = this.newTableOps(identifier);
        TableMetadata lastMetadata = null;
        if (purge) {
            try {
                lastMetadata = ops.current();
            }
            catch (NotFoundException e) {
                LOG.warn("Failed to load table metadata for table: {}, continuing drop without purge", (Object)identifier, (Object)e);
            }
        }
        try {
            this.clients.run(client -> {
                client.dropTable(database, identifier.name(), false, false);
                return null;
            });
            if (purge && lastMetadata != null) {
                CatalogUtil.dropTableData((FileIO)ops.io(), (TableMetadata)lastMetadata);
            }
            LOG.info("Dropped table: {}", (Object)identifier);
            return true;
        }
        catch (NoSuchObjectException | NoSuchTableException e) {
            LOG.info("Skipping drop, table does not exist: {}", (Object)identifier, (Object)e);
            return false;
        }
        catch (TException e) {
            throw new RuntimeException("Failed to drop " + identifier, e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted in call to dropTable", e);
        }
    }

    public void renameTable(TableIdentifier from, TableIdentifier originalTo) {
        if (!this.isValidIdentifier(from)) {
            throw new NoSuchTableException("Invalid identifier: %s", new Object[]{from});
        }
        TableIdentifier to = this.removeCatalogName(originalTo);
        Preconditions.checkArgument((boolean)this.isValidIdentifier(to), (String)"Invalid identifier: %s", (Object)to);
        String toDatabase = to.namespace().level(0);
        String fromDatabase = from.namespace().level(0);
        String fromName = from.name();
        try {
            org.apache.hadoop.hive.metastore.api.Table table = (org.apache.hadoop.hive.metastore.api.Table)this.clients.run(client -> client.getTable(fromDatabase, fromName));
            HiveTableOperations.validateTableIsIceberg(table, HiveCatalog.fullTableName((String)this.name, (TableIdentifier)from));
            table.setDbName(toDatabase);
            table.setTableName(to.name());
            this.clients.run(client -> {
                MetastoreUtil.alterTable(client, fromDatabase, fromName, table);
                return null;
            });
            LOG.info("Renamed table from {}, to {}", (Object)from, (Object)to);
        }
        catch (NoSuchObjectException e) {
            throw new NoSuchTableException("Table does not exist: %s", new Object[]{from});
        }
        catch (AlreadyExistsException e) {
            throw new org.apache.iceberg.exceptions.AlreadyExistsException("Table already exists: %s", new Object[]{to});
        }
        catch (TException e) {
            throw new RuntimeException("Failed to rename " + from + " to " + to, e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted in call to rename", e);
        }
    }

    public Table registerTable(TableIdentifier identifier, String metadataFileLocation) {
        Preconditions.checkArgument((boolean)this.isValidIdentifier(identifier), (String)"Invalid identifier: %s", (Object)identifier);
        if (this.tableExists(identifier)) {
            throw new org.apache.iceberg.exceptions.AlreadyExistsException("Table already exists: %s", new Object[]{identifier});
        }
        TableOperations ops = this.newTableOps(identifier);
        InputFile metadataFile = this.fileIO.newInputFile(metadataFileLocation);
        TableMetadata metadata = TableMetadataParser.read((FileIO)ops.io(), (InputFile)metadataFile);
        ops.commit(null, metadata);
        return new BaseTable(ops, identifier.toString());
    }

    public void createNamespace(Namespace namespace, Map<String, String> meta) {
        Preconditions.checkArgument((!namespace.isEmpty() ? 1 : 0) != 0, (String)"Cannot create namespace with invalid name: %s", (Object)namespace);
        Preconditions.checkArgument((boolean)this.isValidateNamespace(namespace), (String)"Cannot support multi part namespace in Hive Metastore: %s", (Object)namespace);
        try {
            this.clients.run(client -> {
                client.createDatabase(this.convertToDatabase(namespace, meta));
                return null;
            });
            LOG.info("Created namespace: {}", (Object)namespace);
        }
        catch (AlreadyExistsException e) {
            throw new org.apache.iceberg.exceptions.AlreadyExistsException((Throwable)e, "Namespace '%s' already exists!", new Object[]{namespace});
        }
        catch (TException e) {
            throw new RuntimeException("Failed to create namespace " + namespace + " in Hive Metastore", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted in call to createDatabase(name) " + namespace + " in Hive Metastore", e);
        }
    }

    public List<Namespace> listNamespaces(Namespace namespace) {
        if (!this.isValidateNamespace(namespace) && !namespace.isEmpty()) {
            throw new NoSuchNamespaceException("Namespace does not exist: %s", new Object[]{namespace});
        }
        if (!namespace.isEmpty()) {
            return ImmutableList.of();
        }
        try {
            List<Namespace> namespaces = ((List)this.clients.run(IMetaStoreClient::getAllDatabases)).stream().map(xva$0 -> Namespace.of((String[])new String[]{xva$0})).collect(Collectors.toList());
            LOG.debug("Listing namespace {} returned tables: {}", (Object)namespace, namespaces);
            return namespaces;
        }
        catch (TException e) {
            throw new RuntimeException("Failed to list all namespace: " + namespace + " in Hive Metastore", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted in call to getAllDatabases() " + namespace + " in Hive Metastore", e);
        }
    }

    public boolean dropNamespace(Namespace namespace) {
        if (!this.isValidateNamespace(namespace)) {
            return false;
        }
        try {
            this.clients.run(client -> {
                client.dropDatabase(namespace.level(0), false, false, false);
                return null;
            });
            LOG.info("Dropped namespace: {}", (Object)namespace);
            return true;
        }
        catch (InvalidOperationException e) {
            throw new NamespaceNotEmptyException((Throwable)e, "Namespace %s is not empty. One or more tables exist.", new Object[]{namespace});
        }
        catch (NoSuchObjectException e) {
            return false;
        }
        catch (TException e) {
            throw new RuntimeException("Failed to drop namespace " + namespace + " in Hive Metastore", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted in call to drop dropDatabase(name) " + namespace + " in Hive Metastore", e);
        }
    }

    public boolean setProperties(Namespace namespace, Map<String, String> properties) {
        HashMap parameter = Maps.newHashMap();
        parameter.putAll(this.loadNamespaceMetadata(namespace));
        parameter.putAll(properties);
        Database database = this.convertToDatabase(namespace, parameter);
        this.alterHiveDataBase(namespace, database);
        LOG.debug("Successfully set properties {} for {}", properties.keySet(), (Object)namespace);
        return true;
    }

    public boolean removeProperties(Namespace namespace, Set<String> properties) {
        HashMap parameter = Maps.newHashMap();
        parameter.putAll(this.loadNamespaceMetadata(namespace));
        properties.forEach(key -> {
            String cfr_ignored_0 = parameter.put(key, null);
        });
        Database database = this.convertToDatabase(namespace, parameter);
        this.alterHiveDataBase(namespace, database);
        LOG.debug("Successfully removed properties {} from {}", properties, (Object)namespace);
        return true;
    }

    private void alterHiveDataBase(Namespace namespace, Database database) {
        try {
            this.clients.run(client -> {
                client.alterDatabase(namespace.level(0), database);
                return null;
            });
        }
        catch (NoSuchObjectException | UnknownDBException e) {
            throw new NoSuchNamespaceException(e, "Namespace does not exist: %s", new Object[]{namespace});
        }
        catch (TException e) {
            throw new RuntimeException("Failed to list namespace under namespace: " + namespace + " in Hive Metastore", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted in call to getDatabase(name) " + namespace + " in Hive Metastore", e);
        }
    }

    public Map<String, String> loadNamespaceMetadata(Namespace namespace) {
        if (!this.isValidateNamespace(namespace)) {
            throw new NoSuchNamespaceException("Namespace does not exist: %s", new Object[]{namespace});
        }
        try {
            Database database = (Database)this.clients.run(client -> client.getDatabase(namespace.level(0)));
            Map<String, String> metadata = this.convertToMetadata(database);
            LOG.debug("Loaded metadata for namespace {} found {}", (Object)namespace, metadata.keySet());
            return metadata;
        }
        catch (NoSuchObjectException | UnknownDBException e) {
            throw new NoSuchNamespaceException(e, "Namespace does not exist: %s", new Object[]{namespace});
        }
        catch (TException e) {
            throw new RuntimeException("Failed to list namespace under namespace: " + namespace + " in Hive Metastore", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted in call to getDatabase(name) " + namespace + " in Hive Metastore", e);
        }
    }

    protected boolean isValidIdentifier(TableIdentifier tableIdentifier) {
        return tableIdentifier.namespace().levels().length == 1;
    }

    private TableIdentifier removeCatalogName(TableIdentifier to) {
        if (this.isValidIdentifier(to)) {
            return to;
        }
        if (to.namespace().levels().length == 2 && this.name().equalsIgnoreCase(to.namespace().level(0))) {
            return TableIdentifier.of((Namespace)Namespace.of((String[])new String[]{to.namespace().level(1)}), (String)to.name());
        }
        return to;
    }

    private boolean isValidateNamespace(Namespace namespace) {
        return namespace.levels().length == 1;
    }

    public TableOperations newTableOps(TableIdentifier tableIdentifier) {
        String dbName = tableIdentifier.namespace().level(0);
        String tableName = tableIdentifier.name();
        return new HiveTableOperations(this.conf, this.clients, this.fileIO, this.name, dbName, tableName);
    }

    protected String defaultWarehouseLocation(TableIdentifier tableIdentifier) {
        try {
            Database databaseData = (Database)this.clients.run(client -> client.getDatabase(tableIdentifier.namespace().levels()[0]));
            if (databaseData.getLocationUri() != null) {
                return String.format("%s/%s", databaseData.getLocationUri(), tableIdentifier.name());
            }
        }
        catch (TException e) {
            throw new RuntimeException(String.format("Metastore operation failed for %s", tableIdentifier), e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted during commit", e);
        }
        String warehouseLocation = this.getWarehouseLocation();
        return String.format("%s/%s.db/%s", warehouseLocation, tableIdentifier.namespace().levels()[0], tableIdentifier.name());
    }

    private String getWarehouseLocation() {
        String warehouseLocation = this.conf.get(HiveConf.ConfVars.METASTOREWAREHOUSE.varname);
        Preconditions.checkNotNull((Object)warehouseLocation, (Object)"Warehouse location is not set: hive.metastore.warehouse.dir=null");
        return warehouseLocation;
    }

    private Map<String, String> convertToMetadata(Database database) {
        HashMap meta = Maps.newHashMap();
        meta.putAll(database.getParameters());
        meta.put("location", database.getLocationUri());
        if (database.getDescription() != null) {
            meta.put("comment", database.getDescription());
        }
        return meta;
    }

    Database convertToDatabase(Namespace namespace, Map<String, String> meta) {
        if (!this.isValidateNamespace(namespace)) {
            throw new NoSuchNamespaceException("Namespace does not exist: %s", new Object[]{namespace});
        }
        Database database = new Database();
        HashMap parameter = Maps.newHashMap();
        database.setName(namespace.level(0));
        database.setLocationUri(new Path(this.getWarehouseLocation(), namespace.level(0)).toString() + ".db");
        meta.forEach((key, value) -> {
            if (key.equals("comment")) {
                database.setDescription(value);
            } else if (key.equals("location")) {
                database.setLocationUri(value);
            } else if (value != null) {
                parameter.put(key, value);
            }
        });
        database.setParameters((Map)parameter);
        return database;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("name", (Object)this.name).add("uri", (Object)(this.conf == null ? "" : this.conf.get(HiveConf.ConfVars.METASTOREURIS.varname))).toString();
    }

    public void setConf(Configuration conf) {
        this.conf = new Configuration(conf);
    }

    public Configuration getConf() {
        return this.conf;
    }

    protected Map<String, String> properties() {
        return this.catalogProperties == null ? ImmutableMap.of() : this.catalogProperties;
    }

    @VisibleForTesting
    void setListAllTables(boolean listAllTables) {
        this.listAllTables = listAllTables;
    }
}

