/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import java.nio.ByteBuffer;
import org.apache.iceberg.Schema;
import org.apache.iceberg.expressions.BoundPredicate;
import org.apache.iceberg.expressions.BoundReference;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.ExpressionVisitors;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.expressions.UnboundPredicate;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.filter2.predicate.FilterApi;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.filter2.predicate.Operators;
import org.apache.parquet.io.api.Binary;

class ParquetFilters {
    private ParquetFilters() {
    }

    static FilterCompat.Filter convert(Schema schema, Expression expr, boolean caseSensitive) {
        FilterPredicate pred = (FilterPredicate)ExpressionVisitors.visit((Expression)expr, (ExpressionVisitors.ExpressionVisitor)new ConvertFilterToParquet(schema, caseSensitive));
        if (pred != null && pred != AlwaysTrue.INSTANCE) {
            return FilterCompat.get((FilterPredicate)pred);
        }
        return FilterCompat.NOOP;
    }

    private static <C extends Comparable<C>, COL extends Operators.Column<C>> FilterPredicate pred(Expression.Operation op, COL col, C value) {
        switch (op) {
            case IS_NULL: {
                return FilterApi.eq(col, null);
            }
            case NOT_NULL: {
                return FilterApi.notEq(col, null);
            }
            case IS_NAN: {
                if (col.getColumnType().equals(Double.class)) {
                    return FilterApi.eq(col, (Comparable)Double.valueOf(Double.NaN));
                }
                if (col.getColumnType().equals(Float.class)) {
                    return FilterApi.eq(col, (Comparable)Float.valueOf(Float.NaN));
                }
                return AlwaysFalse.INSTANCE;
            }
            case NOT_NAN: {
                if (col.getColumnType().equals(Double.class)) {
                    return FilterApi.notEq(col, (Comparable)Double.valueOf(Double.NaN));
                }
                if (col.getColumnType().equals(Float.class)) {
                    return FilterApi.notEq(col, (Comparable)Float.valueOf(Float.NaN));
                }
                return AlwaysTrue.INSTANCE;
            }
            case EQ: {
                return FilterApi.eq(col, value);
            }
            case NOT_EQ: {
                return FilterApi.notEq(col, value);
            }
            case GT: {
                return FilterApi.gt(col, value);
            }
            case GT_EQ: {
                return FilterApi.gtEq(col, value);
            }
            case LT: {
                return FilterApi.lt(col, value);
            }
            case LT_EQ: {
                return FilterApi.ltEq(col, value);
            }
        }
        throw new UnsupportedOperationException("Unsupported predicate operation: " + op);
    }

    private static <C extends Comparable<C>> C getParquetPrimitive(Literal<?> lit) {
        if (lit == null) {
            return null;
        }
        Object value = lit.value();
        if (value instanceof Number) {
            return (C)((Comparable)lit.value());
        }
        if (value instanceof CharSequence) {
            return (C)Binary.fromString((String)value.toString());
        }
        if (value instanceof ByteBuffer) {
            return (C)Binary.fromReusedByteBuffer((ByteBuffer)((ByteBuffer)value));
        }
        throw new UnsupportedOperationException("Type not supported yet: " + value.getClass().getName());
    }

    private static class AlwaysFalse
    implements FilterPredicate {
        static final AlwaysFalse INSTANCE = new AlwaysFalse();

        private AlwaysFalse() {
        }

        public <R> R accept(FilterPredicate.Visitor<R> visitor) {
            throw new UnsupportedOperationException("AlwaysTrue is a placeholder only");
        }
    }

    private static class AlwaysTrue
    implements FilterPredicate {
        static final AlwaysTrue INSTANCE = new AlwaysTrue();

        private AlwaysTrue() {
        }

        public <R> R accept(FilterPredicate.Visitor<R> visitor) {
            throw new UnsupportedOperationException("AlwaysTrue is a placeholder only");
        }
    }

    private static class ConvertFilterToParquet
    extends ExpressionVisitors.ExpressionVisitor<FilterPredicate> {
        private final Schema schema;
        private final boolean caseSensitive;

        private ConvertFilterToParquet(Schema schema, boolean caseSensitive) {
            this.schema = schema;
            this.caseSensitive = caseSensitive;
        }

        public FilterPredicate alwaysTrue() {
            return AlwaysTrue.INSTANCE;
        }

        public FilterPredicate alwaysFalse() {
            return AlwaysFalse.INSTANCE;
        }

        public FilterPredicate not(FilterPredicate child) {
            if (child == AlwaysTrue.INSTANCE) {
                return AlwaysFalse.INSTANCE;
            }
            if (child == AlwaysFalse.INSTANCE) {
                return AlwaysTrue.INSTANCE;
            }
            return FilterApi.not((FilterPredicate)child);
        }

        public FilterPredicate and(FilterPredicate left, FilterPredicate right) {
            if (left == AlwaysFalse.INSTANCE || right == AlwaysFalse.INSTANCE) {
                return AlwaysFalse.INSTANCE;
            }
            if (left == AlwaysTrue.INSTANCE) {
                return right;
            }
            if (right == AlwaysTrue.INSTANCE) {
                return left;
            }
            return FilterApi.and((FilterPredicate)left, (FilterPredicate)right);
        }

        public FilterPredicate or(FilterPredicate left, FilterPredicate right) {
            if (left == AlwaysTrue.INSTANCE || right == AlwaysTrue.INSTANCE) {
                return AlwaysTrue.INSTANCE;
            }
            if (left == AlwaysFalse.INSTANCE) {
                return right;
            }
            if (right == AlwaysFalse.INSTANCE) {
                return left;
            }
            return FilterApi.or((FilterPredicate)left, (FilterPredicate)right);
        }

        protected Expression bind(UnboundPredicate<?> pred) {
            return pred.bind(this.schema.asStruct(), this.caseSensitive);
        }

        public <T> FilterPredicate predicate(BoundPredicate<T> pred) {
            Literal lit;
            if (!(pred.term() instanceof BoundReference)) {
                throw new UnsupportedOperationException("Cannot convert non-reference to Parquet filter: " + pred.term());
            }
            Expression.Operation op = pred.op();
            BoundReference ref = (BoundReference)pred.term();
            String path = this.schema.idToAlias(Integer.valueOf(ref.fieldId()));
            if (pred.isUnaryPredicate()) {
                lit = null;
            } else if (pred.isLiteralPredicate()) {
                lit = pred.asLiteralPredicate().literal();
            } else {
                throw new UnsupportedOperationException("Cannot convert to Parquet filter: " + pred);
            }
            switch (ref.type().typeId()) {
                case BOOLEAN: {
                    Operators.BooleanColumn col = FilterApi.booleanColumn((String)path);
                    switch (op) {
                        case EQ: {
                            return FilterApi.eq((Operators.Column)col, (Comparable)ParquetFilters.getParquetPrimitive(lit));
                        }
                        case NOT_EQ: {
                            return FilterApi.notEq((Operators.Column)col, (Comparable)ParquetFilters.getParquetPrimitive(lit));
                        }
                    }
                    break;
                }
                case INTEGER: 
                case DATE: {
                    return ParquetFilters.pred(op, (Operators.Column)FilterApi.intColumn((String)path), ParquetFilters.getParquetPrimitive(lit));
                }
                case LONG: 
                case TIME: 
                case TIMESTAMP: {
                    return ParquetFilters.pred(op, (Operators.Column)FilterApi.longColumn((String)path), ParquetFilters.getParquetPrimitive(lit));
                }
                case FLOAT: {
                    return ParquetFilters.pred(op, (Operators.Column)FilterApi.floatColumn((String)path), ParquetFilters.getParquetPrimitive(lit));
                }
                case DOUBLE: {
                    return ParquetFilters.pred(op, (Operators.Column)FilterApi.doubleColumn((String)path), ParquetFilters.getParquetPrimitive(lit));
                }
                case STRING: 
                case UUID: 
                case FIXED: 
                case BINARY: 
                case DECIMAL: {
                    return ParquetFilters.pred(op, (Operators.Column)FilterApi.binaryColumn((String)path), ParquetFilters.getParquetPrimitive(lit));
                }
            }
            throw new UnsupportedOperationException("Cannot convert to Parquet filter: " + pred);
        }

        public <T> FilterPredicate predicate(UnboundPredicate<T> pred) {
            Expression bound = this.bind(pred);
            if (bound instanceof BoundPredicate) {
                return this.predicate((BoundPredicate<T>)((BoundPredicate)bound));
            }
            if (bound == Expressions.alwaysTrue()) {
                return AlwaysTrue.INSTANCE;
            }
            if (bound == Expressions.alwaysFalse()) {
                return AlwaysFalse.INSTANCE;
            }
            throw new UnsupportedOperationException("Cannot convert to Parquet filter: " + pred);
        }
    }
}

