/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery.zk;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import org.apache.curator.utils.PathUtils;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteFeatures;
import org.apache.ignite.internal.managers.discovery.IgniteDiscoverySpi;
import org.apache.ignite.internal.managers.discovery.IgniteDiscoverySpiInternalListener;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteProductVersion;
import org.apache.ignite.resources.LoggerResource;
import org.apache.ignite.spi.IgniteSpiAdapter;
import org.apache.ignite.spi.IgniteSpiConfiguration;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.IgniteSpiMBeanAdapter;
import org.apache.ignite.spi.IgniteSpiMultipleInstancesSupport;
import org.apache.ignite.spi.communication.CommunicationSpi;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationSpi;
import org.apache.ignite.spi.discovery.DiscoveryMetricsProvider;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.DiscoverySpiCustomMessage;
import org.apache.ignite.spi.discovery.DiscoverySpiDataExchange;
import org.apache.ignite.spi.discovery.DiscoverySpiHistorySupport;
import org.apache.ignite.spi.discovery.DiscoverySpiListener;
import org.apache.ignite.spi.discovery.DiscoverySpiMutableCustomMessageSupport;
import org.apache.ignite.spi.discovery.DiscoverySpiNodeAuthenticator;
import org.apache.ignite.spi.discovery.DiscoverySpiOrderSupport;
import org.apache.ignite.spi.discovery.zk.ZookeeperDiscoverySpiMBean;
import org.apache.ignite.spi.discovery.zk.internal.ZookeeperClusterNode;
import org.apache.ignite.spi.discovery.zk.internal.ZookeeperDiscoveryImpl;
import org.apache.ignite.spi.discovery.zk.internal.ZookeeperDiscoveryStatistics;
import org.jetbrains.annotations.Nullable;

@IgniteSpiMultipleInstancesSupport(value=true)
@DiscoverySpiOrderSupport(value=true)
@DiscoverySpiHistorySupport(value=true)
@DiscoverySpiMutableCustomMessageSupport(value=false)
public class ZookeeperDiscoverySpi
extends IgniteSpiAdapter
implements IgniteDiscoverySpi {
    public static final String DFLT_ROOT_PATH = "/apacheIgnite";
    public static final long DFLT_JOIN_TIMEOUT = 0L;
    @GridToStringInclude
    private String zkRootPath = "/apacheIgnite";
    @GridToStringInclude
    private String zkConnectionString;
    private long joinTimeout = 0L;
    @GridToStringInclude
    private long sesTimeout;
    private boolean clientReconnectDisabled;
    @GridToStringExclude
    private DiscoverySpiListener lsnr;
    @GridToStringExclude
    private DiscoverySpiDataExchange exchange;
    @GridToStringExclude
    private DiscoverySpiNodeAuthenticator nodeAuth;
    @GridToStringExclude
    private DiscoveryMetricsProvider metricsProvider;
    @GridToStringExclude
    private ZookeeperDiscoveryImpl impl;
    @GridToStringExclude
    private Map<String, Object> locNodeAttrs;
    @GridToStringExclude
    private IgniteProductVersion locNodeVer;
    @GridToStringExclude
    private Serializable consistentId;
    private IgniteBiTuple<Collection<String>, Collection<String>> addrs;
    @LoggerResource
    @GridToStringExclude
    private IgniteLogger log;
    private IgniteDiscoverySpiInternalListener internalLsnr;
    private final ZookeeperDiscoveryStatistics stats = new ZookeeperDiscoveryStatistics();

    public String getZkRootPath() {
        return this.zkRootPath;
    }

    @IgniteSpiConfiguration(optional=true)
    public ZookeeperDiscoverySpi setZkRootPath(String zkRootPath) {
        this.zkRootPath = zkRootPath;
        return this;
    }

    public long getSessionTimeout() {
        return this.sesTimeout;
    }

    @IgniteSpiConfiguration(optional=true)
    public ZookeeperDiscoverySpi setSessionTimeout(long sesTimeout) {
        this.sesTimeout = sesTimeout;
        return this;
    }

    public long getJoinTimeout() {
        return this.joinTimeout;
    }

    @IgniteSpiConfiguration(optional=true)
    public ZookeeperDiscoverySpi setJoinTimeout(long joinTimeout) {
        this.joinTimeout = joinTimeout;
        return this;
    }

    public String getZkConnectionString() {
        return this.zkConnectionString;
    }

    @IgniteSpiConfiguration(optional=false)
    public ZookeeperDiscoverySpi setZkConnectionString(String zkConnectionString) {
        this.zkConnectionString = zkConnectionString;
        return this;
    }

    public boolean isClientReconnectDisabled() {
        return this.clientReconnectDisabled;
    }

    @IgniteSpiConfiguration(optional=true)
    public ZookeeperDiscoverySpi setClientReconnectDisabled(boolean clientReconnectDisabled) {
        this.clientReconnectDisabled = clientReconnectDisabled;
        return this;
    }

    public boolean clientReconnectSupported() {
        return !this.clientReconnectDisabled;
    }

    public void clientReconnect() {
        this.impl.reconnect();
    }

    public boolean knownNode(UUID nodeId) {
        return this.impl.knownNode(nodeId);
    }

    public boolean supportsCommunicationFailureResolve() {
        return true;
    }

    public void resolveCommunicationFailure(ClusterNode node, Exception err) {
        this.impl.resolveCommunicationError(node, err);
    }

    @Nullable
    public Serializable consistentId() throws IgniteSpiException {
        if (this.consistentId == null) {
            this.consistentId = this.ignite.configuration().getConsistentId();
            if (this.consistentId == null) {
                this.initAddresses();
                ArrayList sortedAddrs = new ArrayList((Collection)this.addrs.get1());
                Collections.sort(sortedAddrs);
                if (IgniteSystemProperties.getBoolean((String)"IGNITE_CONSISTENT_ID_BY_HOST_WITHOUT_PORT")) {
                    this.consistentId = U.consistentId(sortedAddrs);
                } else {
                    Integer commPort = null;
                    if (this.locNodeAttrs != null) {
                        commPort = (Integer)this.locNodeAttrs.get(TcpCommunicationSpi.class.getSimpleName() + "." + "comm.tcp.port");
                    } else {
                        CommunicationSpi commSpi = this.ignite.configuration().getCommunicationSpi();
                        if (commSpi instanceof TcpCommunicationSpi && (commPort = Integer.valueOf(((TcpCommunicationSpi)commSpi).boundPort())) == -1) {
                            commPort = null;
                        }
                    }
                    if (commPort == null) {
                        U.warn((IgniteLogger)this.log, (Object)"Can not initialize default consistentId, TcpCommunicationSpi port is not initialized.");
                        this.consistentId = this.ignite.configuration().getNodeId();
                    } else {
                        this.consistentId = U.consistentId(sortedAddrs, (int)commPort);
                    }
                }
            }
        }
        return this.consistentId;
    }

    private void initAddresses() {
        if (this.addrs == null) {
            InetAddress locAddr;
            String locHost = this.ignite != null ? this.ignite.configuration().getLocalHost() : null;
            try {
                locAddr = U.resolveLocalHost((String)locHost);
            }
            catch (IOException e) {
                throw new IgniteSpiException("Unknown local address: " + locHost, (Throwable)e);
            }
            try {
                this.addrs = U.resolveLocalAddresses((InetAddress)locAddr);
            }
            catch (Exception e) {
                throw new IgniteSpiException("Failed to resolve local host to set of external addresses: " + locHost, (Throwable)e);
            }
        }
    }

    public Collection<ClusterNode> getRemoteNodes() {
        return this.impl.remoteNodes();
    }

    public boolean allNodesSupport(IgniteFeatures feature) {
        if (this.impl == null) {
            return false;
        }
        return this.impl.allNodesSupport(feature);
    }

    public ClusterNode getLocalNode() {
        return this.impl != null ? this.impl.localNode() : null;
    }

    @Nullable
    public ClusterNode getNode(UUID nodeId) {
        return this.impl.node(nodeId);
    }

    public boolean pingNode(UUID nodeId) {
        return this.impl.pingNode(nodeId);
    }

    public void setNodeAttributes(Map<String, Object> attrs, IgniteProductVersion ver) {
        assert (this.locNodeAttrs == null);
        assert (this.locNodeVer == null);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Node attributes to set: " + attrs);
            this.log.debug("Node version to set: " + ver);
        }
        this.locNodeAttrs = attrs;
        this.locNodeVer = ver;
    }

    public void setListener(@Nullable DiscoverySpiListener lsnr) {
        this.lsnr = lsnr;
    }

    public void setDataExchange(DiscoverySpiDataExchange exchange) {
        this.exchange = exchange;
    }

    public void setMetricsProvider(DiscoveryMetricsProvider metricsProvider) {
        this.metricsProvider = metricsProvider;
    }

    public void disconnect() throws IgniteSpiException {
        this.impl.stop();
    }

    public void setAuthenticator(DiscoverySpiNodeAuthenticator auth) {
        this.nodeAuth = auth;
    }

    public DiscoverySpiNodeAuthenticator getAuthenticator() {
        return this.nodeAuth;
    }

    public long getGridStartTime() {
        return this.impl.gridStartTime();
    }

    public void sendCustomEvent(DiscoverySpiCustomMessage msg) {
        IgniteDiscoverySpiInternalListener internalLsnr = this.impl.internalLsnr;
        if (internalLsnr != null && !internalLsnr.beforeSendCustomEvent((DiscoverySpi)this, this.log, msg)) {
            return;
        }
        this.impl.sendCustomMessage(msg);
    }

    public void failNode(UUID nodeId, @Nullable String warning) {
        this.impl.failNode(nodeId, warning);
    }

    public boolean isClientMode() throws IllegalStateException {
        return this.impl.localNode().isClient();
    }

    public void spiStart(@Nullable String igniteInstanceName) throws IgniteSpiException {
        this.startStopwatch();
        if (this.sesTimeout == 0L) {
            this.sesTimeout = this.ignite.configuration().getFailureDetectionTimeout().intValue();
        }
        this.assertParameter(this.sesTimeout > 0L, "sessionTimeout > 0");
        A.notNullOrEmpty((String)this.zkConnectionString, (String)"zkConnectionString can not be empty");
        A.notNullOrEmpty((String)this.zkRootPath, (String)"zkRootPath can not be empty");
        this.zkRootPath = this.zkRootPath.trim();
        if (this.zkRootPath.endsWith("/")) {
            this.zkRootPath = this.zkRootPath.substring(0, this.zkRootPath.length() - 1);
        }
        try {
            PathUtils.validatePath((String)this.zkRootPath);
        }
        catch (IllegalArgumentException e) {
            throw new IgniteSpiException("zkRootPath is invalid: " + this.zkRootPath, (Throwable)e);
        }
        ZookeeperClusterNode locNode = this.initLocalNode();
        if (this.log.isInfoEnabled()) {
            this.log.info("Start Zookeeper discovery [zkConnectionString=" + this.zkConnectionString + ", sessionTimeout=" + this.sesTimeout + ", zkRootPath=" + this.zkRootPath + ']');
        }
        this.impl = new ZookeeperDiscoveryImpl(this, igniteInstanceName, this.log, this.zkRootPath, locNode, this.lsnr, this.exchange, this.internalLsnr, this.stats);
        this.registerMBean(igniteInstanceName, new ZookeeperDiscoverySpiMBeanImpl(this), ZookeeperDiscoverySpiMBean.class);
        try {
            this.impl.startJoinAndWait();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IgniteSpiException("Failed to join cluster, thread was interrupted", (Throwable)e);
        }
    }

    public void setInternalListener(IgniteDiscoverySpiInternalListener lsnr) {
        if (this.impl != null) {
            this.impl.internalLsnr = lsnr;
        } else {
            this.internalLsnr = lsnr;
        }
    }

    public void simulateNodeFailure() {
        this.impl.simulateNodeFailure();
    }

    public void spiStop() throws IgniteSpiException {
        this.unregisterMBean();
        if (this.impl != null) {
            this.impl.stop();
        }
    }

    public Map<String, Object> getLocNodeAttrs() {
        return this.locNodeAttrs;
    }

    private ZookeeperClusterNode initLocalNode() {
        assert (this.ignite != null);
        this.initAddresses();
        ZookeeperClusterNode locNode = new ZookeeperClusterNode(this.ignite.configuration().getNodeId(), (Collection)this.addrs.get1(), (Collection)this.addrs.get2(), this.locNodeVer, this.locNodeAttrs, this.consistentId(), this.sesTimeout, this.ignite.configuration().isClientMode(), this.metricsProvider);
        locNode.local(true);
        DiscoverySpiListener lsnr = this.lsnr;
        if (lsnr != null) {
            lsnr.onLocalNodeInitialized((ClusterNode)locNode);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Local node initialized: " + locNode);
        }
        if (this.metricsProvider != null) {
            locNode.setMetrics(this.metricsProvider.metrics());
            locNode.setCacheMetrics(this.metricsProvider.cacheMetrics());
        }
        return locNode;
    }

    private ZookeeperDiscoverySpi cloneSpiConfiguration() {
        ZookeeperDiscoverySpi spi = new ZookeeperDiscoverySpi();
        spi.setZkRootPath(this.zkRootPath);
        spi.setZkConnectionString(this.zkConnectionString);
        spi.setSessionTimeout(this.sesTimeout);
        spi.setJoinTimeout(this.joinTimeout);
        spi.setClientReconnectDisabled(this.clientReconnectDisabled);
        return spi;
    }

    public String toString() {
        return S.toString(ZookeeperDiscoverySpi.class, (Object)((Object)this));
    }

    private class ZookeeperDiscoverySpiMBeanImpl
    extends IgniteSpiMBeanAdapter
    implements ZookeeperDiscoverySpiMBean {
        public ZookeeperDiscoverySpiMBeanImpl(IgniteSpiAdapter spiAdapter) {
            super(spiAdapter);
        }

        public String getSpiState() {
            return ZookeeperDiscoverySpi.this.impl.getSpiState();
        }

        public long getNodesJoined() {
            return ZookeeperDiscoverySpi.this.stats.joinedNodesCnt();
        }

        public long getNodesLeft() {
            return 0L;
        }

        public long getNodesFailed() {
            return ZookeeperDiscoverySpi.this.stats.failedNodesCnt();
        }

        @Override
        public long getCommErrorProcNum() {
            return ZookeeperDiscoverySpi.this.stats.commErrorCount();
        }

        @Nullable
        public UUID getCoordinator() {
            return ZookeeperDiscoverySpi.this.impl.getCoordinator();
        }

        @Nullable
        public String getCoordinatorNodeFormatted() {
            return String.valueOf(ZookeeperDiscoverySpi.this.impl.node(ZookeeperDiscoverySpi.this.impl.getCoordinator()));
        }

        public String getLocalNodeFormatted() {
            return String.valueOf(ZookeeperDiscoverySpi.this.getLocalNode());
        }

        public void excludeNode(String nodeId) {
            UUID node;
            try {
                node = UUID.fromString(nodeId);
            }
            catch (IllegalArgumentException e) {
                U.error((IgniteLogger)ZookeeperDiscoverySpi.this.log, (Object)("Failed to parse node ID: " + nodeId), (Throwable)e);
                return;
            }
            String msg = "Node excluded, node=" + nodeId + "using JMX interface, initiator=" + this.getLocalNodeId();
            ZookeeperDiscoverySpi.this.impl.failNode(node, msg);
        }

        @Override
        public String getZkConnectionString() {
            return ZookeeperDiscoverySpi.this.zkConnectionString;
        }

        @Override
        public long getZkSessionTimeout() {
            return ZookeeperDiscoverySpi.this.sesTimeout;
        }

        @Override
        public String getZkSessionId() {
            return ZookeeperDiscoverySpi.this.impl.getZkSessionId();
        }

        @Override
        public String getZkRootPath() {
            return ZookeeperDiscoverySpi.this.zkRootPath;
        }

        @Override
        public long getNodeOrder() {
            return ZookeeperDiscoverySpi.this.getLocalNode().order();
        }
    }
}

