/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb.assembler;

import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.Mode;
import org.apache.jena.assembler.assemblers.AssemblerBase;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sdb.assembler.AssemblerVocab;
import org.apache.jena.sdb.assembler.CommandAssemblerException;
import org.apache.jena.sparql.util.FmtUtils;
import org.apache.jena.sparql.util.graph.GraphUtils;
import org.apache.jena.util.FileManager;

public class QueryAssembler
extends AssemblerBase
implements Assembler {
    public Object open(Assembler a, Resource cmd, Mode mode) {
        if (cmd.hasProperty(AssemblerVocab.pQueryFile) && cmd.hasProperty(AssemblerVocab.pQueryString)) {
            throw new CommandAssemblerException(cmd, "Both " + FmtUtils.stringForResource((Resource)AssemblerVocab.pQueryString) + " and " + FmtUtils.stringForResource((Resource)AssemblerVocab.pQueryFile) + " present");
        }
        if (!cmd.hasProperty(AssemblerVocab.pQueryFile) && !cmd.hasProperty(AssemblerVocab.pQueryString)) {
            throw new CommandAssemblerException(cmd, "No queryString or queryFile present");
        }
        String queryString = GraphUtils.getStringValue((Resource)cmd, (Property)AssemblerVocab.pQueryString);
        if (queryString == null) {
            String filename = GraphUtils.getStringValue((Resource)cmd, (Property)AssemblerVocab.pQueryFile);
            queryString = FileManager.get().readWholeFileAsUTF8(filename);
        }
        return QueryFactory.create((String)queryString);
    }
}

