/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb.compiler;

import org.apache.jena.sdb.SDB;
import org.apache.jena.sdb.Store;
import org.apache.jena.sdb.compiler.QueryCompiler;
import org.apache.jena.sdb.core.SDBRequest;
import org.apache.jena.sdb.util.StoreUtils;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.core.Substitute;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.util.Context;

public class SDBCompile {
    public static Op compile(Store store, Op op) {
        return SDBCompile.compile(store, op, null);
    }

    public static Op compile(Store store, Op op, Context context) {
        if (context == null) {
            context = SDB.getContext();
        }
        SDBRequest request = new SDBRequest(store, (PrefixMapping)null, context);
        return SDBCompile.compile(store, op, null, context, request);
    }

    public static Op compile(Store store, Op op, Binding binding, Context context, SDBRequest request) {
        if (binding != null && !binding.isEmpty()) {
            op = Substitute.substitute((Op)op, (Binding)binding);
        }
        if (StoreUtils.isHSQL(store)) {
            request.LeftJoinTranslation = false;
            request.DistinctTranslation = true;
            request.LimitOffsetTranslation = false;
        }
        if (StoreUtils.isH2(store)) {
            request.LeftJoinTranslation = false;
            request.DistinctTranslation = true;
            request.LimitOffsetTranslation = false;
        }
        if (StoreUtils.isDerby(store)) {
            request.LeftJoinTranslation = true;
            request.LimitOffsetTranslation = false;
            request.DistinctTranslation = false;
        }
        if (StoreUtils.isPostgreSQL(store)) {
            request.LeftJoinTranslation = true;
            request.LimitOffsetTranslation = true;
            request.DistinctTranslation = true;
        }
        if (StoreUtils.isMySQL(store)) {
            request.LeftJoinTranslation = true;
            request.LimitOffsetTranslation = true;
            request.DistinctTranslation = true;
        }
        if (StoreUtils.isSQLServer(store)) {
            request.LeftJoinTranslation = true;
            request.LimitOffsetTranslation = false;
            request.DistinctTranslation = false;
        }
        if (StoreUtils.isOracle(store)) {
            request.LeftJoinTranslation = true;
            request.LimitOffsetTranslation = false;
            request.DistinctTranslation = false;
        }
        if (StoreUtils.isDB2(store)) {
            request.LeftJoinTranslation = true;
            request.LimitOffsetTranslation = false;
            request.DistinctTranslation = false;
        }
        if (StoreUtils.isSAP(store)) {
            request.LeftJoinTranslation = true;
            request.LimitOffsetTranslation = true;
            request.DistinctTranslation = true;
        }
        QueryCompiler queryCompiler = store.getQueryCompilerFactory().createQueryCompiler(request);
        Op op2 = queryCompiler.compile(op);
        return op2;
    }
}

