/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb.core.sqlexpr;

import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.sdb.core.sqlexpr.S_Like;
import org.apache.jena.sdb.core.sqlexpr.S_Regex;
import org.apache.jena.sdb.core.sqlexpr.SqlColumn;
import org.apache.jena.sdb.core.sqlexpr.SqlConstant;
import org.apache.jena.sdb.core.sqlexpr.SqlExpr;
import org.apache.jena.sdb.core.sqlexpr.SqlExpr1;
import org.apache.jena.sdb.core.sqlexpr.SqlExpr2;
import org.apache.jena.sdb.core.sqlexpr.SqlExprVisitor;
import org.apache.jena.sdb.core.sqlexpr.SqlFunction1;
import org.apache.jena.sdb.sql.SQLUtils;
import org.apache.jena.sdb.util.RegexUtils;

public class SqlExprGenerateSQL
implements SqlExprVisitor {
    private IndentedWriter out;
    public String RegexOperator = "REGEXP";

    SqlExprGenerateSQL(IndentedWriter out) {
        this.out = out;
    }

    @Override
    public void visit(SqlColumn column) {
        this.out.print(column.asString());
    }

    @Override
    public void visit(SqlConstant constant) {
        this.out.print(constant.asSqlString());
    }

    @Override
    public void visit(SqlFunction1 expr) {
        this.out.print(expr.getFuncSymbol());
        this.out.print("(");
        expr.getExpr().visit(this);
        this.out.print(")");
    }

    @Override
    public void visit(SqlExpr1 expr) {
        this.printExpr(expr.getExpr());
        this.out.print(" ");
        this.out.print(expr.getExprSymbol());
    }

    @Override
    public void visit(SqlExpr2 expr) {
        this.printExpr(expr.getLeft());
        this.out.print(" ");
        this.out.print(expr.getOpSymbol());
        this.out.print(" ");
        this.printExpr(expr.getRight());
    }

    @Override
    public void visit(S_Like pattern) {
        if (pattern.isCaseInsensitive()) {
            this.out.print("lower(");
            pattern.getExpr().visit(this);
            this.out.print(") LIKE ");
            this.out.print(SQLUtils.quoteStr(pattern.getPattern().toLowerCase()));
        } else {
            pattern.getExpr().visit(this);
            this.out.print(" LIKE ");
            this.out.print(SQLUtils.quoteStr(pattern.getPattern()));
        }
    }

    @Override
    public void visit(S_Regex regex) {
        regex.getExpr().visit(this);
        String pattern = regex.getPattern();
        String patternLike = RegexUtils.regexToLike(pattern);
        if (patternLike != null) {
            this.out.print(" LIKE ");
            this.out.print(SQLUtils.quoteStr(patternLike));
            return;
        }
        this.out.print(" ");
        this.out.print(this.RegexOperator);
        this.out.print(" ");
        if (regex.getFlags() != null && !regex.getFlags().equals("i")) {
            this.out.print("BINARY ");
        }
        this.out.print(SQLUtils.quoteStr(regex.getPattern()));
    }

    private void printExpr(SqlExpr expr) {
        boolean atomic;
        boolean bl = atomic = expr.isColumn() || expr.isConstant();
        if (!atomic) {
            this.out.print("( ");
        }
        expr.visit(this);
        if (!atomic) {
            this.out.print(" )");
        }
    }
}

