/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb.core.sqlnode;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.sdb.SDB;
import org.apache.jena.sdb.core.Annotations;
import org.apache.jena.sdb.core.sqlexpr.S_Equal;
import org.apache.jena.sdb.core.sqlexpr.SqlColumn;
import org.apache.jena.sdb.core.sqlexpr.SqlExpr;
import org.apache.jena.sdb.core.sqlexpr.SqlExprList;
import org.apache.jena.sdb.core.sqlnode.ColAlias;
import org.apache.jena.sdb.core.sqlnode.SqlCoalesce;
import org.apache.jena.sdb.core.sqlnode.SqlDistinct;
import org.apache.jena.sdb.core.sqlnode.SqlJoin;
import org.apache.jena.sdb.core.sqlnode.SqlJoinInner;
import org.apache.jena.sdb.core.sqlnode.SqlJoinLeftOuter;
import org.apache.jena.sdb.core.sqlnode.SqlNode;
import org.apache.jena.sdb.core.sqlnode.SqlNodeVisitor;
import org.apache.jena.sdb.core.sqlnode.SqlProject;
import org.apache.jena.sdb.core.sqlnode.SqlRename;
import org.apache.jena.sdb.core.sqlnode.SqlRestrict;
import org.apache.jena.sdb.core.sqlnode.SqlSelectBlock;
import org.apache.jena.sdb.core.sqlnode.SqlSlice;
import org.apache.jena.sdb.core.sqlnode.SqlTable;
import org.apache.jena.sdb.core.sqlnode.SqlUnion;
import org.apache.jena.sdb.shared.SDBInternalError;
import org.apache.jena.sdb.shared.SDBNotImplemented;
import org.apache.jena.sparql.core.Var;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerateSQLVisitor
implements SqlNodeVisitor {
    private static Logger log = LoggerFactory.getLogger(GenerateSQLVisitor.class);
    protected IndentedWriter out;
    int levelSelectBlock = 0;
    public boolean outputAnnotations = SDB.getContext().isTrueOrUndef(SDB.annotateGeneratedSQL);
    private static final int annotationColumn = 40;
    private static boolean commentSQLStyle = true;
    static boolean allOnOneLine = false;

    public GenerateSQLVisitor(IndentedWriter out) {
        this.out = out;
    }

    public void visit(SqlProject sqlNode) {
        this.shouldNotSee(sqlNode);
    }

    public void visit(SqlDistinct sqlNode) {
        this.shouldNotSee(sqlNode);
    }

    public void visit(SqlRestrict sqlNode) {
        this.shouldNotSee(sqlNode);
    }

    public void visit(SqlSlice sqlNode) {
        this.shouldNotSee(sqlNode);
    }

    public void visit(SqlRename sqlNode) {
        this.shouldNotSee(sqlNode);
    }

    private void shouldNotSee(SqlNode sqlNode) {
        throw new SDBInternalError("Didn't expect: " + Lib.className((Object)sqlNode));
    }

    @Override
    public void visit(SqlSelectBlock sqlSelectBlock) {
        ++this.levelSelectBlock;
        if (this.levelSelectBlock > 1) {
            // empty if block
        }
        this.genPrefix(sqlSelectBlock);
        this.out.print("SELECT ");
        if (sqlSelectBlock.getDistinct()) {
            this.out.print("DISTINCT ");
        }
        if (this.annotate(sqlSelectBlock)) {
            this.out.ensureStartOfLine();
        }
        this.out.incIndent();
        this.genColumnPrefix(sqlSelectBlock);
        this.print(sqlSelectBlock.getCols());
        this.out.decIndent();
        this.out.ensureStartOfLine();
        this.out.print("FROM");
        if (!sqlSelectBlock.getSubNode().isTable()) {
            this.out.println();
        } else {
            this.out.print(" ");
        }
        this.out.incIndent();
        this.outputNode(sqlSelectBlock.getSubNode(), true);
        this.out.decIndent();
        this.out.ensureStartOfLine();
        if (sqlSelectBlock.getConditions().size() > 0) {
            this.genWHERE(sqlSelectBlock.getConditions());
        }
        this.out.ensureStartOfLine();
        this.genLimitOffset(sqlSelectBlock);
        this.genSuffix(sqlSelectBlock);
        --this.levelSelectBlock;
    }

    protected void genPrefix(SqlSelectBlock sqlSelectBlock) {
    }

    protected void genColumnPrefix(SqlSelectBlock sqlSelectBlock) {
    }

    protected void genSuffix(SqlSelectBlock sqlSelectBlock) {
    }

    protected void genLimitOffset(SqlSelectBlock sqlSelectBlock) {
        if (sqlSelectBlock.getLength() >= 0L) {
            this.out.println("LIMIT " + sqlSelectBlock.getLength());
        }
        if (sqlSelectBlock.getStart() >= 0L) {
            this.out.println("OFFSET " + sqlSelectBlock.getStart());
        }
    }

    private void print(List<ColAlias> cols) {
        String sep = "";
        if (cols.size() == 0) {
            this.out.print("*");
        }
        String currentPrefix = null;
        String splitMarker = ".";
        for (ColAlias c : cols) {
            this.out.print(sep);
            String cn = c.getColumn().getFullColumnName();
            int j = cn.lastIndexOf(splitMarker);
            if (j == -1) {
                currentPrefix = null;
            } else {
                String x = cn.substring(0, j);
                if (currentPrefix != null && !x.equals(currentPrefix)) {
                    this.out.println();
                }
                currentPrefix = x;
            }
            sep = ", ";
            this.out.print(c.getColumn().getFullColumnName());
            if (c.getAlias() == null) continue;
            this.out.print(this.aliasToken());
            this.out.print(c.getAlias().getColumnName());
        }
    }

    private void genWHERE(SqlExprList conditions) {
        this.out.print("WHERE");
        this.out.print(" ");
        this.out.incIndent();
        this.conditionList(conditions);
        this.out.decIndent();
    }

    @Override
    public void visit(SqlTable table) {
        this.out.print(table.getTableName());
        this.out.print(this.aliasToken());
        this.out.print(table.getAliasName());
        this.annotate(table);
    }

    @Override
    public void visit(SqlJoinInner join) {
        join = this.rewrite(join);
        this.visitJoin(join);
    }

    public SqlJoinInner rewrite(SqlJoinInner join) {
        if (!join.getRight().isInnerJoin()) {
            return join;
        }
        SqlJoinInner right = join.getRight().asInnerJoin();
        String alias1 = join.getAliasName();
        String alias2 = right.getAliasName();
        SqlNode sn_a = join.getLeft();
        SqlNode sn_b = right.getLeft();
        SqlNode sn_c = right.getRight();
        SqlExprList conditions = new SqlExprList(join.getConditions());
        conditions.addAll(right.getConditions());
        Set<SqlTable> tables_ab = sn_a.tablesInvolved();
        tables_ab.addAll(sn_b.tablesInvolved());
        SqlExprList newCond_ab = new SqlExprList();
        SqlExprList newCond_c = new SqlExprList();
        for (SqlExpr e : conditions) {
            Set<SqlColumn> cols = e.getColumnsNeeded();
            Set<SqlTable> tables = GenerateSQLVisitor.tables(cols);
            tables.removeAll(tables_ab);
            if (tables.size() == 0) {
                newCond_ab.add(e);
                continue;
            }
            newCond_c.add(e);
        }
        if (newCond_ab.size() + newCond_c.size() != conditions.size()) {
            log.error(String.format("Conditions mismatch: (%d,%d,%d)", newCond_ab.size(), newCond_c.size(), conditions.size()));
        }
        SqlJoinInner join2 = new SqlJoinInner(sn_a, sn_b);
        join2.addConditions(newCond_ab);
        join2 = new SqlJoinInner(join2, sn_c);
        join2.addConditions(newCond_c);
        return join2;
    }

    private static Set<SqlTable> tables(Set<SqlColumn> cols) {
        return Iter.toSet((Iterator)Iter.map(cols.iterator(), SqlColumn::getTable));
    }

    @Override
    public void visit(SqlJoinLeftOuter join) {
        this.visitJoin(join);
    }

    @Override
    public void visit(SqlCoalesce sqlNode) {
        this.out.print("SELECT ");
        boolean first = true;
        SqlJoin join = sqlNode.getJoinNode();
        for (Var v : sqlNode.getCoalesceVars()) {
            if (!first) {
                this.out.print(", ");
            }
            SqlColumn col = sqlNode.getIdScope().findScopeForVar(v).getColumn();
            SqlColumn leftCol = join.getLeft().getIdScope().findScopeForVar(v).getColumn();
            SqlColumn rightCol = join.getRight().getIdScope().findScopeForVar(v).getColumn();
            this.out.print("COALESCE(");
            this.out.print(leftCol.getFullColumnName());
            this.out.print(", ");
            this.out.print(rightCol.getFullColumnName());
            this.out.print(")");
            this.out.print(this.aliasToken());
            this.out.print(col.getColumnName());
            first = false;
        }
        for (Var v : sqlNode.getNonCoalesceVars()) {
            if (!first) {
                this.out.print(", ");
            }
            first = false;
            SqlColumn colSub = join.getIdScope().findScopeForVar(v).getColumn();
            SqlColumn col = sqlNode.getIdScope().findScopeForVar(v).getColumn();
            this.out.print(colSub.getFullColumnName());
            this.out.print(this.aliasToken());
            this.out.print(col.getColumnName());
        }
        this.out.ensureStartOfLine();
        this.out.incIndent();
        this.out.println("FROM");
        join.visit(this);
        this.out.ensureStartOfLine();
    }

    @Override
    public void visit(SqlUnion sqlUnion) {
        throw new SDBNotImplemented("SQL generation of SqlUnion");
    }

    protected void visitJoin(SqlJoin join) {
        this.visitJoin(join, join.getJoinType().sqlOperator());
    }

    protected void visitJoin(SqlJoin join, String joinOperatorName) {
        SqlNode left = join.getLeft();
        SqlNode right = join.getRight();
        if (left.isJoin() && left.getAliasName() == null) {
            this.outputNode(left, false);
        } else {
            this.out.incIndent();
            this.outputNode(left, true);
            this.out.decIndent();
        }
        this.out.println();
        this.out.print(joinOperatorName);
        this.annotate(join);
        this.out.println();
        boolean bracketsRight = true;
        if (bracketsRight) {
            this.out.incIndent();
        }
        this.outputNode(right, bracketsRight);
        if (bracketsRight) {
            this.out.decIndent();
        }
        this.out.println();
        this.out.print("ON ");
        if (join.getConditions().size() > 0) {
            this.conditionList(join.getConditions());
        } else {
            this.out.print(" ( ");
            this.out.print(this.leftJoinNoConditionsString());
            this.out.print(" )");
        }
    }

    protected String aliasToken() {
        return " AS ";
    }

    protected String leftJoinNoConditionsString() {
        return "1 = 1";
    }

    public void conditionList(SqlExprList conditions) {
        if (conditions.size() == 0) {
            return;
        }
        this.out.print("( ");
        String sep = "  AND ";
        boolean first = true;
        boolean lastAnnotated = false;
        for (SqlExpr c : conditions) {
            boolean needsParens;
            if (!first) {
                if (!allOnOneLine) {
                    this.out.println();
                }
                this.out.print(sep);
            }
            boolean bl = needsParens = !(c instanceof S_Equal);
            if (needsParens) {
                this.out.print("( ");
            }
            this.out.print(c.asSQL());
            if (needsParens) {
                this.out.print(" )");
            }
            if (!allOnOneLine) {
                lastAnnotated = this.annotate(c);
            }
            first = false;
        }
        if (!allOnOneLine && lastAnnotated) {
            this.out.println("");
        }
        this.out.print(" )");
        first = true;
        if (allOnOneLine) {
            for (SqlExpr c : conditions) {
                if (!c.hasNotes()) continue;
                if (!first) {
                    this.out.println();
                }
                this.annotate(c);
                first = false;
            }
        }
    }

    private void outputNode(SqlNode sqlNode, boolean mayNeedBrackets) {
        if (sqlNode.isTable()) {
            sqlNode.visit(this);
            return;
        }
        boolean brackets = false;
        brackets = brackets || mayNeedBrackets && sqlNode.isCoalesce();
        boolean bl = brackets = brackets || mayNeedBrackets && sqlNode.isSelectBlock();
        if (brackets) {
            this.out.print("( ");
            this.out.incIndent();
        }
        sqlNode.visit(this);
        if (brackets) {
            this.out.decIndent();
            this.out.ensureStartOfLine();
            this.out.print(")");
        }
        if (sqlNode.getAliasName() != null) {
            this.out.print(this.aliasToken());
            this.out.print(sqlNode.getAliasName());
        }
        this.annotate(sqlNode);
    }

    private boolean annotate(Annotations sqlNode) {
        return this.annotate(sqlNode, 40);
    }

    private boolean annotate(Annotations sqlNode, int indentationColumn) {
        if (!this.outputAnnotations) {
            return false;
        }
        boolean first = true;
        for (String s : sqlNode.getNotes()) {
            if (!first) {
                this.out.println();
            }
            first = false;
            this.out.pad(indentationColumn, true);
            if (commentSQLStyle) {
                this.out.print(" -- ");
                this.out.print(s);
                continue;
            }
            this.out.print(" /* ");
            this.out.print(s);
            this.out.print(" */");
        }
        return !commentSQLStyle || !first;
    }
}

