/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb.layout2.expr;

import org.apache.jena.sdb.SDBException;
import org.apache.jena.sdb.compiler.SDBConstraint;
import org.apache.jena.sdb.core.ExprPattern;
import org.apache.jena.sdb.core.Scope;
import org.apache.jena.sdb.core.sqlexpr.S_And;
import org.apache.jena.sdb.core.sqlexpr.S_Equal;
import org.apache.jena.sdb.core.sqlexpr.SqlColumn;
import org.apache.jena.sdb.core.sqlexpr.SqlConstant;
import org.apache.jena.sdb.core.sqlexpr.SqlExpr;
import org.apache.jena.sdb.exprmatch.MapResult;
import org.apache.jena.sdb.layout2.ValueType;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.Expr;
import org.slf4j.LoggerFactory;

class StringEqualsSqlGen
extends SDBConstraint {
    ExprPattern exprPattern;
    boolean completeConstraint;

    public StringEqualsSqlGen(Expr expr, ExprPattern exprPattern, boolean completeConstraint) {
        super(expr, completeConstraint);
        this.exprPattern = exprPattern;
    }

    @Override
    public SDBConstraint substitute(Binding binding) {
        return new StringEqualsSqlGen(this.getExpr().copySubstitute(binding), this.exprPattern, super.isComplete());
    }

    @Override
    public SqlExpr compile(Scope scope) {
        MapResult rMap = this.exprPattern.match(this.getExpr());
        if (rMap == null) {
            throw new SDBException("Couldn't compile after all: " + this.getExpr());
        }
        Var var = rMap.get("a1").getExprVar().asVar();
        String str = rMap.get("a2").getConstant().getString();
        if (!scope.hasColumnForVar(var)) {
            LoggerFactory.getLogger(this.getClass()).error("Variable '" + var + "' not in scope");
            return null;
        }
        SqlColumn vCol = scope.findScopeForVar(var).getColumn();
        SqlColumn lexCol = new SqlColumn(vCol.getTable(), "lex");
        SqlColumn vTypeCol = new SqlColumn(vCol.getTable(), "type");
        S_Equal isStr = new S_Equal(vTypeCol, new SqlConstant(ValueType.STRING.getTypeId()));
        isStr.addNote("is a string");
        S_Equal strEquals = new S_Equal(lexCol, new SqlConstant(str));
        isStr.addNote(this.getExpr().toString());
        return new S_And(isStr, strEquals);
    }
}

