/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb.layout2.expr;

import org.apache.jena.sdb.compiler.ConditionCompiler;
import org.apache.jena.sdb.compiler.SDBConstraint;
import org.apache.jena.sdb.core.ExprPattern;
import org.apache.jena.sdb.exprmatch.ActionMatch;
import org.apache.jena.sdb.exprmatch.ActionMatchString;
import org.apache.jena.sdb.exprmatch.ActionMatchVar;
import org.apache.jena.sdb.exprmatch.MapResult;
import org.apache.jena.sdb.layout2.expr.StringEqualsSqlGen;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.Expr;

public class StringExprCompiler
implements ConditionCompiler {
    private static ExprPattern equalsString1 = new ExprPattern("?a1 = ?a2", new Var[]{Var.alloc((String)"a1"), Var.alloc((String)"a2")}, new ActionMatch[]{new ActionMatchVar(), new ActionMatchString()});
    private static ExprPattern equalsString2 = new ExprPattern("?a2 = ?a1", new Var[]{Var.alloc((String)"a1"), Var.alloc((String)"a2")}, new ActionMatch[]{new ActionMatchVar(), new ActionMatchString()});

    @Override
    public SDBConstraint recognize(Expr expr) {
        MapResult rMap = null;
        rMap = equalsString1.match(expr);
        if (rMap != null) {
            Var var = rMap.get("a1").getExprVar().asVar();
            String str = rMap.get("a2").getConstant().getString();
            return new StringEqualsSqlGen(expr, equalsString1, true);
        }
        return null;
    }
}

