/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb.layout2.index;

import java.sql.SQLException;
import org.apache.jena.sdb.layout2.TableDescNodes;
import org.apache.jena.sdb.layout2.TableDescQuads;
import org.apache.jena.sdb.layout2.TableDescTriples;
import org.apache.jena.sdb.layout2.hash.FmtLayout2HashSAP;
import org.apache.jena.sdb.sql.SAPStorageType;
import org.apache.jena.sdb.sql.SDBConnection;
import org.apache.jena.sdb.sql.SDBExceptionSQL;
import org.apache.jena.sdb.sql.SQLUtils;

public class FmtLayout2IndexSAP
extends FmtLayout2HashSAP {
    public FmtLayout2IndexSAP(SDBConnection connection, SAPStorageType storageType) {
        super(connection, storageType);
    }

    @Override
    protected void formatTableTriples() {
        this.dropTable(TableDescTriples.name());
        try {
            this.connection().exec(SQLUtils.sqlStr("CREATE " + this.storageType.getStorageName() + " TABLE " + TableDescTriples.name() + " (", "    s integer NOT NULL,", "    p integer NOT NULL,", "    o integer NOT NULL", ")"));
            this.connection().exec(SQLUtils.sqlStr("ALTER TABLE " + TableDescTriples.name() + " ADD PRIMARY KEY (s, p, o)"));
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL("SQLException formatting table '" + TableDescTriples.name() + "'", ex);
        }
    }

    @Override
    protected void formatTableQuads() {
        this.dropTable(TableDescQuads.name());
        try {
            this.connection().exec(SQLUtils.sqlStr("CREATE " + this.storageType.getStorageName() + " TABLE " + TableDescQuads.name() + " (", "    g integer NOT NULL,", "    s integer NOT NULL,", "    p integer NOT NULL,", "    o integer NOT NULL", ")"));
            this.connection().exec(SQLUtils.sqlStr("ALTER TABLE " + TableDescQuads.name() + " ADD PRIMARY KEY (g, s, p, o)"));
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL("SQLException formatting table '" + TableDescTriples.name() + "'", ex);
        }
    }

    @Override
    protected void formatTableNodes() {
        this.dropTable(TableDescNodes.name());
        try {
            this.connection().exec(SQLUtils.sqlStr("CREATE " + this.storageType.getStorageName() + " TABLE " + TableDescNodes.name() + " (", "   id INTEGER NOT NULL,", "   hash BIGINT NOT NULL,", "   lex nvarchar(5000) NOT NULL,", "   lang nvarchar(10) NOT NULL default '',", "   datatype nvarchar(200) NOT NULL default '',", "   type integer NOT NULL default '0'", ")"));
            this.connection().exec(SQLUtils.sqlStr("ALTER TABLE " + TableDescNodes.name() + " ADD PRIMARY KEY (id)"));
            this.connection().execSilent("DROP SEQUENCE nodeid");
            this.connection().exec(SQLUtils.sqlStr("CREATE SEQUENCE nodeid", "START WITH 1", "INCREMENT BY 1", "NO CYCLE"));
            this.connection().exec("CREATE UNIQUE INDEX Hash ON " + TableDescNodes.name() + " (hash)");
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL("SQLException formatting table '" + TableDescNodes.name() + "'", ex);
        }
    }
}

